/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFc1iSDK;
import com.appsflyer.internal.AFc1pSDK;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AFg1xSDK {
    @NotNull
    private final Map<String, Object> getCurrencyIso4217Code;
    @Nullable
    private final PackageManager getMediationNetwork;
    @NotNull
    private final String getRevenue;

    public AFg1xSDK(@NotNull AFc1iSDK aFc1iSDK, @NotNull AFc1pSDK aFc1pSDK) {
        Intrinsics.checkNotNullParameter((Object)aFc1iSDK, (String)"");
        Intrinsics.checkNotNullParameter((Object)aFc1pSDK, (String)"");
        this.getCurrencyIso4217Code = new LinkedHashMap();
        Context context = aFc1iSDK.getRevenue;
        this.getMediationNetwork = context != null ? context.getPackageManager() : null;
        String string = aFc1pSDK.getRevenue.getRevenue.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        this.getRevenue = string;
    }

    @NotNull
    public final Map<String, Object> getMonetizationNetwork() {
        if (this.getCurrencyIso4217Code.isEmpty()) {
            Object object;
            try {
                Object object2 = this.getMediationNetwork;
                if (object2 != null && (object2 = object2.getInstallerPackageName(this.getRevenue)) != null) {
                    object = object2;
                    this.getCurrencyIso4217Code.put("installer_package", object);
                }
            }
            catch (Exception exception) {
                AFLogger.afErrorLog("Exception while getting the app's installer package. ", exception);
            }
            if (Build.VERSION.SDK_INT >= 30) {
                object = this;
                Map map = new LinkedHashMap();
                Object object3 = object.getRevenue;
                PackageManager packageManager = object.getMediationNetwork;
                if (packageManager != null && (packageManager = packageManager.getInstallSourceInfo((String)object3)) != null) {
                    map = packageManager;
                    Intrinsics.checkNotNullExpressionValue((Object)packageManager, (String)"");
                    object = new LinkedHashMap();
                    String string = map.getInitiatingPackageName();
                    String string2 = "initiating_package";
                    object3 = object;
                    if (string != null) {
                        object3.put(string2, string);
                    }
                    string = map.getInstallingPackageName();
                    string2 = "installing_package";
                    object3 = object;
                    if (string != null) {
                        object3.put(string2, string);
                    }
                    string = map.getOriginatingPackageName();
                    string2 = "originating_package";
                    object3 = object;
                    if (string != null) {
                        object3.put(string2, string);
                    }
                    map = object;
                }
                this.getCurrencyIso4217Code.put("install_source_info", map);
            }
        }
        return this.getCurrencyIso4217Code;
    }
}

