/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFh1aSDK;
import com.appsflyer.internal.AFh1cSDK;
import org.json.JSONException;
import org.json.JSONObject;

public final class AFi1wSDK {
    private final boolean getMediationNetwork;
    @NonNull
    public final String getRevenue;
    @NonNull
    public final String getCurrencyIso4217Code;
    @NonNull
    public final AFh1aSDK AFAdRevenueData;
    @Nullable
    public final AFh1cSDK getMonetizationNetwork;

    public AFi1wSDK(@NonNull String object) throws JSONException {
        if (object == null) {
            throw new JSONException("Failed to parse remote configuration JSON: originalJson is null");
        }
        try {
            JSONObject jSONObject = new JSONObject((String)object);
            this.getRevenue = jSONObject.getString("ver");
            this.getMediationNetwork = jSONObject.optBoolean("test_mode");
            this.getCurrencyIso4217Code = object;
            this.AFAdRevenueData = this.getRevenue.startsWith("default") ? AFh1aSDK.getRevenue : AFh1aSDK.getCurrencyIso4217Code;
            object = null;
            jSONObject = jSONObject.optJSONObject("features");
            if (jSONObject != null) {
                object = new AFh1cSDK(jSONObject);
            }
            this.getMonetizationNetwork = object;
            return;
        }
        catch (JSONException jSONException) {
            AFLogger.afErrorLogForExcManagerOnly("Error in RC config parsing", jSONException);
            throw new JSONException("Failed to parse remote configuration JSON");
        }
    }

    public final boolean equals(Object o) {
        AFi1wSDK aFi1wSDK;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        aFi1wSDK = aFi1wSDK;
        if (this.getMediationNetwork != aFi1wSDK.getMediationNetwork) {
            return false;
        }
        if (!this.getRevenue.equals(aFi1wSDK.getRevenue)) {
            return false;
        }
        return this.getCurrencyIso4217Code.equals(aFi1wSDK.getCurrencyIso4217Code);
    }

    public final int hashCode() {
        int n = this.getMediationNetwork ? 1 : 0;
        n = n * 31 + this.getRevenue.hashCode();
        n = n * 31 + this.getCurrencyIso4217Code.hashCode();
        if (this.getMonetizationNetwork != null) {
            n = n * 31 + ((Object)this.getMonetizationNetwork).hashCode();
        }
        return n;
    }
}

