/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.util.Base64;
import androidx.annotation.Nullable;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFd1rSDK;
import com.appsflyer.internal.AFh1vSDK;
import com.appsflyer.internal.AFi1vSDK;
import java.nio.charset.Charset;

public final class AFg1vSDK {
    public final AFd1rSDK getMediationNetwork;
    public AFi1vSDK getRevenue;
    public long getCurrencyIso4217Code;
    public long getMonetizationNetwork;
    @Nullable
    public AFi1vSDK AFAdRevenueData = null;

    public AFg1vSDK(AFd1rSDK aFd1rSDK) {
        this.getMediationNetwork = aFd1rSDK;
        this.getRevenue = this.getCurrencyIso4217Code();
        this.getCurrencyIso4217Code = aFd1rSDK.getMediationNetwork("af_rc_timestamp", 0L);
        this.getMonetizationNetwork = aFd1rSDK.getMediationNetwork("af_rc_max_age", 0L);
    }

    @Nullable
    private AFi1vSDK getCurrencyIso4217Code() {
        String string = this.getMediationNetwork.getMonetizationNetwork("af_remote_config", null);
        if (string == null) {
            AFLogger.INSTANCE.d(AFh1vSDK.component1, "No configuration found in cache");
            return null;
        }
        try {
            string = new String(Base64.decode((String)string, (int)2), Charset.defaultCharset());
            return new AFi1vSDK(string);
        }
        catch (Exception exception) {
            AFLogger.INSTANCE.e(AFh1vSDK.component1, "Error reading malformed configuration from cache, requires fetching from remote again", exception, true);
            return null;
        }
    }
}

