package com.appsflyer;

import android.content.Context;
import android.content.pm.PackageManager;

import java.lang.ref.WeakReference;

/**
 * @author by shacharaharon on 19/01/2017.
 */

class AFLifecycleCallbacks {

    static void doOnResume(Context context) {
        AFLogger.afInfoLog("onBecameForeground");
        AppsFlyerLib.getInstance().resetTimeEnteredForeground();
        AppsFlyerLib.getInstance().trackEventInternal(context, null, null);

        AFLogger.resetDeltaTime();
    }

    static void doOnPause(Context context) {
        AFLogger.afInfoLog("onBecameBackground");
        AppsFlyerLib.getInstance().resetTimeWentToBackground();
        AFLogger.afInfoLog("callStatsBackground background call");
        WeakReference<Context> weakContext = new WeakReference<>(context.getApplicationContext());
        AppsFlyerLib.getInstance().callStatsBackground(weakContext);
        RemoteDebuggingManager rdInstance = RemoteDebuggingManager.getInstance();
        if (rdInstance.isRemoteDebuggingEnabledFromServer()) {
            rdInstance.stopRemoteDebuggingMode();
            if (weakContext.get() != null) {
                String packageName = weakContext.get().getPackageName();
                PackageManager packageManager = weakContext.get().getPackageManager();
                rdInstance.sendRemoteDebuggingData(packageName,packageManager);
            }
            rdInstance.releaseRemoteDebugging();
        } else {
            AFLogger.afDebugLog("RD status is OFF");
        }

        AFExecutor.getInstance().shutdownExecutors();
    }

}
