package com.appsflyer;

import android.os.AsyncTask;
import android.os.Build;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * Created by shacharaharon on 21/03/2017.
 */

public class AFExecutor {

    private static final int CORE_POOL_SIZE = 2;
    private static AFExecutor instance;
    private Executor afThreadPoolExecutor;
    private ScheduledExecutorService afScheduledThreadPoolExecutor;
    private Executor afSerialExecutor;

    private AFExecutor() {
    }

    public static AFExecutor getInstance() {
        if (instance == null) {
            instance = new AFExecutor();
        }
        return instance;
    }

    public Executor getSerialExecutor() {
        if (afSerialExecutor == null) {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB) {
                afSerialExecutor = AsyncTask.SERIAL_EXECUTOR;
            } else {
                return Executors.newSingleThreadExecutor();
            }
        }
        return afSerialExecutor;
    }

    public Executor getThreadPoolExecutor() {
        boolean isExecutorTerminated = afThreadPoolExecutor == null ||
                (afThreadPoolExecutor instanceof ThreadPoolExecutor &&
                        (((ThreadPoolExecutor) afThreadPoolExecutor).isShutdown() || ((ThreadPoolExecutor) afThreadPoolExecutor).isTerminated()
                                || ((ThreadPoolExecutor) afThreadPoolExecutor).isTerminating()));
        if (isExecutorTerminated) {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB) {
                afThreadPoolExecutor = AsyncTask.THREAD_POOL_EXECUTOR;
            } else {
                return Executors.newSingleThreadExecutor();
            }
        }
        return afThreadPoolExecutor;
    }

    ScheduledThreadPoolExecutor getScheduledThreadPoolExecutor() {
        boolean isExecutorTerminated = afScheduledThreadPoolExecutor == null || afScheduledThreadPoolExecutor.isShutdown() || afScheduledThreadPoolExecutor.isTerminated();
        if (isExecutorTerminated) {
            afScheduledThreadPoolExecutor = Executors.newScheduledThreadPool(CORE_POOL_SIZE);
        }
        return (ScheduledThreadPoolExecutor) afScheduledThreadPoolExecutor;
    }

    void shutdown() {
        try {
            afScheduledThreadPoolExecutor.awaitTermination(10, TimeUnit.SECONDS);
            ((ThreadPoolExecutor) afThreadPoolExecutor).awaitTermination(10, TimeUnit.SECONDS);
        } catch (Throwable ignore) {
        }
        afScheduledThreadPoolExecutor.shutdown();
        if (afThreadPoolExecutor instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor) afThreadPoolExecutor).shutdown();
        }
    }
}
