package com.appsflyer;

import com.google.android.gms.gcm.GoogleCloudMessaging;
import com.google.android.gms.iid.InstanceID;
import com.google.android.gms.iid.InstanceIDListenerService;

import java.io.IOException;

/**
 * Created by shacharaharon on 04/07/2016.
 */
public class InstanceIDListener extends InstanceIDListenerService {

    private String _refreshedToken;
    private long _tokenTimestamp;

    @Override
    public void onTokenRefresh() {
        super.onTokenRefresh();
        AFLogger.afLog("onTokenRefresh called");

        final String gcmProjectNumber = AppsFlyerProperties.getInstance().getString(AppsFlyerProperties.GCM_PROJECT_NUMBER);
        InstanceID instanceID = InstanceID.getInstance(this);
        try {
            _refreshedToken = instanceID.getToken(gcmProjectNumber,
                    GoogleCloudMessaging.INSTANCE_ID_SCOPE, null);
            _tokenTimestamp = System.currentTimeMillis();
        } catch (IOException e) {
            AFLogger.afLogE("Could not load registration ID",e);
        } catch (Throwable t) {
            AFLogger.afLogE("Error registering for uninstall feature",t);
        }
        if (_refreshedToken != null) {
            AFLogger.afLog("new token=" + _refreshedToken);
            String token = AppsFlyerProperties.getInstance().getString(AppsFlyerProperties.GCM_TOKEN);
            String instanceId = AppsFlyerProperties.getInstance().getString(AppsFlyerProperties.GCM_INSTANCE_ID);
            String tokenTimestamp = AppsFlyerProperties.getInstance().getString(AppsFlyerProperties.GCM_TOKEN_TIMESTAMP);

            GcmToken existingGcmToken = new GcmToken(tokenTimestamp, token, instanceId);
            GcmToken newGcmToken = new GcmToken(_tokenTimestamp, _refreshedToken, instanceId);
            if (existingGcmToken.update(newGcmToken)) {
                AppsFlyerLib.getInstance().updateServerGcmToken(existingGcmToken,this);
            }
        }
    }
}