/*
 * Decompiled with CFR 0.152.
 */
package com.tracelytics.util;

import com.tracelytics.joboe.HostId;
import com.tracelytics.logging.Logger;
import com.tracelytics.logging.LoggerFactory;
import com.tracelytics.util.DummyHostInfoReader;
import com.tracelytics.util.HostInfoReader;
import com.tracelytics.util.HostInfoReaderProvider;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostInfoUtils {
    private static Logger a = LoggerFactory.getLogger();
    private static HostInfoReader b;

    public static String getAzureInstanceId() {
        return b.getAzureInstanceId();
    }

    private HostInfoUtils() {
    }

    public static OsType getOsType() {
        String string = System.getProperty("os.name");
        if (string == null) {
            a.warn("Failed to identify OS, system property `os.name` is null");
            return OsType.UNKNOWN;
        }
        if (string.toLowerCase().startsWith("windows")) {
            return OsType.WINDOWS;
        }
        if (string.toLowerCase().startsWith("linux")) {
            return OsType.LINUX;
        }
        if (string.toLowerCase().startsWith("mac")) {
            return OsType.MAC;
        }
        a.info("Unsupported OS type detected: " + string);
        return OsType.UNKNOWN;
    }

    public static void init(HostInfoReader hostInfoReader) {
        b = hostInfoReader;
    }

    public static String getHostName() {
        return b.getHostName();
    }

    public static HostId getHostId() {
        return b.getHostId();
    }

    public static Map<String, Object> getHostMetadata() {
        return b.getHostMetadata();
    }

    public static NetworkAddressInfo getNetworkAddressInfo() {
        return b.getNetworkAddressInfo();
    }

    static {
        Iterator<HostInfoReaderProvider> iterator = ServiceLoader.load(HostInfoReaderProvider.class).iterator();
        if (iterator.hasNext()) {
            iterator = iterator.next();
            a.debug("Use HostInfoReaderProvider implementation " + iterator.getClass().getName());
            b = iterator.getHostInfoReader();
        }
        if (b == null) {
            b = new DummyHostInfoReader();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NetworkAddressInfo {
        private List<String> a;
        private List<String> b;

        public NetworkAddressInfo(List<String> list, List<String> list2) {
            this.a = list;
            this.b = list2;
        }

        public List<String> getIpAddresses() {
            return this.a;
        }

        public List<String> getMacAddresses() {
            return this.b;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OsType {
        LINUX("Linux"),
        WINDOWS("Windows"),
        MAC("Mac"),
        UNKNOWN("Unknown");

        private final String a;

        private OsType(String string2) {
            this.a = string2;
        }

        public final String getLabel() {
            return this.a;
        }
    }
}

