/*
 * Decompiled with CFR 0.152.
 */
package com.tracelytics.util;

import com.tracelytics.logging.Logger;
import com.tracelytics.logging.LoggerFactory;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class DaemonThreadFactory
implements ThreadFactory {
    private static final Logger a = LoggerFactory.getLogger();
    private final String b;
    private AtomicInteger c = new AtomicInteger(0);

    private DaemonThreadFactory(String string) {
        this.b = string != null ? "AppOptics-" + string : "AppOptics";
    }

    public static DaemonThreadFactory newInstance(String string) {
        return new DaemonThreadFactory(string);
    }

    public Thread newThread(Runnable runnable) {
        runnable = Executors.defaultThreadFactory().newThread(runnable);
        ((Thread)runnable).setDaemon(true);
        ((Thread)runnable).setName(this.b + "-" + this.c.incrementAndGet());
        try {
            ((Thread)runnable).setContextClassLoader(null);
        }
        catch (SecurityException securityException) {
            a.warn("Cannot set the context class loader of System Monitor threads to null. Tomcat might display warning message of memory leak during shutdown");
        }
        return runnable;
    }
}

