/*
 * Decompiled with CFR 0.152.
 */
package com.tracelytics.joboe.span.impl;

import com.tracelytics.joboe.Context;
import com.tracelytics.joboe.Event;
import com.tracelytics.joboe.Metadata;
import com.tracelytics.joboe.OboeException;
import com.tracelytics.joboe.TraceConfig;
import com.tracelytics.joboe.TraceDecision;
import com.tracelytics.joboe.TraceDecisionUtil;
import com.tracelytics.joboe.XTraceOption;
import com.tracelytics.joboe.XTraceOptions;
import com.tracelytics.joboe.config.ConfigManager;
import com.tracelytics.joboe.config.ConfigProperty;
import com.tracelytics.joboe.config.ProfilerSetting;
import com.tracelytics.joboe.span.impl.LogEntry;
import com.tracelytics.joboe.span.impl.ScopeManager;
import com.tracelytics.joboe.span.impl.Span;
import com.tracelytics.joboe.span.impl.SpanReporter;
import com.tracelytics.logging.Logger;
import com.tracelytics.logging.LoggerFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TraceEventSpanReporter
implements SpanReporter {
    private final Logger a = LoggerFactory.getLogger();
    public static final TraceEventSpanReporter REPORTER = new TraceEventSpanReporter();
    private static final boolean b;

    private TraceEventSpanReporter() {
    }

    public void reportOnStart(Span span) {
        Metadata metadata = span.context().getMetadata();
        Event event = null;
        if (metadata.isSampled()) {
            String string = span.getSpanPropertyValue(Span.SpanProperty.ENTRY_XID);
            if (string != null) {
                try {
                    event = Context.createEventWithIDAndContext(string, metadata);
                }
                catch (OboeException oboeException) {
                    this.a.warn("Failed to set op ID for entry event : " + oboeException.getMessage(), oboeException);
                    event = Context.createEventWithContext(metadata);
                }
            } else {
                boolean bl = span.isRoot() && span.getSpanPropertyValue(Span.SpanProperty.IS_ENTRY_SERVICE_ROOT) != false;
                event = Context.createEventWithContext(metadata, !bl);
                if (bl) {
                    Object object = span.getSpanPropertyValue(Span.SpanProperty.TRACE_DECISION);
                    Object object2 = ((TraceDecision)object).getTraceConfig();
                    XTraceOptions xTraceOptions = span.getSpanPropertyValue(Span.SpanProperty.X_TRACE_OPTIONS);
                    if (object2 != null) {
                        object = ((TraceDecision)object).getRequestType();
                        event.addInfo("SampleRate", ((TraceDecisionUtil.RequestType)((Object)object)).isTriggerTrace() ? -1 : ((TraceConfig)object2).getSampleRate(), "SampleSource", ((TraceDecisionUtil.RequestType)((Object)object)).isTriggerTrace() ? -1 : ((TraceConfig)object2).getSampleRateSourceValue(), "BucketCapacity", ((TraceConfig)object2).getBucketCapacity(((TraceDecisionUtil.RequestType)((Object)object)).getBucketType()), "BucketRate", ((TraceConfig)object2).getBucketRate(((TraceDecisionUtil.RequestType)((Object)object)).getBucketType()));
                        if (((TraceDecisionUtil.RequestType)((Object)object)).isTriggerTrace()) {
                            event.addInfo("TriggeredTrace", (Object)Boolean.TRUE);
                        }
                    }
                    if (xTraceOptions != null) {
                        object = xTraceOptions.getCustomKvs();
                        if (object != null) {
                            object = object.entrySet().iterator();
                            while (object.hasNext()) {
                                object2 = (Map.Entry)object.next();
                                event.addInfo(((XTraceOption)object2.getKey()).getKey(), object2.getValue());
                            }
                        }
                        if ((object = xTraceOptions.getOptionValue(XTraceOption.PD_KEYS)) != null) {
                            event.addInfo("PDKeys", object);
                        }
                    }
                }
            }
        }
        if (event != null) {
            event.addInfo("Layer", span.getOperationName(), "Label", "entry");
            HashMap<String, Object> hashMap = new HashMap<String, Object>(span.getTags());
            event.addInfo(hashMap);
            event.setTimestamp(span.getStart());
            event.report(metadata);
            span.setSpanPropertyValue(Span.SpanProperty.REPORTED_TAG_KEYS, hashMap.keySet());
        }
    }

    public void reportOnFinish(Span object, long l2) {
        Metadata metadata = ((Span)object).context().getMetadata();
        if (((Span)object).context().isSampled()) {
            Event event;
            block14: {
                String string = ((Span)object).getSpanPropertyValue(Span.SpanProperty.EXIT_XID);
                if (string != null) {
                    try {
                        event = Context.createEventWithIDAndContext(string, metadata);
                        break block14;
                    }
                    catch (OboeException oboeException) {
                        this.a.warn("Failed to report span on finish with exitXTraceId [" + string + "], not using the exitXTraceId :" + oboeException.getMessage());
                    }
                }
                event = Context.createEventWithContext(metadata);
            }
            event.addInfo("Layer", ((Span)object).getOperationName(), "Label", "exit");
            event.setTimestamp(l2);
            if (((Span)object).isRoot()) {
                if (((Span)object).hasTraceProperty(Span.TraceProperty.TRANSACTION_NAME)) {
                    event.addInfo("TransactionName", (Object)((Span)object).getTracePropertyValue(Span.TraceProperty.TRANSACTION_NAME));
                }
                if (b) {
                    int n2 = ((Span)object).getSpanPropertyValue(Span.SpanProperty.PROFILE_SPAN_COUNT).get();
                    event.addInfo("ProfileSpans", (Object)n2);
                } else {
                    event.addInfo("ProfileSpans", (Object)-1);
                }
            }
            if (((Span)object).getSpanPropertyValue(Span.SpanProperty.IS_ASYNC).booleanValue()) {
                event.setAsync();
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>(((Span)object).getTags());
            Set<String> set = ((Span)object).getSpanPropertyValue(Span.SpanProperty.REPORTED_TAG_KEYS);
            if (set != null) {
                hashMap.keySet().removeAll(set);
            }
            event.addInfo(hashMap);
            object = ((Span)object).getSpanPropertyValue(Span.SpanProperty.CHILD_EDGES);
            if (object != null) {
                object = object.iterator();
                while (object.hasNext()) {
                    set = (String)object.next();
                    event.addEdge((String)((Object)set));
                }
            }
            event.report(metadata);
            object = ScopeManager.INSTANCE.activeSpan();
            if (object != null) {
                set = new HashSet<String>();
                Set<String> set2 = ((Span)object).getSpanPropertyValue(Span.SpanProperty.CHILD_EDGES);
                if (set2 != null) {
                    set.addAll(set2);
                }
                set.add(metadata.toHexString());
                ((Span)object).setSpanPropertyValue(Span.SpanProperty.CHILD_EDGES, set);
            }
        }
    }

    public void reportOnLog(Span span, LogEntry logEntry) {
        Metadata metadata = span.context().getMetadata();
        if (metadata.isSampled()) {
            Event event = Context.createEventWithContext(metadata);
            event.addInfo("Layer", (Object)span.getOperationName());
            if (logEntry.isError()) {
                event.addInfo("Label", (Object)"error");
            } else {
                event.addInfo("Label", (Object)"info");
            }
            event.addInfo(logEntry.getFields());
            event.setTimestamp(logEntry.getTimestamp());
            event.report(metadata);
        }
    }

    static {
        ProfilerSetting profilerSetting = (ProfilerSetting)ConfigManager.getConfig(ConfigProperty.PROFILER);
        b = profilerSetting != null && profilerSetting.isEnabled();
    }
}

