/*
 * Decompiled with CFR 0.152.
 */
package com.tracelytics.joboe.rpc;

import com.tracelytics.joboe.Event;
import com.tracelytics.joboe.rpc.Client;
import com.tracelytics.joboe.rpc.ClientException;
import com.tracelytics.joboe.rpc.ClientFatalException;
import com.tracelytics.joboe.rpc.ClientRecoverableException;
import com.tracelytics.joboe.rpc.ProtocolClient;
import com.tracelytics.joboe.rpc.ProtocolClientFactory;
import com.tracelytics.joboe.rpc.Result;
import com.tracelytics.joboe.rpc.ResultCode;
import com.tracelytics.joboe.rpc.RpcClientRejectedExecutionException;
import com.tracelytics.joboe.rpc.SettingsResult;
import com.tracelytics.logging.Logger;
import com.tracelytics.logging.LoggerFactory;
import com.tracelytics.util.DaemonThreadFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RpcClient
implements Client {
    private static final Logger d = LoggerFactory.getLogger();
    protected String a;
    protected int b;
    private final String e;
    private boolean f = false;
    private boolean g = false;
    private boolean h = false;
    private Client.Status i = Client.Status.NOT_CONNECTED;
    protected ProtocolClient c;
    private final ProtocolClientFactory<? extends ProtocolClient> j;
    private final Map<TaskType, ExecutorService> k = new HashMap<TaskType, ExecutorService>();
    private final RetryParamConstants l;
    private b m;

    public RpcClient(String string, int n2, String string2, ProtocolClientFactory<? extends ProtocolClient> protocolClientFactory, TaskType ... taskTypeArray) {
        this(string, n2, string2, RetryParamConstants.a(), protocolClientFactory, taskTypeArray);
    }

    public RpcClient(String taskTypeArray, int n2, String string, RetryParamConstants object, ProtocolClientFactory<? extends ProtocolClient> protocolClientFactory, TaskType ... taskTypeArray2) {
        this.a = taskTypeArray;
        this.b = n2;
        this.e = string;
        this.l = object;
        this.j = protocolClientFactory;
        taskTypeArray = this;
        ExecutorService executorService = Executors.newSingleThreadExecutor(DaemonThreadFactory.newInstance("init-rpc-client"));
        executorService.submit(new Runnable((RpcClient)taskTypeArray){
            private /* synthetic */ RpcClient a;
            {
                this.a = rpcClient;
            }

            public final void run() {
                this.a.c();
            }
        });
        executorService.shutdown();
        if (taskTypeArray2 == null || taskTypeArray2.length == 0) {
            taskTypeArray2 = TaskType.values();
        }
        taskTypeArray = taskTypeArray2;
        int n3 = taskTypeArray2.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            object = taskTypeArray[i2];
            if (!((TaskType)((Object)object)).a) continue;
            this.k.put((TaskType)((Object)object), new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(100), DaemonThreadFactory.newInstance(((Enum)object).name().toLowerCase() + "-executor")));
        }
        this.m = new b();
    }

    private <T extends Result> Future<T> a(Callable<T> object, TaskType taskType) throws RpcClientRejectedExecutionException {
        block4: {
            Object object2 = this.k.get((Object)taskType);
            if (object2 == null) {
                throw new RpcClientRejectedExecutionException("Cannot submit job of taskType [" + (Object)((Object)taskType) + "] as this collector client only handles " + this.k.keySet());
            }
            object = new FutureTask(new Callable<T>(this, taskType, (Callable)object){
                private /* synthetic */ TaskType a;
                private /* synthetic */ Callable b;
                private /* synthetic */ RpcClient c;
                {
                    this.c = rpcClient;
                    this.a = taskType;
                    this.b = callable;
                }

                private T a(Callable<T> object, c c2) throws ClientException {
                    RpcClient rpcClient = this.c;
                    synchronized (rpcClient) {
                        try {
                            if (!this.c.b()) {
                                return null;
                            }
                            object = (Result)object.call();
                            if (this.c.f) {
                                d.info("Protocol client [" + (Object)((Object)this.a) + "] successfully recovered : " + this.c.a + ":" + this.c.b);
                                RpcClient.a(this.c, false);
                            }
                            RpcClient.b(this.c, false);
                            if (((Result)object).getResultCode() == ResultCode.TRY_LATER) {
                                c2.a(com.tracelytics.joboe.rpc.RpcClient$d.a);
                            } else if (((Result)object).getResultCode() == ResultCode.LIMIT_EXCEEDED) {
                                c2.a(com.tracelytics.joboe.rpc.RpcClient$d.b);
                            } else if (((Result)object).getResultCode() == ResultCode.REDIRECT && c2.a(com.tracelytics.joboe.rpc.RpcClient$d.e, true)) {
                                RpcClient.a(this.c, ((Result)object).getArg());
                            }
                            this.c.i = ((Result)object).getResultCode().isError() ? Client.Status.FAILURE : Client.Status.OK;
                            this.c.m.a();
                            return object;
                        }
                        catch (Exception exception) {
                            if (this.c.h) {
                                d.debug("Found exception during collector Client shutdown. This is probably not critical as the client is shutting down : " + exception.getMessage(), exception);
                                return null;
                            }
                            if (exception instanceof ClientRecoverableException) {
                                this.c.a(exception, this.a);
                                1 var1_3 = this;
                                var1_3.c.d();
                                var1_3.c.c();
                                c2.a(com.tracelytics.joboe.rpc.RpcClient$d.d);
                                return null;
                            }
                            if (exception instanceof ClientException) {
                                d.warn("Error sending message to collector (fatal exception) [" + (Object)((Object)this.a) + "] : " + exception.getClass().getName() + " message: " + exception.getMessage());
                                throw (ClientException)exception;
                            }
                            d.warn("Error sending message to collector (fatal exception) [" + (Object)((Object)this.a) + "] : " + exception.getClass().getName() + " message: " + exception.getMessage());
                            throw new ClientException(exception);
                        }
                    }
                }

                @Override
                public final /* synthetic */ Object call() throws Exception {
                    Object t2;
                    1 var1_1 = this;
                    c c2 = new c(var1_1.c, var1_1.a);
                    do {
                        1 v0 = var1_1;
                        t2 = v0.a(v0.b, c2);
                    } while (!var1_1.c.h && c2.a());
                    if (t2 == null) {
                        throw new ClientException("Failed to get response of taskType [" + (Object)((Object)var1_1.a) + "] from collector after " + c2.b + " tries");
                    }
                    return t2;
                }
            });
            try {
                object2.execute((Runnable)object);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                if (object2.isShutdown()) break block4;
                object2 = rejectedExecutionException;
                object = this;
                if (d.shouldLog(Logger.Level.DEBUG) || !((RpcClient)object).g) {
                    d.warn("Rejected operation on Collector client side, probably due to full queue : " + ((Throwable)object2).getMessage());
                    ((RpcClient)object).g = true;
                }
                throw new RpcClientRejectedExecutionException(rejectedExecutionException);
            }
        }
        return object;
    }

    private synchronized boolean b() {
        if (this.c == null) {
            this.c();
        }
        return this.c != null;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private final synchronized void c() {
        boolean bl;
        c c2 = new c(this, TaskType.CONNECTION_INIT);
        boolean bl2 = bl = !this.h;
        while (bl) {
            d.debug("Creating collector client  : " + this.a + ":" + this.b);
            try {
                this.c = this.j.buildClient(this.a, this.b);
                d.debug("Created collector client  : " + this.a + ":" + this.b);
                this.c.doPing(this.e);
                d.debug("Collector client Ping successful");
                this.i = Client.Status.OK;
                return;
            }
            catch (Exception exception) {
                this.i = Client.Status.NOT_CONNECTED;
                if (com.tracelytics.joboe.rpc.RpcClient$c.a(c2, com.tracelytics.joboe.rpc.RpcClient$d.c) == 20) {
                    TaskType taskType = TaskType.CONNECTION_INIT;
                    Exception exception2 = exception;
                    RpcClient rpcClient = this;
                    if (d.shouldLog(Logger.Level.DEBUG) || !rpcClient.f) {
                        if (d.shouldLog(Logger.Level.DEBUG)) {
                            d.warn("SSL client connection to collector [" + rpcClient.a + ":" + rpcClient.b + "] failed after retries [" + (Object)((Object)taskType) + "], message : " + exception2.getMessage(), exception2);
                        } else {
                            d.warn("SSL client connection to collector [" + rpcClient.a + ":" + rpcClient.b + "] failed after retries [" + (Object)((Object)taskType) + "], message : " + exception2.getMessage());
                        }
                        rpcClient.f = true;
                    }
                } else {
                    this.a(exception, TaskType.CONNECTION_INIT);
                }
                c2.a(com.tracelytics.joboe.rpc.RpcClient$d.c);
                this.d();
                bl = !this.h && c2.a();
            }
        }
    }

    private void a(Exception exception, TaskType taskType) {
        if (d.shouldLog(Logger.Level.DEBUG)) {
            d.warn("SSL client connection to collector [" + this.a + ":" + this.b + "] failed [" + (Object)((Object)taskType) + "], message : " + exception.getMessage(), exception);
            this.f = true;
        }
    }

    @Override
    public Future<Result> postEvents(List<Event> list, Client.Callback<Result> callback) throws ClientException {
        return this.a(new a<Result>(this, callback, list){
            private /* synthetic */ List a;
            private /* synthetic */ RpcClient b;
            {
                this.b = rpcClient;
                this.a = list;
                super(callback, (byte)0);
            }

            @Override
            public final Result a() throws Exception {
                return this.b.c.doPostEvents(this.b.e, this.a);
            }
        }, TaskType.POST_EVENTS);
    }

    @Override
    public Future<Result> postMetrics(List<Map<String, Object>> list, Client.Callback<Result> callback) throws ClientException {
        return this.a(new a<Result>(this, callback, list){
            private /* synthetic */ List a;
            private /* synthetic */ RpcClient b;
            {
                this.b = rpcClient;
                this.a = list;
                super(callback, (byte)0);
            }

            @Override
            public final Result a() throws Exception {
                return this.b.c.doPostMetrics(this.b.e, this.a);
            }
        }, TaskType.POST_METRICS);
    }

    @Override
    public Future<Result> postStatus(List<Map<String, Object>> list, Client.Callback<Result> callback) throws ClientException {
        return this.a(new a<Result>(this, callback, list){
            private /* synthetic */ List a;
            private /* synthetic */ RpcClient b;
            {
                this.b = rpcClient;
                this.a = list;
                super(callback, (byte)0);
            }

            @Override
            public final Result a() throws Exception {
                return this.b.c.doPostStatus(this.b.e, this.a);
            }
        }, TaskType.POST_STATUS);
    }

    @Override
    public Future<SettingsResult> getSettings(String string, Client.Callback<SettingsResult> callback) throws ClientException {
        return this.a(new a<SettingsResult>(this, callback, string){
            private /* synthetic */ String a;
            private /* synthetic */ RpcClient b;
            {
                this.b = rpcClient;
                this.a = string;
                super(callback, (byte)0);
            }

            @Override
            public final /* synthetic */ Result a() throws Exception {
                6 var1_1 = this;
                return var1_1.b.c.doGetSettings(var1_1.b.e, var1_1.a);
            }
        }, TaskType.GET_SETTINGS);
    }

    @Override
    public void close() {
        this.h = true;
        for (ExecutorService executorService : this.k.values()) {
            if (this.i != Client.Status.OK) {
                d.debug("Force shutting down the collector client executor to avoid hanging due to connection retry");
                executorService.shutdownNow();
                continue;
            }
            d.debug("Shutting down the collector client executor");
            executorService.shutdown();
        }
        this.d();
    }

    private synchronized void d() {
        if (this.c != null) {
            this.c.shutdown();
            this.c = null;
        }
    }

    @Override
    public Client.Status getStatus() {
        return this.i;
    }

    public String toString() {
        return "RpcClient [host=" + this.a + ", port=" + this.b + "]";
    }

    static /* synthetic */ boolean a(RpcClient rpcClient, boolean bl) {
        rpcClient.f = false;
        return false;
    }

    static /* synthetic */ boolean b(RpcClient rpcClient, boolean bl) {
        rpcClient.g = false;
        return false;
    }

    static /* synthetic */ void a(RpcClient rpcClient, String string) throws ClientFatalException {
        rpcClient.d();
        if (string != null && !"".equals(string)) {
            String string2;
            String[] stringArray = string.split(":");
            Integer n2 = null;
            if (stringArray.length == 1) {
                d.warn("Redirect from Collector but couldn't locate port number from the response arg: [" + string + "], using previous port: " + rpcClient.b);
                string2 = stringArray[0];
            } else {
                string2 = stringArray[0];
                try {
                    n2 = Integer.parseInt(stringArray[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ClientFatalException("Failed to perform collector Redirect. Invalid port number [" + stringArray[1] + "] found in arg [" + string + "]");
                }
            }
            rpcClient.a = string2;
            if (n2 != null) {
                rpcClient.b = n2;
            }
            d.info("Collector Redirect to " + rpcClient.a + ":" + rpcClient.b);
            rpcClient.c();
            return;
        }
        throw new ClientFatalException("Failed to perform collector Redirect. Redirect args is empty");
    }

    final class b {
        private ScheduledExecutorService b = Executors.newScheduledThreadPool(1, DaemonThreadFactory.newInstance("keep-alive"));
        private ScheduledFuture<?> c;
        private Runnable d;

        public b() {
            this.d = new Runnable(this, RpcClient.this){
                private /* synthetic */ b a;
                {
                    this.a = b2;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void run() {
                    RpcClient rpcClient = this.a.RpcClient.this;
                    synchronized (rpcClient) {
                        try {
                            this.a.RpcClient.this.c.doPing(this.a.RpcClient.this.e);
                            this.a.a();
                        }
                        catch (Exception exception) {
                            d.debug("Keep alive ping failed [" + exception.getMessage() + "]", exception);
                        }
                        return;
                    }
                }
            };
            this.a();
        }

        private synchronized void a() {
            if (this.c != null) {
                this.c.cancel(false);
            }
            this.c = this.b.schedule(this.d, 20L, TimeUnit.SECONDS);
        }
    }

    final class c {
        private final Map<d, Integer> a = new HashMap<d, Integer>();
        private final Map<d, Integer> b = new HashMap<d, Integer>();
        private boolean c;
        private Integer d;
        private TaskType e;
        private /* synthetic */ RpcClient f;

        c(RpcClient rpcClient, TaskType taskType) {
            this.f = rpcClient;
            this.e = taskType;
        }

        public final boolean a(d d2) {
            return this.a(d2, false);
        }

        public final boolean a(d d2, boolean bl) {
            Integer n2;
            Integer n3;
            block5: {
                int n4;
                block6: {
                    block4: {
                        n3 = this.a.get((Object)d2);
                        if (n3 != null) break block4;
                        c c2 = this;
                        n3 = c2.c(c2.e, d2);
                        if (n3 != null) break block5;
                        n4 = 0;
                        break block6;
                    }
                    c c3 = this;
                    n2 = c3.b(c3.e, d2);
                    n4 = n2 != null ? Math.min((int)((double)n3.intValue() * 1.5), n2) : (int)((double)n3.intValue() * 1.5);
                }
                n3 = n4;
            }
            if (bl) {
                this.a.clear();
            }
            this.a.put(d2, n3);
            n2 = this.b.get((Object)d2);
            n2 = n2 == null ? Integer.valueOf(1) : Integer.valueOf(n2 + 1);
            if (bl) {
                this.b.clear();
            }
            this.b.put(d2, n2);
            c c4 = this;
            Integer n5 = c4.a(c4.e, d2);
            boolean bl2 = this.c = n5 == null || n2 <= n5;
            if (!this.c) {
                d.debug("Not going to retry message as max retry count [" + n5 + "] is exceeded, cause: " + (Object)((Object)d2));
                this.d = 0;
            } else {
                d.debug("Flagging to retry message with delay [" + n3 + "] ms, cause: " + (Object)((Object)d2));
                this.d = n3;
            }
            return this.c;
        }

        private Integer a(TaskType taskType, d d2) {
            return (Integer)((Map)this.f.l.c.get((Object)taskType)).get((Object)d2);
        }

        private Integer b(TaskType taskType, d d2) {
            return (Integer)((Map)this.f.l.b.get((Object)taskType)).get((Object)d2);
        }

        private Integer c(TaskType taskType, d d2) {
            return (Integer)((Map)this.f.l.a.get((Object)taskType)).get((Object)d2);
        }

        public final boolean a() {
            if (this.c) {
                try {
                    if (this.d > 0) {
                        d.debug("Collector client retry sleeping for " + this.d + " millisecs");
                        TimeUnit.MILLISECONDS.sleep(this.d.intValue());
                    }
                }
                catch (InterruptedException interruptedException) {
                    d.debug("Collector client retry sleep is interrupted, message: " + interruptedException.getMessage());
                    return false;
                }
                finally {
                    this.d = 0;
                    this.c = false;
                }
                return true;
            }
            return false;
        }

        static /* synthetic */ int a(c c2, d d2) {
            if (c2.b.containsKey((Object)d2)) {
                return c2.b.get((Object)d2);
            }
            return 0;
        }
    }

    public static class RetryParamConstants {
        private final Map<TaskType, Map<d, Integer>> a = new HashMap<TaskType, Map<d, Integer>>();
        private final Map<TaskType, Map<d, Integer>> b = new HashMap<TaskType, Map<d, Integer>>();
        private final Map<TaskType, Map<d, Integer>> c = new HashMap<TaskType, Map<d, Integer>>();

        static final RetryParamConstants a() {
            RetryParamConstants retryParamConstants = new RetryParamConstants(500, 60000, 20);
            return retryParamConstants;
        }

        private final void a(TaskType object, Integer n2) {
            for (Map.Entry entry : this.c.get(object).entrySet()) {
                if (!((d)((Object)entry.getKey())).a()) continue;
                entry.setValue(n2);
            }
        }

        public RetryParamConstants(int n2, int n3, int n4) {
            for (TaskType taskType : TaskType.values()) {
                HashMap<d, Integer> hashMap = new HashMap<d, Integer>();
                hashMap.put(com.tracelytics.joboe.rpc.RpcClient$d.a, n2);
                hashMap.put(com.tracelytics.joboe.rpc.RpcClient$d.b, n2);
                hashMap.put(com.tracelytics.joboe.rpc.RpcClient$d.c, n2);
                hashMap.put(com.tracelytics.joboe.rpc.RpcClient$d.d, n2);
                this.a.put(taskType, hashMap);
                hashMap = new HashMap<d, Integer>();
                hashMap.put(com.tracelytics.joboe.rpc.RpcClient$d.a, n3);
                hashMap.put(com.tracelytics.joboe.rpc.RpcClient$d.b, n3);
                hashMap.put(com.tracelytics.joboe.rpc.RpcClient$d.c, n3);
                hashMap.put(com.tracelytics.joboe.rpc.RpcClient$d.d, n3);
                this.b.put(taskType, hashMap);
                hashMap = new HashMap<d, Integer>();
                hashMap.put(com.tracelytics.joboe.rpc.RpcClient$d.a, n4);
                hashMap.put(com.tracelytics.joboe.rpc.RpcClient$d.b, n4);
                hashMap.put(com.tracelytics.joboe.rpc.RpcClient$d.c, null);
                hashMap.put(com.tracelytics.joboe.rpc.RpcClient$d.d, n4);
                hashMap.put(com.tracelytics.joboe.rpc.RpcClient$d.e, n4);
                this.c.put(taskType, hashMap);
            }
            this.a(TaskType.GET_SETTINGS, 0);
            this.a(TaskType.CONNECTION_INIT, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum d {
        a(true),
        b(true),
        c(true),
        d(true),
        f(false),
        e(false);

        private boolean g;

        private d(boolean bl) {
            this.g = bl;
        }

        public final boolean a() {
            return this.g;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class a<T extends Result>
    implements Callable<T> {
        private final Client.Callback<T> a;
        private static String b = null;

        private a(Client.Callback<T> callback) {
            this.a = callback;
        }

        private T b() throws Exception {
            try {
                String string;
                T t2 = this.a();
                if (this.a != null) {
                    this.a.complete(t2);
                }
                if ((string = ((Result)t2).getWarning()) != null && !"".equals(string)) {
                    if (d.shouldLog(Logger.Level.DEBUG) || !string.equals(b)) {
                        d.warn("RPC call warning : [" + string + "]");
                        b = string;
                    }
                } else if (((Result)t2).getResultCode() == ResultCode.OK) {
                    b = null;
                }
                return t2;
            }
            catch (Exception exception) {
                if (this.a != null) {
                    this.a.fail(exception);
                }
                throw exception;
            }
        }

        public abstract T a() throws Exception;

        @Override
        public /* synthetic */ Object call() throws Exception {
            return this.b();
        }

        /* synthetic */ a(Client.Callback callback, byte by) {
            this(callback);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TaskType {
        POST_EVENTS(true),
        POST_METRICS(true),
        POST_STATUS(true),
        GET_SETTINGS(true),
        CONNECTION_INIT(false);

        private boolean a;

        private TaskType(boolean bl) {
            this.a = bl;
        }
    }
}

