/*
 * Decompiled with CFR 0.152.
 */
package com.tracelytics.joboe.config;

import com.tracelytics.a.h.a;
import com.tracelytics.a.h.b;
import com.tracelytics.joboe.config.ConfigGroup;
import com.tracelytics.joboe.config.ConfigParser;
import com.tracelytics.joboe.config.ConfigProperty;
import com.tracelytics.joboe.config.InvalidConfigException;
import com.tracelytics.logging.Logger;
import com.tracelytics.logging.LoggerFactory;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigContainer {
    private static final Logger a = LoggerFactory.getLogger();
    private final Map<ConfigGroup, Map<ConfigProperty, Object>> b = new HashMap<ConfigGroup, Map<ConfigProperty, Object>>();

    public ConfigContainer subset(ConfigGroup ... configGroupArray) {
        ConfigContainer configContainer = new ConfigContainer();
        for (ConfigGroup configGroup : configGroupArray) {
            configContainer.b.put(configGroup, this.b.get((Object)configGroup));
        }
        return configContainer;
    }

    public Object get(ConfigProperty configProperty) {
        Map<ConfigProperty, Object> map = this.b.get((Object)configProperty.a());
        if (map != null) {
            return map.get((Object)configProperty);
        }
        return null;
    }

    public boolean containsProperty(ConfigProperty configProperty) {
        Map<ConfigProperty, Object> map = this.b.get((Object)configProperty.a());
        if (map != null) {
            return map.containsKey((Object)configProperty);
        }
        return false;
    }

    public Object remove(ConfigProperty configProperty) {
        Map<ConfigProperty, Object> map = this.b.get((Object)configProperty.a());
        if (map != null) {
            return map.remove((Object)configProperty);
        }
        return null;
    }

    public void put(ConfigProperty configProperty, Object object) throws InvalidConfigException {
        this.put(configProperty, object, false);
    }

    public void put(ConfigProperty configProperty, Object object, boolean bl) throws InvalidConfigException {
        Map<ConfigProperty, Object> map = this.b.get((Object)configProperty.a());
        if (map == null) {
            map = new HashMap<ConfigProperty, Object>();
            this.b.put(configProperty.a(), map);
        }
        if (!bl && map.containsKey((Object)configProperty)) {
            if (!map.get((Object)configProperty).equals(object)) {
                a.debug("key [" + (Object)((Object)configProperty) + "] is already defined. Ignoring new value");
                return;
            }
        } else {
            if (object == null) {
                throw new InvalidConfigException(configProperty, " Does not support null property value", null);
            }
            map.put(configProperty, object);
        }
    }

    public void putByStringValue(ConfigProperty configProperty, String string) throws InvalidConfigException {
        Object object = ConfigContainer.a(string, configProperty);
        if (object == null) {
            throw new InvalidConfigException(configProperty, "Does not support null property value, the value [" + string + "] got converted to null value", null);
        }
        this.put(configProperty, object);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <T extends Serializable> Object a(String string, ConfigProperty configProperty) throws InvalidConfigException {
        void var2_14;
        Class<? extends Serializable> clazz = configProperty.getTypeClass();
        ConfigParser<?, ?> configParser = configProperty.getConfigParser();
        try {
            if (clazz != String.class) {
                string = string.trim();
            }
            if (clazz == String.class) {
                String string2 = string;
            } else if (clazz == Long.class) {
                Long l2 = new Long(string);
            } else if (clazz == BigDecimal.class) {
                BigDecimal bigDecimal = new BigDecimal(string);
            } else if (clazz == Integer.class) {
                Integer n2 = new Integer(string);
            } else if (clazz == Boolean.class) {
                if (!"true".equalsIgnoreCase(string) && !"false".equalsIgnoreCase(string)) throw new InvalidConfigException(configProperty, "[" + string + "] is not valid boolean value");
                Boolean bl = new Boolean(string);
            } else if (clazz == String[].class) {
                String[] stringArray = ConfigContainer.a(string);
            } else {
                a.warn("Unknown type for configuration: " + clazz.getName());
                String string3 = string;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidConfigException(configProperty, "Failed to parse value [" + string + "] of class [" + clazz.getName() + "], message: " + illegalArgumentException.getMessage(), illegalArgumentException);
        }
        if (configParser == null) return var2_14;
        try {
            return configParser.convert(var2_14);
        }
        catch (InvalidConfigException invalidConfigException) {
            throw new InvalidConfigException(configProperty, invalidConfigException.getMessage(), invalidConfigException.getCause());
        }
        catch (ClassCastException classCastException) {
            throw new InvalidConfigException(configProperty, "Failed to read config value " + var2_14 + ", message : " + classCastException.getMessage(), classCastException);
        }
    }

    private static String[] a(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            a a2 = new a(string);
            for (int i2 = 0; i2 < a2.a(); ++i2) {
                arrayList.add((String)a2.a(i2));
            }
        }
        catch (b b2) {
            a.warn(b2.getMessage());
            throw new IllegalArgumentException("Cannot parse the string value " + string + " as json array : " + b2.getMessage(), b2);
        }
        ArrayList<String> arrayList2 = arrayList;
        return arrayList2.toArray(new String[arrayList2.size()]);
    }

    public String toString() {
        return this.b.toString();
    }
}

