/*
 * Decompiled with CFR 0.152.
 */
package com.tracelytics.agent.config;

import com.tracelytics.joboe.config.ConfigParser;
import com.tracelytics.joboe.config.InvalidConfigException;
import com.tracelytics.joboe.config.ProxyConfig;
import java.net.MalformedURLException;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyConfigParser
implements ConfigParser<String, ProxyConfig> {
    public static final ProxyConfigParser INSTANCE = new ProxyConfigParser();

    private ProxyConfigParser() {
    }

    @Override
    public ProxyConfig convert(String object) throws InvalidConfigException {
        try {
            object = new URL((String)object);
        }
        catch (MalformedURLException malformedURLException) {
            throw new InvalidConfigException("Failed to parse proxy string value. The config value should either be http://<proxyHost>:<proxyPort> for a proxy server that does not require authentication, or http://<username>:<password>@<proxyHost>:<proxyPort> for a proxy server that requires Basic authentication. Error message is [" + malformedURLException.getMessage() + "]", malformedURLException);
        }
        if (!"http".equals(((URL)object).getProtocol())) {
            throw new InvalidConfigException("Failed to parse proxy string value. Unsupported protocol [" + ((URL)object).getProtocol() + "]. Currently support only proxying via a HTTP proxy server");
        }
        if (((URL)object).getPort() == -1) {
            throw new InvalidConfigException("Failed to parse proxy string value. Missing/Invalid port number.");
        }
        String[] stringArray = ((URL)object).getUserInfo();
        if (stringArray != null) {
            if ((stringArray = stringArray.split(":", 2)).length != 2) {
                throw new InvalidConfigException("Failed to parse proxy config's user/password, it should be in username:password format");
            }
            return new ProxyConfig(((URL)object).getHost(), ((URL)object).getPort(), stringArray[0], stringArray[1]);
        }
        return new ProxyConfig(((URL)object).getHost(), ((URL)object).getPort(), null, null);
    }
}

