/*
 * Decompiled with CFR 0.152.
 */
package com.tracelytics.agent.config;

import com.tracelytics.instrumentation.Module;
import com.tracelytics.joboe.config.ConfigParser;
import com.tracelytics.joboe.config.InvalidConfigException;
import com.tracelytics.logging.Logger;
import com.tracelytics.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModulesParser
implements ConfigParser<String[], List<Module>> {
    private Logger a = LoggerFactory.getLogger();
    public static final ModulesParser INSTANCE = new ModulesParser();

    @Override
    public List<Module> convert(String[] stringArray) throws InvalidConfigException {
        ArrayList<Module> arrayList = new ArrayList<Module>();
        for (String string : stringArray) {
            if ("ALL".equals(string)) {
                return Arrays.asList(Module.values());
            }
            try {
                Module module = Module.valueOf(string);
                arrayList.add(module);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.a.warn("Failed to parse module string [" + string + "] as it is not a known module");
                throw new InvalidConfigException(illegalArgumentException);
            }
        }
        return arrayList;
    }
}

