/*
 * Decompiled with CFR 0.152.
 */
package com.tracelytics.agent;

import com.tracelytics.a.f.a.h;
import com.tracelytics.agent.AppEnvironment;
import com.tracelytics.agent.ResourceDirectory;
import com.tracelytics.agent.a;
import com.tracelytics.agent.b;
import com.tracelytics.agent.config.HideParamsConfigParser;
import com.tracelytics.agent.config.LogFileStringParser;
import com.tracelytics.agent.config.LogSettingParser;
import com.tracelytics.agent.config.LogTraceIdSettingParser;
import com.tracelytics.agent.config.ModeStringToBooleanParser;
import com.tracelytics.agent.config.ModulesParser;
import com.tracelytics.agent.config.ProfilerSettingParser;
import com.tracelytics.agent.config.ProxyConfigParser;
import com.tracelytics.agent.config.RangeValidationParser;
import com.tracelytics.agent.config.TracingModeParser;
import com.tracelytics.agent.config.TransactionSettingsConfigParser;
import com.tracelytics.agent.config.UrlSampleRateConfigParser;
import com.tracelytics.joboe.config.ConfigContainer;
import com.tracelytics.joboe.config.ConfigGroup;
import com.tracelytics.joboe.config.ConfigManager;
import com.tracelytics.joboe.config.ConfigProperty;
import com.tracelytics.joboe.config.ConfigSourceType;
import com.tracelytics.joboe.config.EnvConfigReader;
import com.tracelytics.joboe.config.InvalidConfigException;
import com.tracelytics.joboe.config.InvalidConfigReadSourceException;
import com.tracelytics.joboe.config.InvalidConfigServiceKeyException;
import com.tracelytics.joboe.config.JavaAgentArgumentConfigReader;
import com.tracelytics.joboe.config.JsonConfigReader;
import com.tracelytics.joboe.config.ProfilerSetting;
import com.tracelytics.joboe.config.TraceConfigs;
import com.tracelytics.joboe.rpc.ClientException;
import com.tracelytics.joboe.rpc.ClientLoggingCallback;
import com.tracelytics.joboe.rpc.Result;
import com.tracelytics.joboe.rpc.RpcClientManager;
import com.tracelytics.logging.Logger;
import com.tracelytics.logging.LoggerFactory;
import com.tracelytics.monitor.c;
import com.tracelytics.util.JavaProcessUtils;
import com.tracelytics.util.ServiceKeyUtils;
import com.tracelytics.util.TimeUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Agent
implements ClassFileTransformer {
    public static final int SAMPLE_RESOLUTION = 1000000;
    public static final int MIN_SUPPORTED_JAVA_MAJOR_VERSION = 50;
    public static String version = null;
    private static a a = null;
    private static AgentStatus b = AgentStatus.UNINITIALIZED;
    private static final Logger c = LoggerFactory.getLogger();
    private static String d;
    private static long e;
    private static AtomicBoolean f;
    private static String g;

    /*
     * Loose catch block
     */
    public static void premain(String object, Instrumentation instrumentation) {
        block45: {
            block44: {
                block43: {
                    if (b == AgentStatus.INITIALIZED_FAILED || b == AgentStatus.INITIALIZED_SUCCESSFUL) {
                        c.warn("WARNING: Agent has already been initialized: Check command line parameters to make sure -javaagent is only specified once.");
                        return;
                    }
                    JavaProcessUtils.getPid();
                    Properties properties = new Properties();
                    properties.load(Agent.class.getResourceAsStream("/versions.properties"));
                    version = properties.getProperty("agent.version");
                    if (version != null) break block43;
                    c.warn("Could not locate agent.version in /versions.properties for version. Agent not starting...");
                    try {
                        if (Agent.getStatus() != AgentStatus.DISABLED) {
                            e = Agent.currentTimeStamp();
                            if (!"jboss".equals(AppEnvironment.getAppServerName()) && h.b >= 51) {
                                Agent.a(true);
                            }
                            if (Agent.getStatus() == AgentStatus.INITIALIZED_SUCCESSFUL) {
                                com.tracelytics.monitor.c.a();
                            }
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        c.warn("Failed to execute finally block in premain: " + throwable.getMessage(), throwable);
                        b = AgentStatus.INITIALIZED_FAILED;
                        return;
                    }
                }
                if (version.endsWith("-SNAPSHOT")) {
                    version = version.substring(0, version.length() - 9);
                }
                Agent.initConfig((String)object);
                object = (Boolean)ConfigManager.getConfig(ConfigProperty.AGENT_ENABLED);
                object = object == null ? true : (Boolean)object;
                if (((Boolean)object).booleanValue()) break block44;
                b = AgentStatus.DISABLED;
                c.info("Agent is disabled as agent.enabled is configured to false.");
                try {
                    if (Agent.getStatus() != AgentStatus.DISABLED) {
                        e = Agent.currentTimeStamp();
                        if (!"jboss".equals(AppEnvironment.getAppServerName()) && h.b >= 51) {
                            Agent.a(true);
                        }
                        if (Agent.getStatus() == AgentStatus.INITIALIZED_SUCCESSFUL) {
                            com.tracelytics.monitor.c.a();
                        }
                    }
                    return;
                }
                catch (Throwable throwable) {
                    c.warn("Failed to execute finally block in premain: " + throwable.getMessage(), throwable);
                    b = AgentStatus.INITIALIZED_FAILED;
                    return;
                }
            }
            if (h.b >= 50) break block45;
            b = AgentStatus.DISABLED;
            c.info("Agent is disabled as it only supports Java Major version 50 or later, but found " + h.b);
            try {
                if (Agent.getStatus() != AgentStatus.DISABLED) {
                    e = Agent.currentTimeStamp();
                    if (!"jboss".equals(AppEnvironment.getAppServerName()) && h.b >= 51) {
                        Agent.a(true);
                    }
                    if (Agent.getStatus() == AgentStatus.INITIALIZED_SUCCESSFUL) {
                        com.tracelytics.monitor.c.a();
                    }
                }
                return;
            }
            catch (Throwable throwable) {
                c.warn("Failed to execute finally block in premain: " + throwable.getMessage(), throwable);
                b = AgentStatus.INITIALIZED_FAILED;
                return;
            }
        }
        if (instrumentation == null) {
            c.info("premain() Instrumentation parameter is null, not setting agent");
        } else {
            a = h.b >= 53 ? new b(instrumentation) : new a(instrumentation);
            try {
                instrumentation.addTransformer(a, true);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                c.info("Running on jdk 1.5 or earlier, would not attempt to retransform classes");
                instrumentation.addTransformer(a);
            }
        }
        Agent.a(AgentStatus.INITIALIZED_SUCCESSFUL);
        b = AgentStatus.INITIALIZED_SUCCESSFUL;
        try {
            if (Agent.getStatus() != AgentStatus.DISABLED) {
                e = Agent.currentTimeStamp();
                if (!"jboss".equals(AppEnvironment.getAppServerName()) && h.b >= 51) {
                    Agent.a(true);
                }
                if (Agent.getStatus() == AgentStatus.INITIALIZED_SUCCESSFUL) {
                    com.tracelytics.monitor.c.a();
                }
            }
            return;
        }
        catch (Throwable throwable) {
            c.warn("Failed to execute finally block in premain: " + throwable.getMessage(), throwable);
            b = AgentStatus.INITIALIZED_FAILED;
            return;
        }
        catch (Throwable throwable) {
            try {
                c.error("Exception during initialization : " + throwable.getMessage(), throwable);
                d = throwable.getMessage() != null ? throwable.getMessage() : "Exception thrown [" + throwable.getClass().getName() + "]";
                Agent.a(AgentStatus.INITIALIZED_FAILED);
                b = AgentStatus.INITIALIZED_FAILED;
            }
            catch (Throwable throwable2) {
                try {
                    if (Agent.getStatus() != AgentStatus.DISABLED) {
                        e = Agent.currentTimeStamp();
                        if (!"jboss".equals(AppEnvironment.getAppServerName()) && h.b >= 51) {
                            Agent.a(true);
                        }
                        if (Agent.getStatus() == AgentStatus.INITIALIZED_SUCCESSFUL) {
                            com.tracelytics.monitor.c.a();
                        }
                    }
                }
                catch (Throwable throwable3) {
                    c.warn("Failed to execute finally block in premain: " + throwable3.getMessage(), throwable3);
                    b = AgentStatus.INITIALIZED_FAILED;
                }
                throw throwable2;
            }
            try {
                if (Agent.getStatus() != AgentStatus.DISABLED) {
                    e = Agent.currentTimeStamp();
                    if (!"jboss".equals(AppEnvironment.getAppServerName()) && h.b >= 51) {
                        Agent.a(true);
                    }
                    if (Agent.getStatus() == AgentStatus.INITIALIZED_SUCCESSFUL) {
                        com.tracelytics.monitor.c.a();
                    }
                }
                return;
            }
            catch (Throwable throwable4) {
                c.warn("Failed to execute finally block in premain: " + throwable4.getMessage(), throwable4);
                b = AgentStatus.INITIALIZED_FAILED;
                return;
            }
        }
    }

    public static void initConfig(String string) throws InvalidConfigException {
        Agent.initConfig(string, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void initConfig(String object, String string) throws InvalidConfigException {
        ConfigContainer configContainer = null;
        boolean bl = false;
        try {
            ConfigProperty.AGENT_LOGGING.setParser(LogSettingParser.INSTANCE);
            ConfigProperty.AGENT_LOG_FILE.setParser(new LogFileStringParser());
            ConfigProperty.AGENT_LOGGING_TRACE_ID.setParser(LogTraceIdSettingParser.INSTANCE);
            ConfigProperty.AGENT_TRACING_MODE.setParser(new TracingModeParser());
            ConfigProperty.AGENT_SQL_QUERY_MAX_LENGTH.setParser(new RangeValidationParser<Integer>(2048, 131072));
            ConfigProperty.AGENT_URL_SAMPLE_RATE.setParser(UrlSampleRateConfigParser.INSTANCE);
            ConfigProperty.AGENT_BACKTRACE_MODULES.setParser(ModulesParser.INSTANCE);
            ConfigProperty.AGENT_EXTENDED_BACK_TRACES_BY_MODULE.setParser(ModulesParser.INSTANCE);
            ConfigProperty.AGENT_HIDE_PARAMS.setParser(new HideParamsConfigParser());
            ConfigProperty.AGENT_TRANSACTION_SETTINGS.setParser(TransactionSettingsConfigParser.INSTANCE);
            ConfigProperty.AGENT_TRIGGER_TRACE_ENABLED.setParser(ModeStringToBooleanParser.INSTANCE);
            ConfigProperty.AGENT_PROXY.setParser(ProxyConfigParser.INSTANCE);
            ConfigProperty.PROFILER.setParser(ProfilerSettingParser.INSTANCE);
            configContainer = Agent.a((String)object, System.getenv(), string);
        }
        catch (InvalidConfigException invalidConfigException) {
            try {
                bl = true;
                if (!(invalidConfigException instanceof InvalidConfigReadSourceException)) throw invalidConfigException;
                configContainer = ((InvalidConfigReadSourceException)invalidConfigException).getConfigContainerBeforeException();
                throw invalidConfigException;
            }
            catch (Throwable throwable) {
                if (configContainer == null) throw throwable;
                LoggerFactory.init(configContainer.subset(ConfigGroup.AGENT));
                try {
                    Agent.b(configContainer);
                    throw throwable;
                }
                catch (InvalidConfigException invalidConfigException2) {
                    if (bl) throw throwable;
                    throw invalidConfigException2;
                }
            }
        }
        LoggerFactory.init(configContainer.subset(ConfigGroup.AGENT));
        try {
            Agent.b(configContainer);
            return;
        }
        catch (InvalidConfigException invalidConfigException) {
            object = invalidConfigException;
            throw invalidConfigException;
        }
    }

    private static void a(AgentStatus object) {
        if (object == AgentStatus.INITIALIZED_SUCCESSFUL) {
            c.info("Java agent version " + Agent.getVersion() + " started successfully");
        } else {
            c.info("Java agent version " + Agent.getVersion() + " failed to start");
        }
        object = ResourceDirectory.getAgentJarPath();
        c.info("Java agent jar location: " + (object != null ? ((File)object).toString() : "unresolved"));
        c.info("Java agent config location: " + (g != null ? g : "unresolved"));
        object = (String)ConfigManager.getConfig(ConfigProperty.AGENT_SERVICE_KEY);
        if (object != null && (object = ServiceKeyUtils.getServiceName((String)object)) != null) {
            c.info("Java agent service name: " + (String)object);
        }
    }

    public static long currentTimeStamp() {
        return TimeUtils.getTimestampMicroSeconds();
    }

    public static AgentStatus getStatus() {
        return b;
    }

    public static String getVersion() {
        return version;
    }

    private static ConfigContainer a(String object, Map<String, String> object2, String object3) throws InvalidConfigException {
        ConfigContainer configContainer = new ConfigContainer();
        if (object3 != null) {
            configContainer.putByStringValue(ConfigProperty.AGENT_SERVICE_KEY, (String)object3);
        }
        object3 = new ArrayList();
        try {
            c.debug("Start reading configs from ENV");
            new EnvConfigReader((Map<String, String>)object2).read(configContainer);
            c.debug("Finished reading configs from ENV");
        }
        catch (InvalidConfigException invalidConfigException) {
            object3.add(new InvalidConfigReadSourceException(invalidConfigException.getConfigProperty(), ConfigSourceType.ENV_VAR, null, configContainer, invalidConfigException));
        }
        try {
            c.debug("Start reading configs from -javaagent arguments");
            new JavaAgentArgumentConfigReader((String)object).read(configContainer);
            c.debug("Finished reading configs from -javaagent arguments");
        }
        catch (InvalidConfigException invalidConfigException) {
            object3.add(new InvalidConfigReadSourceException(invalidConfigException.getConfigProperty(), ConfigSourceType.JVM_ARG, null, configContainer, invalidConfigException));
        }
        object2 = null;
        try {
            if (configContainer.containsProperty(ConfigProperty.AGENT_CONFIG)) {
                object2 = (String)configContainer.get(ConfigProperty.AGENT_CONFIG);
                try {
                    object = new FileInputStream((String)object2);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new InvalidConfigException(fileNotFoundException);
                }
            }
            object2 = ResourceDirectory.getJavaAgentConfigLocation();
            try {
                object = new FileInputStream((String)object2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                c.info("No config file found in " + ResourceDirectory.getJavaAgentConfigLocation() + " . Going to use default values");
                object = Agent.class.getResourceAsStream("/javaagent.json");
                object2 = "default";
            }
            g = object2;
            c.debug("Start reading configs from config file: " + g);
            new JsonConfigReader((InputStream)object).read(configContainer);
            c.debug("Finished reading configs from config file: " + g);
        }
        catch (InvalidConfigException invalidConfigException) {
            object3.add(new InvalidConfigReadSourceException(invalidConfigException.getConfigProperty(), ConfigSourceType.JSON_FILE, (String)object2, configContainer, invalidConfigException));
        }
        if (!object3.isEmpty()) {
            throw (InvalidConfigException)object3.get(0);
        }
        Agent.a(configContainer);
        return configContainer;
    }

    private static void a(ConfigContainer configContainer) throws InvalidConfigException {
        Object object = new HashSet<ConfigProperty>();
        object.add(ConfigProperty.AGENT_SERVICE_KEY);
        object.add(ConfigProperty.AGENT_LOGGING);
        object.add(ConfigProperty.AGENT_JDBC_INST_ALL);
        object.add(ConfigProperty.MONITOR_JMX_ENABLE);
        object.add(ConfigProperty.MONITOR_JMX_SCOPES);
        HashSet<ConfigProperty> hashSet = new HashSet<ConfigProperty>();
        object = object.iterator();
        while (object.hasNext()) {
            ConfigProperty configProperty = (ConfigProperty)((Object)object.next());
            if (configContainer.containsProperty(configProperty)) continue;
            hashSet.add(configProperty);
        }
        if (!hashSet.isEmpty()) {
            object = new StringBuffer("Missing Configs ");
            ((StringBuffer)object).append(((Object)hashSet).toString());
            throw new InvalidConfigException(((StringBuffer)object).toString());
        }
    }

    private static void b(ConfigContainer configContainer) throws InvalidConfigException {
        Object object;
        Object object2;
        if (configContainer.containsProperty(ConfigProperty.AGENT_DEBUG)) {
            configContainer.put(ConfigProperty.AGENT_LOGGING, Boolean.FALSE);
        }
        if (configContainer.containsProperty(ConfigProperty.AGENT_SAMPLE_RATE) && ((Integer)(object2 = (Integer)configContainer.get(ConfigProperty.AGENT_SAMPLE_RATE)) < 0 || (Integer)object2 > 1000000)) {
            c.warn((Object)((Object)ConfigProperty.AGENT_SAMPLE_RATE) + ": Invalid argument value: " + object2 + ": must be between 0 and 1000000");
            throw new InvalidConfigException("Invalid " + ConfigProperty.AGENT_SAMPLE_RATE.getConfigFileKey() + " : " + object2);
        }
        if (configContainer.containsProperty(ConfigProperty.AGENT_SERVICE_KEY) && !"".equals(configContainer.get(ConfigProperty.AGENT_SERVICE_KEY))) {
            object2 = (String)configContainer.get(ConfigProperty.AGENT_SERVICE_KEY);
            object = ServiceKeyUtils.transformServiceKey((String)object2);
            if (!((String)object).equalsIgnoreCase((String)object2)) {
                c.warn("Invalid service name detected in service key, the service key is transformed to " + ServiceKeyUtils.maskServiceKey((String)object));
                configContainer.put(ConfigProperty.AGENT_SERVICE_KEY, object, true);
            }
        } else {
            if (!configContainer.containsProperty(ConfigProperty.AGENT_SERVICE_KEY)) {
                c.warn("Could not find the service key! Please specify " + ConfigProperty.AGENT_SERVICE_KEY.getConfigFileKey() + " in javaagent.json");
                throw new InvalidConfigServiceKeyException("Service key not found");
            }
            c.warn("Service key is empty! Please specify " + ConfigProperty.AGENT_SERVICE_KEY.getConfigFileKey() + " in javaagent.json");
            throw new InvalidConfigServiceKeyException("Service key is empty");
        }
        c.debug("Service key (masked) is [" + ServiceKeyUtils.maskServiceKey((String)object) + "]");
        if (!configContainer.containsProperty(ConfigProperty.AGENT_JDBC_INST_ALL)) {
            configContainer.put(ConfigProperty.AGENT_JDBC_INST_ALL, Boolean.FALSE);
        }
        object2 = null;
        if (configContainer.containsProperty(ConfigProperty.AGENT_TRANSACTION_SETTINGS)) {
            if (configContainer.containsProperty(ConfigProperty.AGENT_URL_SAMPLE_RATE)) {
                c.warn(ConfigProperty.AGENT_URL_SAMPLE_RATE.getConfigFileKey() + " is ignored as " + ConfigProperty.AGENT_TRANSACTION_SETTINGS.getConfigFileKey() + " is also defined");
            }
            object2 = (TraceConfigs)configContainer.get(ConfigProperty.AGENT_TRANSACTION_SETTINGS);
        } else if (configContainer.containsProperty(ConfigProperty.AGENT_URL_SAMPLE_RATE)) {
            object2 = (TraceConfigs)configContainer.get(ConfigProperty.AGENT_URL_SAMPLE_RATE);
        }
        if (object2 != null) {
            configContainer.put(ConfigProperty.AGENT_INTERNAL_TRANSACTION_SETTINGS, object2);
        }
        if (!configContainer.containsProperty(ConfigProperty.AGENT_LAYER)) {
            configContainer.put(ConfigProperty.AGENT_LAYER, AppEnvironment.getAppServerName());
        }
        object = null;
        if (configContainer.containsProperty(ConfigProperty.PROFILER_ENABLED_ENV_VAR)) {
            object = (Boolean)configContainer.get(ConfigProperty.PROFILER_ENABLED_ENV_VAR);
        }
        object2 = null;
        if (configContainer.containsProperty(ConfigProperty.PROFILER_INTERVAL_ENV_VAR)) {
            object2 = (Integer)configContainer.get(ConfigProperty.PROFILER_INTERVAL_ENV_VAR);
        }
        ProfilerSetting profilerSetting = null;
        if (configContainer.containsProperty(ConfigProperty.PROFILER)) {
            profilerSetting = (ProfilerSetting)configContainer.get(ConfigProperty.PROFILER);
            boolean bl = object != null ? ((Boolean)object).booleanValue() : profilerSetting.isEnabled();
            int n2 = object2 != null ? ((Integer)object2).intValue() : profilerSetting.getInterval();
            profilerSetting = new ProfilerSetting(bl, profilerSetting.getExcludePackages(), n2, profilerSetting.getCircuitBreakerDurationThreshold(), profilerSetting.getCircuitBreakerCountThreshold());
        } else if (object != null || object2 != null) {
            profilerSetting = new ProfilerSetting(object != null ? (Boolean)object : false, object2 != null ? (Integer)object2 : 20);
        }
        if (profilerSetting != null) {
            configContainer.put(ConfigProperty.PROFILER, profilerSetting, true);
        }
        ConfigManager.initialize(configContainer);
    }

    public static void checkRetransformation() {
        if (b == AgentStatus.INITIALIZED_SUCCESSFUL && a != null) {
            a.a();
        }
    }

    public static void reportInit() {
        Agent.a(false);
    }

    private static void a(boolean bl) {
        block6: {
            if (!f.getAndSet(true)) {
                try {
                    Object object = (String)ConfigManager.getConfig(ConfigProperty.AGENT_LAYER);
                    object = Agent.a((String)object, version, d, e);
                    if (bl && (int)((bl = ConfigManager.getConfig(ConfigProperty.AGENT_INIT_TIMEOUT) != null ? (Integer)ConfigManager.getConfig(ConfigProperty.AGENT_INIT_TIMEOUT) : 10) ? 1 : 0) != 0) {
                        try {
                            object.get((long)bl, TimeUnit.SECONDS);
                            break block6;
                        }
                        catch (TimeoutException timeoutException) {
                            c.info("Failed to post init message after waiting for " + (int)(bl ? 1 : 0) + " seconds");
                        }
                    }
                    return;
                }
                catch (Exception exception) {
                    c.warn("Failed to post init message: " + (exception.getMessage() != null ? exception.getMessage() : exception.toString()));
                    if (d == null) break block6;
                    c.warn("Failed to report init error [" + d + "]");
                }
            }
        }
    }

    private static Future<Result> a(String object, String object2, String string, long l2) throws ClientException {
        object = Agent.b((String)object, (String)object2, string, l2);
        object2 = RpcClientManager.getClient(RpcClientManager.OperationType.STATUS);
        return object2.postStatus(Collections.singletonList(object), new ClientLoggingCallback<Result>("post init message"));
    }

    private static Map<String, Object> b(String object, String string, String string2, long l2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("Layer", object);
        hashMap.put("Label", "single");
        hashMap.put("__Init", Boolean.TRUE);
        if (string != null) {
            hashMap.put("Java.AppOptics.Version", string);
        }
        if ((object = System.getProperty("java.version")) != null) {
            hashMap.put("Java.Version", object);
        }
        if (string2 != null) {
            hashMap.put("Error", string2);
        }
        if ((object = ResourceDirectory.getAgentJarPath()) != null) {
            hashMap.put("Java.InstallDirectory", ((File)object).getAbsolutePath());
            hashMap.put("Java.InstallTimestamp", ((File)object).lastModified() / 1000L);
        }
        hashMap.put("Java.LastRestart", l2);
        return hashMap;
    }

    static {
        f = new AtomicBoolean(false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AgentStatus {
        INITIALIZED_SUCCESSFUL,
        INITIALIZED_FAILED,
        UNINITIALIZED,
        DISABLED;

    }
}

