/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.instrumentation.nosql.mongo2;

import com.appoptics.instrumentation.nosql.mongo2.Mongo2BaseInstrumentation;
import com.appoptics.instrumentation.nosql.mongo2.Mongo2DbCursorInstrumentation;
import com.tracelytics.a.f.g;
import com.tracelytics.a.f.l;
import com.tracelytics.a.f.t;
import com.tracelytics.instrumentation.Instrument;
import com.tracelytics.instrumentation.MethodMatcher;
import com.tracelytics.instrumentation.Module;
import com.tracelytics.joboe.Context;
import com.tracelytics.joboe.Event;
import java.util.Arrays;
import java.util.List;

@Instrument(targetType={"com.mongodb.DBPort"}, module=Module.MONGODB, appLoaderPackage={"com.appoptics.apploader.instrumenter.nosql.mongo2"})
public class Mongo2DbPortInstrumentation
extends Mongo2BaseInstrumentation {
    private static final String f = Mongo2DbPortInstrumentation.class.getName();
    private static List<MethodMatcher<Integer>> g = Arrays.asList(new MethodMatcher<Integer>("say", new String[]{"com.mongodb.OutMessage"}, "void", 0), new MethodMatcher<Integer>("call", new String[]{"com.mongodb.OutMessage"}, "com.mongodb.Response", 0));

    public boolean applyInstrumentation(g g2, String iterator, byte[] byArray) throws Exception {
        iterator = this.a(g2, g).keySet();
        boolean bl = this.c();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            l l2 = (l)iterator.next();
            if (!Mongo2DbPortInstrumentation.shouldModify(g2, l2)) continue;
            if (bl) {
                Mongo2DbPortInstrumentation.insertBefore(l2, "String query = com.appoptics.apploader.instrumenter.nosql.mongo2.Mongo2QueryInstrumenter.getQuery();" + f + ".startPortOperation(host(), ($1 != null && $1.getOpCode() != null) ? $1.getOpCode().toString() : null,query);");
            } else {
                Mongo2DbPortInstrumentation.insertBefore(l2, "String query = com.appoptics.apploader.instrumenter.nosql.mongo2.Mongo2QueryInstrumenter.getQuery();" + f + ".startPortOperation(host(), null, query);");
            }
            Mongo2DbPortInstrumentation.insertAfter(l2, f + ".endPortOperation();", true);
        }
        return true;
    }

    private boolean c() {
        try {
            g g2 = this.d.c("com.mongodb.OutMessage");
            try {
                g2.a("getOpCode", "()Lcom/mongodb/OutMessage$OpCode;");
                return true;
            }
            catch (t t2) {
                return false;
            }
        }
        catch (t t3) {
            a.warn("Cannot check signatures for com.mongodb.OutMessage as class cannot be loaded");
            return false;
        }
    }

    public static void startPortOperation(String string, String string2, String string3) {
        Event event = Context.createEvent();
        if (Mongo2DbPortInstrumentation.a()) {
            event.addInfo("Layer", "mongoDB", "Label", "entry", "Flavor", "mongodb");
            Mongo2DbCursorInstrumentation.CursorOpInfo cursorOpInfo = Mongo2DbCursorInstrumentation.getCurrentCursorOp();
            if (cursorOpInfo != null) {
                event.addInfo("QueryOp", (Object)"find");
                if (cursorOpInfo.getOp() != null) {
                    event.addInfo("CursorOp", (Object)cursorOpInfo.getOp());
                }
                if (string3 != null) {
                    event.addInfo("Query", (Object)string3);
                }
                if (cursorOpInfo.getDatabaseName() != null) {
                    event.addInfo("Database", (Object)cursorOpInfo.getDatabaseName());
                }
                if (cursorOpInfo.getCollectionName() != null) {
                    event.addInfo("Collection", (Object)cursorOpInfo.getCollectionName());
                }
                if (cursorOpInfo.getSort() != null) {
                    event.addInfo("Sort", (Object)cursorOpInfo.getSort());
                }
                if (cursorOpInfo.getBatchSize() != 0) {
                    event.addInfo("BatchSize", (Object)cursorOpInfo.getBatchSize());
                }
                if (cursorOpInfo.getLimit() > 0) {
                    event.addInfo("Limit", (Object)cursorOpInfo.getLimit());
                }
                event.addInfo("CursorId", (Object)cursorOpInfo.getId());
            }
        } else {
            event.addInfo("Layer", "mongoDB", "Label", "info");
        }
        if (string != null) {
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            event.addInfo("RemoteHost", (Object)string);
        }
        if (string2 != null) {
            event.addInfo("OpCode", (Object)string2);
        }
        event.report();
    }

    public static void endPortOperation() {
        if (Mongo2DbPortInstrumentation.b()) {
            Event event = Context.createEvent();
            event.addInfo("Layer", "mongoDB", "Label", "exit");
            event.report();
        }
    }
}

