/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.util.internal;

import com.appoptics.ext.io.netty.util.internal.InternalThreadLocalMap;
import com.appoptics.ext.io.netty.util.internal.SystemPropertyUtil;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;
import java.security.SecureRandom;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public final class ThreadLocalRandom
extends Random {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ThreadLocalRandom.class);
    private static final AtomicLong seedUniquifier = new AtomicLong();
    private static volatile long initialSeedUniquifier = SystemPropertyUtil.getLong("com.appoptics.ext.io.netty.initialSeedUniquifier", 0L);
    private static final Thread seedGeneratorThread;
    private static final BlockingQueue<Long> seedQueue;
    private static final long seedGeneratorStartTime;
    private static volatile long seedGeneratorEndTime;
    private long rnd;
    boolean initialized = true;
    private static final long serialVersionUID = -5851777807851030925L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getInitialSeedUniquifier() {
        long l2 = initialSeedUniquifier;
        if (l2 != 0L) {
            return l2;
        }
        Class<ThreadLocalRandom> clazz = ThreadLocalRandom.class;
        synchronized (ThreadLocalRandom.class) {
            boolean bl;
            block10: {
                long l3;
                l2 = initialSeedUniquifier;
                if (l2 != 0L) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return l2;
                }
                long l4 = seedGeneratorStartTime + TimeUnit.SECONDS.toNanos(3L);
                bl = false;
                do {
                    l3 = l4 - System.nanoTime();
                    try {
                        Long l5 = l3 <= 0L ? (Long)seedQueue.poll() : seedQueue.poll(l3, TimeUnit.NANOSECONDS);
                        if (l5 == null) continue;
                        l2 = l5;
                    }
                    catch (InterruptedException interruptedException) {
                        bl = true;
                        logger.warn("Failed to generate a seed from SecureRandom due to an InterruptedException.");
                    }
                    break block10;
                } while (l3 > 0L);
                seedGeneratorThread.interrupt();
                logger.warn("Failed to generate a seed from SecureRandom within {} seconds. Not enough entropy?", (Object)3L);
            }
            l2 ^= 0x3255ECDC33BAE119L;
            initialSeedUniquifier = l2 ^= Long.reverse(System.nanoTime());
            if (bl) {
                Thread.currentThread().interrupt();
                seedGeneratorThread.interrupt();
            }
            if (seedGeneratorEndTime == 0L) {
                seedGeneratorEndTime = System.nanoTime();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return l2;
        }
    }

    private static long newSeed() {
        long l2;
        long l3;
        long l4;
        while (!seedUniquifier.compareAndSet(l4, l3 = (l2 = (l4 = seedUniquifier.get()) != 0L ? l4 : ThreadLocalRandom.getInitialSeedUniquifier()) * 181783497276652981L)) {
        }
        if (l4 == 0L && logger.isDebugEnabled()) {
            if (seedGeneratorEndTime != 0L) {
                logger.debug(String.format("-Dio.netty.initialSeedUniquifier: 0x%016x (took %d ms)", l2, TimeUnit.NANOSECONDS.toMillis(seedGeneratorEndTime - seedGeneratorStartTime)));
            } else {
                logger.debug(String.format("-Dio.netty.initialSeedUniquifier: 0x%016x", l2));
            }
        }
        return l3 ^ System.nanoTime();
    }

    private static long mix64(long l2) {
        long l3 = l2;
        l2 = (l3 ^ l3 >>> 33) * -49064778989728563L;
        l2 = (l2 ^ l2 >>> 33) * -4265267296055464877L;
        return l2 ^ l2 >>> 33;
    }

    ThreadLocalRandom() {
        super(ThreadLocalRandom.newSeed());
    }

    public static ThreadLocalRandom current() {
        return InternalThreadLocalMap.get().random();
    }

    public final void setSeed(long l2) {
        if (this.initialized) {
            throw new UnsupportedOperationException();
        }
        this.rnd = (l2 ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
    }

    protected final int next(int n2) {
        this.rnd = this.rnd * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        return (int)(this.rnd >>> 48 - n2);
    }

    static {
        if (initialSeedUniquifier == 0L) {
            boolean bl = SystemPropertyUtil.getBoolean("java.util.secureRandomSeed", false);
            if (bl) {
                seedQueue = new LinkedBlockingQueue<Long>();
                seedGeneratorStartTime = System.nanoTime();
                seedGeneratorThread = new Thread("initialSeedUniquifierGenerator"){

                    public final void run() {
                        Object object = new SecureRandom();
                        object = ((SecureRandom)object).generateSeed(8);
                        seedGeneratorEndTime = System.nanoTime();
                        long l2 = ((long)object[0] & 0xFFL) << 56 | ((long)object[1] & 0xFFL) << 48 | ((long)object[2] & 0xFFL) << 40 | ((long)object[3] & 0xFFL) << 32 | ((long)object[4] & 0xFFL) << 24 | ((long)object[5] & 0xFFL) << 16 | ((long)object[6] & 0xFFL) << 8 | (long)object[7] & 0xFFL;
                        seedQueue.add(l2);
                    }
                };
                seedGeneratorThread.setDaemon(true);
                seedGeneratorThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    public final void uncaughtException(Thread thread, Throwable throwable) {
                        logger.debug("An exception has been raised by {}", (Object)thread.getName(), (Object)throwable);
                    }
                });
                seedGeneratorThread.start();
            } else {
                initialSeedUniquifier = ThreadLocalRandom.mix64(System.currentTimeMillis()) ^ ThreadLocalRandom.mix64(System.nanoTime());
                seedGeneratorThread = null;
                seedQueue = null;
                seedGeneratorStartTime = 0L;
            }
        } else {
            seedGeneratorThread = null;
            seedQueue = null;
            seedGeneratorStartTime = 0L;
        }
    }
}

