/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.util.internal;

import com.appoptics.ext.io.netty.util.Recycler;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectPool<T> {
    ObjectPool() {
    }

    public abstract T get();

    public static <T> ObjectPool<T> newPool(ObjectCreator<T> objectCreator) {
        return new RecyclerObjectPool<T>(ObjectUtil.checkNotNull(objectCreator, "creator"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RecyclerObjectPool<T>
    extends ObjectPool<T> {
        private final Recycler<T> recycler;

        RecyclerObjectPool(final ObjectCreator<T> objectCreator) {
            this.recycler = new Recycler<T>(){

                @Override
                protected T newObject(Recycler.Handle<T> handle) {
                    return objectCreator.newObject(handle);
                }
            };
        }

        @Override
        public final T get() {
            return this.recycler.get();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ObjectCreator<T> {
        public T newObject(Handle<T> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Handle<T> {
        public void recycle(T var1);
    }
}

