/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.util.internal;

import com.appoptics.ext.io.netty.util.CharsetUtil;
import com.appoptics.ext.io.netty.util.internal.NativeLibraryUtil;
import com.appoptics.ext.io.netty.util.internal.PlatformDependent;
import com.appoptics.ext.io.netty.util.internal.SystemPropertyUtil;
import com.appoptics.ext.io.netty.util.internal.ThrowableUtil;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.PosixFilePermission;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NativeLibraryLoader {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NativeLibraryLoader.class);
    private static final File WORKDIR;
    private static final boolean DELETE_NATIVE_LIB_AFTER_LOADING;
    private static final boolean TRY_TO_PATCH_SHADED_ID;
    private static final byte[] UNIQUE_ID_BYTES;

    public static void loadFirstAvailable(ClassLoader classLoader, String ... stringArray) {
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        Object object = stringArray;
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = object[i2];
            try {
                NativeLibraryLoader.load(string, classLoader);
                return;
            }
            catch (Throwable throwable) {
                arrayList.add(throwable);
                logger.debug("Unable to load the library '{}', trying next name...", (Object)string, (Object)throwable);
                continue;
            }
        }
        object = new IllegalArgumentException("Failed to load any of the given libraries: " + Arrays.toString(stringArray));
        ThrowableUtil.addSuppressedAndClear((Throwable)object, arrayList);
        throw object;
    }

    private static String calculatePackagePrefix() {
        String string;
        String string2 = NativeLibraryLoader.class.getName();
        if (!string2.endsWith(string = "com.appoptics.ext.io!netty!util!internal!NativeLibraryLoader".replace('!', '.'))) {
            throw new UnsatisfiedLinkError(String.format("Could not find prefix added to %s to get %s. When shading, only adding a package prefix is supported", string, string2));
        }
        return string2.substring(0, string2.length() - string.length());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void load(String object, ClassLoader classLoader) {
        String string = NativeLibraryLoader.calculatePackagePrefix().replace('.', '_');
        String string2 = string + (String)object;
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        try {
            NativeLibraryLoader.loadLibrary(classLoader, string2, false);
            return;
        }
        catch (Throwable throwable) {
            arrayList.add(throwable);
            if (logger.isDebugEnabled()) {
                logger.debug("{} cannot be loaded from java.library.path, now trying export to -Dio.netty.native.workdir: {}", string2, WORKDIR, throwable);
            }
            String string3 = System.mapLibraryName(string2);
            Object object2 = "META-INF/native/" + string3;
            InputStream inputStream = null;
            FileOutputStream fileOutputStream = null;
            File file = null;
            URL uRL = classLoader == null ? ClassLoader.getSystemResource((String)object2) : classLoader.getResource((String)object2);
            try {
                if (uRL == null) {
                    if (!PlatformDependent.isOsx()) {
                        object2 = new FileNotFoundException((String)object2);
                        ThrowableUtil.addSuppressedAndClear((Throwable)object2, arrayList);
                        throw object2;
                    }
                    object2 = ((String)object2).endsWith(".jnilib") ? "META-INF/native/lib" + string2 + ".dynlib" : "META-INF/native/lib" + string2 + ".jnilib";
                    uRL = classLoader == null ? ClassLoader.getSystemResource((String)object2) : classLoader.getResource((String)object2);
                    if (uRL == null) {
                        FileNotFoundException fileNotFoundException = new FileNotFoundException((String)object2);
                        ThrowableUtil.addSuppressedAndClear(fileNotFoundException, arrayList);
                        throw fileNotFoundException;
                    }
                }
                int n2 = string3.lastIndexOf(46);
                String string4 = string3.substring(0, n2);
                string3 = string3.substring(n2);
                file = File.createTempFile(string4, string3, WORKDIR);
                inputStream = uRL.openStream();
                fileOutputStream = new FileOutputStream(file);
                if (NativeLibraryLoader.shouldShadedLibraryIdBePatched(string)) {
                    NativeLibraryLoader.patchShadedLibraryId(inputStream, fileOutputStream, (String)object, string2);
                } else {
                    int n3;
                    object = new byte[8192];
                    while ((n3 = inputStream.read((byte[])object)) > 0) {
                        ((OutputStream)fileOutputStream).write((byte[])object, 0, n3);
                    }
                }
                fileOutputStream.flush();
                NativeLibraryLoader.closeQuietly(fileOutputStream);
                fileOutputStream = null;
                NativeLibraryLoader.loadLibrary(classLoader, file.getPath(), true);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                try {
                    try {
                        if (file != null && file.isFile() && file.canRead() && !NoexecVolumeDetector.canExecuteExecutable(file)) {
                            logger.info("{} exists but cannot be executed even when execute permissions set; check volume for \"noexec\" flag; use -D{}=[path] to set native working directory separately.", (Object)file.getPath(), (Object)"com.appoptics.ext.io.netty.native.workdir");
                        }
                    }
                    catch (Throwable throwable2) {
                        arrayList.add(throwable2);
                        logger.debug("Error checking if {} is on a file store mounted with noexec", (Object)file, (Object)throwable2);
                    }
                    ThrowableUtil.addSuppressedAndClear(unsatisfiedLinkError, arrayList);
                    throw unsatisfiedLinkError;
                    catch (Exception exception) {
                        UnsatisfiedLinkError unsatisfiedLinkError2 = new UnsatisfiedLinkError("could not load a native library: " + string2);
                        unsatisfiedLinkError2.initCause(exception);
                        ThrowableUtil.addSuppressedAndClear(unsatisfiedLinkError2, arrayList);
                        throw unsatisfiedLinkError2;
                    }
                }
                catch (Throwable throwable3) {
                    NativeLibraryLoader.closeQuietly(inputStream);
                    NativeLibraryLoader.closeQuietly(fileOutputStream);
                    if (!(file == null || DELETE_NATIVE_LIB_AFTER_LOADING && file.delete())) {
                        file.deleteOnExit();
                    }
                    throw throwable3;
                }
            }
            NativeLibraryLoader.closeQuietly(inputStream);
            NativeLibraryLoader.closeQuietly(null);
            if (!(file == null || DELETE_NATIVE_LIB_AFTER_LOADING && file.delete())) {
                file.deleteOnExit();
                return;
            }
            return;
        }
    }

    static boolean patchShadedLibraryId(InputStream object, OutputStream outputStream, String string, String string2) throws IOException {
        boolean bl;
        int n2;
        Object object2 = new byte[8192];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(((InputStream)object).available());
        while ((n2 = ((InputStream)object).read((byte[])object2)) > 0) {
            byteArrayOutputStream.write((byte[])object2, 0, n2);
        }
        byteArrayOutputStream.flush();
        object = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        if (!NativeLibraryLoader.patchShadedLibraryId((byte[])object, string, string2)) {
            object2 = PlatformDependent.normalizedOs();
            String string3 = PlatformDependent.normalizedArch();
            bl = string.endsWith((String)(object2 = (Object)("_" + (String)object2 + "_" + string3))) ? NativeLibraryLoader.patchShadedLibraryId((byte[])object, string.substring(0, string.length() - ((String)object2).length()), string2) : false;
        } else {
            bl = true;
        }
        outputStream.write((byte[])object, 0, ((Object)object).length);
        return bl;
    }

    private static boolean shouldShadedLibraryIdBePatched(String string) {
        return TRY_TO_PATCH_SHADED_ID && PlatformDependent.isOsx() && !string.isEmpty();
    }

    private static boolean patchShadedLibraryId(byte[] byArray, String string, String string2) {
        int n2;
        byte[] byArray2 = string.getBytes(CharsetUtil.UTF_8);
        int n3 = -1;
        block0: for (n2 = 0; n2 < byArray.length && byArray.length - n2 >= byArray2.length; ++n2) {
            int n4 = n2;
            int n5 = 0;
            while (n5 < byArray2.length && byArray[n4++] == byArray2[n5++]) {
                if (n5 != byArray2.length) continue;
                n3 = n2;
                break block0;
            }
        }
        if (n3 == -1) {
            logger.debug("Was not able to find the ID of the shaded native library {}, can't adjust it.", (Object)string2);
            return false;
        }
        for (n2 = 0; n2 < byArray2.length; ++n2) {
            byArray[n3 + n2] = UNIQUE_ID_BYTES[PlatformDependent.threadLocalRandom().nextInt(UNIQUE_ID_BYTES.length)];
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Found the ID of the shaded native library {}. Replacing ID part {} with {}", string2, string, new String(byArray, n3, byArray2.length, CharsetUtil.UTF_8));
        }
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void loadLibrary(ClassLoader serializable, String string, boolean bl) {
        Throwable throwable = null;
        try {
            serializable = NativeLibraryLoader.tryToLoadClass(serializable, NativeLibraryUtil.class);
            NativeLibraryLoader.loadLibraryByHelper(serializable, string, bl);
            logger.debug("Successfully loaded the library {}", (Object)string);
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            try {
                block6: {
                    serializable = unsatisfiedLinkError;
                    throwable = unsatisfiedLinkError;
                    logger.debug("Unable to load the library '{}', trying other loading mechanism.", (Object)string, (Object)serializable);
                    break block6;
                    catch (Exception exception) {
                        serializable = exception;
                        throwable = exception;
                        logger.debug("Unable to load the library '{}', trying other loading mechanism.", (Object)string, (Object)serializable);
                    }
                }
                NativeLibraryUtil.loadLibrary(string, bl);
                logger.debug("Successfully loaded the library {}", (Object)string);
                return;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                if (throwable != null) {
                    ThrowableUtil.addSuppressed((Throwable)unsatisfiedLinkError2, throwable);
                }
                throw unsatisfiedLinkError2;
            }
        }
    }

    private static void loadLibraryByHelper(final Class<?> object, String object2, boolean bl) throws UnsatisfiedLinkError {
        if ((object = AccessController.doPrivileged(new PrivilegedAction<Object>((String)object2, bl){
            final /* synthetic */ String val$name;
            final /* synthetic */ boolean val$absolute;
            {
                this.val$name = string;
                this.val$absolute = bl;
            }

            @Override
            public final Object run() {
                try {
                    Method method = object.getMethod("loadLibrary", String.class, Boolean.TYPE);
                    method.setAccessible(true);
                    return method.invoke(null, this.val$name, this.val$absolute);
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    return exception;
                }
            }
        })) instanceof Throwable) {
            object = (Throwable)object;
            assert (!(object instanceof UnsatisfiedLinkError)) : object + " should be a wrapper throwable";
            object2 = ((Throwable)object).getCause();
            if (object2 instanceof UnsatisfiedLinkError) {
                throw (UnsatisfiedLinkError)object2;
            }
            object2 = new UnsatisfiedLinkError(((Throwable)object).getMessage());
            ((Throwable)object2).initCause((Throwable)object);
            throw object2;
        }
    }

    private static Class<?> tryToLoadClass(final ClassLoader classLoader, final Class<?> clazz) throws ClassNotFoundException {
        try {
            return Class.forName(clazz.getName(), false, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (classLoader == null) {
                throw classNotFoundException;
            }
            try {
                final byte[] byArray = NativeLibraryLoader.classToByteArray(clazz);
                return (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

                    @Override
                    public final Class<?> run() {
                        try {
                            Method method = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
                            method.setAccessible(true);
                            return (Class)method.invoke((Object)classLoader, clazz.getName(), byArray, 0, byArray.length);
                        }
                        catch (Exception exception) {
                            throw new IllegalStateException("Define class failed!", exception);
                        }
                    }
                });
            }
            catch (ClassNotFoundException classNotFoundException2) {
                ClassNotFoundException classNotFoundException3 = classNotFoundException2;
                ThrowableUtil.addSuppressed((Throwable)classNotFoundException2, classNotFoundException);
                throw classNotFoundException3;
            }
            catch (RuntimeException runtimeException) {
                RuntimeException runtimeException2 = runtimeException;
                ThrowableUtil.addSuppressed((Throwable)runtimeException, classNotFoundException);
                throw runtimeException2;
            }
            catch (Error error) {
                Error error2 = error;
                ThrowableUtil.addSuppressed((Throwable)error, classNotFoundException);
                throw error2;
            }
        }
    }

    private static byte[] classToByteArray(Class<?> clazz) throws ClassNotFoundException {
        Object object = clazz.getName();
        int n2 = ((String)object).lastIndexOf(46);
        if (n2 > 0) {
            object = ((String)object).substring(n2 + 1);
        }
        if ((object = clazz.getResource((String)object + ".class")) == null) {
            throw new ClassNotFoundException(clazz.getName());
        }
        byte[] byArray = new byte[1024];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        InputStream inputStream = null;
        try {
            int n3;
            inputStream = ((URL)object).openStream();
            while ((n3 = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n3);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException(clazz.getName(), iOException);
        }
        finally {
            NativeLibraryLoader.closeQuietly(inputStream);
            NativeLibraryLoader.closeQuietly(byteArrayOutputStream);
        }
    }

    private static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
                return;
            }
            catch (IOException iOException) {}
        }
    }

    private NativeLibraryLoader() {
    }

    static {
        UNIQUE_ID_BYTES = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".getBytes(CharsetUtil.US_ASCII);
        Object object = SystemPropertyUtil.get("com.appoptics.ext.io.netty.native.workdir");
        if (object != null) {
            object = new File((String)object);
            ((File)object).mkdirs();
            try {
                object = ((File)object).getAbsoluteFile();
            }
            catch (Exception exception) {}
            WORKDIR = object;
            logger.debug("-Dio.netty.native.workdir: " + WORKDIR);
        } else {
            WORKDIR = PlatformDependent.tmpdir();
            logger.debug("-Dio.netty.native.workdir: " + WORKDIR + " (io.netty.tmpdir)");
        }
        DELETE_NATIVE_LIB_AFTER_LOADING = SystemPropertyUtil.getBoolean("com.appoptics.ext.io.netty.native.deleteLibAfterLoading", true);
        logger.debug("-Dio.netty.native.deleteLibAfterLoading: {}", (Object)DELETE_NATIVE_LIB_AFTER_LOADING);
        TRY_TO_PATCH_SHADED_ID = SystemPropertyUtil.getBoolean("com.appoptics.ext.io.netty.native.tryPatchShadedId", true);
        logger.debug("-Dio.netty.native.tryPatchShadedId: {}", (Object)TRY_TO_PATCH_SHADED_ID);
    }

    private static final class NoexecVolumeDetector {
        private static boolean canExecuteExecutable(File file) throws IOException {
            EnumSet<PosixFilePermission> enumSet;
            if (PlatformDependent.javaVersion() < 7) {
                return true;
            }
            if (file.canExecute()) {
                return true;
            }
            Set<PosixFilePermission> set = Files.getPosixFilePermissions(file.toPath(), new LinkOption[0]);
            if (set.containsAll(enumSet = EnumSet.of(PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_EXECUTE))) {
                return false;
            }
            set = EnumSet.copyOf(set);
            set.addAll(enumSet);
            Files.setPosixFilePermissions(file.toPath(), set);
            return file.canExecute();
        }
    }
}

