/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.util.internal;

import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.PriorityQueue;
import com.appoptics.ext.io.netty.util.internal.PriorityQueueNode;
import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultPriorityQueue<T extends PriorityQueueNode>
extends AbstractQueue<T>
implements PriorityQueue<T> {
    private static final PriorityQueueNode[] EMPTY_ARRAY = new PriorityQueueNode[0];
    private final Comparator<T> comparator;
    private T[] queue;
    private int size;

    public DefaultPriorityQueue(Comparator<T> comparator, int n2) {
        this.comparator = ObjectUtil.checkNotNull(comparator, "comparator");
        this.queue = n2 != 0 ? new PriorityQueueNode[n2] : EMPTY_ARRAY;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public final boolean contains(Object object) {
        if (!(object instanceof PriorityQueueNode)) {
            return false;
        }
        Object object2 = object = (PriorityQueueNode)object;
        return this.contains((PriorityQueueNode)object2, object2.priorityQueueIndex(this));
    }

    @Override
    public final boolean containsTyped(T t2) {
        T t3 = t2;
        return this.contains((PriorityQueueNode)t3, t3.priorityQueueIndex(this));
    }

    @Override
    public final void clear() {
        for (int i2 = 0; i2 < this.size; ++i2) {
            T t2 = this.queue[i2];
            if (t2 == null) continue;
            t2.priorityQueueIndex(this, -1);
            this.queue[i2] = null;
        }
        this.size = 0;
    }

    @Override
    public final void clearIgnoringIndexes() {
        this.size = 0;
    }

    @Override
    public final boolean offer(T t2) {
        if (t2.priorityQueueIndex(this) != -1) {
            throw new IllegalArgumentException("e.priorityQueueIndex(): " + t2.priorityQueueIndex(this) + " (expected: -1" + ") + e: " + t2);
        }
        if (this.size >= this.queue.length) {
            this.queue = (PriorityQueueNode[])Arrays.copyOf(this.queue, this.queue.length + (this.queue.length < 64 ? this.queue.length + 2 : this.queue.length >>> 1));
        }
        DefaultPriorityQueue defaultPriorityQueue = this;
        defaultPriorityQueue.bubbleUp(defaultPriorityQueue.size++, t2);
        return true;
    }

    @Override
    public final T poll() {
        if (this.size == 0) {
            return null;
        }
        T t2 = this.queue[0];
        t2.priorityQueueIndex(this, -1);
        T t3 = this.queue[--this.size];
        this.queue[this.size] = null;
        if (this.size != 0) {
            this.bubbleDown(0, t3);
        }
        return t2;
    }

    @Override
    public final T peek() {
        if (this.size == 0) {
            return null;
        }
        return this.queue[0];
    }

    @Override
    public final boolean remove(Object object) {
        try {
            object = (PriorityQueueNode)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return this.removeTyped((T)object);
    }

    @Override
    public final boolean removeTyped(T t2) {
        int n2 = t2.priorityQueueIndex(this);
        if (!this.contains((PriorityQueueNode)t2, n2)) {
            return false;
        }
        t2.priorityQueueIndex(this, -1);
        if (--this.size == 0 || this.size == n2) {
            this.queue[n2] = null;
            return true;
        }
        T t3 = this.queue[n2] = this.queue[this.size];
        this.queue[this.size] = null;
        if (this.comparator.compare(t2, t3) < 0) {
            this.bubbleDown(n2, t3);
        } else {
            this.bubbleUp(n2, t3);
        }
        return true;
    }

    @Override
    public final void priorityChanged(T t2) {
        int n2;
        T t3;
        int n3 = t2.priorityQueueIndex(this);
        if (!this.contains((PriorityQueueNode)t2, n3)) {
            return;
        }
        if (n3 != 0 && this.comparator.compare(t2, t3 = this.queue[n2 = n3 - 1 >>> 1]) < 0) {
            this.bubbleUp(n3, t2);
            return;
        }
        this.bubbleDown(n3, t2);
    }

    @Override
    public final Object[] toArray() {
        return Arrays.copyOf(this.queue, this.size);
    }

    @Override
    public final <X> X[] toArray(X[] XArray) {
        if (XArray.length < this.size) {
            return Arrays.copyOf(this.queue, this.size, XArray.getClass());
        }
        System.arraycopy(this.queue, 0, XArray, 0, this.size);
        if (XArray.length > this.size) {
            XArray[this.size] = null;
        }
        return XArray;
    }

    @Override
    public final Iterator<T> iterator() {
        return new PriorityQueueIterator();
    }

    private boolean contains(PriorityQueueNode priorityQueueNode, int n2) {
        return n2 >= 0 && n2 < this.size && priorityQueueNode.equals(this.queue[n2]);
    }

    private void bubbleDown(int n2, T t2) {
        int n3 = this.size >>> 1;
        while (n2 < n3) {
            int n4 = (n2 << 1) + 1;
            T t3 = this.queue[n4];
            int n5 = n4 + 1;
            if (n5 < this.size && this.comparator.compare(t3, this.queue[n5]) > 0) {
                n4 = n5;
                t3 = this.queue[n4];
            }
            if (this.comparator.compare(t2, t3) <= 0) break;
            this.queue[n2] = t3;
            t3.priorityQueueIndex(this, n2);
            n2 = n4;
        }
        this.queue[n2] = t2;
        t2.priorityQueueIndex(this, n2);
    }

    private void bubbleUp(int n2, T t2) {
        int n3;
        T t3;
        while (n2 > 0 && this.comparator.compare(t2, t3 = this.queue[n3 = n2 - 1 >>> 1]) < 0) {
            this.queue[n2] = t3;
            t3.priorityQueueIndex(this, n2);
            n2 = n3;
        }
        this.queue[n2] = t2;
        t2.priorityQueueIndex(this, n2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class PriorityQueueIterator
    implements Iterator<T> {
        private int index;

        private PriorityQueueIterator() {
        }

        @Override
        public final boolean hasNext() {
            return this.index < DefaultPriorityQueue.this.size;
        }

        @Override
        public final T next() {
            if (this.index >= DefaultPriorityQueue.this.size) {
                throw new NoSuchElementException();
            }
            return DefaultPriorityQueue.this.queue[this.index++];
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

