/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.util.concurrent;

import com.appoptics.ext.io.netty.util.concurrent.EventExecutor;
import com.appoptics.ext.io.netty.util.concurrent.Future;
import com.appoptics.ext.io.netty.util.concurrent.GenericFutureListener;
import com.appoptics.ext.io.netty.util.concurrent.ImmediateEventExecutor;
import com.appoptics.ext.io.netty.util.concurrent.Promise;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PromiseCombiner {
    private int expectedCount;
    private int doneCount;
    private Promise<Void> aggregatePromise;
    private Throwable cause;
    private final GenericFutureListener<Future<?>> listener = new GenericFutureListener<Future<?>>(){

        @Override
        public void operationComplete(final Future<?> future) {
            if (PromiseCombiner.this.executor.inEventLoop()) {
                this.operationComplete0(future);
                return;
            }
            PromiseCombiner.this.executor.execute(new Runnable(){

                public void run() {
                    this.operationComplete0(future);
                }
            });
        }

        private void operationComplete0(Future<?> future) {
            assert (PromiseCombiner.this.executor.inEventLoop());
            ++PromiseCombiner.this.doneCount;
            if (!future.isSuccess() && PromiseCombiner.this.cause == null) {
                PromiseCombiner.this.cause = future.cause();
            }
            if (PromiseCombiner.this.doneCount == PromiseCombiner.this.expectedCount && PromiseCombiner.this.aggregatePromise != null) {
                PromiseCombiner.this.tryPromise();
            }
        }
    };
    private final EventExecutor executor;

    @Deprecated
    public PromiseCombiner() {
        this(ImmediateEventExecutor.INSTANCE);
    }

    public PromiseCombiner(EventExecutor eventExecutor) {
        this.executor = ObjectUtil.checkNotNull(eventExecutor, "executor");
    }

    @Deprecated
    public final void add(Promise promise) {
        this.add((Future)promise);
    }

    public final void add(Future future) {
        this.checkAddAllowed();
        this.checkInEventLoop();
        ++this.expectedCount;
        future.addListener(this.listener);
    }

    public final void finish(Promise<Void> promise) {
        ObjectUtil.checkNotNull(promise, "aggregatePromise");
        this.checkInEventLoop();
        if (this.aggregatePromise != null) {
            throw new IllegalStateException("Already finished");
        }
        this.aggregatePromise = promise;
        if (this.doneCount == this.expectedCount) {
            this.tryPromise();
        }
    }

    private void checkInEventLoop() {
        if (!this.executor.inEventLoop()) {
            throw new IllegalStateException("Must be called from EventExecutor thread");
        }
    }

    private boolean tryPromise() {
        if (this.cause == null) {
            return this.aggregatePromise.trySuccess(null);
        }
        return this.aggregatePromise.tryFailure(this.cause);
    }

    private void checkAddAllowed() {
        if (this.aggregatePromise != null) {
            throw new IllegalStateException("Adding promises is not allowed after finished adding");
        }
    }
}

