/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.util.concurrent;

import com.appoptics.ext.io.netty.util.concurrent.AbstractScheduledEventExecutor;
import com.appoptics.ext.io.netty.util.concurrent.DefaultThreadFactory;
import com.appoptics.ext.io.netty.util.concurrent.EventExecutor;
import com.appoptics.ext.io.netty.util.concurrent.FailedFuture;
import com.appoptics.ext.io.netty.util.concurrent.Future;
import com.appoptics.ext.io.netty.util.concurrent.OrderedEventExecutor;
import com.appoptics.ext.io.netty.util.concurrent.ScheduledFutureTask;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.PriorityQueue;
import com.appoptics.ext.io.netty.util.internal.ThreadExecutorMap;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GlobalEventExecutor
extends AbstractScheduledEventExecutor
implements OrderedEventExecutor {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(GlobalEventExecutor.class);
    private static final long SCHEDULE_QUIET_PERIOD_INTERVAL = TimeUnit.SECONDS.toNanos(1L);
    public static final GlobalEventExecutor INSTANCE = new GlobalEventExecutor();
    final BlockingQueue<Runnable> taskQueue = new LinkedBlockingQueue<Runnable>();
    final ScheduledFutureTask<Void> quietPeriodTask = new ScheduledFutureTask<Object>((AbstractScheduledEventExecutor)this, Executors.callable(new Runnable(){

        public void run() {
        }
    }, null), ScheduledFutureTask.deadlineNanos(SCHEDULE_QUIET_PERIOD_INTERVAL), -SCHEDULE_QUIET_PERIOD_INTERVAL);
    final ThreadFactory threadFactory;
    private final TaskRunner taskRunner = new TaskRunner();
    private final AtomicBoolean started = new AtomicBoolean();
    volatile Thread thread;
    private final Future<?> terminationFuture = new FailedFuture(this, new UnsupportedOperationException());

    private GlobalEventExecutor() {
        this.scheduledTaskQueue().add(this.quietPeriodTask);
        this.threadFactory = ThreadExecutorMap.apply(new DefaultThreadFactory(DefaultThreadFactory.toPoolName(this.getClass()), false, 5, null), (EventExecutor)this);
    }

    final Runnable takeTask() {
        Runnable runnable;
        BlockingQueue<Runnable> blockingQueue = this.taskQueue;
        do {
            if ((runnable = this.peekScheduledTask()) == null) {
                Runnable runnable2 = null;
                try {
                    runnable2 = blockingQueue.take();
                }
                catch (InterruptedException interruptedException) {}
                return runnable2;
            }
            long l2 = runnable.delayNanos();
            runnable = null;
            if (l2 > 0L) {
                try {
                    runnable = blockingQueue.poll(l2, TimeUnit.NANOSECONDS);
                }
                catch (InterruptedException interruptedException) {
                    return null;
                }
            }
            if (runnable != null) continue;
            this.fetchFromScheduledTaskQueue();
            runnable = (Runnable)blockingQueue.poll();
        } while (runnable == null);
        return runnable;
    }

    private void fetchFromScheduledTaskQueue() {
        long l2 = AbstractScheduledEventExecutor.nanoTime();
        Runnable runnable = this.pollScheduledTask(l2);
        while (runnable != null) {
            this.taskQueue.add(runnable);
            runnable = this.pollScheduledTask(l2);
        }
    }

    private void addTask(Runnable runnable) {
        this.taskQueue.add(ObjectUtil.checkNotNull(runnable, "task"));
    }

    @Override
    public final boolean inEventLoop(Thread thread) {
        return thread == this.thread;
    }

    @Override
    public final Future<?> shutdownGracefully(long l2, long l3, TimeUnit timeUnit) {
        return this.terminationFuture();
    }

    @Override
    public final Future<?> terminationFuture() {
        return this.terminationFuture;
    }

    @Override
    @Deprecated
    public final void shutdown() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean isShutdown() {
        return false;
    }

    @Override
    public final boolean isTerminated() {
        return false;
    }

    @Override
    public final boolean awaitTermination(long l2, TimeUnit timeUnit) {
        return false;
    }

    @Override
    public final void execute(Runnable runnable) {
        this.addTask(ObjectUtil.checkNotNull(runnable, "task"));
        if (!this.inEventLoop()) {
            this.startThread();
        }
    }

    private void startThread() {
        if (this.started.compareAndSet(false, true)) {
            final Thread thread = this.threadFactory.newThread(this.taskRunner);
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    thread.setContextClassLoader(null);
                    return null;
                }
            });
            this.thread = thread;
            thread.start();
        }
    }

    final class TaskRunner
    implements Runnable {
        TaskRunner() {
        }

        public final void run() {
            while (true) {
                Runnable runnable;
                if ((runnable = GlobalEventExecutor.this.takeTask()) != null) {
                    try {
                        runnable.run();
                    }
                    catch (Throwable throwable) {
                        logger.warn("Unexpected exception from the global event executor: ", throwable);
                    }
                    if (runnable != GlobalEventExecutor.this.quietPeriodTask) continue;
                }
                PriorityQueue priorityQueue = GlobalEventExecutor.this.scheduledTaskQueue;
                if (!GlobalEventExecutor.this.taskQueue.isEmpty() || priorityQueue != null && priorityQueue.size() != 1) continue;
                boolean bl = GlobalEventExecutor.this.started.compareAndSet(true, false);
                assert (bl);
                if (GlobalEventExecutor.this.taskQueue.isEmpty() && (priorityQueue == null || priorityQueue.size() == 1) || !GlobalEventExecutor.this.started.compareAndSet(false, true)) break;
            }
        }
    }
}

