/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.util.concurrent;

import com.appoptics.ext.io.netty.util.concurrent.EventExecutor;
import com.appoptics.ext.io.netty.util.concurrent.EventExecutorChooserFactory;
import java.util.concurrent.atomic.AtomicInteger;

public final class DefaultEventExecutorChooserFactory
implements EventExecutorChooserFactory {
    public static final DefaultEventExecutorChooserFactory INSTANCE = new DefaultEventExecutorChooserFactory();

    private DefaultEventExecutorChooserFactory() {
    }

    public final EventExecutorChooserFactory.EventExecutorChooser newChooser(EventExecutor[] eventExecutorArray) {
        if (DefaultEventExecutorChooserFactory.isPowerOfTwo(eventExecutorArray.length)) {
            return new PowerOfTwoEventExecutorChooser(eventExecutorArray);
        }
        return new GenericEventExecutorChooser(eventExecutorArray);
    }

    private static boolean isPowerOfTwo(int n2) {
        int n3 = n2;
        return (n3 & -n3) == n2;
    }

    private static final class GenericEventExecutorChooser
    implements EventExecutorChooserFactory.EventExecutorChooser {
        private final AtomicInteger idx = new AtomicInteger();
        private final EventExecutor[] executors;

        GenericEventExecutorChooser(EventExecutor[] eventExecutorArray) {
            this.executors = eventExecutorArray;
        }

        public final EventExecutor next() {
            return this.executors[Math.abs(this.idx.getAndIncrement() % this.executors.length)];
        }
    }

    private static final class PowerOfTwoEventExecutorChooser
    implements EventExecutorChooserFactory.EventExecutorChooser {
        private final AtomicInteger idx = new AtomicInteger();
        private final EventExecutor[] executors;

        PowerOfTwoEventExecutorChooser(EventExecutor[] eventExecutorArray) {
            this.executors = eventExecutorArray;
        }

        public final EventExecutor next() {
            return this.executors[this.idx.getAndIncrement() & this.executors.length - 1];
        }
    }
}

