/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.util;

import com.appoptics.ext.io.netty.util.NettyRuntime;
import com.appoptics.ext.io.netty.util.concurrent.FastThreadLocal;
import com.appoptics.ext.io.netty.util.internal.MathUtil;
import com.appoptics.ext.io.netty.util.internal.ObjectPool;
import com.appoptics.ext.io.netty.util.internal.SystemPropertyUtil;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Recycler<T> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Recycler.class);
    private static final Handle NOOP_HANDLE = new Handle(){

        public final void recycle(Object object) {
        }
    };
    private static final AtomicInteger ID_GENERATOR = new AtomicInteger(Integer.MIN_VALUE);
    private static final int OWN_THREAD_ID = ID_GENERATOR.getAndIncrement();
    private static final int DEFAULT_MAX_CAPACITY_PER_THREAD;
    private static final int INITIAL_CAPACITY;
    private static final int MAX_SHARED_CAPACITY_FACTOR;
    private static final int MAX_DELAYED_QUEUES_PER_THREAD;
    private static final int LINK_CAPACITY;
    private static final int RATIO;
    private static final int DELAYED_QUEUE_RATIO;
    private final int maxCapacityPerThread;
    private final int maxSharedCapacityFactor;
    private final int interval;
    private final int maxDelayedQueuesPerThread;
    private final int delayedQueueInterval;
    private final FastThreadLocal<Stack<T>> threadLocal = new FastThreadLocal<Stack<T>>(){

        @Override
        protected Stack<T> initialValue() {
            return new Stack(Recycler.this, Thread.currentThread(), Recycler.this.maxCapacityPerThread, Recycler.this.maxSharedCapacityFactor, Recycler.this.interval, Recycler.this.maxDelayedQueuesPerThread, Recycler.this.delayedQueueInterval);
        }

        @Override
        protected void onRemoval(Stack<T> stack) {
            if (stack.threadRef.get() == Thread.currentThread() && DELAYED_RECYCLED.isSet()) {
                ((Map)DELAYED_RECYCLED.get()).remove(stack);
            }
        }
    };
    private static final FastThreadLocal<Map<Stack<?>, WeakOrderQueue>> DELAYED_RECYCLED;

    protected Recycler() {
        this(DEFAULT_MAX_CAPACITY_PER_THREAD);
    }

    protected Recycler(int n2) {
        this(n2, MAX_SHARED_CAPACITY_FACTOR);
    }

    protected Recycler(int n2, int n3) {
        this(n2, n3, RATIO, MAX_DELAYED_QUEUES_PER_THREAD);
    }

    protected Recycler(int n2, int n3, int n4, int n5) {
        this(n2, n3, n4, n5, DELAYED_QUEUE_RATIO);
    }

    protected Recycler(int n2, int n3, int n4, int n5, int n6) {
        this.interval = Math.max(0, n4);
        this.delayedQueueInterval = Math.max(0, n6);
        if (n2 <= 0) {
            this.maxCapacityPerThread = 0;
            this.maxSharedCapacityFactor = 1;
            this.maxDelayedQueuesPerThread = 0;
            return;
        }
        this.maxCapacityPerThread = n2;
        this.maxSharedCapacityFactor = Math.max(1, n3);
        this.maxDelayedQueuesPerThread = Math.max(0, n5);
    }

    public final T get() {
        if (this.maxCapacityPerThread == 0) {
            return this.newObject(NOOP_HANDLE);
        }
        Stack<T> stack = this.threadLocal.get();
        DefaultHandle<T> defaultHandle = stack.pop();
        if (defaultHandle == null) {
            defaultHandle = stack.newHandle();
            stack.newHandle().value = this.newObject(defaultHandle);
        }
        return (T)defaultHandle.value;
    }

    protected abstract T newObject(Handle<T> var1);

    static /* synthetic */ AtomicInteger access$700() {
        return ID_GENERATOR;
    }

    static {
        int n2 = SystemPropertyUtil.getInt("com.appoptics.ext.io.netty.recycler.maxCapacityPerThread", SystemPropertyUtil.getInt("com.appoptics.ext.io.netty.recycler.maxCapacity", 4096));
        if (n2 < 0) {
            n2 = 4096;
        }
        DEFAULT_MAX_CAPACITY_PER_THREAD = n2;
        MAX_SHARED_CAPACITY_FACTOR = Math.max(2, SystemPropertyUtil.getInt("com.appoptics.ext.io.netty.recycler.maxSharedCapacityFactor", 2));
        MAX_DELAYED_QUEUES_PER_THREAD = Math.max(0, SystemPropertyUtil.getInt("com.appoptics.ext.io.netty.recycler.maxDelayedQueuesPerThread", NettyRuntime.availableProcessors() << 1));
        LINK_CAPACITY = MathUtil.safeFindNextPositivePowerOfTwo(Math.max(SystemPropertyUtil.getInt("com.appoptics.ext.io.netty.recycler.linkCapacity", 16), 16));
        RATIO = Math.max(0, SystemPropertyUtil.getInt("com.appoptics.ext.io.netty.recycler.ratio", 8));
        DELAYED_QUEUE_RATIO = Math.max(0, SystemPropertyUtil.getInt("com.appoptics.ext.io.netty.recycler.delayedQueue.ratio", RATIO));
        if (logger.isDebugEnabled()) {
            if (DEFAULT_MAX_CAPACITY_PER_THREAD == 0) {
                logger.debug("-Dio.netty.recycler.maxCapacityPerThread: disabled");
                logger.debug("-Dio.netty.recycler.maxSharedCapacityFactor: disabled");
                logger.debug("-Dio.netty.recycler.linkCapacity: disabled");
                logger.debug("-Dio.netty.recycler.ratio: disabled");
                logger.debug("-Dio.netty.recycler.delayedQueue.ratio: disabled");
            } else {
                logger.debug("-Dio.netty.recycler.maxCapacityPerThread: {}", (Object)DEFAULT_MAX_CAPACITY_PER_THREAD);
                logger.debug("-Dio.netty.recycler.maxSharedCapacityFactor: {}", (Object)MAX_SHARED_CAPACITY_FACTOR);
                logger.debug("-Dio.netty.recycler.linkCapacity: {}", (Object)LINK_CAPACITY);
                logger.debug("-Dio.netty.recycler.ratio: {}", (Object)RATIO);
                logger.debug("-Dio.netty.recycler.delayedQueue.ratio: {}", (Object)DELAYED_QUEUE_RATIO);
            }
        }
        INITIAL_CAPACITY = Math.min(DEFAULT_MAX_CAPACITY_PER_THREAD, 256);
        DELAYED_RECYCLED = new FastThreadLocal<Map<Stack<?>, WeakOrderQueue>>(){

            @Override
            protected final Map<Stack<?>, WeakOrderQueue> initialValue() {
                return new WeakHashMap();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Stack<T> {
        final Recycler<T> parent;
        final WeakReference<Thread> threadRef;
        final AtomicInteger availableSharedCapacity;
        private final int maxDelayedQueues;
        private final int maxCapacity;
        private final int interval;
        private final int delayedQueueInterval;
        DefaultHandle<?>[] elements;
        int size;
        private int handleRecycleCount;
        private WeakOrderQueue cursor;
        private WeakOrderQueue prev;
        private volatile WeakOrderQueue head;

        Stack(Recycler<T> recycler, Thread thread, int n2, int n3, int n4, int n5, int n6) {
            this.parent = recycler;
            this.threadRef = new WeakReference<Thread>(thread);
            this.maxCapacity = n2;
            this.availableSharedCapacity = new AtomicInteger(Math.max(n2 / n3, LINK_CAPACITY));
            this.elements = new DefaultHandle[Math.min(INITIAL_CAPACITY, n2)];
            this.interval = n4;
            this.delayedQueueInterval = n6;
            this.handleRecycleCount = n4;
            this.maxDelayedQueues = n5;
        }

        final synchronized void setHead(WeakOrderQueue weakOrderQueue) {
            weakOrderQueue.setNext(this.head);
            this.head = weakOrderQueue;
        }

        final int increaseCapacity(int n2) {
            int n3 = this.elements.length;
            int n4 = this.maxCapacity;
            while ((n3 <<= 1) < n2 && n3 < n4) {
            }
            if ((n3 = Math.min(n3, n4)) != this.elements.length) {
                this.elements = Arrays.copyOf(this.elements, n3);
            }
            return n3;
        }

        final DefaultHandle<T> pop() {
            int n2 = this.size;
            if (n2 == 0) {
                if (!this.scavenge()) {
                    return null;
                }
                n2 = this.size;
                if (n2 <= 0) {
                    return null;
                }
            }
            DefaultHandle<?> defaultHandle = this.elements[--n2];
            this.elements[n2] = null;
            this.size = n2;
            if (defaultHandle.lastRecycledId != defaultHandle.recycleId) {
                throw new IllegalStateException("recycled multiple times");
            }
            defaultHandle.recycleId = 0;
            defaultHandle.lastRecycledId = 0;
            return defaultHandle;
        }

        private boolean scavenge() {
            if (this.scavengeSome()) {
                return true;
            }
            this.prev = null;
            this.cursor = this.head;
            return false;
        }

        private boolean scavengeSome() {
            WeakOrderQueue weakOrderQueue;
            WeakOrderQueue weakOrderQueue2;
            WeakOrderQueue weakOrderQueue3 = this.cursor;
            if (weakOrderQueue3 == null) {
                weakOrderQueue2 = null;
                weakOrderQueue3 = this.head;
                if (weakOrderQueue3 == null) {
                    return false;
                }
            } else {
                weakOrderQueue2 = this.prev;
            }
            boolean bl = false;
            do {
                if (weakOrderQueue3.transfer(this)) {
                    bl = true;
                    break;
                }
                weakOrderQueue = weakOrderQueue3.getNext();
                if (weakOrderQueue3.get() == null) {
                    if (weakOrderQueue3.hasFinalData()) {
                        while (weakOrderQueue3.transfer(this)) {
                            bl = true;
                        }
                    }
                    if (weakOrderQueue2 == null) continue;
                    weakOrderQueue3.reclaimAllSpaceAndUnlink();
                    weakOrderQueue2.setNext(weakOrderQueue);
                    continue;
                }
                weakOrderQueue2 = weakOrderQueue3;
            } while ((weakOrderQueue3 = weakOrderQueue) != null && !bl);
            this.prev = weakOrderQueue2;
            this.cursor = weakOrderQueue3;
            return bl;
        }

        final void push(DefaultHandle<?> defaultHandle) {
            Thread thread = Thread.currentThread();
            if (this.threadRef.get() == thread) {
                this.pushNow(defaultHandle);
                return;
            }
            this.pushLater(defaultHandle, thread);
        }

        private void pushNow(DefaultHandle<?> defaultHandle) {
            if ((defaultHandle.recycleId | defaultHandle.lastRecycledId) != 0) {
                throw new IllegalStateException("recycled already");
            }
            DefaultHandle<?> defaultHandle2 = defaultHandle;
            defaultHandle2.recycleId = defaultHandle2.lastRecycledId = OWN_THREAD_ID;
            int n2 = this.size;
            if (n2 >= this.maxCapacity || this.dropHandle(defaultHandle)) {
                return;
            }
            if (n2 == this.elements.length) {
                this.elements = Arrays.copyOf(this.elements, Math.min(n2 << 1, this.maxCapacity));
            }
            this.elements[n2] = defaultHandle;
            this.size = n2 + 1;
        }

        private void pushLater(DefaultHandle<?> defaultHandle, Thread thread) {
            if (this.maxDelayedQueues == 0) {
                return;
            }
            Map map = (Map)DELAYED_RECYCLED.get();
            WeakOrderQueue weakOrderQueue = (WeakOrderQueue)map.get(this);
            if (weakOrderQueue == null) {
                if (map.size() >= this.maxDelayedQueues) {
                    map.put(this, WeakOrderQueue.DUMMY);
                    return;
                }
                weakOrderQueue = this.newWeakOrderQueue(thread);
                if (weakOrderQueue == null) {
                    return;
                }
                map.put(this, weakOrderQueue);
            } else if (weakOrderQueue == WeakOrderQueue.DUMMY) {
                return;
            }
            weakOrderQueue.add(defaultHandle);
        }

        private WeakOrderQueue newWeakOrderQueue(Thread thread) {
            return WeakOrderQueue.newQueue(this, thread);
        }

        final boolean dropHandle(DefaultHandle<?> defaultHandle) {
            if (!defaultHandle.hasBeenRecycled) {
                if (this.handleRecycleCount < this.interval) {
                    ++this.handleRecycleCount;
                    return true;
                }
                this.handleRecycleCount = 0;
                defaultHandle.hasBeenRecycled = true;
            }
            return false;
        }

        final DefaultHandle<T> newHandle() {
            return new DefaultHandle(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WeakOrderQueue
    extends WeakReference<Thread> {
        static final WeakOrderQueue DUMMY = new WeakOrderQueue();
        private final Head head;
        private Link tail;
        private WeakOrderQueue next;
        private final int id = Recycler.access$700().getAndIncrement();
        private final int interval;
        private int handleRecycleCount;

        private WeakOrderQueue() {
            super(null);
            this.head = new Head(null);
            this.interval = 0;
        }

        private WeakOrderQueue(Stack<?> stack, Thread thread) {
            super(thread);
            this.tail = new Link();
            this.head = new Head(stack.availableSharedCapacity);
            this.head.link = this.tail;
            this.handleRecycleCount = this.interval = ((Stack)stack).delayedQueueInterval;
        }

        static WeakOrderQueue newQueue(Stack<?> stack, Thread object) {
            if (!Head.reserveSpaceForLink(stack.availableSharedCapacity)) {
                return null;
            }
            object = new WeakOrderQueue(stack, (Thread)object);
            stack.setHead((WeakOrderQueue)object);
            return object;
        }

        final WeakOrderQueue getNext() {
            return this.next;
        }

        final void setNext(WeakOrderQueue weakOrderQueue) {
            assert (weakOrderQueue != this);
            this.next = weakOrderQueue;
        }

        final void reclaimAllSpaceAndUnlink() {
            this.head.reclaimAllSpaceAndUnlink();
            this.next = null;
        }

        final void add(DefaultHandle<?> defaultHandle) {
            defaultHandle.lastRecycledId = this.id;
            if (this.handleRecycleCount < this.interval) {
                ++this.handleRecycleCount;
                return;
            }
            this.handleRecycleCount = 0;
            Link link = this.tail;
            int n2 = link.get();
            if (n2 == LINK_CAPACITY) {
                Link link2 = this.head.newLink();
                if (link2 == null) {
                    return;
                }
                link = link.next = link2;
                this.tail = link.next;
                n2 = link.get();
            }
            link.elements[n2] = defaultHandle;
            defaultHandle.stack = null;
            link.lazySet(n2 + 1);
        }

        final boolean hasFinalData() {
            return this.tail.readIndex != this.tail.get();
        }

        final boolean transfer(Stack<?> stack) {
            Link link = this.head.link;
            if (link == null) {
                return false;
            }
            if (link.readIndex == LINK_CAPACITY) {
                if (link.next == null) {
                    return false;
                }
                link = link.next;
                this.head.relink(link);
            }
            int n2 = link.readIndex;
            int n3 = link.get();
            int n4 = n3 - n2;
            if (n4 == 0) {
                return false;
            }
            int n5 = stack.size;
            if ((n4 = n5 + n4) > stack.elements.length) {
                n4 = stack.increaseCapacity(n4);
                n3 = Math.min(n2 + n4 - n5, n3);
            }
            if (n2 != n3) {
                DefaultHandle<?>[] defaultHandleArray = link.elements;
                DefaultHandle<?>[] defaultHandleArray2 = stack.elements;
                while (n2 < n3) {
                    DefaultHandle<?> defaultHandle = defaultHandleArray[n2];
                    if (defaultHandle.recycleId == 0) {
                        defaultHandle.recycleId = defaultHandle.lastRecycledId;
                    } else if (defaultHandle.recycleId != defaultHandle.lastRecycledId) {
                        throw new IllegalStateException("recycled already");
                    }
                    defaultHandleArray[n2] = null;
                    if (!stack.dropHandle(defaultHandle)) {
                        defaultHandle.stack = stack;
                        defaultHandleArray2[n5++] = defaultHandle;
                    }
                    ++n2;
                }
                if (n3 == LINK_CAPACITY && link.next != null) {
                    this.head.relink(link.next);
                }
                link.readIndex = n3;
                if (stack.size == n5) {
                    return false;
                }
                stack.size = n5;
                return true;
            }
            return false;
        }

        private static final class Head {
            private final AtomicInteger availableSharedCapacity;
            Link link;

            Head(AtomicInteger atomicInteger) {
                this.availableSharedCapacity = atomicInteger;
            }

            final void reclaimAllSpaceAndUnlink() {
                Link link = this.link;
                this.link = null;
                int n2 = 0;
                while (link != null) {
                    n2 += LINK_CAPACITY;
                    Link link2 = link.next;
                    link.next = null;
                    link = link2;
                }
                if (n2 > 0) {
                    this.reclaimSpace(n2);
                }
            }

            private void reclaimSpace(int n2) {
                this.availableSharedCapacity.addAndGet(n2);
            }

            final void relink(Link link) {
                this.reclaimSpace(LINK_CAPACITY);
                this.link = link;
            }

            final Link newLink() {
                if (Head.reserveSpaceForLink(this.availableSharedCapacity)) {
                    return new Link();
                }
                return null;
            }

            static boolean reserveSpaceForLink(AtomicInteger atomicInteger) {
                int n2;
                do {
                    int n3;
                    if ((n3 = atomicInteger.get()) < LINK_CAPACITY) {
                        return false;
                    }
                    n2 = n3;
                } while (!atomicInteger.compareAndSet(n2, n2 - LINK_CAPACITY));
                return true;
            }
        }

        static final class Link
        extends AtomicInteger {
            final DefaultHandle<?>[] elements = new DefaultHandle[Recycler.access$600()];
            int readIndex;
            Link next;

            Link() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DefaultHandle<T>
    implements Handle<T> {
        int lastRecycledId;
        int recycleId;
        boolean hasBeenRecycled;
        Stack<?> stack;
        Object value;

        DefaultHandle(Stack<?> stack) {
            this.stack = stack;
        }

        @Override
        public final void recycle(Object stack) {
            if (stack != this.value) {
                throw new IllegalArgumentException("object does not belong to handle");
            }
            stack = this.stack;
            if (this.lastRecycledId != this.recycleId || stack == null) {
                throw new IllegalStateException("recycled already");
            }
            stack.push(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Handle<T>
    extends ObjectPool.Handle<T> {
    }
}

