/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.util;

import com.appoptics.ext.io.netty.util.ByteProcessor;
import com.appoptics.ext.io.netty.util.HashingStrategy;
import com.appoptics.ext.io.netty.util.internal.MathUtil;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.PlatformDependent;
import java.util.Arrays;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AsciiString
implements CharSequence,
Comparable<CharSequence> {
    public static final AsciiString EMPTY_STRING = AsciiString.cached("");
    private final byte[] value;
    private final int offset;
    private final int length;
    private int hash;
    private String string;
    public static final HashingStrategy<CharSequence> CASE_INSENSITIVE_HASHER = new HashingStrategy<CharSequence>(){

        @Override
        public final int hashCode(CharSequence charSequence) {
            return AsciiString.hashCode(charSequence);
        }

        @Override
        public final boolean equals(CharSequence charSequence, CharSequence charSequence2) {
            return AsciiString.contentEqualsIgnoreCase(charSequence, charSequence2);
        }
    };
    public static final HashingStrategy<CharSequence> CASE_SENSITIVE_HASHER = new HashingStrategy<CharSequence>(){

        @Override
        public final int hashCode(CharSequence charSequence) {
            return AsciiString.hashCode(charSequence);
        }

        @Override
        public final boolean equals(CharSequence charSequence, CharSequence charSequence2) {
            return AsciiString.contentEquals(charSequence, charSequence2);
        }
    };

    public AsciiString(byte[] byArray) {
        this(byArray, true);
    }

    public AsciiString(byte[] byArray, boolean bl) {
        this(byArray, 0, byArray.length, bl);
    }

    public AsciiString(byte[] byArray, int n2, int n3, boolean bl) {
        if (bl) {
            int n4 = n2;
            this.value = Arrays.copyOfRange(byArray, n4, n4 + n3);
            this.offset = 0;
        } else {
            if (MathUtil.isOutOfBounds(n2, n3, byArray.length)) {
                throw new IndexOutOfBoundsException("expected: 0 <= start(" + n2 + ") <= start + length(" + n3 + ") <= value.length(" + byArray.length + ')');
            }
            this.value = byArray;
            this.offset = n2;
        }
        this.length = n3;
    }

    public AsciiString(CharSequence charSequence) {
        this(charSequence, 0, charSequence.length());
    }

    public AsciiString(CharSequence charSequence, int n2, int n3) {
        if (MathUtil.isOutOfBounds(n2, n3, charSequence.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + n2 + ") <= start + length(" + n3 + ") <= value.length(" + charSequence.length() + ')');
        }
        this.value = PlatformDependent.allocateUninitializedArray(n3);
        int n4 = 0;
        while (n4 < n3) {
            this.value[n4] = AsciiString.c2b(charSequence.charAt(n2));
            ++n4;
            ++n2;
        }
        this.offset = 0;
        this.length = n3;
    }

    public final int forEachByte(ByteProcessor byteProcessor) throws Exception {
        return this.forEachByte0(0, this.length(), byteProcessor);
    }

    public final int forEachByte(int n2, int n3, ByteProcessor byteProcessor) throws Exception {
        if (MathUtil.isOutOfBounds(n2, n3, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= index(" + n2 + ") <= start + length(" + n3 + ") <= length(" + this.length() + ')');
        }
        return this.forEachByte0(n2, n3, byteProcessor);
    }

    private int forEachByte0(int n2, int n3, ByteProcessor byteProcessor) throws Exception {
        n3 = this.offset + n2 + n3;
        for (n2 = this.offset + n2; n2 < n3; ++n2) {
            if (byteProcessor.process(this.value[n2])) continue;
            return n2 - this.offset;
        }
        return -1;
    }

    public final byte byteAt(int n2) {
        if (n2 < 0 || n2 >= this.length) {
            throw new IndexOutOfBoundsException("index: " + n2 + " must be in the range [0," + this.length + ")");
        }
        if (PlatformDependent.hasUnsafe()) {
            return PlatformDependent.getByte(this.value, n2 + this.offset);
        }
        return this.value[n2 + this.offset];
    }

    @Override
    public final boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    public final int length() {
        return this.length;
    }

    public final byte[] array() {
        return this.value;
    }

    public final int arrayOffset() {
        return this.offset;
    }

    public final boolean isEntireArrayUsed() {
        return this.offset == 0 && this.length == this.value.length;
    }

    public final byte[] toByteArray() {
        return this.toByteArray(0, this.length());
    }

    public final byte[] toByteArray(int n2, int n3) {
        return Arrays.copyOfRange(this.value, n2 + this.offset, n3 + this.offset);
    }

    @Override
    public final char charAt(int n2) {
        return AsciiString.b2c(this.byteAt(n2));
    }

    @Override
    public final int compareTo(CharSequence charSequence) {
        if (this == charSequence) {
            return 0;
        }
        int n2 = this.length();
        int n3 = charSequence.length();
        int n4 = Math.min(n2, n3);
        int n5 = 0;
        int n6 = this.arrayOffset();
        while (n5 < n4) {
            int n7 = AsciiString.b2c(this.value[n6]) - charSequence.charAt(n5);
            if (n7 != 0) {
                return n7;
            }
            ++n5;
            ++n6;
        }
        return n2 - n3;
    }

    public final boolean endsWith(CharSequence charSequence) {
        int n2 = charSequence.length();
        AsciiString asciiString = this;
        return asciiString.regionMatches(asciiString.length() - n2, charSequence, 0, n2);
    }

    public final boolean contentEqualsIgnoreCase(CharSequence charSequence) {
        if (this == charSequence) {
            return true;
        }
        if (charSequence == null || charSequence.length() != this.length()) {
            return false;
        }
        if (charSequence instanceof AsciiString) {
            AsciiString asciiString = (AsciiString)charSequence;
            int n2 = this.arrayOffset();
            int n3 = asciiString.arrayOffset();
            int n4 = n2 + this.length();
            while (n2 < n4) {
                if (!AsciiString.equalsIgnoreCase(this.value[n2], asciiString.value[n3])) {
                    return false;
                }
                ++n2;
                ++n3;
            }
            return true;
        }
        int n5 = this.arrayOffset();
        int n6 = this.length();
        for (int i2 = 0; i2 < n6; ++i2) {
            if (!AsciiString.equalsIgnoreCase(AsciiString.b2c(this.value[n5]), charSequence.charAt(i2))) {
                return false;
            }
            ++n5;
        }
        return true;
    }

    @Override
    public final AsciiString subSequence(int n2, int n3) {
        return this.subSequence(n2, n3, true);
    }

    public final AsciiString subSequence(int n2, int n3, boolean bl) {
        if (MathUtil.isOutOfBounds(n2, n3 - n2, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + n2 + ") <= end (" + n3 + ") <= length(" + this.length() + ')');
        }
        if (n2 == 0 && n3 == this.length()) {
            return this;
        }
        if (n3 == n2) {
            return EMPTY_STRING;
        }
        return new AsciiString(this.value, n2 + this.offset, n3 - n2, bl);
    }

    public final int indexOf(char c2, int n2) {
        if (c2 > '\u00ff') {
            return -1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        c2 = (char)AsciiString.c2b0(c2);
        int n3 = this.offset + this.length;
        n2 += this.offset;
        while (n2 < n3) {
            if (this.value[n2] == c2) {
                return n2 - this.offset;
            }
            ++n2;
        }
        return -1;
    }

    public final boolean regionMatches(int n2, CharSequence charSequence, int n3, int n4) {
        ObjectUtil.checkNotNull(charSequence, "string");
        if (n3 < 0 || charSequence.length() - n3 < n4) {
            return false;
        }
        int n5 = this.length();
        if (n2 < 0 || n5 - n2 < n4) {
            return false;
        }
        if (n4 <= 0) {
            return true;
        }
        n4 = n3 + n4;
        n2 += this.arrayOffset();
        while (n3 < n4) {
            if (AsciiString.b2c(this.value[n2]) != charSequence.charAt(n3)) {
                return false;
            }
            ++n3;
            ++n2;
        }
        return true;
    }

    public final AsciiString toLowerCase() {
        int n2;
        int n3 = 1;
        int n4 = this.length() + this.arrayOffset();
        for (n2 = this.arrayOffset(); n2 < n4; ++n2) {
            byte by = this.value[n2];
            if (by < 65 || by > 90) continue;
            n3 = 0;
            break;
        }
        if (n3 != 0) {
            return this;
        }
        byte[] byArray = PlatformDependent.allocateUninitializedArray(this.length());
        n2 = 0;
        n3 = this.arrayOffset();
        while (n2 < byArray.length) {
            byArray[n2] = AsciiString.toLowerCase(this.value[n3]);
            ++n2;
            ++n3;
        }
        return new AsciiString(byArray, false);
    }

    public static CharSequence trim(CharSequence charSequence) {
        int n2;
        int n3;
        if (charSequence instanceof AsciiString) {
            return ((AsciiString)charSequence).trim();
        }
        if (charSequence instanceof String) {
            return ((String)charSequence).trim();
        }
        int n4 = n3 = charSequence.length() - 1;
        for (n2 = 0; n2 <= n3 && charSequence.charAt(n2) <= ' '; ++n2) {
        }
        while (n4 >= n2 && charSequence.charAt(n4) <= ' ') {
            --n4;
        }
        if (n2 == 0 && n4 == n3) {
            return charSequence;
        }
        return charSequence.subSequence(n2, n4);
    }

    public final AsciiString trim() {
        int n2;
        int n3;
        int n4 = n3 = this.arrayOffset() + this.length() - 1;
        for (n2 = this.arrayOffset(); n2 <= n3 && this.value[n2] <= 32; ++n2) {
        }
        while (n4 >= n2 && this.value[n4] <= 32) {
            --n4;
        }
        if (n2 == 0 && n4 == n3) {
            return this;
        }
        return new AsciiString(this.value, n2, n4 - n2 + 1, false);
    }

    public final boolean contentEquals(CharSequence charSequence) {
        if (this == charSequence) {
            return true;
        }
        if (charSequence == null || charSequence.length() != this.length()) {
            return false;
        }
        if (charSequence instanceof AsciiString) {
            return this.equals(charSequence);
        }
        int n2 = this.arrayOffset();
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            if (AsciiString.b2c(this.value[n2]) != charSequence.charAt(i2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public final int hashCode() {
        int n2 = this.hash;
        if (n2 == 0) {
            this.hash = n2 = PlatformDependent.hashCodeAscii(this.value, this.offset, this.length);
        }
        return n2;
    }

    public final boolean equals(Object object) {
        if (object == null || object.getClass() != AsciiString.class) {
            return false;
        }
        if (this == object) {
            return true;
        }
        object = (AsciiString)object;
        return this.length() == ((AsciiString)object).length() && this.hashCode() == ((AsciiString)object).hashCode() && PlatformDependent.equals(this.array(), this.arrayOffset(), ((AsciiString)object).array(), ((AsciiString)object).arrayOffset(), this.length());
    }

    @Override
    public final String toString() {
        String string = this.string;
        if (string == null) {
            this.string = string = this.toString(0);
        }
        return string;
    }

    public final String toString(int n2) {
        return this.toString(n2, this.length());
    }

    public final String toString(int n2, int n3) {
        if ((n3 -= n2) == 0) {
            return "";
        }
        if (MathUtil.isOutOfBounds(n2, n3, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + n2 + ") <= srcIdx + length(" + n3 + ") <= srcLen(" + this.length() + ')');
        }
        String string = new String(this.value, 0, n2 + this.offset, n3);
        return string;
    }

    public final int parseInt() {
        return this.parseInt(0, this.length(), 10);
    }

    public final int parseInt(int n2, int n3, int n4) {
        if (n4 < 2 || n4 > 36) {
            throw new NumberFormatException();
        }
        if (n2 == n3) {
            throw new NumberFormatException();
        }
        int n5 = n2;
        boolean bl = this.byteAt(n2) == 45;
        if (bl && ++n5 == n3) {
            throw new NumberFormatException(this.subSequence(n2, n3, false).toString());
        }
        return this.parseInt(n5, n3, n4, bl);
    }

    private int parseInt(int n2, int n3, int n4, boolean bl) {
        int n5 = Integer.MIN_VALUE / n4;
        int n6 = 0;
        int n7 = n2;
        while (n7 < n3) {
            int n8;
            if ((n8 = Character.digit((char)(this.value[n7++ + this.offset] & 0xFF), n4)) == -1) {
                throw new NumberFormatException(this.subSequence(n2, n3, false).toString());
            }
            if (n5 > n6) {
                throw new NumberFormatException(this.subSequence(n2, n3, false).toString());
            }
            if ((n8 = n6 * n4 - n8) > n6) {
                throw new NumberFormatException(this.subSequence(n2, n3, false).toString());
            }
            n6 = n8;
        }
        if (!bl && (n6 = -n6) < 0) {
            throw new NumberFormatException(this.subSequence(n2, n3, false).toString());
        }
        return n6;
    }

    public static AsciiString of(CharSequence charSequence) {
        if (charSequence instanceof AsciiString) {
            return (AsciiString)charSequence;
        }
        return new AsciiString(charSequence);
    }

    public static AsciiString cached(String string) {
        AsciiString asciiString = new AsciiString(string);
        new AsciiString(string).string = string;
        return asciiString;
    }

    public static int hashCode(CharSequence charSequence) {
        if (charSequence == null) {
            return 0;
        }
        if (charSequence instanceof AsciiString) {
            return charSequence.hashCode();
        }
        return PlatformDependent.hashCodeAscii(charSequence);
    }

    public static boolean contentEqualsIgnoreCase(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence == null || charSequence2 == null) {
            return charSequence == charSequence2;
        }
        if (charSequence instanceof AsciiString) {
            return ((AsciiString)charSequence).contentEqualsIgnoreCase(charSequence2);
        }
        if (charSequence2 instanceof AsciiString) {
            return ((AsciiString)charSequence2).contentEqualsIgnoreCase(charSequence);
        }
        if (charSequence.length() != charSequence2.length()) {
            return false;
        }
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            if (AsciiString.equalsIgnoreCase(charSequence.charAt(i2), charSequence2.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean containsContentEqualsIgnoreCase(Collection<CharSequence> object, CharSequence charSequence) {
        object = object.iterator();
        while (object.hasNext()) {
            CharSequence charSequence2 = (CharSequence)object.next();
            if (!AsciiString.contentEqualsIgnoreCase(charSequence, charSequence2)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAllContentEqualsIgnoreCase(Collection<CharSequence> collection, Collection<CharSequence> object) {
        object = object.iterator();
        while (object.hasNext()) {
            CharSequence charSequence = (CharSequence)object.next();
            if (AsciiString.containsContentEqualsIgnoreCase(collection, charSequence)) continue;
            return false;
        }
        return true;
    }

    public static boolean contentEquals(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence == null || charSequence2 == null) {
            return charSequence == charSequence2;
        }
        if (charSequence instanceof AsciiString) {
            return ((AsciiString)charSequence).contentEquals(charSequence2);
        }
        if (charSequence2 instanceof AsciiString) {
            return ((AsciiString)charSequence2).contentEquals(charSequence);
        }
        if (charSequence.length() != charSequence2.length()) {
            return false;
        }
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            if (charSequence.charAt(i2) == charSequence2.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    public static int indexOf(CharSequence charSequence, char c2, int n2) {
        if (charSequence instanceof String) {
            return ((String)charSequence).indexOf(c2, n2);
        }
        if (charSequence instanceof AsciiString) {
            return ((AsciiString)charSequence).indexOf(c2, n2);
        }
        if (charSequence == null) {
            return -1;
        }
        int n3 = charSequence.length();
        int n4 = n2 = n2 < 0 ? 0 : n2;
        while (n2 < n3) {
            if (charSequence.charAt(n2) == c2) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private static boolean equalsIgnoreCase(byte by, byte by2) {
        return by == by2 || AsciiString.toLowerCase(by) == AsciiString.toLowerCase(by2);
    }

    private static boolean equalsIgnoreCase(char c2, char c3) {
        return c2 == c3 || AsciiString.toLowerCase(c2) == AsciiString.toLowerCase(c3);
    }

    private static byte toLowerCase(byte by) {
        if (AsciiString.isUpperCase(by)) {
            return (byte)(by + 32);
        }
        return by;
    }

    public static char toLowerCase(char c2) {
        if (AsciiString.isUpperCase(c2)) {
            return (char)(c2 + 32);
        }
        return c2;
    }

    public static boolean isUpperCase(byte by) {
        return by >= 65 && by <= 90;
    }

    public static boolean isUpperCase(char c2) {
        return c2 >= 'A' && c2 <= 'Z';
    }

    public static byte c2b(char c2) {
        return (byte)(c2 > '\u00ff' ? 63 : (int)c2);
    }

    private static byte c2b0(char c2) {
        return (byte)c2;
    }

    public static char b2c(byte by) {
        return (char)(by & 0xFF);
    }
}

