/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.resolver;

import com.appoptics.ext.io.netty.resolver.AddressResolver;
import com.appoptics.ext.io.netty.util.concurrent.EventExecutor;
import com.appoptics.ext.io.netty.util.concurrent.Future;
import com.appoptics.ext.io.netty.util.concurrent.GenericFutureListener;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.Closeable;
import java.net.SocketAddress;
import java.util.IdentityHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AddressResolverGroup<T extends SocketAddress>
implements Closeable {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AddressResolverGroup.class);
    private final Map<EventExecutor, AddressResolver<T>> resolvers = new IdentityHashMap<EventExecutor, AddressResolver<T>>();
    private final Map<EventExecutor, GenericFutureListener<Future<Object>>> executorTerminationListeners = new IdentityHashMap<EventExecutor, GenericFutureListener<Future<Object>>>();

    protected AddressResolverGroup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object[] objectArray = this.resolvers;
        synchronized (this.resolvers) {
            Object object;
            int n2;
            AddressResolver[] addressResolverArray = this.resolvers.values().toArray(new AddressResolver[0]);
            this.resolvers.clear();
            Map.Entry[] entryArray = this.executorTerminationListeners.entrySet().toArray(new Map.Entry[0]);
            this.executorTerminationListeners.clear();
            // ** MonitorExit[var3_1] (shouldn't be in output)
            objectArray = entryArray;
            int n3 = entryArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                object = objectArray[n2];
                ((EventExecutor)object.getKey()).terminationFuture().removeListener((GenericFutureListener)object.getValue());
            }
            objectArray = addressResolverArray;
            n3 = addressResolverArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                object = objectArray[n2];
                try {
                    object.close();
                    continue;
                }
                catch (Throwable throwable) {
                    logger.warn("Failed to close a resolver:", throwable);
                }
            }
            return;
        }
    }
}

