/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.ssl;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.ByteBufAllocator;
import com.appoptics.ext.io.netty.buffer.ByteBufUtil;
import com.appoptics.ext.io.netty.channel.ChannelHandlerContext;
import com.appoptics.ext.io.netty.handler.codec.base64.Base64;
import com.appoptics.ext.io.netty.handler.codec.base64.Base64Dialect;
import com.appoptics.ext.io.netty.handler.ssl.SslHandshakeCompletionEvent;
import com.appoptics.ext.io.netty.util.NetUtil;
import com.appoptics.ext.io.netty.util.internal.EmptyArrays;
import com.appoptics.ext.io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLHandshakeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SslUtils {
    static final Set<String> TLSV13_CIPHERS = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("TLS_AES_256_GCM_SHA384", "TLS_CHACHA20_POLY1305_SHA256", "TLS_AES_128_GCM_SHA256", "TLS_AES_128_CCM_8_SHA256", "TLS_AES_128_CCM_SHA256")));
    static final String[] DEFAULT_CIPHER_SUITES;
    static final String[] DEFAULT_TLSV13_CIPHER_SUITES;
    static final String[] TLSV13_CIPHER_SUITES;

    static void addIfSupported(Set<String> set, List<String> list, String ... stringArray) {
        for (String string : stringArray) {
            if (!set.contains(string)) continue;
            list.add(string);
        }
    }

    static void useFallbackCiphersIfDefaultIsEmpty(List<String> list, Iterable<String> object) {
        if (list.isEmpty()) {
            object = object.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                if (string.startsWith("SSL_") || string.contains("_RC4_")) continue;
                list.add(string);
            }
        }
    }

    static void useFallbackCiphersIfDefaultIsEmpty(List<String> list, String ... stringArray) {
        SslUtils.useFallbackCiphersIfDefaultIsEmpty(list, Arrays.asList(stringArray));
    }

    static SSLHandshakeException toSSLHandshakeException(Throwable throwable) {
        if (throwable instanceof SSLHandshakeException) {
            return (SSLHandshakeException)throwable;
        }
        return (SSLHandshakeException)new SSLHandshakeException(throwable.getMessage()).initCause(throwable);
    }

    static int getEncryptedPacketLength(ByteBuf byteBuf, int n2) {
        int n3;
        boolean bl;
        int n4 = 0;
        switch (byteBuf.getUnsignedByte(n2)) {
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        if (bl && ((n3 = byteBuf.getUnsignedByte(n2 + 1)) != 3 || (n4 = SslUtils.unsignedShortBE(byteBuf, n2 + 3) + 5) <= 5)) {
            bl = false;
        }
        if (!bl) {
            n3 = (byteBuf.getUnsignedByte(n2) & 0x80) != 0 ? 2 : 3;
            short s2 = byteBuf.getUnsignedByte(n2 + n3 + 1);
            n4 = s2;
            if (s2 == 2 || n4 == 3) {
                n4 = n3 == 2 ? (SslUtils.shortBE(byteBuf, n2) & Short.MAX_VALUE) + 2 : (SslUtils.shortBE(byteBuf, n2) & 0x3FFF) + 3;
                if (n4 <= n3) {
                    return -1;
                }
            } else {
                return -2;
            }
        }
        return n4;
    }

    private static int unsignedShortBE(ByteBuf byteBuf, int n2) {
        if (byteBuf.order() == ByteOrder.BIG_ENDIAN) {
            return byteBuf.getUnsignedShort(n2);
        }
        return byteBuf.getUnsignedShortLE(n2);
    }

    private static short shortBE(ByteBuf byteBuf, int n2) {
        if (byteBuf.order() == ByteOrder.BIG_ENDIAN) {
            return byteBuf.getShort(n2);
        }
        return byteBuf.getShortLE(n2);
    }

    private static short unsignedByte(byte by) {
        return (short)(by & 0xFF);
    }

    private static int unsignedShortBE(ByteBuffer byteBuffer, int n2) {
        return SslUtils.shortBE(byteBuffer, n2) & 0xFFFF;
    }

    private static short shortBE(ByteBuffer byteBuffer, int n2) {
        if (byteBuffer.order() == ByteOrder.BIG_ENDIAN) {
            return byteBuffer.getShort(n2);
        }
        return ByteBufUtil.swapShort(byteBuffer.getShort(n2));
    }

    static int getEncryptedPacketLength(ByteBuffer[] byteBufferArray, int n2) {
        ByteBuffer byteBuffer = byteBufferArray[n2];
        if (byteBuffer.remaining() >= 5) {
            return SslUtils.getEncryptedPacketLength(byteBuffer);
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(5);
        do {
            if ((byteBuffer = byteBufferArray[n2++].duplicate()).remaining() > byteBuffer2.remaining()) {
                ByteBuffer byteBuffer3 = byteBuffer;
                byteBuffer3.limit(byteBuffer3.position() + byteBuffer2.remaining());
            }
            byteBuffer2.put(byteBuffer);
        } while (byteBuffer2.hasRemaining());
        byteBuffer2.flip();
        return SslUtils.getEncryptedPacketLength(byteBuffer2);
    }

    private static int getEncryptedPacketLength(ByteBuffer byteBuffer) {
        int n2;
        boolean bl;
        int n3 = 0;
        int n4 = byteBuffer.position();
        switch (SslUtils.unsignedByte(byteBuffer.get(n4))) {
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        if (bl && ((n2 = SslUtils.unsignedByte(byteBuffer.get(n4 + 1))) != 3 || (n3 = SslUtils.unsignedShortBE(byteBuffer, n4 + 3) + 5) <= 5)) {
            bl = false;
        }
        if (!bl) {
            n2 = (SslUtils.unsignedByte(byteBuffer.get(n4)) & 0x80) != 0 ? 2 : 3;
            short s2 = SslUtils.unsignedByte(byteBuffer.get(n4 + n2 + 1));
            n3 = s2;
            if (s2 == 2 || n3 == 3) {
                n3 = n2 == 2 ? (SslUtils.shortBE(byteBuffer, n4) & Short.MAX_VALUE) + 2 : (SslUtils.shortBE(byteBuffer, n4) & 0x3FFF) + 3;
                if (n3 <= n2) {
                    return -1;
                }
            } else {
                return -2;
            }
        }
        return n3;
    }

    static void handleHandshakeFailure(ChannelHandlerContext channelHandlerContext, Throwable throwable, boolean bl) {
        channelHandlerContext.flush();
        if (bl) {
            channelHandlerContext.fireUserEventTriggered(new SslHandshakeCompletionEvent(throwable));
        }
        channelHandlerContext.close();
    }

    static void zeroout(ByteBuf byteBuf) {
        if (!byteBuf.isReadOnly()) {
            byteBuf.setZero(0, byteBuf.capacity());
        }
    }

    static void zerooutAndRelease(ByteBuf byteBuf) {
        SslUtils.zeroout(byteBuf);
        byteBuf.release();
    }

    static ByteBuf toBase64(ByteBufAllocator object, ByteBuf byteBuf) {
        ByteBuf byteBuf2 = byteBuf;
        object = Base64.encode(byteBuf2, byteBuf2.readerIndex(), byteBuf.readableBytes(), true, Base64Dialect.STANDARD, (ByteBufAllocator)object);
        ByteBuf byteBuf3 = byteBuf;
        byteBuf3.readerIndex(byteBuf3.writerIndex());
        return object;
    }

    static boolean isValidHostNameForSNI(String string) {
        return string != null && string.indexOf(46) > 0 && !string.endsWith(".") && !NetUtil.isValidIpV4Address(string) && !NetUtil.isValidIpV6Address(string);
    }

    static boolean isTLSv13Cipher(String string) {
        return TLSV13_CIPHERS.contains(string);
    }

    static {
        TLSV13_CIPHER_SUITES = new String[]{"TLS_AES_128_GCM_SHA256", "TLS_AES_256_GCM_SHA384"};
        DEFAULT_TLSV13_CIPHER_SUITES = PlatformDependent.javaVersion() >= 11 ? TLSV13_CIPHER_SUITES : EmptyArrays.EMPTY_STRINGS;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384");
        arrayList.add("TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256");
        arrayList.add("TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256");
        arrayList.add("TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384");
        arrayList.add("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA");
        arrayList.add("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA");
        arrayList.add("TLS_RSA_WITH_AES_128_GCM_SHA256");
        arrayList.add("TLS_RSA_WITH_AES_128_CBC_SHA");
        arrayList.add("TLS_RSA_WITH_AES_256_CBC_SHA");
        Collections.addAll(arrayList, DEFAULT_TLSV13_CIPHER_SUITES);
        DEFAULT_CIPHER_SUITES = arrayList.toArray(new String[0]);
    }
}

