/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.ssl;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.ByteBufAllocator;
import com.appoptics.ext.io.netty.buffer.ByteBufInputStream;
import com.appoptics.ext.io.netty.handler.ssl.ApplicationProtocolConfig;
import com.appoptics.ext.io.netty.handler.ssl.ApplicationProtocolNegotiator;
import com.appoptics.ext.io.netty.handler.ssl.CipherSuiteFilter;
import com.appoptics.ext.io.netty.handler.ssl.ClientAuth;
import com.appoptics.ext.io.netty.handler.ssl.JdkSslClientContext;
import com.appoptics.ext.io.netty.handler.ssl.JdkSslServerContext;
import com.appoptics.ext.io.netty.handler.ssl.OpenSsl;
import com.appoptics.ext.io.netty.handler.ssl.OpenSslClientContext;
import com.appoptics.ext.io.netty.handler.ssl.OpenSslServerContext;
import com.appoptics.ext.io.netty.handler.ssl.PemReader;
import com.appoptics.ext.io.netty.handler.ssl.ReferenceCountedOpenSslClientContext;
import com.appoptics.ext.io.netty.handler.ssl.ReferenceCountedOpenSslServerContext;
import com.appoptics.ext.io.netty.handler.ssl.SslProvider;
import com.appoptics.ext.io.netty.util.AttributeMap;
import com.appoptics.ext.io.netty.util.DefaultAttributeMap;
import com.appoptics.ext.io.netty.util.internal.EmptyArrays;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SslContext {
    static final CertificateFactory X509_CERT_FACTORY;
    private final boolean startTls;
    private final AttributeMap attributes = new DefaultAttributeMap();

    public static SslProvider defaultServerProvider() {
        return SslContext.defaultProvider();
    }

    public static SslProvider defaultClientProvider() {
        return SslContext.defaultProvider();
    }

    private static SslProvider defaultProvider() {
        if (OpenSsl.isAvailable()) {
            return SslProvider.OPENSSL;
        }
        return SslProvider.JDK;
    }

    static SslContext newServerContextInternal(SslProvider sslProvider, Provider provider, X509Certificate[] x509CertificateArray, TrustManagerFactory trustManagerFactory, X509Certificate[] x509CertificateArray2, PrivateKey privateKey, String string, KeyManagerFactory keyManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, long l2, long l3, ClientAuth clientAuth, String[] stringArray, boolean bl, boolean bl2, String string2) throws SSLException {
        if (sslProvider == null) {
            sslProvider = SslContext.defaultServerProvider();
        }
        switch (sslProvider) {
            case JDK: {
                if (bl2) {
                    throw new IllegalArgumentException("OCSP is not supported with this SslProvider: " + (Object)((Object)sslProvider));
                }
                return new JdkSslServerContext(provider, x509CertificateArray, trustManagerFactory, x509CertificateArray2, privateKey, string, keyManagerFactory, iterable, cipherSuiteFilter, applicationProtocolConfig, l2, l3, clientAuth, stringArray, bl, string2);
            }
            case OPENSSL: {
                SslContext.verifyNullSslContextProvider(sslProvider, provider);
                return new OpenSslServerContext(x509CertificateArray, trustManagerFactory, x509CertificateArray2, privateKey, string, keyManagerFactory, iterable, cipherSuiteFilter, applicationProtocolConfig, l2, l3, clientAuth, stringArray, bl, bl2, string2);
            }
            case OPENSSL_REFCNT: {
                SslContext.verifyNullSslContextProvider(sslProvider, provider);
                return new ReferenceCountedOpenSslServerContext(x509CertificateArray, trustManagerFactory, x509CertificateArray2, privateKey, string, keyManagerFactory, iterable, cipherSuiteFilter, applicationProtocolConfig, l2, l3, clientAuth, stringArray, bl, bl2, string2);
            }
        }
        throw new Error(sslProvider.toString());
    }

    private static void verifyNullSslContextProvider(SslProvider sslProvider, Provider provider) {
        if (provider != null) {
            throw new IllegalArgumentException("Java Security Provider unsupported for SslProvider: " + (Object)((Object)sslProvider));
        }
    }

    static SslContext newClientContextInternal(SslProvider sslProvider, Provider provider, X509Certificate[] x509CertificateArray, TrustManagerFactory trustManagerFactory, X509Certificate[] x509CertificateArray2, PrivateKey privateKey, String string, KeyManagerFactory keyManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, String[] stringArray, long l2, long l3, boolean bl, String string2) throws SSLException {
        if (sslProvider == null) {
            sslProvider = SslContext.defaultClientProvider();
        }
        switch (sslProvider) {
            case JDK: {
                if (bl) {
                    throw new IllegalArgumentException("OCSP is not supported with this SslProvider: " + (Object)((Object)sslProvider));
                }
                return new JdkSslClientContext(provider, x509CertificateArray, trustManagerFactory, x509CertificateArray2, privateKey, string, keyManagerFactory, iterable, cipherSuiteFilter, applicationProtocolConfig, stringArray, l2, l3, string2);
            }
            case OPENSSL: {
                SslContext.verifyNullSslContextProvider(sslProvider, provider);
                return new OpenSslClientContext(x509CertificateArray, trustManagerFactory, x509CertificateArray2, privateKey, string, keyManagerFactory, iterable, cipherSuiteFilter, applicationProtocolConfig, stringArray, l2, l3, bl, string2);
            }
            case OPENSSL_REFCNT: {
                SslContext.verifyNullSslContextProvider(sslProvider, provider);
                return new ReferenceCountedOpenSslClientContext(x509CertificateArray, trustManagerFactory, x509CertificateArray2, privateKey, string, keyManagerFactory, iterable, cipherSuiteFilter, applicationProtocolConfig, stringArray, l2, l3, bl, string2);
            }
        }
        throw new Error(sslProvider.toString());
    }

    protected SslContext() {
        this(false);
    }

    protected SslContext(boolean bl) {
        this.startTls = bl;
    }

    public final boolean isServer() {
        return !this.isClient();
    }

    public abstract boolean isClient();

    public abstract ApplicationProtocolNegotiator applicationProtocolNegotiator();

    public abstract SSLEngine newEngine(ByteBufAllocator var1, String var2, int var3);

    protected static PKCS8EncodedKeySpec generateKeySpec(char[] object, byte[] object2) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, InvalidKeyException, InvalidAlgorithmParameterException {
        if (object == null) {
            return new PKCS8EncodedKeySpec((byte[])object2);
        }
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo((byte[])object2);
        object2 = encryptedPrivateKeyInfo;
        Object object3 = SecretKeyFactory.getInstance(encryptedPrivateKeyInfo.getAlgName());
        object = new PBEKeySpec((char[])object);
        object = ((SecretKeyFactory)object3).generateSecret((KeySpec)object);
        object3 = Cipher.getInstance(((EncryptedPrivateKeyInfo)object2).getAlgName());
        ((Cipher)object3).init(2, (Key)object, ((EncryptedPrivateKeyInfo)object2).getAlgParameters());
        return ((EncryptedPrivateKeyInfo)object2).getKeySpec((Cipher)object3);
    }

    static KeyStore buildKeyStore(X509Certificate[] x509CertificateArray, PrivateKey privateKey, char[] cArray, String object) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        if (object == null) {
            object = KeyStore.getDefaultType();
        }
        object = KeyStore.getInstance((String)object);
        ((KeyStore)object).load(null, null);
        ((KeyStore)object).setKeyEntry("key", privateKey, cArray, x509CertificateArray);
        return object;
    }

    static PrivateKey toPrivateKey(File file, String string) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, InvalidAlgorithmParameterException, KeyException, IOException {
        if (file == null) {
            return null;
        }
        return SslContext.getPrivateKeyFromByteBuffer(PemReader.readPrivateKey(file), string);
    }

    private static PrivateKey getPrivateKeyFromByteBuffer(ByteBuf object, String string) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, InvalidAlgorithmParameterException, KeyException, IOException {
        byte[] byArray = new byte[((ByteBuf)object).readableBytes()];
        ((ByteBuf)object).readBytes(byArray).release();
        object = SslContext.generateKeySpec(string == null ? null : string.toCharArray(), byArray);
        try {
            return KeyFactory.getInstance("RSA").generatePrivate((KeySpec)object);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            try {
                return KeyFactory.getInstance("DSA").generatePrivate((KeySpec)object);
            }
            catch (InvalidKeySpecException invalidKeySpecException2) {
                try {
                    return KeyFactory.getInstance("EC").generatePrivate((KeySpec)object);
                }
                catch (InvalidKeySpecException invalidKeySpecException3) {
                    throw new InvalidKeySpecException("Neither RSA, DSA nor EC worked", invalidKeySpecException3);
                }
            }
        }
    }

    static X509Certificate[] toX509Certificates(File file) throws CertificateException {
        if (file == null) {
            return null;
        }
        return SslContext.getCertificatesFromBuffers(PemReader.readCertificates(file));
    }

    private static X509Certificate[] getCertificatesFromBuffers(ByteBuf[] byteBufArray) throws CertificateException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        X509Certificate[] x509CertificateArray = new X509Certificate[byteBufArray.length];
        try {
            for (int i2 = 0; i2 < byteBufArray.length; ++i2) {
                ByteBufInputStream byteBufInputStream = new ByteBufInputStream(byteBufArray[i2], false);
                try {
                    x509CertificateArray[i2] = (X509Certificate)certificateFactory.generateCertificate(byteBufInputStream);
                    continue;
                }
                finally {
                    try {
                        ((InputStream)byteBufInputStream).close();
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                }
            }
        }
        finally {
            ByteBuf[] byteBufArray2 = byteBufArray;
            int n2 = byteBufArray.length;
            for (int i3 = 0; i3 < n2; ++i3) {
                ByteBuf byteBuf = byteBufArray2[i3];
                byteBuf.release();
            }
        }
        return x509CertificateArray;
    }

    static TrustManagerFactory buildTrustManagerFactory(X509Certificate[] x509CertificateArray, TrustManagerFactory trustManagerFactory, String object) throws NoSuchAlgorithmException, CertificateException, KeyStoreException, IOException {
        if (object == null) {
            object = KeyStore.getDefaultType();
        }
        object = KeyStore.getInstance((String)object);
        ((KeyStore)object).load(null, null);
        int n2 = 1;
        for (X509Certificate x509Certificate : x509CertificateArray) {
            String string = Integer.toString(n2);
            ((KeyStore)object).setCertificateEntry(string, x509Certificate);
            ++n2;
        }
        if (trustManagerFactory == null) {
            trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        }
        trustManagerFactory.init((KeyStore)object);
        return trustManagerFactory;
    }

    static PrivateKey toPrivateKeyInternal(File file, String string) throws SSLException {
        try {
            return SslContext.toPrivateKey(file, string);
        }
        catch (Exception exception) {
            throw new SSLException(exception);
        }
    }

    static X509Certificate[] toX509CertificatesInternal(File file) throws SSLException {
        try {
            return SslContext.toX509Certificates(file);
        }
        catch (CertificateException certificateException) {
            throw new SSLException(certificateException);
        }
    }

    static KeyManagerFactory buildKeyManagerFactory(X509Certificate[] x509CertificateArray, PrivateKey privateKey, String string, KeyManagerFactory keyManagerFactory, String string2) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        return SslContext.buildKeyManagerFactory(x509CertificateArray, KeyManagerFactory.getDefaultAlgorithm(), privateKey, string, keyManagerFactory, string2);
    }

    static KeyManagerFactory buildKeyManagerFactory(X509Certificate[] object, String string, PrivateKey privateKey, String object2, KeyManagerFactory keyManagerFactory, String string2) throws KeyStoreException, NoSuchAlgorithmException, IOException, CertificateException, UnrecoverableKeyException {
        object2 = SslContext.keyStorePassword((String)object2);
        object = SslContext.buildKeyStore(object, privateKey, (char[])object2, string2);
        return SslContext.buildKeyManagerFactory((KeyStore)object, string, (char[])object2, keyManagerFactory);
    }

    static KeyManagerFactory buildKeyManagerFactory(KeyStore keyStore, String string, char[] cArray, KeyManagerFactory keyManagerFactory) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        if (keyManagerFactory == null) {
            keyManagerFactory = KeyManagerFactory.getInstance(string);
        }
        keyManagerFactory.init(keyStore, cArray);
        return keyManagerFactory;
    }

    static char[] keyStorePassword(String string) {
        if (string == null) {
            return EmptyArrays.EMPTY_CHARS;
        }
        return string.toCharArray();
    }

    static {
        try {
            X509_CERT_FACTORY = CertificateFactory.getInstance("X.509");
            return;
        }
        catch (CertificateException certificateException) {
            throw new IllegalStateException("unable to instance X.509 CertificateFactory", certificateException);
        }
    }
}

