/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.ssl;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.ByteBufAllocator;
import com.appoptics.ext.io.netty.handler.ssl.ApplicationProtocolConfig;
import com.appoptics.ext.io.netty.handler.ssl.ApplicationProtocolNegotiator;
import com.appoptics.ext.io.netty.handler.ssl.CipherSuiteConverter;
import com.appoptics.ext.io.netty.handler.ssl.CipherSuiteFilter;
import com.appoptics.ext.io.netty.handler.ssl.ClientAuth;
import com.appoptics.ext.io.netty.handler.ssl.OpenSsl;
import com.appoptics.ext.io.netty.handler.ssl.OpenSslApplicationProtocolNegotiator;
import com.appoptics.ext.io.netty.handler.ssl.OpenSslCachingX509KeyManagerFactory;
import com.appoptics.ext.io.netty.handler.ssl.OpenSslDefaultApplicationProtocolNegotiator;
import com.appoptics.ext.io.netty.handler.ssl.OpenSslEngineMap;
import com.appoptics.ext.io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import com.appoptics.ext.io.netty.handler.ssl.OpenSslSessionContext;
import com.appoptics.ext.io.netty.handler.ssl.OpenSslX509KeyManagerFactory;
import com.appoptics.ext.io.netty.handler.ssl.OpenSslX509TrustManagerWrapper;
import com.appoptics.ext.io.netty.handler.ssl.PemEncoded;
import com.appoptics.ext.io.netty.handler.ssl.PemPrivateKey;
import com.appoptics.ext.io.netty.handler.ssl.PemX509Certificate;
import com.appoptics.ext.io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import com.appoptics.ext.io.netty.handler.ssl.SslContext;
import com.appoptics.ext.io.netty.handler.ssl.SslUtils;
import com.appoptics.ext.io.netty.internal.tcnative.CertificateVerifier;
import com.appoptics.ext.io.netty.internal.tcnative.SSL;
import com.appoptics.ext.io.netty.internal.tcnative.SSLContext;
import com.appoptics.ext.io.netty.util.AbstractReferenceCounted;
import com.appoptics.ext.io.netty.util.ReferenceCounted;
import com.appoptics.ext.io.netty.util.ResourceLeakDetector;
import com.appoptics.ext.io.netty.util.ResourceLeakDetectorFactory;
import com.appoptics.ext.io.netty.util.ResourceLeakTracker;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.PlatformDependent;
import com.appoptics.ext.io.netty.util.internal.SystemPropertyUtil;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReferenceCountedOpenSslContext
extends SslContext
implements ReferenceCounted {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ReferenceCountedOpenSslContext.class);
    private static final int DEFAULT_BIO_NON_APPLICATION_BUFFER_SIZE = Math.max(1, SystemPropertyUtil.getInt("com.appoptics.ext.io.netty.handler.ssl.openssl.bioNonApplicationBufferSize", 2048));
    static final boolean USE_TASKS = SystemPropertyUtil.getBoolean("com.appoptics.ext.io.netty.handler.ssl.openssl.useTasks", false);
    private static final Integer DH_KEY_LENGTH;
    private static final ResourceLeakDetector<ReferenceCountedOpenSslContext> leakDetector;
    protected long ctx;
    private final List<String> unmodifiableCiphers;
    private final long sessionCacheSize;
    private final long sessionTimeout;
    private final OpenSslApplicationProtocolNegotiator apn;
    private final int mode;
    private final ResourceLeakTracker<ReferenceCountedOpenSslContext> leak;
    private final AbstractReferenceCounted refCnt = new AbstractReferenceCounted(){

        public ReferenceCounted touch(Object object) {
            if (ReferenceCountedOpenSslContext.this.leak != null) {
                ReferenceCountedOpenSslContext.this.leak.record(object);
            }
            return ReferenceCountedOpenSslContext.this;
        }

        protected void deallocate() {
            ReferenceCountedOpenSslContext.this.destroy();
            if (ReferenceCountedOpenSslContext.this.leak != null) {
                boolean bl = ReferenceCountedOpenSslContext.this.leak.close(ReferenceCountedOpenSslContext.this);
                assert (bl);
            }
        }
    };
    final Certificate[] keyCertChain;
    final ClientAuth clientAuth;
    final String[] protocols;
    final boolean enableOcsp;
    final OpenSslEngineMap engineMap = new DefaultOpenSslEngineMap();
    final ReadWriteLock ctxLock = new ReentrantReadWriteLock();
    private volatile int bioNonApplicationBufferSize = DEFAULT_BIO_NON_APPLICATION_BUFFER_SIZE;
    static final OpenSslApplicationProtocolNegotiator NONE_PROTOCOL_NEGOTIATOR;

    ReferenceCountedOpenSslContext(Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, long l2, long l3, int n2, Certificate[] certificateArray, ClientAuth clientAuth, String[] stringArray, boolean bl, boolean bl2, boolean bl3) throws SSLException {
        this(iterable, cipherSuiteFilter, ReferenceCountedOpenSslContext.toNegotiator(applicationProtocolConfig), l2, l3, n2, certificateArray, clientAuth, stringArray, bl, bl2, bl3);
    }

    ReferenceCountedOpenSslContext(Iterable<String> iterable, CipherSuiteFilter object, OpenSslApplicationProtocolNegotiator openSslApplicationProtocolNegotiator, long l2, long l3, int n2, Certificate[] certificateArray, ClientAuth clientAuth, String[] stringArray, boolean bl, boolean bl2, boolean bl3) throws SSLException {
        super(bl);
        OpenSsl.ensureAvailability();
        if (bl2 && !OpenSsl.isOcspSupported()) {
            throw new IllegalStateException("OCSP is not supported.");
        }
        if (n2 != 1 && n2 != 0) {
            throw new IllegalArgumentException("mode most be either SSL.SSL_MODE_SERVER or SSL.SSL_MODE_CLIENT");
        }
        this.leak = bl3 ? leakDetector.track(this) : null;
        this.mode = n2;
        this.clientAuth = this.isServer() ? ObjectUtil.checkNotNull(clientAuth, "clientAuth") : ClientAuth.NONE;
        this.protocols = stringArray;
        this.enableOcsp = bl2;
        this.keyCertChain = certificateArray == null ? null : (Certificate[])certificateArray.clone();
        this.unmodifiableCiphers = Arrays.asList(ObjectUtil.checkNotNull(object, "cipherFilter").filterCipherSuites(iterable, OpenSsl.DEFAULT_CIPHERS, OpenSsl.availableJavaCipherSuites()));
        this.apn = ObjectUtil.checkNotNull(openSslApplicationProtocolNegotiator, "apn");
        try {
            String[] stringArray2;
            int n3;
            try {
                n3 = 30;
                if (OpenSsl.isTlsv13Supported()) {
                    n3 = 62;
                }
                this.ctx = SSLContext.make((int)n3, (int)n2);
            }
            catch (Exception exception) {
                throw new SSLException("failed to create an SSL_CTX", exception);
            }
            n3 = OpenSsl.isTlsv13Supported() ? 1 : 0;
            object = new StringBuilder();
            StringBuilder stringBuilder = new StringBuilder();
            try {
                if (this.unmodifiableCiphers.isEmpty()) {
                    SSLContext.setCipherSuite((long)this.ctx, (String)"", (boolean)false);
                    if (n3 != 0) {
                        SSLContext.setCipherSuite((long)this.ctx, (String)"", (boolean)true);
                    }
                } else {
                    CipherSuiteConverter.convertToCipherStrings(this.unmodifiableCiphers, (StringBuilder)object, stringBuilder, OpenSsl.isBoringSSL());
                    SSLContext.setCipherSuite((long)this.ctx, (String)((StringBuilder)object).toString(), (boolean)false);
                    if (n3 != 0) {
                        SSLContext.setCipherSuite((long)this.ctx, (String)stringBuilder.toString(), (boolean)true);
                    }
                }
            }
            catch (SSLException sSLException) {
                SSLException sSLException2 = sSLException;
                throw sSLException;
            }
            catch (Exception exception) {
                throw new SSLException("failed to set cipher suite: " + this.unmodifiableCiphers, exception);
            }
            n3 = SSLContext.getOptions((long)this.ctx) | SSL.SSL_OP_NO_SSLv2 | SSL.SSL_OP_NO_SSLv3 | SSL.SSL_OP_NO_TLSv1_3 | SSL.SSL_OP_CIPHER_SERVER_PREFERENCE | SSL.SSL_OP_NO_COMPRESSION | SSL.SSL_OP_NO_TICKET;
            if (((StringBuilder)object).length() == 0) {
                n3 |= SSL.SSL_OP_NO_SSLv2 | SSL.SSL_OP_NO_SSLv3 | SSL.SSL_OP_NO_TLSv1 | SSL.SSL_OP_NO_TLSv1_1 | SSL.SSL_OP_NO_TLSv1_2;
            }
            SSLContext.setOptions((long)this.ctx, (int)n3);
            SSLContext.setMode((long)this.ctx, (int)(SSLContext.getMode((long)this.ctx) | SSL.SSL_MODE_ACCEPT_MOVING_WRITE_BUFFER));
            if (DH_KEY_LENGTH != null) {
                SSLContext.setTmpDHLength((long)this.ctx, (int)DH_KEY_LENGTH);
            }
            if (!(stringArray2 = openSslApplicationProtocolNegotiator.protocols()).isEmpty()) {
                stringArray2 = stringArray2.toArray(new String[0]);
                int n4 = ReferenceCountedOpenSslContext.opensslSelectorFailureBehavior(openSslApplicationProtocolNegotiator.selectorFailureBehavior());
                switch (openSslApplicationProtocolNegotiator.protocol()) {
                    case NPN: {
                        SSLContext.setNpnProtos((long)this.ctx, (String[])stringArray2, (int)n4);
                        break;
                    }
                    case ALPN: {
                        SSLContext.setAlpnProtos((long)this.ctx, (String[])stringArray2, (int)n4);
                        break;
                    }
                    case NPN_AND_ALPN: {
                        SSLContext.setNpnProtos((long)this.ctx, (String[])stringArray2, (int)n4);
                        SSLContext.setAlpnProtos((long)this.ctx, (String[])stringArray2, (int)n4);
                        break;
                    }
                    default: {
                        throw new Error();
                    }
                }
            }
            if (l2 <= 0L) {
                l2 = SSLContext.setSessionCacheSize((long)this.ctx, (long)20480L);
            }
            this.sessionCacheSize = l2;
            SSLContext.setSessionCacheSize((long)this.ctx, (long)l2);
            if (l3 <= 0L) {
                l3 = SSLContext.setSessionCacheTimeout((long)this.ctx, (long)300L);
            }
            this.sessionTimeout = l3;
            SSLContext.setSessionCacheTimeout((long)this.ctx, (long)l3);
            if (bl2) {
                SSLContext.enableOcsp((long)this.ctx, (boolean)this.isClient());
            }
            SSLContext.setUseTasks((long)this.ctx, (boolean)USE_TASKS);
            return;
        }
        catch (Throwable throwable) {
            this.release();
            throw throwable;
        }
    }

    private static int opensslSelectorFailureBehavior(ApplicationProtocolConfig.SelectorFailureBehavior selectorFailureBehavior) {
        switch (selectorFailureBehavior) {
            case NO_ADVERTISE: {
                return 0;
            }
            case CHOOSE_MY_LAST_PROTOCOL: {
                return 1;
            }
        }
        throw new Error();
    }

    @Override
    public ApplicationProtocolNegotiator applicationProtocolNegotiator() {
        return this.apn;
    }

    @Override
    public final boolean isClient() {
        return this.mode == 0;
    }

    @Override
    public final SSLEngine newEngine(ByteBufAllocator byteBufAllocator, String string, int n2) {
        return this.newEngine0(byteBufAllocator, string, n2, true);
    }

    SSLEngine newEngine0(ByteBufAllocator byteBufAllocator, String string, int n2, boolean bl) {
        return new ReferenceCountedOpenSslEngine(this, byteBufAllocator, string, n2, bl, true);
    }

    public int getBioNonApplicationBufferSize() {
        return this.bioNonApplicationBufferSize;
    }

    public abstract OpenSslSessionContext sessionContext();

    private void destroy() {
        Lock lock = this.ctxLock.writeLock();
        lock.lock();
        try {
            if (this.ctx != 0L) {
                if (this.enableOcsp) {
                    SSLContext.disableOcsp((long)this.ctx);
                }
                SSLContext.free((long)this.ctx);
                this.ctx = 0L;
                OpenSslSessionContext openSslSessionContext = this.sessionContext();
                if (openSslSessionContext != null) {
                    openSslSessionContext.destroy();
                }
            }
            return;
        }
        finally {
            lock.unlock();
        }
    }

    protected static X509TrustManager chooseTrustManager(TrustManager[] trustManagerArray) {
        for (TrustManager trustManager : trustManagerArray) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            if (PlatformDependent.javaVersion() >= 7) {
                return OpenSslX509TrustManagerWrapper.wrapIfNeeded((X509TrustManager)trustManager);
            }
            return (X509TrustManager)trustManager;
        }
        throw new IllegalStateException("no X509TrustManager found");
    }

    protected static X509KeyManager chooseX509KeyManager(KeyManager[] keyManagerArray) {
        for (KeyManager keyManager : keyManagerArray) {
            if (!(keyManager instanceof X509KeyManager)) continue;
            return (X509KeyManager)keyManager;
        }
        throw new IllegalStateException("no X509KeyManager found");
    }

    static OpenSslApplicationProtocolNegotiator toNegotiator(ApplicationProtocolConfig applicationProtocolConfig) {
        if (applicationProtocolConfig == null) {
            return NONE_PROTOCOL_NEGOTIATOR;
        }
        switch (applicationProtocolConfig.protocol()) {
            case NONE: {
                return NONE_PROTOCOL_NEGOTIATOR;
            }
            case NPN: 
            case ALPN: 
            case NPN_AND_ALPN: {
                switch (applicationProtocolConfig.selectedListenerFailureBehavior()) {
                    case CHOOSE_MY_LAST_PROTOCOL: 
                    case ACCEPT: {
                        switch (applicationProtocolConfig.selectorFailureBehavior()) {
                            case NO_ADVERTISE: 
                            case CHOOSE_MY_LAST_PROTOCOL: {
                                return new OpenSslDefaultApplicationProtocolNegotiator(applicationProtocolConfig);
                            }
                        }
                        throw new UnsupportedOperationException("OpenSSL provider does not support " + (Object)((Object)applicationProtocolConfig.selectorFailureBehavior()) + " behavior");
                    }
                }
                throw new UnsupportedOperationException("OpenSSL provider does not support " + (Object)((Object)applicationProtocolConfig.selectedListenerFailureBehavior()) + " behavior");
            }
        }
        throw new Error();
    }

    static boolean useExtendedTrustManager(X509TrustManager x509TrustManager) {
        return PlatformDependent.javaVersion() >= 7 && x509TrustManager instanceof X509ExtendedTrustManager;
    }

    @Override
    public final int refCnt() {
        return this.refCnt.refCnt();
    }

    @Override
    public final ReferenceCounted retain() {
        this.refCnt.retain();
        return this;
    }

    @Override
    public final ReferenceCounted touch() {
        this.refCnt.touch();
        return this;
    }

    @Override
    public final ReferenceCounted touch(Object object) {
        this.refCnt.touch(object);
        return this;
    }

    @Override
    public final boolean release() {
        return this.refCnt.release();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void setKeyMaterial(long l2, X509Certificate[] x509CertificateArray, PrivateKey privateKey, String string) throws SSLException {
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        PemEncoded pemEncoded = null;
        try {
            pemEncoded = PemX509Certificate.toPEM(ByteBufAllocator.DEFAULT, true, x509CertificateArray);
            l4 = ReferenceCountedOpenSslContext.toBIO(ByteBufAllocator.DEFAULT, pemEncoded.retain());
            l5 = ReferenceCountedOpenSslContext.toBIO(ByteBufAllocator.DEFAULT, pemEncoded.retain());
            if (privateKey != null) {
                l3 = ReferenceCountedOpenSslContext.toBIO(ByteBufAllocator.DEFAULT, privateKey);
            }
            SSLContext.setCertificateBio((long)l2, (long)l4, (long)l3, (String)(string == null ? "" : string));
            SSLContext.setCertificateChainBio((long)l2, (long)l5, (boolean)true);
        }
        catch (SSLException sSLException) {
            try {
                SSLException sSLException2 = sSLException;
                throw sSLException;
                catch (Exception exception) {
                    throw new SSLException("failed to set certificate and key", exception);
                }
            }
            catch (Throwable throwable) {
                ReferenceCountedOpenSslContext.freeBio(l3);
                ReferenceCountedOpenSslContext.freeBio(l4);
                ReferenceCountedOpenSslContext.freeBio(l5);
                if (pemEncoded != null) {
                    pemEncoded.release();
                }
                throw throwable;
            }
        }
        ReferenceCountedOpenSslContext.freeBio(l3);
        ReferenceCountedOpenSslContext.freeBio(l4);
        ReferenceCountedOpenSslContext.freeBio(l5);
        if (pemEncoded != null) {
            pemEncoded.release();
            return;
        }
    }

    static void freeBio(long l2) {
        if (l2 != 0L) {
            SSL.freeBIO((long)l2);
        }
    }

    static long toBIO(ByteBufAllocator byteBufAllocator, PrivateKey object) throws Exception {
        if (object == null) {
            return 0L;
        }
        object = PemPrivateKey.toPEM(byteBufAllocator, true, (PrivateKey)object);
        try {
            long l2 = ReferenceCountedOpenSslContext.toBIO(byteBufAllocator, object.retain());
            return l2;
        }
        finally {
            object.release();
        }
    }

    static long toBIO(ByteBufAllocator byteBufAllocator, X509Certificate ... object) throws Exception {
        if (object == null) {
            return 0L;
        }
        if (((X509Certificate[])object).length == 0) {
            throw new IllegalArgumentException("certChain can't be empty");
        }
        object = PemX509Certificate.toPEM(byteBufAllocator, true, (X509Certificate[])object);
        try {
            long l2 = ReferenceCountedOpenSslContext.toBIO(byteBufAllocator, object.retain());
            return l2;
        }
        finally {
            object.release();
        }
    }

    static long toBIO(ByteBufAllocator byteBufAllocator, PemEncoded pemEncoded) throws Exception {
        try {
            long l2;
            ByteBuf byteBuf = pemEncoded.content();
            if (byteBuf.isDirect()) {
                long l3 = ReferenceCountedOpenSslContext.newBIO(byteBuf.retainedSlice());
                return l3;
            }
            ByteBuf byteBuf2 = byteBufAllocator.directBuffer(byteBuf.readableBytes());
            try {
                ByteBuf byteBuf3 = byteBuf;
                byteBuf2.writeBytes(byteBuf3, byteBuf3.readerIndex(), byteBuf.readableBytes());
                l2 = ReferenceCountedOpenSslContext.newBIO(byteBuf2.retainedSlice());
            }
            catch (Throwable throwable) {
                try {
                    if (pemEncoded.isSensitive()) {
                        SslUtils.zeroout(byteBuf2);
                    }
                }
                finally {
                    byteBuf2.release();
                }
                throw throwable;
            }
            try {
                if (pemEncoded.isSensitive()) {
                    SslUtils.zeroout(byteBuf2);
                }
            }
            finally {
                byteBuf2.release();
            }
            return l2;
        }
        finally {
            pemEncoded.release();
        }
    }

    private static long newBIO(ByteBuf byteBuf) throws Exception {
        try {
            long l2 = SSL.newMemBIO();
            int n2 = byteBuf.readableBytes();
            if (SSL.bioWrite((long)l2, (long)(OpenSsl.memoryAddress(byteBuf) + (long)byteBuf.readerIndex()), (int)n2) != n2) {
                SSL.freeBIO((long)l2);
                throw new IllegalStateException("Could not write data to memory BIO");
            }
            return l2;
        }
        finally {
            byteBuf.release();
        }
    }

    static OpenSslKeyMaterialProvider providerFor(KeyManagerFactory keyManagerFactory, String string) {
        if (keyManagerFactory instanceof OpenSslX509KeyManagerFactory) {
            return ((OpenSslX509KeyManagerFactory)keyManagerFactory).newProvider();
        }
        if (keyManagerFactory instanceof OpenSslCachingX509KeyManagerFactory) {
            return ((OpenSslCachingX509KeyManagerFactory)keyManagerFactory).newProvider(string);
        }
        return new OpenSslKeyMaterialProvider(ReferenceCountedOpenSslContext.chooseX509KeyManager(keyManagerFactory.getKeyManagers()), string);
    }

    static {
        leakDetector = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(ReferenceCountedOpenSslContext.class);
        NONE_PROTOCOL_NEGOTIATOR = new OpenSslApplicationProtocolNegotiator(){

            @Override
            public final ApplicationProtocolConfig.Protocol protocol() {
                return ApplicationProtocolConfig.Protocol.NONE;
            }

            @Override
            public final List<String> protocols() {
                return Collections.emptyList();
            }

            @Override
            public final ApplicationProtocolConfig.SelectorFailureBehavior selectorFailureBehavior() {
                return ApplicationProtocolConfig.SelectorFailureBehavior.CHOOSE_MY_LAST_PROTOCOL;
            }

            @Override
            public final ApplicationProtocolConfig.SelectedListenerFailureBehavior selectedListenerFailureBehavior() {
                return ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT;
            }
        };
        Integer n2 = null;
        try {
            String string = SystemPropertyUtil.get("jdk.tls.ephemeralDHKeySize");
            if (string != null) {
                try {
                    n2 = Integer.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    logger.debug("ReferenceCountedOpenSslContext supports -Djdk.tls.ephemeralDHKeySize={int}, but got: " + string);
                }
            }
        }
        catch (Throwable throwable) {}
        DH_KEY_LENGTH = n2;
    }

    private static final class DefaultOpenSslEngineMap
    implements OpenSslEngineMap {
        private final Map<Long, ReferenceCountedOpenSslEngine> engines = PlatformDependent.newConcurrentHashMap();

        private DefaultOpenSslEngineMap() {
        }

        public final ReferenceCountedOpenSslEngine remove(long l2) {
            return this.engines.remove(l2);
        }

        public final void add(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine) {
            this.engines.put(referenceCountedOpenSslEngine.sslPointer(), referenceCountedOpenSslEngine);
        }
    }

    static abstract class AbstractCertificateVerifier
    extends CertificateVerifier {
        private final OpenSslEngineMap engineMap;

        AbstractCertificateVerifier(OpenSslEngineMap openSslEngineMap) {
            this.engineMap = openSslEngineMap;
        }
    }
}

