/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.ssl;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.handler.ssl.PemEncoded;
import com.appoptics.ext.io.netty.handler.ssl.SslUtils;
import com.appoptics.ext.io.netty.util.AbstractReferenceCounted;
import com.appoptics.ext.io.netty.util.IllegalReferenceCountException;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;

class PemValue
extends AbstractReferenceCounted
implements PemEncoded {
    private final ByteBuf content;
    private final boolean sensitive;

    PemValue(ByteBuf byteBuf, boolean bl) {
        this.content = ObjectUtil.checkNotNull(byteBuf, "content");
        this.sensitive = bl;
    }

    public boolean isSensitive() {
        return this.sensitive;
    }

    public ByteBuf content() {
        int n2 = this.refCnt();
        if (n2 <= 0) {
            throw new IllegalReferenceCountException(n2);
        }
        return this.content;
    }

    public PemValue touch() {
        return (PemValue)super.touch();
    }

    public PemValue touch(Object object) {
        this.content.touch(object);
        return this;
    }

    public PemValue retain() {
        return (PemValue)super.retain();
    }

    protected void deallocate() {
        if (this.sensitive) {
            SslUtils.zeroout(this.content);
        }
        this.content.release();
    }
}

