/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.ssl;

import com.appoptics.ext.io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import com.appoptics.ext.io.netty.handler.ssl.OpenSslSessionContext;
import com.appoptics.ext.io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import com.appoptics.ext.io.netty.internal.tcnative.SSLContext;
import java.util.concurrent.locks.Lock;

public final class OpenSslServerSessionContext
extends OpenSslSessionContext {
    OpenSslServerSessionContext(ReferenceCountedOpenSslContext referenceCountedOpenSslContext, OpenSslKeyMaterialProvider openSslKeyMaterialProvider) {
        super(referenceCountedOpenSslContext, openSslKeyMaterialProvider);
    }

    public final void setSessionTimeout(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        Lock lock = this.context.ctxLock.writeLock();
        lock.lock();
        try {
            SSLContext.setSessionCacheTimeout((long)this.context.ctx, (long)n2);
            return;
        }
        finally {
            lock.unlock();
        }
    }

    public final int getSessionTimeout() {
        Lock lock = this.context.ctxLock.readLock();
        lock.lock();
        try {
            int n2 = (int)SSLContext.getSessionCacheTimeout((long)this.context.ctx);
            return n2;
        }
        finally {
            lock.unlock();
        }
    }

    public final void setSessionCacheSize(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        Lock lock = this.context.ctxLock.writeLock();
        lock.lock();
        try {
            SSLContext.setSessionCacheSize((long)this.context.ctx, (long)n2);
            return;
        }
        finally {
            lock.unlock();
        }
    }

    public final int getSessionCacheSize() {
        Lock lock = this.context.ctxLock.readLock();
        lock.lock();
        try {
            int n2 = (int)SSLContext.getSessionCacheSize((long)this.context.ctx);
            return n2;
        }
        finally {
            lock.unlock();
        }
    }

    public final boolean setSessionIdContext(byte[] byArray) {
        Lock lock = this.context.ctxLock.writeLock();
        lock.lock();
        try {
            boolean bl = SSLContext.setSessionIdContext((long)this.context.ctx, (byte[])byArray);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }
}

