/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.ssl;

import com.appoptics.ext.io.netty.handler.ssl.ApplicationProtocolConfig;
import com.appoptics.ext.io.netty.handler.ssl.CipherSuiteFilter;
import com.appoptics.ext.io.netty.handler.ssl.ClientAuth;
import com.appoptics.ext.io.netty.handler.ssl.OpenSslApplicationProtocolNegotiator;
import com.appoptics.ext.io.netty.handler.ssl.OpenSslContext;
import com.appoptics.ext.io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import com.appoptics.ext.io.netty.handler.ssl.OpenSslServerSessionContext;
import com.appoptics.ext.io.netty.handler.ssl.ReferenceCountedOpenSslServerContext;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OpenSslServerContext
extends OpenSslContext {
    private final OpenSslServerSessionContext sessionContext;

    OpenSslServerContext(X509Certificate[] x509CertificateArray, TrustManagerFactory trustManagerFactory, X509Certificate[] x509CertificateArray2, PrivateKey privateKey, String string, KeyManagerFactory keyManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, long l2, long l3, ClientAuth clientAuth, String[] stringArray, boolean bl, boolean bl2, String string2) throws SSLException {
        this(x509CertificateArray, trustManagerFactory, x509CertificateArray2, privateKey, string, keyManagerFactory, iterable, cipherSuiteFilter, OpenSslServerContext.toNegotiator(applicationProtocolConfig), l2, l3, clientAuth, stringArray, bl, bl2, string2);
    }

    private OpenSslServerContext(X509Certificate[] x509CertificateArray, TrustManagerFactory trustManagerFactory, X509Certificate[] x509CertificateArray2, PrivateKey privateKey, String string, KeyManagerFactory keyManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, OpenSslApplicationProtocolNegotiator openSslApplicationProtocolNegotiator, long l2, long l3, ClientAuth clientAuth, String[] stringArray, boolean bl, boolean bl2, String string2) throws SSLException {
        super(iterable, cipherSuiteFilter, openSslApplicationProtocolNegotiator, l2, l3, 1, (Certificate[])x509CertificateArray2, clientAuth, stringArray, bl, bl2);
        try {
            OpenSslKeyMaterialProvider.validateKeyMaterialSupported(x509CertificateArray2, privateKey, string);
            this.sessionContext = ReferenceCountedOpenSslServerContext.newSessionContext(this, this.ctx, this.engineMap, x509CertificateArray, trustManagerFactory, x509CertificateArray2, privateKey, string, keyManagerFactory, string2);
            return;
        }
        catch (Throwable throwable) {
            this.release();
            throw throwable;
        }
    }

    @Override
    public final OpenSslServerSessionContext sessionContext() {
        return this.sessionContext;
    }
}

