/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.ssl;

import com.appoptics.ext.io.netty.buffer.ByteBufAllocator;
import com.appoptics.ext.io.netty.handler.ssl.JdkApplicationProtocolNegotiator;
import com.appoptics.ext.io.netty.handler.ssl.JdkSslEngine;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.SystemPropertyUtil;
import com.appoptics.ext.org.conscrypt.BufferAllocator;
import com.appoptics.ext.org.conscrypt.Conscrypt;
import com.appoptics.ext.org.conscrypt.HandshakeListener;
import java.nio.ByteBuffer;
import java.util.LinkedHashSet;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ConscryptAlpnSslEngine
extends JdkSslEngine {
    private static final boolean USE_BUFFER_ALLOCATOR = SystemPropertyUtil.getBoolean("com.appoptics.ext.io.netty.handler.ssl.conscrypt.useBufferAllocator", true);

    static ConscryptAlpnSslEngine newClientEngine(SSLEngine sSLEngine, ByteBufAllocator byteBufAllocator, JdkApplicationProtocolNegotiator jdkApplicationProtocolNegotiator) {
        return new ClientEngine(sSLEngine, byteBufAllocator, jdkApplicationProtocolNegotiator);
    }

    static ConscryptAlpnSslEngine newServerEngine(SSLEngine sSLEngine, ByteBufAllocator byteBufAllocator, JdkApplicationProtocolNegotiator jdkApplicationProtocolNegotiator) {
        return new ServerEngine(sSLEngine, byteBufAllocator, jdkApplicationProtocolNegotiator);
    }

    private ConscryptAlpnSslEngine(SSLEngine sSLEngine, ByteBufAllocator byteBufAllocator, List<String> list) {
        super(sSLEngine);
        if (USE_BUFFER_ALLOCATOR) {
            Conscrypt.setBufferAllocator((SSLEngine)sSLEngine, (BufferAllocator)new BufferAllocatorAdapter(byteBufAllocator));
        }
        Conscrypt.setApplicationProtocols((SSLEngine)sSLEngine, (String[])list.toArray(new String[0]));
    }

    final int calculateOutNetBufSize(int n2, int n3) {
        long l2 = (long)Conscrypt.maxSealOverhead((SSLEngine)this.getWrappedEngine()) * (long)n3;
        return (int)Math.min(Integer.MAX_VALUE, (long)n2 + l2);
    }

    final SSLEngineResult unwrap(ByteBuffer[] byteBufferArray, ByteBuffer[] byteBufferArray2) throws SSLException {
        return Conscrypt.unwrap((SSLEngine)this.getWrappedEngine(), (ByteBuffer[])byteBufferArray, (ByteBuffer[])byteBufferArray2);
    }

    private static final class BufferAllocatorAdapter
    extends BufferAllocator {
        private final ByteBufAllocator alloc;

        BufferAllocatorAdapter(ByteBufAllocator byteBufAllocator) {
            this.alloc = byteBufAllocator;
        }
    }

    private static final class ServerEngine
    extends ConscryptAlpnSslEngine {
        private final JdkApplicationProtocolNegotiator.ProtocolSelector protocolSelector;

        ServerEngine(SSLEngine sSLEngine, ByteBufAllocator byteBufAllocator, JdkApplicationProtocolNegotiator jdkApplicationProtocolNegotiator) {
            super(sSLEngine, byteBufAllocator, jdkApplicationProtocolNegotiator.protocols());
            Conscrypt.setHandshakeListener((SSLEngine)sSLEngine, (HandshakeListener)new HandshakeListener(){});
            this.protocolSelector = ObjectUtil.checkNotNull(jdkApplicationProtocolNegotiator.protocolSelectorFactory().newSelector(this, new LinkedHashSet<String>(jdkApplicationProtocolNegotiator.protocols())), "protocolSelector");
        }
    }

    private static final class ClientEngine
    extends ConscryptAlpnSslEngine {
        private final JdkApplicationProtocolNegotiator.ProtocolSelectionListener protocolListener;

        ClientEngine(SSLEngine sSLEngine, ByteBufAllocator byteBufAllocator, JdkApplicationProtocolNegotiator jdkApplicationProtocolNegotiator) {
            super(sSLEngine, byteBufAllocator, jdkApplicationProtocolNegotiator.protocols());
            Conscrypt.setHandshakeListener((SSLEngine)sSLEngine, (HandshakeListener)new HandshakeListener(){});
            this.protocolListener = ObjectUtil.checkNotNull(jdkApplicationProtocolNegotiator.protocolListenerFactory().newListener(this, jdkApplicationProtocolNegotiator.protocols()), "protocolListener");
        }
    }
}

