/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.proxy;

import com.appoptics.ext.io.netty.channel.Channel;
import com.appoptics.ext.io.netty.channel.ChannelDuplexHandler;
import com.appoptics.ext.io.netty.channel.ChannelFuture;
import com.appoptics.ext.io.netty.channel.ChannelFutureListener;
import com.appoptics.ext.io.netty.channel.ChannelHandlerContext;
import com.appoptics.ext.io.netty.channel.ChannelPromise;
import com.appoptics.ext.io.netty.channel.PendingWriteQueue;
import com.appoptics.ext.io.netty.handler.proxy.ProxyConnectException;
import com.appoptics.ext.io.netty.handler.proxy.ProxyConnectionEvent;
import com.appoptics.ext.io.netty.util.ReferenceCountUtil;
import com.appoptics.ext.io.netty.util.concurrent.DefaultPromise;
import com.appoptics.ext.io.netty.util.concurrent.EventExecutor;
import com.appoptics.ext.io.netty.util.concurrent.ScheduledFuture;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.nio.channels.ConnectionPendingException;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProxyHandler
extends ChannelDuplexHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ProxyHandler.class);
    private final SocketAddress proxyAddress;
    private volatile SocketAddress destinationAddress;
    private volatile long connectTimeoutMillis = 10000L;
    private volatile ChannelHandlerContext ctx;
    private PendingWriteQueue pendingWrites;
    private boolean finished;
    private boolean suppressChannelReadComplete;
    private boolean flushedPrematurely;
    private final LazyChannelPromise connectPromise = new LazyChannelPromise();
    private ScheduledFuture<?> connectTimeoutFuture;
    private final ChannelFutureListener writeListener = new ChannelFutureListener(){

        public void operationComplete(ChannelFuture channelFuture) throws Exception {
            if (!channelFuture.isSuccess()) {
                ProxyHandler.this.setConnectFailure(channelFuture.cause());
            }
        }
    };

    protected ProxyHandler(SocketAddress socketAddress) {
        this.proxyAddress = ObjectUtil.checkNotNull(socketAddress, "proxyAddress");
    }

    public abstract String protocol();

    public abstract String authScheme();

    public final <T extends SocketAddress> T destinationAddress() {
        return (T)this.destinationAddress;
    }

    @Override
    public final void handlerAdded(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.ctx = channelHandlerContext;
        this.addCodec(channelHandlerContext);
        if (channelHandlerContext.channel().isActive()) {
            this.sendInitialMessage(channelHandlerContext);
        }
    }

    protected abstract void addCodec(ChannelHandlerContext var1) throws Exception;

    protected abstract void removeEncoder(ChannelHandlerContext var1) throws Exception;

    protected abstract void removeDecoder(ChannelHandlerContext var1) throws Exception;

    @Override
    public final void connect(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) throws Exception {
        if (this.destinationAddress != null) {
            channelPromise.setFailure(new ConnectionPendingException());
            return;
        }
        this.destinationAddress = socketAddress;
        channelHandlerContext.connect(this.proxyAddress, socketAddress2, channelPromise);
    }

    @Override
    public final void channelActive(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.sendInitialMessage(channelHandlerContext);
        channelHandlerContext.fireChannelActive();
    }

    private void sendInitialMessage(ChannelHandlerContext channelHandlerContext) throws Exception {
        Object object;
        long l2 = this.connectTimeoutMillis;
        if (l2 > 0L) {
            this.connectTimeoutFuture = channelHandlerContext.executor().schedule(new Runnable(){

                public void run() {
                    if (!ProxyHandler.this.connectPromise.isDone()) {
                        ProxyHandler.this.setConnectFailure(new ProxyConnectException(ProxyHandler.this.exceptionMessage("timeout")));
                    }
                }
            }, l2, TimeUnit.MILLISECONDS);
        }
        if ((object = this.newInitialMessage(channelHandlerContext)) != null) {
            this.sendToProxyServer(object);
        }
        ProxyHandler.readIfNeeded(channelHandlerContext);
    }

    protected abstract Object newInitialMessage(ChannelHandlerContext var1) throws Exception;

    protected final void sendToProxyServer(Object object) {
        this.ctx.writeAndFlush(object).addListener(this.writeListener);
    }

    @Override
    public final void channelInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
        if (this.finished) {
            channelHandlerContext.fireChannelInactive();
            return;
        }
        this.setConnectFailure(new ProxyConnectException(this.exceptionMessage("disconnected")));
    }

    @Override
    public final void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) throws Exception {
        if (this.finished) {
            channelHandlerContext.fireExceptionCaught(throwable);
            return;
        }
        this.setConnectFailure(throwable);
    }

    @Override
    public final void channelRead(ChannelHandlerContext object, Object object2) throws Exception {
        block4: {
            if (this.finished) {
                this.suppressChannelReadComplete = false;
                object.fireChannelRead(object2);
                return;
            }
            this.suppressChannelReadComplete = true;
            try {
                boolean bl = this.handleResponse((ChannelHandlerContext)object, object2);
                if (!bl) break block4;
                this.setConnectSuccess();
            }
            catch (Throwable throwable) {
                object = throwable;
                object = throwable;
                ReferenceCountUtil.release(object2);
                this.setConnectFailure((Throwable)object);
                return;
            }
            catch (Throwable throwable) {
                ReferenceCountUtil.release(object2);
                throw throwable;
            }
        }
        ReferenceCountUtil.release(object2);
        return;
    }

    protected abstract boolean handleResponse(ChannelHandlerContext var1, Object var2) throws Exception;

    private void setConnectSuccess() {
        this.finished = true;
        this.cancelConnectTimeoutFuture();
        if (!this.connectPromise.isDone()) {
            boolean bl = true & this.safeRemoveEncoder();
            this.ctx.fireUserEventTriggered(new ProxyConnectionEvent(this.protocol(), this.authScheme(), this.proxyAddress, this.destinationAddress));
            if (bl &= this.safeRemoveDecoder()) {
                this.writePendingWrites();
                if (this.flushedPrematurely) {
                    this.ctx.flush();
                }
                this.connectPromise.trySuccess(this.ctx.channel());
                return;
            }
            ProxyConnectException proxyConnectException = new ProxyConnectException("failed to remove all codec handlers added by the proxy handler; bug?");
            this.failPendingWritesAndClose(proxyConnectException);
        }
    }

    private boolean safeRemoveDecoder() {
        try {
            ProxyHandler proxyHandler = this;
            proxyHandler.removeDecoder(proxyHandler.ctx);
            return true;
        }
        catch (Exception exception) {
            logger.warn("Failed to remove proxy decoders:", exception);
            return false;
        }
    }

    private boolean safeRemoveEncoder() {
        try {
            ProxyHandler proxyHandler = this;
            proxyHandler.removeEncoder(proxyHandler.ctx);
            return true;
        }
        catch (Exception exception) {
            logger.warn("Failed to remove proxy encoders:", exception);
            return false;
        }
    }

    private void setConnectFailure(Throwable throwable) {
        this.finished = true;
        this.cancelConnectTimeoutFuture();
        if (!this.connectPromise.isDone()) {
            if (!(throwable instanceof ProxyConnectException)) {
                throwable = new ProxyConnectException(this.exceptionMessage(throwable.toString()), throwable);
            }
            this.safeRemoveDecoder();
            this.safeRemoveEncoder();
            this.failPendingWritesAndClose(throwable);
        }
    }

    private void failPendingWritesAndClose(Throwable throwable) {
        this.failPendingWrites(throwable);
        this.connectPromise.tryFailure(throwable);
        this.ctx.fireExceptionCaught(throwable);
        this.ctx.close();
    }

    private void cancelConnectTimeoutFuture() {
        if (this.connectTimeoutFuture != null) {
            this.connectTimeoutFuture.cancel(false);
            this.connectTimeoutFuture = null;
        }
    }

    protected final String exceptionMessage(String string) {
        if (string == null) {
            string = "";
        }
        StringBuilder stringBuilder = new StringBuilder(128 + string.length()).append(this.protocol()).append(", ").append(this.authScheme()).append(", ").append(this.proxyAddress).append(" => ").append(this.destinationAddress);
        if (!string.isEmpty()) {
            stringBuilder.append(", ").append(string);
        }
        return stringBuilder.toString();
    }

    @Override
    public final void channelReadComplete(ChannelHandlerContext channelHandlerContext) throws Exception {
        if (this.suppressChannelReadComplete) {
            this.suppressChannelReadComplete = false;
            ProxyHandler.readIfNeeded(channelHandlerContext);
            return;
        }
        channelHandlerContext.fireChannelReadComplete();
    }

    @Override
    public final void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) throws Exception {
        if (this.finished) {
            this.writePendingWrites();
            channelHandlerContext.write(object, channelPromise);
            return;
        }
        this.addPendingWrite(channelHandlerContext, object, channelPromise);
    }

    @Override
    public final void flush(ChannelHandlerContext channelHandlerContext) throws Exception {
        if (this.finished) {
            this.writePendingWrites();
            channelHandlerContext.flush();
            return;
        }
        this.flushedPrematurely = true;
    }

    private static void readIfNeeded(ChannelHandlerContext channelHandlerContext) {
        if (!channelHandlerContext.channel().config().isAutoRead()) {
            channelHandlerContext.read();
        }
    }

    private void writePendingWrites() {
        if (this.pendingWrites != null) {
            this.pendingWrites.removeAndWriteAll();
            this.pendingWrites = null;
        }
    }

    private void failPendingWrites(Throwable throwable) {
        if (this.pendingWrites != null) {
            this.pendingWrites.removeAndFailAll(throwable);
            this.pendingWrites = null;
        }
    }

    private void addPendingWrite(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        PendingWriteQueue pendingWriteQueue = this.pendingWrites;
        if (pendingWriteQueue == null) {
            this.pendingWrites = pendingWriteQueue = new PendingWriteQueue(channelHandlerContext);
        }
        pendingWriteQueue.add(object, channelPromise);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class LazyChannelPromise
    extends DefaultPromise<Channel> {
        private LazyChannelPromise() {
        }

        @Override
        protected final EventExecutor executor() {
            if (ProxyHandler.this.ctx == null) {
                throw new IllegalStateException();
            }
            return ProxyHandler.this.ctx.executor();
        }
    }
}

