/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec.http2;

import com.appoptics.ext.io.netty.handler.codec.http2.DefaultHttp2Headers;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Headers;
import com.appoptics.ext.io.netty.util.AsciiString;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReadOnlyHttp2Headers
implements Http2Headers {
    private final AsciiString[] pseudoHeaders;
    private final AsciiString[] otherHeaders;

    public static ReadOnlyHttp2Headers serverHeaders(boolean bl, AsciiString asciiString, AsciiString ... asciiStringArray) {
        return new ReadOnlyHttp2Headers(bl, new AsciiString[]{Http2Headers.PseudoHeaderName.STATUS.value(), asciiString}, asciiStringArray);
    }

    private ReadOnlyHttp2Headers(boolean bl, AsciiString[] asciiStringArray, AsciiString ... asciiStringArray2) {
        assert ((asciiStringArray.length & 1) == 0);
        if ((asciiStringArray2.length & 1) != 0) {
            throw ReadOnlyHttp2Headers.newInvalidArraySizeException();
        }
        if (bl) {
            ReadOnlyHttp2Headers.validateHeaders(asciiStringArray, asciiStringArray2);
        }
        this.pseudoHeaders = asciiStringArray;
        this.otherHeaders = asciiStringArray2;
    }

    private static IllegalArgumentException newInvalidArraySizeException() {
        return new IllegalArgumentException("pseudoHeaders and otherHeaders must be arrays of [name, value] pairs");
    }

    private static void validateHeaders(AsciiString[] asciiStringArray, AsciiString ... asciiStringArray2) {
        int n2;
        for (n2 = 1; n2 < asciiStringArray.length; n2 += 2) {
            if (asciiStringArray[n2] != null) continue;
            throw new IllegalArgumentException("pseudoHeaders value at index " + n2 + " is null");
        }
        n2 = 0;
        int n3 = asciiStringArray2.length - 1;
        for (int i2 = 0; i2 < n3; i2 += 2) {
            AsciiString asciiString = asciiStringArray2[i2];
            DefaultHttp2Headers.HTTP2_NAME_VALIDATOR.validateName(asciiString);
            if (n2 == 0 && !asciiString.isEmpty() && asciiString.byteAt(0) != 58) {
                n2 = 1;
            } else if (n2 != 0 && !asciiString.isEmpty() && asciiString.byteAt(0) == 58) {
                throw new IllegalArgumentException("otherHeaders name at index " + i2 + " is a pseudo header that appears after non-pseudo headers.");
            }
            if (asciiStringArray2[i2 + 1] != null) continue;
            throw new IllegalArgumentException("otherHeaders value at index " + (i2 + 1) + " is null");
        }
    }

    private AsciiString get0(CharSequence charSequence) {
        int n2;
        int n3 = AsciiString.hashCode(charSequence);
        int n4 = this.pseudoHeaders.length - 1;
        for (n2 = 0; n2 < n4; n2 += 2) {
            AsciiString asciiString = this.pseudoHeaders[n2];
            if (asciiString.hashCode() != n3 || !asciiString.contentEqualsIgnoreCase(charSequence)) continue;
            return this.pseudoHeaders[n2 + 1];
        }
        n2 = this.otherHeaders.length - 1;
        for (int i2 = 0; i2 < n2; i2 += 2) {
            AsciiString asciiString = this.otherHeaders[i2];
            if (asciiString.hashCode() != n3 || !asciiString.contentEqualsIgnoreCase(charSequence)) continue;
            return this.otherHeaders[i2 + 1];
        }
        return null;
    }

    @Override
    public final CharSequence get(CharSequence charSequence) {
        return this.get0(charSequence);
    }

    @Override
    public final List<CharSequence> getAll(CharSequence charSequence) {
        int n2;
        int n3 = AsciiString.hashCode(charSequence);
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
        int n4 = this.pseudoHeaders.length - 1;
        for (n2 = 0; n2 < n4; n2 += 2) {
            AsciiString asciiString = this.pseudoHeaders[n2];
            if (asciiString.hashCode() != n3 || !asciiString.contentEqualsIgnoreCase(charSequence)) continue;
            arrayList.add(this.pseudoHeaders[n2 + 1]);
        }
        n2 = this.otherHeaders.length - 1;
        for (int i2 = 0; i2 < n2; i2 += 2) {
            AsciiString asciiString = this.otherHeaders[i2];
            if (asciiString.hashCode() != n3 || !asciiString.contentEqualsIgnoreCase(charSequence)) continue;
            arrayList.add(this.otherHeaders[i2 + 1]);
        }
        return arrayList;
    }

    @Override
    public final int size() {
        return this.pseudoHeaders.length + this.otherHeaders.length >>> 1;
    }

    @Override
    public final boolean isEmpty() {
        return this.pseudoHeaders.length == 0 && this.otherHeaders.length == 0;
    }

    @Override
    public final Http2Headers add(CharSequence charSequence, CharSequence charSequence2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public final Iterator<Map.Entry<CharSequence, CharSequence>> iterator() {
        return new ReadOnlyIterator();
    }

    @Override
    public final Http2Headers method(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public final Http2Headers scheme(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public final Http2Headers authority(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public final Http2Headers path(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public final Http2Headers status(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public final CharSequence status() {
        return this.get(Http2Headers.PseudoHeaderName.STATUS.value());
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName()).append('[');
        String string = "";
        for (Map.Entry<CharSequence, CharSequence> entry : this) {
            stringBuilder.append(string);
            stringBuilder.append(entry.getKey()).append(": ").append(entry.getValue());
            string = ", ";
        }
        return stringBuilder.append(']').toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ReadOnlyIterator
    implements Iterator<Map.Entry<CharSequence, CharSequence>>,
    Map.Entry<CharSequence, CharSequence> {
        private int i;
        private AsciiString[] current;
        private AsciiString key;
        private AsciiString value;

        private ReadOnlyIterator() {
            this.current = ReadOnlyHttp2Headers.this.pseudoHeaders.length != 0 ? ReadOnlyHttp2Headers.this.pseudoHeaders : ReadOnlyHttp2Headers.this.otherHeaders;
        }

        @Override
        public final boolean hasNext() {
            return this.i != this.current.length;
        }

        @Override
        public final Map.Entry<CharSequence, CharSequence> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.key = this.current[this.i];
            this.value = this.current[this.i + 1];
            this.i += 2;
            if (this.i == this.current.length && this.current == ReadOnlyHttp2Headers.this.pseudoHeaders) {
                this.current = ReadOnlyHttp2Headers.this.otherHeaders;
                this.i = 0;
            }
            return this;
        }

        @Override
        public final CharSequence getKey() {
            return this.key;
        }

        @Override
        public final CharSequence getValue() {
            return this.value;
        }

        @Override
        public final CharSequence setValue(CharSequence charSequence) {
            throw new UnsupportedOperationException("read only");
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException("read only");
        }

        public final String toString() {
            return this.key.toString() + '=' + this.value.toString();
        }
    }
}

