/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec.http2;

import com.appoptics.ext.io.netty.channel.Channel;
import com.appoptics.ext.io.netty.channel.ChannelFuture;
import com.appoptics.ext.io.netty.channel.ChannelFutureListener;
import com.appoptics.ext.io.netty.channel.ChannelHandler;
import com.appoptics.ext.io.netty.channel.ChannelHandlerContext;
import com.appoptics.ext.io.netty.channel.ServerChannel;
import com.appoptics.ext.io.netty.handler.codec.http2.AbstractHttp2StreamChannel;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2ChannelDuplexHandler;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2CodecUtil;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Error;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Exception;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Frame;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2FrameCodec;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2FrameStream;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2FrameStreamEvent;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2FrameStreamException;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2FrameStreamVisitor;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2GoAwayFrame;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2ResetFrame;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2StreamFrame;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2WindowUpdateFrame;
import java.util.Queue;

public final class Http2MultiplexHandler
extends Http2ChannelDuplexHandler {
    static final ChannelFutureListener CHILD_CHANNEL_REGISTRATION_LISTENER = new ChannelFutureListener(){

        public final void operationComplete(ChannelFuture channelFuture) {
            Http2MultiplexHandler.registerDone(channelFuture);
        }
    };
    private final ChannelHandler inboundStreamHandler;
    private final ChannelHandler upgradeStreamHandler;
    private final Queue<AbstractHttp2StreamChannel> readCompletePendingQueue;
    private boolean parentReadInProgress;
    private int idCount;
    private volatile ChannelHandlerContext ctx;

    static void registerDone(ChannelFuture object) {
        if (!object.isSuccess()) {
            if ((object = object.channel()).isRegistered()) {
                object.close();
                return;
            }
            object.unsafe().closeForcibly();
        }
    }

    protected final void handlerAdded0(ChannelHandlerContext channelHandlerContext) {
        if (channelHandlerContext.executor() != channelHandlerContext.channel().eventLoop()) {
            throw new IllegalStateException("EventExecutor must be EventLoop of Channel");
        }
        this.ctx = channelHandlerContext;
    }

    protected final void handlerRemoved0(ChannelHandlerContext channelHandlerContext) {
        this.readCompletePendingQueue.clear();
    }

    public final void channelRead(ChannelHandlerContext object, Object object2) throws Exception {
        this.parentReadInProgress = true;
        if (object2 instanceof Http2StreamFrame) {
            if (object2 instanceof Http2WindowUpdateFrame) {
                return;
            }
            object = (Http2StreamFrame)object2;
            Object object3 = (Http2FrameCodec.DefaultHttp2FrameStream)object.stream();
            object3 = (AbstractHttp2StreamChannel)((Http2FrameCodec.DefaultHttp2FrameStream)object3).attachment;
            if (object2 instanceof Http2ResetFrame) {
                ((AbstractHttp2StreamChannel)object3).pipeline().fireUserEventTriggered(object2);
                return;
            }
            ((AbstractHttp2StreamChannel)object3).fireChildRead((Http2Frame)object);
            return;
        }
        if (object2 instanceof Http2GoAwayFrame) {
            this.onHttp2GoAwayFrame((ChannelHandlerContext)object, (Http2GoAwayFrame)object2);
        }
        object.fireChannelRead(object2);
    }

    public final void channelWritabilityChanged(ChannelHandlerContext channelHandlerContext) throws Exception {
        if (channelHandlerContext.channel().isWritable()) {
            this.forEachActiveStream(AbstractHttp2StreamChannel.WRITABLE_VISITOR);
        }
        channelHandlerContext.fireChannelWritabilityChanged();
    }

    public final void userEventTriggered(ChannelHandlerContext object, Object object2) throws Exception {
        if (object2 instanceof Http2FrameStreamEvent) {
            object2 = (Http2FrameStreamEvent)object2;
            Http2FrameCodec.DefaultHttp2FrameStream defaultHttp2FrameStream = (Http2FrameCodec.DefaultHttp2FrameStream)((Http2FrameStreamEvent)object2).stream();
            if (((Http2FrameStreamEvent)object2).type() == Http2FrameStreamEvent.Type.State) {
                switch (defaultHttp2FrameStream.state()) {
                    case HALF_CLOSED_LOCAL: {
                        if (defaultHttp2FrameStream.id() != 1) break;
                    }
                    case HALF_CLOSED_REMOTE: 
                    case OPEN: {
                        if (defaultHttp2FrameStream.attachment != null) break;
                        if (defaultHttp2FrameStream.id() == 1 && !Http2MultiplexHandler.isServer((ChannelHandlerContext)object)) {
                            if (this.upgradeStreamHandler == null) {
                                throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, "Client is misconfigured for upgrade requests", new Object[0]);
                            }
                            object2 = new Http2MultiplexHandlerStreamChannel(defaultHttp2FrameStream, this.upgradeStreamHandler);
                            ((AbstractHttp2StreamChannel)object2).closeOutbound();
                        } else {
                            object2 = new Http2MultiplexHandlerStreamChannel(defaultHttp2FrameStream, this.inboundStreamHandler);
                        }
                        object = object.channel().eventLoop().register((Channel)object2);
                        if (object.isDone()) {
                            Http2MultiplexHandler.registerDone((ChannelFuture)object);
                            return;
                        }
                        object.addListener(CHILD_CHANNEL_REGISTRATION_LISTENER);
                        return;
                    }
                    case CLOSED: {
                        object = (AbstractHttp2StreamChannel)defaultHttp2FrameStream.attachment;
                        if (object == null) break;
                        ((AbstractHttp2StreamChannel)object).streamClosed();
                    }
                }
            }
            return;
        }
        object.fireUserEventTriggered(object2);
    }

    public final void exceptionCaught(ChannelHandlerContext object, Throwable throwable) throws Exception {
        if (throwable instanceof Http2FrameStreamException) {
            object = (Http2FrameStreamException)throwable;
            object = ((Http2FrameStreamException)object).stream();
            object = (AbstractHttp2StreamChannel)((Http2FrameCodec.DefaultHttp2FrameStream)object).attachment;
            try {
                ((AbstractHttp2StreamChannel)object).pipeline().fireExceptionCaught(throwable.getCause());
                return;
            }
            finally {
                ((AbstractHttp2StreamChannel)object).unsafe().closeForcibly();
            }
        }
        object.fireExceptionCaught(throwable);
    }

    private static boolean isServer(ChannelHandlerContext channelHandlerContext) {
        return channelHandlerContext.channel().parent() instanceof ServerChannel;
    }

    private void onHttp2GoAwayFrame(ChannelHandlerContext channelHandlerContext, final Http2GoAwayFrame http2GoAwayFrame) {
        try {
            final boolean bl = Http2MultiplexHandler.isServer(channelHandlerContext);
            this.forEachActiveStream(new Http2FrameStreamVisitor(){

                public boolean visit(Http2FrameStream object) {
                    int n2 = object.id();
                    if (n2 > http2GoAwayFrame.lastStreamId() && Http2CodecUtil.isStreamIdValid(n2, bl)) {
                        object = (AbstractHttp2StreamChannel)((Http2FrameCodec.DefaultHttp2FrameStream)object).attachment;
                        ((AbstractHttp2StreamChannel)object).pipeline().fireUserEventTriggered(http2GoAwayFrame.retainedDuplicate());
                    }
                    return true;
                }
            });
            return;
        }
        catch (Http2Exception http2Exception) {
            channelHandlerContext.fireExceptionCaught(http2Exception);
            channelHandlerContext.close();
            return;
        }
    }

    public final void channelReadComplete(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.processPendingReadCompleteQueue();
        channelHandlerContext.fireChannelReadComplete();
    }

    private void processPendingReadCompleteQueue() {
        this.parentReadInProgress = true;
        AbstractHttp2StreamChannel abstractHttp2StreamChannel = this.readCompletePendingQueue.poll();
        if (abstractHttp2StreamChannel != null) {
            try {
                do {
                    abstractHttp2StreamChannel.fireChildReadComplete();
                } while ((abstractHttp2StreamChannel = this.readCompletePendingQueue.poll()) != null);
            }
            finally {
                this.parentReadInProgress = false;
                this.readCompletePendingQueue.clear();
                this.ctx.flush();
            }
        } else {
            this.parentReadInProgress = false;
        }
    }

    private final class Http2MultiplexHandlerStreamChannel
    extends AbstractHttp2StreamChannel {
        Http2MultiplexHandlerStreamChannel(Http2FrameCodec.DefaultHttp2FrameStream defaultHttp2FrameStream, ChannelHandler channelHandler) {
            super(defaultHttp2FrameStream, ++Http2MultiplexHandler.this.idCount, channelHandler);
        }

        protected final boolean isParentReadInProgress() {
            return Http2MultiplexHandler.this.parentReadInProgress;
        }

        protected final void addChannelToReadCompletePendingQueue() {
            while (!Http2MultiplexHandler.this.readCompletePendingQueue.offer(this)) {
                Http2MultiplexHandler.this.processPendingReadCompleteQueue();
            }
        }

        protected final ChannelHandlerContext parentContext() {
            return Http2MultiplexHandler.this.ctx;
        }
    }
}

