/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec.http2;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.channel.ChannelHandlerContext;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Exception;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Flags;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2FrameListener;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2FrameLogger;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2FrameReader;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Headers;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Settings;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;

public class Http2InboundFrameLogger
implements Http2FrameReader {
    private final Http2FrameReader reader;
    private final Http2FrameLogger logger;

    public Http2InboundFrameLogger(Http2FrameReader http2FrameReader, Http2FrameLogger http2FrameLogger) {
        this.reader = ObjectUtil.checkNotNull(http2FrameReader, "reader");
        this.logger = ObjectUtil.checkNotNull(http2FrameLogger, "logger");
    }

    public void readFrame(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, final Http2FrameListener http2FrameListener) throws Http2Exception {
        this.reader.readFrame(channelHandlerContext, byteBuf, new Http2FrameListener(){

            public int onDataRead(ChannelHandlerContext channelHandlerContext, int n2, ByteBuf byteBuf, int n3, boolean bl) throws Http2Exception {
                Http2InboundFrameLogger.this.logger.logData(Http2FrameLogger.Direction.INBOUND, channelHandlerContext, n2, byteBuf, n3, bl);
                return http2FrameListener.onDataRead(channelHandlerContext, n2, byteBuf, n3, bl);
            }

            public void onHeadersRead(ChannelHandlerContext channelHandlerContext, int n2, Http2Headers http2Headers, int n3, boolean bl) throws Http2Exception {
                Http2InboundFrameLogger.this.logger.logHeaders(Http2FrameLogger.Direction.INBOUND, channelHandlerContext, n2, http2Headers, n3, bl);
                http2FrameListener.onHeadersRead(channelHandlerContext, n2, http2Headers, n3, bl);
            }

            public void onHeadersRead(ChannelHandlerContext channelHandlerContext, int n2, Http2Headers http2Headers, int n3, short s2, boolean bl, int n4, boolean bl2) throws Http2Exception {
                Http2InboundFrameLogger.this.logger.logHeaders(Http2FrameLogger.Direction.INBOUND, channelHandlerContext, n2, http2Headers, n3, s2, bl, n4, bl2);
                http2FrameListener.onHeadersRead(channelHandlerContext, n2, http2Headers, n3, s2, bl, n4, bl2);
            }

            public void onPriorityRead(ChannelHandlerContext channelHandlerContext, int n2, int n3, short s2, boolean bl) throws Http2Exception {
                Http2InboundFrameLogger.this.logger.logPriority(Http2FrameLogger.Direction.INBOUND, channelHandlerContext, n2, n3, s2, bl);
                http2FrameListener.onPriorityRead(channelHandlerContext, n2, n3, s2, bl);
            }

            public void onRstStreamRead(ChannelHandlerContext channelHandlerContext, int n2, long l2) throws Http2Exception {
                Http2InboundFrameLogger.this.logger.logRstStream(Http2FrameLogger.Direction.INBOUND, channelHandlerContext, n2, l2);
                http2FrameListener.onRstStreamRead(channelHandlerContext, n2, l2);
            }

            public void onSettingsAckRead(ChannelHandlerContext channelHandlerContext) throws Http2Exception {
                Http2InboundFrameLogger.this.logger.logSettingsAck(Http2FrameLogger.Direction.INBOUND, channelHandlerContext);
                http2FrameListener.onSettingsAckRead(channelHandlerContext);
            }

            public void onSettingsRead(ChannelHandlerContext channelHandlerContext, Http2Settings http2Settings) throws Http2Exception {
                Http2InboundFrameLogger.this.logger.logSettings(Http2FrameLogger.Direction.INBOUND, channelHandlerContext, http2Settings);
                http2FrameListener.onSettingsRead(channelHandlerContext, http2Settings);
            }

            public void onPingRead(ChannelHandlerContext channelHandlerContext, long l2) throws Http2Exception {
                Http2InboundFrameLogger.this.logger.logPing(Http2FrameLogger.Direction.INBOUND, channelHandlerContext, l2);
                http2FrameListener.onPingRead(channelHandlerContext, l2);
            }

            public void onPingAckRead(ChannelHandlerContext channelHandlerContext, long l2) throws Http2Exception {
                Http2InboundFrameLogger.this.logger.logPingAck(Http2FrameLogger.Direction.INBOUND, channelHandlerContext, l2);
                http2FrameListener.onPingAckRead(channelHandlerContext, l2);
            }

            public void onPushPromiseRead(ChannelHandlerContext channelHandlerContext, int n2, int n3, Http2Headers http2Headers, int n4) throws Http2Exception {
                Http2InboundFrameLogger.this.logger.logPushPromise(Http2FrameLogger.Direction.INBOUND, channelHandlerContext, n2, n3, http2Headers, n4);
                http2FrameListener.onPushPromiseRead(channelHandlerContext, n2, n3, http2Headers, n4);
            }

            public void onGoAwayRead(ChannelHandlerContext channelHandlerContext, int n2, long l2, ByteBuf byteBuf) throws Http2Exception {
                Http2InboundFrameLogger.this.logger.logGoAway(Http2FrameLogger.Direction.INBOUND, channelHandlerContext, n2, l2, byteBuf);
                http2FrameListener.onGoAwayRead(channelHandlerContext, n2, l2, byteBuf);
            }

            public void onWindowUpdateRead(ChannelHandlerContext channelHandlerContext, int n2, int n3) throws Http2Exception {
                Http2InboundFrameLogger.this.logger.logWindowsUpdate(Http2FrameLogger.Direction.INBOUND, channelHandlerContext, n2, n3);
                http2FrameListener.onWindowUpdateRead(channelHandlerContext, n2, n3);
            }

            public void onUnknownFrame(ChannelHandlerContext channelHandlerContext, byte by, int n2, Http2Flags http2Flags, ByteBuf byteBuf) throws Http2Exception {
                Http2InboundFrameLogger.this.logger.logUnknownFrame(Http2FrameLogger.Direction.INBOUND, channelHandlerContext, by, n2, http2Flags, byteBuf);
                http2FrameListener.onUnknownFrame(channelHandlerContext, by, n2, http2Flags, byteBuf);
            }
        });
    }

    public void close() {
        this.reader.close();
    }

    public Http2FrameReader.Configuration configuration() {
        return this.reader.configuration();
    }
}

