/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec.http2;

import com.appoptics.ext.io.netty.buffer.ByteBufUtil;
import com.appoptics.ext.io.netty.channel.Channel;
import com.appoptics.ext.io.netty.channel.ChannelFuture;
import com.appoptics.ext.io.netty.channel.ChannelFutureListener;
import com.appoptics.ext.io.netty.channel.ChannelHandlerContext;
import com.appoptics.ext.io.netty.channel.ChannelPromise;
import com.appoptics.ext.io.netty.handler.codec.UnsupportedMessageTypeException;
import com.appoptics.ext.io.netty.handler.codec.http.HttpServerUpgradeHandler;
import com.appoptics.ext.io.netty.handler.codec.http2.DefaultHttp2GoAwayFrame;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2CodecUtil;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Connection;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2ConnectionHandler;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2ConnectionPrefaceAndSettingsFrameWrittenEvent;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2DataFrame;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Error;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Exception;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Frame;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2FrameStream;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2FrameStreamEvent;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2FrameStreamException;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2FrameStreamVisitor;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2GoAwayFrame;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2HeadersFrame;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2NoMoreStreamIdsException;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2PingFrame;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2ResetFrame;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2SettingsAckFrame;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2SettingsFrame;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Stream;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2StreamVisitor;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2UnknownFrame;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2WindowUpdateFrame;
import com.appoptics.ext.io.netty.handler.codec.http2.HttpConversionUtil;
import com.appoptics.ext.io.netty.handler.codec.http2.InboundHttpToHttp2Adapter;
import com.appoptics.ext.io.netty.util.ReferenceCountUtil;
import com.appoptics.ext.io.netty.util.collection.IntObjectMap;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogLevel;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;

public class Http2FrameCodec
extends Http2ConnectionHandler {
    private static final InternalLogger LOG = InternalLoggerFactory.getInstance(Http2FrameCodec.class);
    protected final Http2Connection.PropertyKey streamKey;
    private final Http2Connection.PropertyKey upgradeKey;
    private final Integer initialFlowControlWindowSize;
    ChannelHandlerContext ctx;
    private int numBufferedStreams;
    private final IntObjectMap<DefaultHttp2FrameStream> frameStreamToInitializeMap;

    DefaultHttp2FrameStream newStream() {
        return new DefaultHttp2FrameStream();
    }

    final void forEachActiveStream(final Http2FrameStreamVisitor http2FrameStreamVisitor) throws Http2Exception {
        assert (this.ctx.executor().inEventLoop());
        if (this.connection().numActiveStreams() > 0) {
            this.connection().forEachActiveStream(new Http2StreamVisitor(){

                public boolean visit(Http2Stream http2Stream) {
                    try {
                        return http2FrameStreamVisitor.visit((Http2FrameStream)http2Stream.getProperty(Http2FrameCodec.this.streamKey));
                    }
                    catch (Throwable throwable) {
                        Http2FrameCodec.this.onError(Http2FrameCodec.this.ctx, false, throwable);
                        return false;
                    }
                }
            });
        }
    }

    public final void handlerAdded(ChannelHandlerContext object) throws Exception {
        this.ctx = object;
        super.handlerAdded((ChannelHandlerContext)object);
        this.handlerAdded0((ChannelHandlerContext)object);
        object = this.connection();
        if (object.isServer()) {
            this.tryExpandConnectionFlowControlWindow((Http2Connection)object);
        }
    }

    private void tryExpandConnectionFlowControlWindow(Http2Connection object) throws Http2Exception {
        if (this.initialFlowControlWindowSize != null) {
            Http2Stream http2Stream = object.connectionStream();
            object = object.local().flowController();
            int n2 = this.initialFlowControlWindowSize - object.initialWindowSize(http2Stream);
            if (n2 > 0) {
                object.incrementWindowSize(http2Stream, Math.max(n2 << 1, n2));
                Http2FrameCodec http2FrameCodec = this;
                http2FrameCodec.flush(http2FrameCodec.ctx);
            }
        }
    }

    void handlerAdded0(ChannelHandlerContext channelHandlerContext) throws Exception {
    }

    public final void userEventTriggered(final ChannelHandlerContext channelHandlerContext, final Object object) throws Exception {
        if (object == Http2ConnectionPrefaceAndSettingsFrameWrittenEvent.INSTANCE) {
            Http2FrameCodec http2FrameCodec = this;
            http2FrameCodec.tryExpandConnectionFlowControlWindow(http2FrameCodec.connection());
            channelHandlerContext.executor().execute(new Runnable(){

                public void run() {
                    channelHandlerContext.fireUserEventTriggered(object);
                }
            });
            return;
        }
        if (object instanceof HttpServerUpgradeHandler.UpgradeEvent) {
            object = (HttpServerUpgradeHandler.UpgradeEvent)object;
            try {
                this.onUpgradeEvent(channelHandlerContext, ((HttpServerUpgradeHandler.UpgradeEvent)object).retain());
                Http2Stream http2Stream = this.connection().stream(1);
                if (http2Stream.getProperty(this.streamKey) == null) {
                    this.onStreamActive0(http2Stream);
                }
                ((HttpServerUpgradeHandler.UpgradeEvent)object).upgradeRequest().headers().setInt(HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), 1);
                http2Stream.setProperty(this.upgradeKey, Boolean.TRUE);
                InboundHttpToHttp2Adapter.handle(channelHandlerContext, this.connection(), this.decoder().frameListener(), ((HttpServerUpgradeHandler.UpgradeEvent)object).upgradeRequest().retain());
            }
            finally {
                ((HttpServerUpgradeHandler.UpgradeEvent)object).release();
            }
        } else {
            channelHandlerContext.fireUserEventTriggered(object);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        if (object instanceof Http2DataFrame) {
            object = (Http2DataFrame)object;
            this.encoder().writeData(channelHandlerContext, object.stream().id(), object.content(), object.padding(), object.isEndStream(), channelPromise);
            return;
        }
        if (object instanceof Http2HeadersFrame) {
            this.writeHeadersFrame(channelHandlerContext, (Http2HeadersFrame)object, channelPromise);
            return;
        }
        if (object instanceof Http2WindowUpdateFrame) {
            object = (Http2WindowUpdateFrame)object;
            Http2FrameStream http2FrameStream = object.stream();
            try {
                if (http2FrameStream == null) {
                    this.increaseInitialConnectionWindow(object.windowSizeIncrement());
                } else {
                    this.consumeBytes(http2FrameStream.id(), object.windowSizeIncrement());
                }
                channelPromise.setSuccess();
                return;
            }
            catch (Throwable throwable) {
                channelPromise.setFailure(throwable);
                return;
            }
        }
        if (object instanceof Http2ResetFrame) {
            object = (Http2ResetFrame)object;
            int n2 = object.stream().id();
            if (this.connection().streamMayHaveExisted(n2)) {
                this.encoder().writeRstStream(channelHandlerContext, object.stream().id(), object.errorCode(), channelPromise);
                return;
            }
            ReferenceCountUtil.release(object);
            channelPromise.setFailure(Http2Exception.streamError(object.stream().id(), Http2Error.PROTOCOL_ERROR, "Stream never existed", new Object[0]));
            return;
        }
        if (object instanceof Http2PingFrame) {
            object = (Http2PingFrame)object;
            this.encoder().writePing(channelHandlerContext, object.ack(), object.content(), channelPromise);
            return;
        }
        if (object instanceof Http2SettingsFrame) {
            this.encoder().writeSettings(channelHandlerContext, ((Http2SettingsFrame)object).settings(), channelPromise);
            return;
        }
        if (object instanceof Http2SettingsAckFrame) {
            this.encoder().writeSettingsAck(channelHandlerContext, channelPromise);
            return;
        }
        if (object instanceof Http2GoAwayFrame) {
            this.writeGoAwayFrame(channelHandlerContext, (Http2GoAwayFrame)object, channelPromise);
            return;
        }
        if (object instanceof Http2UnknownFrame) {
            object = (Http2UnknownFrame)object;
            this.encoder().writeFrame(channelHandlerContext, object.frameType(), object.stream().id(), object.flags(), object.content(), channelPromise);
            return;
        }
        if (!(object instanceof Http2Frame)) {
            channelHandlerContext.write(object, channelPromise);
            return;
        }
        ReferenceCountUtil.release(object);
        throw new UnsupportedMessageTypeException(object, new Class[0]);
    }

    private void increaseInitialConnectionWindow(int n2) throws Http2Exception {
        this.connection().local().flowController().incrementWindowSize(this.connection().connectionStream(), n2);
    }

    final boolean consumeBytes(int n2, int n3) throws Http2Exception {
        Boolean bl;
        Http2Stream http2Stream = this.connection().stream(n2);
        if (http2Stream != null && n2 == 1 && Boolean.TRUE.equals(bl = (Boolean)http2Stream.getProperty(this.upgradeKey))) {
            return false;
        }
        return this.connection().local().flowController().consumeBytes(http2Stream, n3);
    }

    private void writeGoAwayFrame(ChannelHandlerContext channelHandlerContext, Http2GoAwayFrame http2GoAwayFrame, ChannelPromise channelPromise) {
        if (http2GoAwayFrame.lastStreamId() >= 0) {
            http2GoAwayFrame.release();
            throw new IllegalArgumentException("Last stream id must not be set on GOAWAY frame");
        }
        int n2 = this.connection().remote().lastStreamCreated();
        long l2 = (long)n2 + ((long)http2GoAwayFrame.extraStreamIds() << 1);
        if (l2 > Integer.MAX_VALUE) {
            l2 = Integer.MAX_VALUE;
        }
        this.goAway(channelHandlerContext, (int)l2, http2GoAwayFrame.errorCode(), http2GoAwayFrame.content(), channelPromise);
    }

    private void writeHeadersFrame(ChannelHandlerContext channelHandlerContext, Http2HeadersFrame http2HeadersFrame, ChannelPromise channelPromise) {
        if (Http2CodecUtil.isStreamIdValid(http2HeadersFrame.stream().id())) {
            this.encoder().writeHeaders(channelHandlerContext, http2HeadersFrame.stream().id(), http2HeadersFrame.headers(), http2HeadersFrame.padding(), http2HeadersFrame.isEndStream(), channelPromise);
            return;
        }
        DefaultHttp2FrameStream defaultHttp2FrameStream = (DefaultHttp2FrameStream)http2HeadersFrame.stream();
        Http2Connection http2Connection = this.connection();
        final int n2 = http2Connection.local().incrementAndGetNextStreamId();
        if (n2 < 0) {
            channelPromise.setFailure(new Http2NoMoreStreamIdsException());
            this.onHttp2Frame(channelHandlerContext, new DefaultHttp2GoAwayFrame(http2Connection.isServer() ? Integer.MAX_VALUE : 0x7FFFFFFE, Http2Error.NO_ERROR.code(), ByteBufUtil.writeAscii(channelHandlerContext.alloc(), (CharSequence)"Stream IDs exhausted on local stream creation")));
            return;
        }
        defaultHttp2FrameStream.id = n2;
        defaultHttp2FrameStream = this.frameStreamToInitializeMap.put(n2, defaultHttp2FrameStream);
        assert (defaultHttp2FrameStream == null);
        this.encoder().writeHeaders(channelHandlerContext, n2, http2HeadersFrame.headers(), http2HeadersFrame.padding(), http2HeadersFrame.isEndStream(), channelPromise);
        if (!channelPromise.isDone()) {
            ++this.numBufferedStreams;
            channelPromise.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture channelFuture) {
                    Http2FrameCodec.this.numBufferedStreams--;
                    Http2FrameCodec.this.handleHeaderFuture(channelFuture, n2);
                }
            });
            return;
        }
        this.handleHeaderFuture(channelPromise, n2);
    }

    private void handleHeaderFuture(ChannelFuture channelFuture, int n2) {
        if (!channelFuture.isSuccess()) {
            this.frameStreamToInitializeMap.remove(n2);
        }
    }

    private void onStreamActive0(Http2Stream object) {
        if (object.id() != 1 && this.connection().local().isValidStreamId(object.id())) {
            return;
        }
        object = this.newStream().setStreamAndProperty(this.streamKey, (Http2Stream)object);
        Http2FrameCodec http2FrameCodec = this;
        http2FrameCodec.onHttp2StreamStateChanged(http2FrameCodec.ctx, (DefaultHttp2FrameStream)object);
    }

    protected void onConnectionError(ChannelHandlerContext channelHandlerContext, boolean bl, Throwable throwable, Http2Exception http2Exception) {
        if (!bl) {
            channelHandlerContext.fireExceptionCaught(throwable);
        }
        super.onConnectionError(channelHandlerContext, bl, throwable, http2Exception);
    }

    protected final void onStreamError(ChannelHandlerContext channelHandlerContext, boolean bl, Throwable throwable, Http2Exception.StreamException streamException) {
        int n2 = streamException.streamId();
        Object object = this.connection().stream(n2);
        if (object == null) {
            this.onHttp2UnknownStreamError(channelHandlerContext, throwable, streamException);
            super.onStreamError(channelHandlerContext, bl, throwable, streamException);
            return;
        }
        if ((object = (Http2FrameStream)object.getProperty(this.streamKey)) == null) {
            LOG.warn("Stream exception thrown without stream object attached.", throwable);
            super.onStreamError(channelHandlerContext, bl, throwable, streamException);
            return;
        }
        if (!bl) {
            this.onHttp2FrameStreamException(channelHandlerContext, new Http2FrameStreamException((Http2FrameStream)object, streamException.error(), throwable));
        }
    }

    private void onHttp2UnknownStreamError(ChannelHandlerContext object, Throwable throwable, Http2Exception.StreamException streamException) {
        object = streamException.error() == Http2Error.STREAM_CLOSED ? InternalLogLevel.DEBUG : InternalLogLevel.WARN;
        LOG.log((InternalLogLevel)((Object)object), "Stream exception thrown for unknown stream {}.", (Object)streamException.streamId(), (Object)throwable);
    }

    protected final boolean isGracefulShutdownComplete() {
        return super.isGracefulShutdownComplete() && this.numBufferedStreams == 0;
    }

    private void onUpgradeEvent(ChannelHandlerContext channelHandlerContext, HttpServerUpgradeHandler.UpgradeEvent upgradeEvent) {
        channelHandlerContext.fireUserEventTriggered(upgradeEvent);
    }

    void onHttp2StreamStateChanged(ChannelHandlerContext channelHandlerContext, DefaultHttp2FrameStream defaultHttp2FrameStream) {
        channelHandlerContext.fireUserEventTriggered(defaultHttp2FrameStream.stateChanged);
    }

    void onHttp2Frame(ChannelHandlerContext channelHandlerContext, Http2Frame http2Frame) {
        channelHandlerContext.fireChannelRead(http2Frame);
    }

    void onHttp2FrameStreamException(ChannelHandlerContext channelHandlerContext, Http2FrameStreamException http2FrameStreamException) {
        channelHandlerContext.fireExceptionCaught(http2FrameStreamException);
    }

    static class DefaultHttp2FrameStream
    implements Http2FrameStream {
        private volatile int id = -1;
        volatile Http2Stream stream;
        final Http2FrameStreamEvent stateChanged = Http2FrameStreamEvent.stateChanged(this);
        final Http2FrameStreamEvent writabilityChanged = Http2FrameStreamEvent.writabilityChanged(this);
        Channel attachment;

        DefaultHttp2FrameStream() {
        }

        DefaultHttp2FrameStream setStreamAndProperty(Http2Connection.PropertyKey propertyKey, Http2Stream http2Stream) {
            assert (this.id == -1 || http2Stream.id() == this.id);
            this.stream = http2Stream;
            http2Stream.setProperty(propertyKey, this);
            return this;
        }

        public int id() {
            Http2Stream http2Stream = this.stream;
            if (http2Stream == null) {
                return this.id;
            }
            return http2Stream.id();
        }

        public Http2Stream.State state() {
            Http2Stream http2Stream = this.stream;
            if (http2Stream == null) {
                return Http2Stream.State.IDLE;
            }
            return http2Stream.state();
        }

        public String toString() {
            return String.valueOf(this.id());
        }
    }
}

