/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec.http2;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.ByteBufUtil;
import com.appoptics.ext.io.netty.buffer.Unpooled;
import com.appoptics.ext.io.netty.channel.ChannelFuture;
import com.appoptics.ext.io.netty.channel.ChannelFutureListener;
import com.appoptics.ext.io.netty.channel.ChannelHandlerContext;
import com.appoptics.ext.io.netty.channel.ChannelOutboundHandler;
import com.appoptics.ext.io.netty.channel.ChannelPromise;
import com.appoptics.ext.io.netty.handler.codec.ByteToMessageDecoder;
import com.appoptics.ext.io.netty.handler.codec.http.HttpResponseStatus;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2CodecUtil;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Connection;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2ConnectionDecoder;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2ConnectionEncoder;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2ConnectionPrefaceAndSettingsFrameWrittenEvent;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Error;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Exception;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2FrameWriter;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Headers;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2LifecycleManager;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Settings;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Stream;
import com.appoptics.ext.io.netty.handler.codec.http2.ReadOnlyHttp2Headers;
import com.appoptics.ext.io.netty.util.AsciiString;
import com.appoptics.ext.io.netty.util.CharsetUtil;
import com.appoptics.ext.io.netty.util.concurrent.Future;
import com.appoptics.ext.io.netty.util.concurrent.GenericFutureListener;
import com.appoptics.ext.io.netty.util.concurrent.ScheduledFuture;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Http2ConnectionHandler
extends ByteToMessageDecoder
implements ChannelOutboundHandler,
Http2LifecycleManager {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Http2ConnectionHandler.class);
    private static final Http2Headers HEADERS_TOO_LARGE_HEADERS = ReadOnlyHttp2Headers.serverHeaders(false, HttpResponseStatus.REQUEST_HEADER_FIELDS_TOO_LARGE.codeAsText(), new AsciiString[0]);
    private static final ByteBuf HTTP_1_X_BUF = Unpooled.unreleasableBuffer(Unpooled.wrappedBuffer(new byte[]{72, 84, 84, 80, 47, 49, 46})).asReadOnly();
    private final Http2ConnectionDecoder decoder;
    private final Http2ConnectionEncoder encoder;
    private final Http2Settings initialSettings;
    private final boolean decoupleCloseAndGoAway;
    private ChannelFutureListener closeListener;
    private BaseDecoder byteDecoder;
    private long gracefulShutdownTimeoutMillis;

    protected Http2ConnectionHandler(Http2ConnectionDecoder http2ConnectionDecoder, Http2ConnectionEncoder http2ConnectionEncoder, Http2Settings http2Settings) {
        this(http2ConnectionDecoder, http2ConnectionEncoder, http2Settings, false);
    }

    protected Http2ConnectionHandler(Http2ConnectionDecoder http2ConnectionDecoder, Http2ConnectionEncoder http2ConnectionEncoder, Http2Settings http2Settings, boolean bl) {
        this.initialSettings = ObjectUtil.checkNotNull(http2Settings, "initialSettings");
        this.decoder = ObjectUtil.checkNotNull(http2ConnectionDecoder, "decoder");
        this.encoder = ObjectUtil.checkNotNull(http2ConnectionEncoder, "encoder");
        this.decoupleCloseAndGoAway = bl;
        if (http2ConnectionEncoder.connection() != http2ConnectionDecoder.connection()) {
            throw new IllegalArgumentException("Encoder and Decoder do not share the same connection object");
        }
    }

    public void gracefulShutdownTimeoutMillis(long l2) {
        if (l2 < -1L) {
            throw new IllegalArgumentException("gracefulShutdownTimeoutMillis: " + l2 + " (expected: -1 for indefinite or >= 0)");
        }
        this.gracefulShutdownTimeoutMillis = l2;
    }

    public Http2Connection connection() {
        return this.encoder.connection();
    }

    public Http2ConnectionDecoder decoder() {
        return this.decoder;
    }

    public Http2ConnectionEncoder encoder() {
        return this.encoder;
    }

    private boolean prefaceSent() {
        return this.byteDecoder != null && this.byteDecoder.prefaceSent();
    }

    public void onHttpClientUpgrade() throws Http2Exception {
        if (this.connection().isServer()) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Client-side HTTP upgrade requested for a server", new Object[0]);
        }
        if (!this.prefaceSent()) {
            throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, "HTTP upgrade must occur after preface was sent", new Object[0]);
        }
        if (this.decoder.prefaceReceived()) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "HTTP upgrade must occur before HTTP/2 preface is received", new Object[0]);
        }
        this.connection().local().createStream(1, true);
    }

    @Override
    public void flush(ChannelHandlerContext channelHandlerContext) {
        try {
            this.encoder.flowController().writePendingBytes();
            channelHandlerContext.flush();
            return;
        }
        catch (Http2Exception http2Exception) {
            this.onError(channelHandlerContext, true, http2Exception);
            return;
        }
        catch (Throwable throwable) {
            this.onError(channelHandlerContext, true, Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, throwable, "Error flushing", new Object[0]));
            return;
        }
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.encoder.lifecycleManager(this);
        this.decoder.lifecycleManager(this);
        this.encoder.flowController().channelHandlerContext(channelHandlerContext);
        this.decoder.flowController().channelHandlerContext(channelHandlerContext);
        this.byteDecoder = new PrefaceDecoder(channelHandlerContext);
    }

    @Override
    protected void handlerRemoved0(ChannelHandlerContext channelHandlerContext) throws Exception {
        if (this.byteDecoder != null) {
            this.byteDecoder.handlerRemoved(channelHandlerContext);
            this.byteDecoder = null;
        }
    }

    @Override
    public void channelActive(ChannelHandlerContext channelHandlerContext) throws Exception {
        if (this.byteDecoder == null) {
            this.byteDecoder = new PrefaceDecoder(channelHandlerContext);
        }
        this.byteDecoder.channelActive(channelHandlerContext);
        super.channelActive(channelHandlerContext);
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
        super.channelInactive(channelHandlerContext);
        if (this.byteDecoder != null) {
            this.byteDecoder.channelInactive(channelHandlerContext);
            this.byteDecoder = null;
        }
    }

    @Override
    public void channelWritabilityChanged(ChannelHandlerContext channelHandlerContext) throws Exception {
        try {
            if (channelHandlerContext.channel().isWritable()) {
                this.flush(channelHandlerContext);
            }
            this.encoder.flowController().channelWritabilityChanged();
            return;
        }
        finally {
            super.channelWritabilityChanged(channelHandlerContext);
        }
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
        this.byteDecoder.decode(channelHandlerContext, byteBuf, list);
    }

    @Override
    public void connect(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) throws Exception {
        channelHandlerContext.connect(socketAddress, socketAddress2, channelPromise);
    }

    @Override
    public void disconnect(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) throws Exception {
        channelHandlerContext.disconnect(channelPromise);
    }

    @Override
    public void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) throws Exception {
        if (this.decoupleCloseAndGoAway) {
            channelHandlerContext.close(channelPromise);
            return;
        }
        channelPromise = channelPromise.unvoid();
        if (!channelHandlerContext.channel().isActive()) {
            channelHandlerContext.close(channelPromise);
            return;
        }
        ChannelFuture channelFuture = this.connection().goAwaySent() ? channelHandlerContext.write(Unpooled.EMPTY_BUFFER) : this.goAway(channelHandlerContext, null, channelHandlerContext.newPromise());
        channelHandlerContext.flush();
        this.doGracefulShutdown(channelHandlerContext, channelFuture, channelPromise);
    }

    private ChannelFutureListener newClosingChannelFutureListener(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        long l2 = this.gracefulShutdownTimeoutMillis;
        if (l2 < 0L) {
            return new ClosingChannelFutureListener(channelHandlerContext, channelPromise);
        }
        return new ClosingChannelFutureListener(channelHandlerContext, channelPromise, l2, TimeUnit.MILLISECONDS);
    }

    private void doGracefulShutdown(ChannelHandlerContext object, ChannelFuture object2, ChannelPromise channelPromise) {
        object = this.newClosingChannelFutureListener((ChannelHandlerContext)object, channelPromise);
        if (this.isGracefulShutdownComplete()) {
            object2.addListener((GenericFutureListener<? extends Future<? super Void>>)object);
            return;
        }
        if (this.closeListener == null) {
            this.closeListener = object;
            return;
        }
        if (channelPromise != null) {
            object2 = this.closeListener;
            this.closeListener = new ChannelFutureListener((ChannelFutureListener)object2, (ChannelFutureListener)object){
                final /* synthetic */ ChannelFutureListener val$oldCloseListener;
                final /* synthetic */ ChannelFutureListener val$listener;
                {
                    this.val$oldCloseListener = channelFutureListener;
                    this.val$listener = channelFutureListener2;
                }

                public void operationComplete(ChannelFuture channelFuture) throws Exception {
                    try {
                        this.val$oldCloseListener.operationComplete(channelFuture);
                        return;
                    }
                    finally {
                        this.val$listener.operationComplete(channelFuture);
                    }
                }
            };
        }
    }

    @Override
    public void read(ChannelHandlerContext channelHandlerContext) throws Exception {
        channelHandlerContext.read();
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) throws Exception {
        channelHandlerContext.write(object, channelPromise);
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) throws Exception {
        try {
            this.channelReadComplete0(channelHandlerContext);
            return;
        }
        finally {
            this.flush(channelHandlerContext);
        }
    }

    final void channelReadComplete0(ChannelHandlerContext channelHandlerContext) {
        this.discardSomeReadBytes();
        if (!channelHandlerContext.channel().config().isAutoRead()) {
            channelHandlerContext.read();
        }
        channelHandlerContext.fireChannelReadComplete();
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) throws Exception {
        if (Http2CodecUtil.getEmbeddedHttp2Exception(throwable) != null) {
            this.onError(channelHandlerContext, false, throwable);
            return;
        }
        super.exceptionCaught(channelHandlerContext, throwable);
    }

    @Override
    public void closeStreamLocal(Http2Stream http2Stream, ChannelFuture channelFuture) {
        switch (http2Stream.state()) {
            case HALF_CLOSED_LOCAL: 
            case OPEN: {
                http2Stream.closeLocalSide();
                return;
            }
        }
        this.closeStream(http2Stream, channelFuture);
    }

    @Override
    public void closeStreamRemote(Http2Stream http2Stream, ChannelFuture channelFuture) {
        switch (http2Stream.state()) {
            case OPEN: 
            case HALF_CLOSED_REMOTE: {
                http2Stream.closeRemoteSide();
                return;
            }
        }
        this.closeStream(http2Stream, channelFuture);
    }

    @Override
    public void closeStream(Http2Stream http2Stream, ChannelFuture channelFuture) {
        http2Stream.close();
        if (channelFuture.isDone()) {
            this.checkCloseConnection(channelFuture);
            return;
        }
        channelFuture.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture channelFuture) throws Exception {
                Http2ConnectionHandler.this.checkCloseConnection(channelFuture);
            }
        });
    }

    @Override
    public void onError(ChannelHandlerContext channelHandlerContext, boolean bl, Throwable throwable) {
        Object object = Http2CodecUtil.getEmbeddedHttp2Exception(throwable);
        if (Http2Exception.isStreamError((Http2Exception)object)) {
            this.onStreamError(channelHandlerContext, bl, throwable, (Http2Exception.StreamException)object);
        } else if (object instanceof Http2Exception.CompositeStreamException) {
            object = (Http2Exception.CompositeStreamException)object;
            object = ((Http2Exception.CompositeStreamException)object).iterator();
            while (object.hasNext()) {
                Http2Exception.StreamException streamException = (Http2Exception.StreamException)object.next();
                this.onStreamError(channelHandlerContext, bl, throwable, streamException);
            }
        } else {
            this.onConnectionError(channelHandlerContext, bl, throwable, (Http2Exception)object);
        }
        channelHandlerContext.flush();
    }

    protected boolean isGracefulShutdownComplete() {
        return this.connection().numActiveStreams() == 0;
    }

    protected void onConnectionError(ChannelHandlerContext channelHandlerContext, boolean bl, Throwable object, Http2Exception http2Exception) {
        if (http2Exception == null) {
            http2Exception = new Http2Exception(Http2Error.INTERNAL_ERROR, ((Throwable)object).getMessage(), (Throwable)object);
        }
        ChannelPromise channelPromise = channelHandlerContext.newPromise();
        object = this.goAway(channelHandlerContext, http2Exception, channelHandlerContext.newPromise());
        if (http2Exception.shutdownHint() == Http2Exception.ShutdownHint.GRACEFUL_SHUTDOWN) {
            this.doGracefulShutdown(channelHandlerContext, (ChannelFuture)object, channelPromise);
            return;
        }
        object.addListener(this.newClosingChannelFutureListener(channelHandlerContext, channelPromise));
    }

    protected void onStreamError(ChannelHandlerContext channelHandlerContext, boolean bl, Throwable throwable, Http2Exception.StreamException streamException) {
        int n2 = streamException.streamId();
        Http2Stream http2Stream = this.connection().stream(n2);
        if (streamException instanceof Http2Exception.HeaderListSizeException && ((Http2Exception.HeaderListSizeException)streamException).duringDecode() && this.connection().isServer()) {
            if (http2Stream == null) {
                try {
                    http2Stream = this.encoder.connection().remote().createStream(n2, true);
                }
                catch (Http2Exception http2Exception) {
                    this.resetUnknownStream(channelHandlerContext, n2, streamException.error().code(), channelHandlerContext.newPromise());
                    return;
                }
            }
            if (http2Stream != null && !http2Stream.isHeadersSent()) {
                try {
                    this.handleServerHeaderDecodeSizeError(channelHandlerContext, http2Stream);
                }
                catch (Throwable throwable2) {
                    this.onError(channelHandlerContext, bl, Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, throwable2, "Error DecodeSizeError", new Object[0]));
                }
            }
        }
        if (http2Stream == null) {
            if (!bl || this.connection().local().mayHaveCreatedStream(n2)) {
                this.resetUnknownStream(channelHandlerContext, n2, streamException.error().code(), channelHandlerContext.newPromise());
                return;
            }
        } else {
            this.resetStream(channelHandlerContext, http2Stream, streamException.error().code(), channelHandlerContext.newPromise());
        }
    }

    protected void handleServerHeaderDecodeSizeError(ChannelHandlerContext channelHandlerContext, Http2Stream http2Stream) {
        this.encoder().writeHeaders(channelHandlerContext, http2Stream.id(), HEADERS_TOO_LARGE_HEADERS, 0, true, channelHandlerContext.newPromise());
    }

    protected Http2FrameWriter frameWriter() {
        return this.encoder().frameWriter();
    }

    private ChannelFuture resetUnknownStream(final ChannelHandlerContext channelHandlerContext, int n2, long l2, ChannelPromise channelPromise) {
        ChannelFuture channelFuture = this.frameWriter().writeRstStream(channelHandlerContext, n2, l2, channelPromise);
        if (channelFuture.isDone()) {
            this.closeConnectionOnError(channelHandlerContext, channelFuture);
        } else {
            channelFuture.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture channelFuture) throws Exception {
                    Http2ConnectionHandler.this.closeConnectionOnError(channelHandlerContext, channelFuture);
                }
            });
        }
        return channelFuture;
    }

    @Override
    public ChannelFuture resetStream(ChannelHandlerContext channelHandlerContext, int n2, long l2, ChannelPromise channelPromise) {
        Http2Stream http2Stream = this.connection().stream(n2);
        if (http2Stream == null) {
            return this.resetUnknownStream(channelHandlerContext, n2, l2, channelPromise.unvoid());
        }
        return this.resetStream(channelHandlerContext, http2Stream, l2, channelPromise);
    }

    private ChannelFuture resetStream(final ChannelHandlerContext channelHandlerContext, final Http2Stream http2Stream, long l2, ChannelPromise channelPromise) {
        channelPromise = channelPromise.unvoid();
        if (http2Stream.isResetSent()) {
            return channelPromise.setSuccess();
        }
        http2Stream.resetSent();
        ChannelFuture channelFuture = http2Stream.state() == Http2Stream.State.IDLE || this.connection().local().created(http2Stream) && !http2Stream.isHeadersSent() && !http2Stream.isPushPromiseSent() ? channelPromise.setSuccess() : this.frameWriter().writeRstStream(channelHandlerContext, http2Stream.id(), l2, channelPromise);
        if (channelFuture.isDone()) {
            this.processRstStreamWriteResult(channelHandlerContext, http2Stream, channelFuture);
        } else {
            channelFuture.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture channelFuture) throws Exception {
                    Http2ConnectionHandler.this.processRstStreamWriteResult(channelHandlerContext, http2Stream, channelFuture);
                }
            });
        }
        return channelFuture;
    }

    @Override
    public ChannelFuture goAway(final ChannelHandlerContext channelHandlerContext, final int n2, final long l2, final ByteBuf byteBuf, ChannelPromise channelPromise) {
        channelPromise = channelPromise.unvoid();
        Object object = this.connection();
        try {
            if (!object.goAwaySent(n2, l2, byteBuf)) {
                byteBuf.release();
                channelPromise.trySuccess();
                return channelPromise;
            }
        }
        catch (Throwable throwable) {
            byteBuf.release();
            channelPromise.tryFailure(throwable);
            return channelPromise;
        }
        byteBuf.retain();
        object = this.frameWriter().writeGoAway(channelHandlerContext, n2, l2, byteBuf, channelPromise);
        if (object.isDone()) {
            Http2ConnectionHandler.processGoAwayWriteResult(channelHandlerContext, n2, l2, byteBuf, (ChannelFuture)object);
        } else {
            object.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture channelFuture) throws Exception {
                    Http2ConnectionHandler.processGoAwayWriteResult(channelHandlerContext, n2, l2, byteBuf, channelFuture);
                }
            });
        }
        return object;
    }

    private void checkCloseConnection(ChannelFuture channelFuture) {
        if (this.closeListener != null && this.isGracefulShutdownComplete()) {
            ChannelFutureListener channelFutureListener = this.closeListener;
            this.closeListener = null;
            try {
                channelFutureListener.operationComplete(channelFuture);
                return;
            }
            catch (Exception exception) {
                throw new IllegalStateException("Close listener threw an unexpected exception", exception);
            }
        }
    }

    private ChannelFuture goAway(ChannelHandlerContext channelHandlerContext, Http2Exception http2Exception, ChannelPromise channelPromise) {
        long l2 = http2Exception != null ? http2Exception.error().code() : Http2Error.NO_ERROR.code();
        int n2 = this.connection().remote().lastStreamCreated();
        return this.goAway(channelHandlerContext, n2, l2, Http2CodecUtil.toByteBuf(channelHandlerContext, http2Exception), channelPromise);
    }

    private void processRstStreamWriteResult(ChannelHandlerContext channelHandlerContext, Http2Stream http2Stream, ChannelFuture channelFuture) {
        if (channelFuture.isSuccess()) {
            this.closeStream(http2Stream, channelFuture);
            return;
        }
        this.onConnectionError(channelHandlerContext, true, channelFuture.cause(), null);
    }

    private void closeConnectionOnError(ChannelHandlerContext channelHandlerContext, ChannelFuture channelFuture) {
        if (!channelFuture.isSuccess()) {
            this.onConnectionError(channelHandlerContext, true, channelFuture.cause(), null);
        }
    }

    private static ByteBuf clientPrefaceString(Http2Connection http2Connection) {
        if (http2Connection.isServer()) {
            return Http2CodecUtil.connectionPrefaceBuf();
        }
        return null;
    }

    private static void processGoAwayWriteResult(ChannelHandlerContext channelHandlerContext, int n2, long l2, ByteBuf byteBuf, ChannelFuture channelFuture) {
        try {
            if (channelFuture.isSuccess()) {
                if (l2 != Http2Error.NO_ERROR.code()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("{} Sent GOAWAY: lastStreamId '{}', errorCode '{}', debugData '{}'. Forcing shutdown of the connection.", channelHandlerContext.channel(), n2, l2, byteBuf.toString(CharsetUtil.UTF_8), channelFuture.cause());
                    }
                    channelHandlerContext.close();
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("{} Sending GOAWAY failed: lastStreamId '{}', errorCode '{}', debugData '{}'. Forcing shutdown of the connection.", channelHandlerContext.channel(), n2, l2, byteBuf.toString(CharsetUtil.UTF_8), channelFuture.cause());
                }
                channelHandlerContext.close();
            }
            return;
        }
        finally {
            byteBuf.release();
        }
    }

    private static final class ClosingChannelFutureListener
    implements ChannelFutureListener {
        private final ChannelHandlerContext ctx;
        private final ChannelPromise promise;
        private final ScheduledFuture<?> timeoutTask;
        private boolean closed;

        ClosingChannelFutureListener(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
            this.ctx = channelHandlerContext;
            this.promise = channelPromise;
            this.timeoutTask = null;
        }

        ClosingChannelFutureListener(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise, long l2, TimeUnit timeUnit) {
            this.ctx = channelHandlerContext;
            this.promise = channelPromise;
            this.timeoutTask = channelHandlerContext.executor().schedule(new Runnable(){

                public void run() {
                    ClosingChannelFutureListener.this.doClose();
                }
            }, l2, timeUnit);
        }

        public final void operationComplete(ChannelFuture channelFuture) {
            if (this.timeoutTask != null) {
                this.timeoutTask.cancel(false);
            }
            this.doClose();
        }

        private void doClose() {
            if (this.closed) {
                assert (this.timeoutTask != null);
                return;
            }
            this.closed = true;
            if (this.promise == null) {
                this.ctx.close();
                return;
            }
            this.ctx.close(this.promise);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class FrameDecoder
    extends BaseDecoder {
        private FrameDecoder() {
        }

        @Override
        public final void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
            try {
                Http2ConnectionHandler.this.decoder.decodeFrame(channelHandlerContext, byteBuf, list);
                return;
            }
            catch (Throwable throwable) {
                Http2ConnectionHandler.this.onError(channelHandlerContext, false, throwable);
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class PrefaceDecoder
    extends BaseDecoder {
        private ByteBuf clientPrefaceString;
        private boolean prefaceSent;

        PrefaceDecoder(ChannelHandlerContext channelHandlerContext) throws Exception {
            this.clientPrefaceString = Http2ConnectionHandler.clientPrefaceString(Http2ConnectionHandler.this.encoder.connection());
            this.sendPreface(channelHandlerContext);
        }

        @Override
        public final boolean prefaceSent() {
            return this.prefaceSent;
        }

        @Override
        public final void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
            try {
                if (channelHandlerContext.channel().isActive() && this.readClientPrefaceString(byteBuf) && this.verifyFirstFrameIsSettings(byteBuf)) {
                    Http2ConnectionHandler.this.byteDecoder = new FrameDecoder();
                    Http2ConnectionHandler.this.byteDecoder.decode(channelHandlerContext, byteBuf, list);
                }
                return;
            }
            catch (Throwable throwable) {
                Http2ConnectionHandler.this.onError(channelHandlerContext, false, throwable);
                return;
            }
        }

        @Override
        public final void channelActive(ChannelHandlerContext channelHandlerContext) throws Exception {
            this.sendPreface(channelHandlerContext);
        }

        @Override
        public final void channelInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
            this.cleanup();
            super.channelInactive(channelHandlerContext);
        }

        @Override
        public final void handlerRemoved(ChannelHandlerContext channelHandlerContext) throws Exception {
            this.cleanup();
        }

        private void cleanup() {
            if (this.clientPrefaceString != null) {
                this.clientPrefaceString.release();
                this.clientPrefaceString = null;
            }
        }

        private boolean readClientPrefaceString(ByteBuf object) throws Http2Exception {
            int n2;
            block7: {
                block6: {
                    if (this.clientPrefaceString == null) {
                        return true;
                    }
                    n2 = this.clientPrefaceString.readableBytes();
                    n2 = Math.min(((ByteBuf)object).readableBytes(), n2);
                    if (n2 == 0) break block6;
                    ByteBuf byteBuf = object;
                    if (ByteBufUtil.equals(byteBuf, byteBuf.readerIndex(), this.clientPrefaceString, this.clientPrefaceString.readerIndex(), n2)) break block7;
                }
                ByteBuf byteBuf = object;
                n2 = ByteBufUtil.indexOf(HTTP_1_X_BUF, byteBuf.slice(byteBuf.readerIndex(), Math.min(((ByteBuf)object).readableBytes(), 1024)));
                if (n2 != -1) {
                    ByteBuf byteBuf2 = object;
                    object = byteBuf2.toString(byteBuf2.readerIndex(), n2 - ((ByteBuf)object).readerIndex(), CharsetUtil.US_ASCII);
                    throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Unexpected HTTP/1.x request: %s", object);
                }
                ByteBuf byteBuf3 = object;
                object = ByteBufUtil.hexDump(byteBuf3, byteBuf3.readerIndex(), Math.min(((ByteBuf)object).readableBytes(), this.clientPrefaceString.readableBytes()));
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "HTTP/2 client preface string missing or corrupt. Hex dump for received bytes: %s", object);
            }
            ((ByteBuf)object).skipBytes(n2);
            this.clientPrefaceString.skipBytes(n2);
            if (!this.clientPrefaceString.isReadable()) {
                this.clientPrefaceString.release();
                this.clientPrefaceString = null;
                return true;
            }
            return false;
        }

        private boolean verifyFirstFrameIsSettings(ByteBuf byteBuf) throws Http2Exception {
            if (byteBuf.readableBytes() < 5) {
                return false;
            }
            ByteBuf byteBuf2 = byteBuf;
            short s2 = byteBuf2.getUnsignedByte(byteBuf2.readerIndex() + 3);
            ByteBuf byteBuf3 = byteBuf;
            short s3 = byteBuf3.getUnsignedByte(byteBuf3.readerIndex() + 4);
            if (s2 != 4 || (s3 & 1) != 0) {
                Object[] objectArray = new Object[1];
                ByteBuf byteBuf4 = byteBuf;
                objectArray[0] = ByteBufUtil.hexDump(byteBuf4, byteBuf4.readerIndex(), 5);
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "First received frame was not SETTINGS. Hex dump for first 5 bytes: %s", objectArray);
            }
            return true;
        }

        private void sendPreface(ChannelHandlerContext channelHandlerContext) throws Exception {
            if (this.prefaceSent || !channelHandlerContext.channel().isActive()) {
                return;
            }
            this.prefaceSent = true;
            boolean bl = !Http2ConnectionHandler.this.connection().isServer();
            if (bl) {
                channelHandlerContext.write(Http2CodecUtil.connectionPrefaceBuf()).addListener(ChannelFutureListener.CLOSE_ON_FAILURE);
            }
            Http2ConnectionHandler.this.encoder.writeSettings(channelHandlerContext, Http2ConnectionHandler.this.initialSettings, channelHandlerContext.newPromise()).addListener(ChannelFutureListener.CLOSE_ON_FAILURE);
            if (bl) {
                Http2ConnectionHandler.this.userEventTriggered(channelHandlerContext, Http2ConnectionPrefaceAndSettingsFrameWrittenEvent.INSTANCE);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class BaseDecoder {
        private BaseDecoder() {
        }

        public abstract void decode(ChannelHandlerContext var1, ByteBuf var2, List<Object> var3) throws Exception;

        public void handlerRemoved(ChannelHandlerContext channelHandlerContext) throws Exception {
        }

        public void channelActive(ChannelHandlerContext channelHandlerContext) throws Exception {
        }

        public void channelInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
            Http2ConnectionHandler.this.encoder().close();
            Http2ConnectionHandler.this.decoder().close();
            Http2ConnectionHandler.this.connection().close(channelHandlerContext.voidPromise());
        }

        public boolean prefaceSent() {
            return true;
        }
    }
}

