/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec.http2;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.ByteBufAllocator;
import com.appoptics.ext.io.netty.channel.ChannelHandlerContext;
import com.appoptics.ext.io.netty.handler.codec.http2.DefaultHttp2HeadersDecoder;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2CodecUtil;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Error;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Exception;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Flags;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2FrameListener;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2FrameReader;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2FrameSizePolicy;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Headers;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2HeadersDecoder;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Settings;
import com.appoptics.ext.io.netty.util.internal.PlatformDependent;

public class DefaultHttp2FrameReader
implements Http2FrameReader,
Http2FrameReader.Configuration,
Http2FrameSizePolicy {
    private final Http2HeadersDecoder headersDecoder;
    private boolean readingHeaders = true;
    private boolean readError;
    private byte frameType;
    private int streamId;
    private Http2Flags flags;
    private int payloadLength;
    private HeadersContinuation headersContinuation;
    private int maxFrameSize;

    public DefaultHttp2FrameReader() {
        this(true);
    }

    public DefaultHttp2FrameReader(boolean bl) {
        this(new DefaultHttp2HeadersDecoder(bl));
    }

    public DefaultHttp2FrameReader(Http2HeadersDecoder http2HeadersDecoder) {
        this.headersDecoder = http2HeadersDecoder;
        this.maxFrameSize = 16384;
    }

    public Http2HeadersDecoder.Configuration headersConfiguration() {
        return this.headersDecoder.configuration();
    }

    public Http2FrameReader.Configuration configuration() {
        return this;
    }

    public Http2FrameSizePolicy frameSizePolicy() {
        return this;
    }

    public void maxFrameSize(int n2) throws Http2Exception {
        if (!Http2CodecUtil.isMaxFrameSizeValid(n2)) {
            throw Http2Exception.streamError(this.streamId, Http2Error.FRAME_SIZE_ERROR, "Invalid MAX_FRAME_SIZE specified in sent settings: %d", n2);
        }
        this.maxFrameSize = n2;
    }

    public int maxFrameSize() {
        return this.maxFrameSize;
    }

    public void close() {
        this.closeHeadersContinuation();
    }

    private void closeHeadersContinuation() {
        if (this.headersContinuation != null) {
            this.headersContinuation.close();
            this.headersContinuation = null;
        }
    }

    public void readFrame(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, Http2FrameListener http2FrameListener) throws Http2Exception {
        if (this.readError) {
            ByteBuf byteBuf2 = byteBuf;
            byteBuf2.skipBytes(byteBuf2.readableBytes());
            return;
        }
        try {
            do {
                if (this.readingHeaders) {
                    this.processHeaderState(byteBuf);
                    if (this.readingHeaders) {
                        return;
                    }
                }
                this.processPayloadState(channelHandlerContext, byteBuf, http2FrameListener);
                if (this.readingHeaders) continue;
                return;
            } while (byteBuf.isReadable());
            return;
        }
        catch (Http2Exception http2Exception) {
            this.readError = !Http2Exception.isStreamError(http2Exception);
            throw http2Exception;
        }
        catch (RuntimeException runtimeException) {
            this.readError = true;
            throw runtimeException;
        }
        catch (Throwable throwable) {
            this.readError = true;
            PlatformDependent.throwException(throwable);
            return;
        }
    }

    private void processHeaderState(ByteBuf byteBuf) throws Http2Exception {
        if (byteBuf.readableBytes() < 9) {
            return;
        }
        this.payloadLength = byteBuf.readUnsignedMedium();
        if (this.payloadLength > this.maxFrameSize) {
            throw Http2Exception.connectionError(Http2Error.FRAME_SIZE_ERROR, "Frame length: %d exceeds maximum: %d", this.payloadLength, this.maxFrameSize);
        }
        this.frameType = byteBuf.readByte();
        this.flags = new Http2Flags(byteBuf.readUnsignedByte());
        this.streamId = Http2CodecUtil.readUnsignedInt(byteBuf);
        this.readingHeaders = false;
        switch (this.frameType) {
            case 0: {
                this.verifyDataFrame();
                return;
            }
            case 1: {
                this.verifyHeadersFrame();
                return;
            }
            case 2: {
                this.verifyPriorityFrame();
                return;
            }
            case 3: {
                this.verifyRstStreamFrame();
                return;
            }
            case 4: {
                this.verifySettingsFrame();
                return;
            }
            case 5: {
                this.verifyPushPromiseFrame();
                return;
            }
            case 6: {
                this.verifyPingFrame();
                return;
            }
            case 7: {
                this.verifyGoAwayFrame();
                return;
            }
            case 8: {
                this.verifyWindowUpdateFrame();
                return;
            }
            case 9: {
                this.verifyContinuationFrame();
                return;
            }
        }
        this.verifyUnknownFrame();
    }

    private void processPayloadState(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, Http2FrameListener http2FrameListener) throws Http2Exception {
        if (byteBuf.readableBytes() < this.payloadLength) {
            return;
        }
        int n2 = byteBuf.readerIndex() + this.payloadLength;
        this.readingHeaders = true;
        switch (this.frameType) {
            case 0: {
                this.readDataFrame(channelHandlerContext, byteBuf, n2, http2FrameListener);
                break;
            }
            case 1: {
                this.readHeadersFrame(channelHandlerContext, byteBuf, n2, http2FrameListener);
                break;
            }
            case 2: {
                this.readPriorityFrame(channelHandlerContext, byteBuf, http2FrameListener);
                break;
            }
            case 3: {
                this.readRstStreamFrame(channelHandlerContext, byteBuf, http2FrameListener);
                break;
            }
            case 4: {
                this.readSettingsFrame(channelHandlerContext, byteBuf, http2FrameListener);
                break;
            }
            case 5: {
                this.readPushPromiseFrame(channelHandlerContext, byteBuf, n2, http2FrameListener);
                break;
            }
            case 6: {
                this.readPingFrame(channelHandlerContext, byteBuf.readLong(), http2FrameListener);
                break;
            }
            case 7: {
                DefaultHttp2FrameReader.readGoAwayFrame(channelHandlerContext, byteBuf, n2, http2FrameListener);
                break;
            }
            case 8: {
                this.readWindowUpdateFrame(channelHandlerContext, byteBuf, http2FrameListener);
                break;
            }
            case 9: {
                this.readContinuationFrame(byteBuf, n2, http2FrameListener);
                break;
            }
            default: {
                this.readUnknownFrame(channelHandlerContext, byteBuf, n2, http2FrameListener);
            }
        }
        byteBuf.readerIndex(n2);
    }

    private void verifyDataFrame() throws Http2Exception {
        this.verifyAssociatedWithAStream();
        this.verifyNotProcessingHeaders();
        DefaultHttp2FrameReader defaultHttp2FrameReader = this;
        defaultHttp2FrameReader.verifyPayloadLength(defaultHttp2FrameReader.payloadLength);
        if (this.payloadLength < this.flags.getPaddingPresenceFieldLength()) {
            throw Http2Exception.streamError(this.streamId, Http2Error.FRAME_SIZE_ERROR, "Frame length %d too small.", this.payloadLength);
        }
    }

    private void verifyHeadersFrame() throws Http2Exception {
        this.verifyAssociatedWithAStream();
        this.verifyNotProcessingHeaders();
        DefaultHttp2FrameReader defaultHttp2FrameReader = this;
        defaultHttp2FrameReader.verifyPayloadLength(defaultHttp2FrameReader.payloadLength);
        int n2 = this.flags.getPaddingPresenceFieldLength() + this.flags.getNumPriorityBytes();
        if (this.payloadLength < n2) {
            throw Http2Exception.streamError(this.streamId, Http2Error.FRAME_SIZE_ERROR, "Frame length too small." + this.payloadLength, new Object[0]);
        }
    }

    private void verifyPriorityFrame() throws Http2Exception {
        this.verifyAssociatedWithAStream();
        this.verifyNotProcessingHeaders();
        if (this.payloadLength != 5) {
            throw Http2Exception.streamError(this.streamId, Http2Error.FRAME_SIZE_ERROR, "Invalid frame length %d.", this.payloadLength);
        }
    }

    private void verifyRstStreamFrame() throws Http2Exception {
        this.verifyAssociatedWithAStream();
        this.verifyNotProcessingHeaders();
        if (this.payloadLength != 4) {
            throw Http2Exception.connectionError(Http2Error.FRAME_SIZE_ERROR, "Invalid frame length %d.", this.payloadLength);
        }
    }

    private void verifySettingsFrame() throws Http2Exception {
        this.verifyNotProcessingHeaders();
        DefaultHttp2FrameReader defaultHttp2FrameReader = this;
        defaultHttp2FrameReader.verifyPayloadLength(defaultHttp2FrameReader.payloadLength);
        if (this.streamId != 0) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "A stream ID must be zero.", new Object[0]);
        }
        if (this.flags.ack() && this.payloadLength > 0) {
            throw Http2Exception.connectionError(Http2Error.FRAME_SIZE_ERROR, "Ack settings frame must have an empty payload.", new Object[0]);
        }
        if (this.payloadLength % 6 > 0) {
            throw Http2Exception.connectionError(Http2Error.FRAME_SIZE_ERROR, "Frame length %d invalid.", this.payloadLength);
        }
    }

    private void verifyPushPromiseFrame() throws Http2Exception {
        this.verifyNotProcessingHeaders();
        DefaultHttp2FrameReader defaultHttp2FrameReader = this;
        defaultHttp2FrameReader.verifyPayloadLength(defaultHttp2FrameReader.payloadLength);
        int n2 = this.flags.getPaddingPresenceFieldLength() + 4;
        if (this.payloadLength < n2) {
            throw Http2Exception.streamError(this.streamId, Http2Error.FRAME_SIZE_ERROR, "Frame length %d too small.", this.payloadLength);
        }
    }

    private void verifyPingFrame() throws Http2Exception {
        this.verifyNotProcessingHeaders();
        if (this.streamId != 0) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "A stream ID must be zero.", new Object[0]);
        }
        if (this.payloadLength != 8) {
            throw Http2Exception.connectionError(Http2Error.FRAME_SIZE_ERROR, "Frame length %d incorrect size for ping.", this.payloadLength);
        }
    }

    private void verifyGoAwayFrame() throws Http2Exception {
        this.verifyNotProcessingHeaders();
        DefaultHttp2FrameReader defaultHttp2FrameReader = this;
        defaultHttp2FrameReader.verifyPayloadLength(defaultHttp2FrameReader.payloadLength);
        if (this.streamId != 0) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "A stream ID must be zero.", new Object[0]);
        }
        if (this.payloadLength < 8) {
            throw Http2Exception.connectionError(Http2Error.FRAME_SIZE_ERROR, "Frame length %d too small.", this.payloadLength);
        }
    }

    private void verifyWindowUpdateFrame() throws Http2Exception {
        this.verifyNotProcessingHeaders();
        DefaultHttp2FrameReader.verifyStreamOrConnectionId(this.streamId, "Stream ID");
        if (this.payloadLength != 4) {
            throw Http2Exception.connectionError(Http2Error.FRAME_SIZE_ERROR, "Invalid frame length %d.", this.payloadLength);
        }
    }

    private void verifyContinuationFrame() throws Http2Exception {
        this.verifyAssociatedWithAStream();
        DefaultHttp2FrameReader defaultHttp2FrameReader = this;
        defaultHttp2FrameReader.verifyPayloadLength(defaultHttp2FrameReader.payloadLength);
        if (this.headersContinuation == null) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Received %s frame but not currently processing headers.", this.frameType);
        }
        if (this.streamId != this.headersContinuation.getStreamId()) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Continuation stream ID does not match pending headers. Expected %d, but received %d.", this.headersContinuation.getStreamId(), this.streamId);
        }
        if (this.payloadLength < this.flags.getPaddingPresenceFieldLength()) {
            throw Http2Exception.streamError(this.streamId, Http2Error.FRAME_SIZE_ERROR, "Frame length %d too small for padding.", this.payloadLength);
        }
    }

    private void verifyUnknownFrame() throws Http2Exception {
        this.verifyNotProcessingHeaders();
    }

    private void readDataFrame(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, int n2, Http2FrameListener http2FrameListener) throws Http2Exception {
        int n3 = this.readPadding(byteBuf);
        this.verifyPadding(n3);
        n2 = DefaultHttp2FrameReader.lengthWithoutTrailingPadding(n2 - byteBuf.readerIndex(), n3);
        byteBuf = byteBuf.readSlice(n2);
        http2FrameListener.onDataRead(channelHandlerContext, this.streamId, byteBuf, n3, this.flags.endOfStream());
    }

    private void readHeadersFrame(final ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, int n2, Http2FrameListener http2FrameListener) throws Http2Exception {
        final int n3 = this.streamId;
        final Http2Flags http2Flags = this.flags;
        final int n4 = this.readPadding(byteBuf);
        this.verifyPadding(n4);
        if (this.flags.priorityPresent()) {
            long l2 = byteBuf.readUnsignedInt();
            final boolean bl = (l2 & 0x80000000L) != 0L;
            final int n5 = (int)(l2 & Integer.MAX_VALUE);
            if (n5 == this.streamId) {
                throw Http2Exception.streamError(this.streamId, Http2Error.PROTOCOL_ERROR, "A stream cannot depend on itself.", new Object[0]);
            }
            final short s2 = (short)(byteBuf.readUnsignedByte() + 1);
            n2 = DefaultHttp2FrameReader.lengthWithoutTrailingPadding(n2 - byteBuf.readerIndex(), n4);
            this.headersContinuation = new HeadersContinuation(){

                public int getStreamId() {
                    return n3;
                }

                public void processFragment(boolean bl2, ByteBuf byteBuf, int n2, Http2FrameListener http2FrameListener) throws Http2Exception {
                    HeadersBlockBuilder headersBlockBuilder = this.headersBlockBuilder();
                    headersBlockBuilder.addFragment(byteBuf, n2, channelHandlerContext.alloc(), bl2);
                    if (bl2) {
                        http2FrameListener.onHeadersRead(channelHandlerContext, n3, headersBlockBuilder.headers(), n5, s2, bl, n4, http2Flags.endOfStream());
                    }
                }
            };
            this.headersContinuation.processFragment(this.flags.endOfHeaders(), byteBuf, n2, http2FrameListener);
            DefaultHttp2FrameReader defaultHttp2FrameReader = this;
            defaultHttp2FrameReader.resetHeadersContinuationIfEnd(defaultHttp2FrameReader.flags.endOfHeaders());
            return;
        }
        this.headersContinuation = new HeadersContinuation(){

            public int getStreamId() {
                return n3;
            }

            public void processFragment(boolean bl, ByteBuf byteBuf, int n2, Http2FrameListener http2FrameListener) throws Http2Exception {
                HeadersBlockBuilder headersBlockBuilder = this.headersBlockBuilder();
                headersBlockBuilder.addFragment(byteBuf, n2, channelHandlerContext.alloc(), bl);
                if (bl) {
                    http2FrameListener.onHeadersRead(channelHandlerContext, n3, headersBlockBuilder.headers(), n4, http2Flags.endOfStream());
                }
            }
        };
        int n6 = DefaultHttp2FrameReader.lengthWithoutTrailingPadding(n2 - byteBuf.readerIndex(), n4);
        this.headersContinuation.processFragment(this.flags.endOfHeaders(), byteBuf, n6, http2FrameListener);
        DefaultHttp2FrameReader defaultHttp2FrameReader = this;
        defaultHttp2FrameReader.resetHeadersContinuationIfEnd(defaultHttp2FrameReader.flags.endOfHeaders());
    }

    private void resetHeadersContinuationIfEnd(boolean bl) {
        if (bl) {
            this.closeHeadersContinuation();
        }
    }

    private void readPriorityFrame(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, Http2FrameListener http2FrameListener) throws Http2Exception {
        long l2 = byteBuf.readUnsignedInt();
        boolean bl = (l2 & 0x80000000L) != 0L;
        int n2 = (int)(l2 & Integer.MAX_VALUE);
        if (n2 == this.streamId) {
            throw Http2Exception.streamError(this.streamId, Http2Error.PROTOCOL_ERROR, "A stream cannot depend on itself.", new Object[0]);
        }
        short s2 = (short)(byteBuf.readUnsignedByte() + 1);
        http2FrameListener.onPriorityRead(channelHandlerContext, this.streamId, n2, s2, bl);
    }

    private void readRstStreamFrame(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, Http2FrameListener http2FrameListener) throws Http2Exception {
        long l2 = byteBuf.readUnsignedInt();
        http2FrameListener.onRstStreamRead(channelHandlerContext, this.streamId, l2);
    }

    private void readSettingsFrame(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, Http2FrameListener http2FrameListener) throws Http2Exception {
        if (this.flags.ack()) {
            http2FrameListener.onSettingsAckRead(channelHandlerContext);
            return;
        }
        int n2 = this.payloadLength / 6;
        Http2Settings http2Settings = new Http2Settings();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = (char)byteBuf.readUnsignedShort();
            long l2 = byteBuf.readUnsignedInt();
            try {
                http2Settings.put(c2, l2);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                switch (c2) {
                    case '\u0005': {
                        IllegalArgumentException illegalArgumentException2 = illegalArgumentException;
                        throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, illegalArgumentException2, illegalArgumentException2.getMessage(), new Object[0]);
                    }
                    case '\u0004': {
                        IllegalArgumentException illegalArgumentException3 = illegalArgumentException;
                        throw Http2Exception.connectionError(Http2Error.FLOW_CONTROL_ERROR, illegalArgumentException3, illegalArgumentException3.getMessage(), new Object[0]);
                    }
                }
                IllegalArgumentException illegalArgumentException4 = illegalArgumentException;
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, illegalArgumentException4, illegalArgumentException4.getMessage(), new Object[0]);
            }
        }
        http2FrameListener.onSettingsRead(channelHandlerContext, http2Settings);
    }

    private void readPushPromiseFrame(final ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, int n2, Http2FrameListener http2FrameListener) throws Http2Exception {
        final int n3 = this.streamId;
        final int n4 = this.readPadding(byteBuf);
        this.verifyPadding(n4);
        final int n5 = Http2CodecUtil.readUnsignedInt(byteBuf);
        this.headersContinuation = new HeadersContinuation(){

            public int getStreamId() {
                return n3;
            }

            public void processFragment(boolean bl, ByteBuf byteBuf, int n2, Http2FrameListener http2FrameListener) throws Http2Exception {
                this.headersBlockBuilder().addFragment(byteBuf, n2, channelHandlerContext.alloc(), bl);
                if (bl) {
                    http2FrameListener.onPushPromiseRead(channelHandlerContext, n3, n5, this.headersBlockBuilder().headers(), n4);
                }
            }
        };
        int n6 = DefaultHttp2FrameReader.lengthWithoutTrailingPadding(n2 - byteBuf.readerIndex(), n4);
        this.headersContinuation.processFragment(this.flags.endOfHeaders(), byteBuf, n6, http2FrameListener);
        DefaultHttp2FrameReader defaultHttp2FrameReader = this;
        defaultHttp2FrameReader.resetHeadersContinuationIfEnd(defaultHttp2FrameReader.flags.endOfHeaders());
    }

    private void readPingFrame(ChannelHandlerContext channelHandlerContext, long l2, Http2FrameListener http2FrameListener) throws Http2Exception {
        if (this.flags.ack()) {
            http2FrameListener.onPingAckRead(channelHandlerContext, l2);
            return;
        }
        http2FrameListener.onPingRead(channelHandlerContext, l2);
    }

    private static void readGoAwayFrame(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, int n2, Http2FrameListener http2FrameListener) throws Http2Exception {
        int n3 = Http2CodecUtil.readUnsignedInt(byteBuf);
        long l2 = byteBuf.readUnsignedInt();
        byteBuf = byteBuf.readSlice(n2 - byteBuf.readerIndex());
        http2FrameListener.onGoAwayRead(channelHandlerContext, n3, l2, byteBuf);
    }

    private void readWindowUpdateFrame(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, Http2FrameListener http2FrameListener) throws Http2Exception {
        int n2 = Http2CodecUtil.readUnsignedInt(byteBuf);
        if (n2 == 0) {
            throw Http2Exception.streamError(this.streamId, Http2Error.PROTOCOL_ERROR, "Received WINDOW_UPDATE with delta 0 for stream: %d", this.streamId);
        }
        http2FrameListener.onWindowUpdateRead(channelHandlerContext, this.streamId, n2);
    }

    private void readContinuationFrame(ByteBuf byteBuf, int n2, Http2FrameListener http2FrameListener) throws Http2Exception {
        this.headersContinuation.processFragment(this.flags.endOfHeaders(), byteBuf, n2 - byteBuf.readerIndex(), http2FrameListener);
        DefaultHttp2FrameReader defaultHttp2FrameReader = this;
        defaultHttp2FrameReader.resetHeadersContinuationIfEnd(defaultHttp2FrameReader.flags.endOfHeaders());
    }

    private void readUnknownFrame(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, int n2, Http2FrameListener http2FrameListener) throws Http2Exception {
        byteBuf = byteBuf.readSlice(n2 - byteBuf.readerIndex());
        http2FrameListener.onUnknownFrame(channelHandlerContext, this.frameType, this.streamId, this.flags, byteBuf);
    }

    private int readPadding(ByteBuf byteBuf) {
        if (!this.flags.paddingPresent()) {
            return 0;
        }
        return byteBuf.readUnsignedByte() + 1;
    }

    private void verifyPadding(int n2) throws Http2Exception {
        if ((n2 = DefaultHttp2FrameReader.lengthWithoutTrailingPadding(this.payloadLength, n2)) < 0) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Frame payload too small for padding.", new Object[0]);
        }
    }

    private static int lengthWithoutTrailingPadding(int n2, int n3) {
        if (n3 == 0) {
            return n2;
        }
        return n2 - (n3 - 1);
    }

    private void verifyNotProcessingHeaders() throws Http2Exception {
        if (this.headersContinuation != null) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Received frame of type %s while processing headers on stream %d.", this.frameType, this.headersContinuation.getStreamId());
        }
    }

    private void verifyPayloadLength(int n2) throws Http2Exception {
        if (n2 > this.maxFrameSize) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Total payload length %d exceeds max frame length.", n2);
        }
    }

    private void verifyAssociatedWithAStream() throws Http2Exception {
        if (this.streamId == 0) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Frame of type %s must be associated with a stream.", this.frameType);
        }
    }

    private static void verifyStreamOrConnectionId(int n2, String string) throws Http2Exception {
        if (n2 < 0) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "%s must be >= 0", string);
        }
    }

    protected class HeadersBlockBuilder {
        private ByteBuf headerBlock;

        protected HeadersBlockBuilder() {
        }

        private void headerSizeExceeded() throws Http2Exception {
            this.close();
            Http2CodecUtil.headerListSizeExceeded(DefaultHttp2FrameReader.this.headersDecoder.configuration().maxHeaderListSizeGoAway());
        }

        final void addFragment(ByteBuf byteBuf, int n2, ByteBufAllocator object, boolean bl) throws Http2Exception {
            if (this.headerBlock == null) {
                if ((long)n2 > DefaultHttp2FrameReader.this.headersDecoder.configuration().maxHeaderListSizeGoAway()) {
                    this.headerSizeExceeded();
                }
                if (bl) {
                    this.headerBlock = byteBuf.readRetainedSlice(n2);
                    return;
                }
                this.headerBlock = object.buffer(n2).writeBytes(byteBuf, n2);
                return;
            }
            if (DefaultHttp2FrameReader.this.headersDecoder.configuration().maxHeaderListSizeGoAway() - (long)n2 < (long)this.headerBlock.readableBytes()) {
                this.headerSizeExceeded();
            }
            if (this.headerBlock.isWritable(n2)) {
                this.headerBlock.writeBytes(byteBuf, n2);
                return;
            }
            object = object.buffer(this.headerBlock.readableBytes() + n2);
            ((ByteBuf)object).writeBytes(this.headerBlock).writeBytes(byteBuf, n2);
            this.headerBlock.release();
            this.headerBlock = object;
        }

        Http2Headers headers() throws Http2Exception {
            try {
                Http2Headers http2Headers = DefaultHttp2FrameReader.this.headersDecoder.decodeHeaders(DefaultHttp2FrameReader.this.streamId, this.headerBlock);
                return http2Headers;
            }
            finally {
                this.close();
            }
        }

        void close() {
            if (this.headerBlock != null) {
                this.headerBlock.release();
                this.headerBlock = null;
            }
            DefaultHttp2FrameReader.this.headersContinuation = null;
        }
    }

    private abstract class HeadersContinuation {
        private final HeadersBlockBuilder builder;

        private HeadersContinuation() {
            this.builder = new HeadersBlockBuilder();
        }

        abstract int getStreamId();

        abstract void processFragment(boolean var1, ByteBuf var2, int var3, Http2FrameListener var4) throws Http2Exception;

        final HeadersBlockBuilder headersBlockBuilder() {
            return this.builder;
        }

        final void close() {
            this.builder.close();
        }
    }
}

