/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec.http2;

import com.appoptics.ext.io.netty.buffer.ByteBufAllocator;
import com.appoptics.ext.io.netty.channel.Channel;
import com.appoptics.ext.io.netty.channel.ChannelConfig;
import com.appoptics.ext.io.netty.channel.ChannelFuture;
import com.appoptics.ext.io.netty.channel.ChannelFutureListener;
import com.appoptics.ext.io.netty.channel.ChannelHandler;
import com.appoptics.ext.io.netty.channel.ChannelHandlerContext;
import com.appoptics.ext.io.netty.channel.ChannelId;
import com.appoptics.ext.io.netty.channel.ChannelMetadata;
import com.appoptics.ext.io.netty.channel.ChannelOutboundBuffer;
import com.appoptics.ext.io.netty.channel.ChannelPipeline;
import com.appoptics.ext.io.netty.channel.ChannelPromise;
import com.appoptics.ext.io.netty.channel.DefaultChannelConfig;
import com.appoptics.ext.io.netty.channel.DefaultChannelPipeline;
import com.appoptics.ext.io.netty.channel.EventLoop;
import com.appoptics.ext.io.netty.channel.MessageSizeEstimator;
import com.appoptics.ext.io.netty.channel.RecvByteBufAllocator;
import com.appoptics.ext.io.netty.channel.VoidChannelPromise;
import com.appoptics.ext.io.netty.handler.codec.http2.DefaultHttp2ResetFrame;
import com.appoptics.ext.io.netty.handler.codec.http2.DefaultHttp2WindowUpdateFrame;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2CodecUtil;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2DataFrame;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Error;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Exception;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Frame;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2FrameCodec;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2FrameStream;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2FrameStreamException;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2FrameStreamVisitor;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2HeadersFrame;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2StreamChannel;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2StreamChannelId;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2StreamFrame;
import com.appoptics.ext.io.netty.util.DefaultAttributeMap;
import com.appoptics.ext.io.netty.util.ReferenceCountUtil;
import com.appoptics.ext.io.netty.util.internal.StringUtil;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

abstract class AbstractHttp2StreamChannel
extends DefaultAttributeMap
implements Http2StreamChannel {
    static final Http2FrameStreamVisitor WRITABLE_VISITOR = new Http2FrameStreamVisitor(){

        public final boolean visit(Http2FrameStream object) {
            object = (AbstractHttp2StreamChannel)((Http2FrameCodec.DefaultHttp2FrameStream)object).attachment;
            ((AbstractHttp2StreamChannel)object).trySetWritable();
            return true;
        }
    };
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractHttp2StreamChannel.class);
    private static final ChannelMetadata METADATA = new ChannelMetadata(false, 16);
    private static final AtomicLongFieldUpdater<AbstractHttp2StreamChannel> TOTAL_PENDING_SIZE_UPDATER = AtomicLongFieldUpdater.newUpdater(AbstractHttp2StreamChannel.class, "totalPendingSize");
    private static final AtomicIntegerFieldUpdater<AbstractHttp2StreamChannel> UNWRITABLE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(AbstractHttp2StreamChannel.class, "unwritable");
    private final ChannelFutureListener windowUpdateFrameWriteListener = new ChannelFutureListener(){

        public void operationComplete(ChannelFuture channelFuture) {
            AbstractHttp2StreamChannel.windowUpdateFrameWriteComplete(channelFuture, AbstractHttp2StreamChannel.this);
        }
    };
    private final Http2StreamChannelConfig config = new Http2StreamChannelConfig(this);
    private final Http2ChannelUnsafe unsafe = new Http2ChannelUnsafe();
    private final ChannelId channelId;
    private final ChannelPipeline pipeline;
    private final Http2FrameCodec.DefaultHttp2FrameStream stream;
    private final ChannelPromise closePromise;
    private volatile boolean registered;
    private volatile long totalPendingSize;
    private volatile int unwritable;
    private Runnable fireChannelWritabilityChangedTask;
    private boolean outboundClosed;
    private int flowControlledBytes;
    private ReadStatus readStatus = ReadStatus.IDLE;
    private Queue<Object> inboundBuffer;
    private boolean firstFrameWritten;
    private boolean readCompletePending;

    private static void windowUpdateFrameWriteComplete(ChannelFuture object, Channel channel) {
        if ((object = object.cause()) != null) {
            Throwable throwable;
            if (object instanceof Http2FrameStreamException && (throwable = ((Throwable)object).getCause()) != null) {
                object = throwable;
            }
            channel.pipeline().fireExceptionCaught((Throwable)object);
            channel.unsafe().close(channel.unsafe().voidPromise());
        }
    }

    AbstractHttp2StreamChannel(Http2FrameCodec.DefaultHttp2FrameStream defaultHttp2FrameStream, int n2, ChannelHandler channelHandler) {
        this.stream = defaultHttp2FrameStream;
        defaultHttp2FrameStream.attachment = this;
        AbstractHttp2StreamChannel abstractHttp2StreamChannel = this;
        this.pipeline = new DefaultChannelPipeline(abstractHttp2StreamChannel){

            protected void incrementPendingOutboundBytes(long l2) {
                AbstractHttp2StreamChannel.this.incrementPendingOutboundBytes(l2, true);
            }

            protected void decrementPendingOutboundBytes(long l2) {
                AbstractHttp2StreamChannel.this.decrementPendingOutboundBytes(l2, true);
            }
        };
        this.closePromise = this.pipeline.newPromise();
        this.channelId = new Http2StreamChannelId(this.parent().id(), n2);
        if (channelHandler != null) {
            this.pipeline.addLast(channelHandler);
        }
    }

    private void incrementPendingOutboundBytes(long l2, boolean bl) {
        if (l2 == 0L) {
            return;
        }
        long l3 = TOTAL_PENDING_SIZE_UPDATER.addAndGet(this, l2);
        if (l3 > (long)this.config().getWriteBufferHighWaterMark()) {
            this.setUnwritable(bl);
        }
    }

    private void decrementPendingOutboundBytes(long l2, boolean bl) {
        if (l2 == 0L) {
            return;
        }
        long l3 = TOTAL_PENDING_SIZE_UPDATER.addAndGet(this, -l2);
        if (l3 < (long)this.config().getWriteBufferLowWaterMark() && this.parent().isWritable()) {
            this.setWritable(bl);
        }
    }

    final void trySetWritable() {
        if (this.totalPendingSize < (long)this.config().getWriteBufferLowWaterMark()) {
            this.setWritable(false);
        }
    }

    private void setWritable(boolean bl) {
        int n2;
        int n3;
        while (!UNWRITABLE_UPDATER.compareAndSet(this, n3 = this.unwritable, n2 = n3 & 0xFFFFFFFE)) {
        }
        if (n3 != 0 && n2 == 0) {
            this.fireChannelWritabilityChanged(bl);
            return;
        }
    }

    private void setUnwritable(boolean bl) {
        int n2;
        int n3;
        while (!UNWRITABLE_UPDATER.compareAndSet(this, n3 = this.unwritable, n2 = n3 | 1)) {
        }
        if (n3 == 0 && n2 != 0) {
            this.fireChannelWritabilityChanged(bl);
            return;
        }
    }

    private void fireChannelWritabilityChanged(boolean bl) {
        final ChannelPipeline channelPipeline = this.pipeline();
        if (bl) {
            Runnable runnable = this.fireChannelWritabilityChangedTask;
            if (runnable == null) {
                this.fireChannelWritabilityChangedTask = runnable = new Runnable(){

                    public void run() {
                        channelPipeline.fireChannelWritabilityChanged();
                    }
                };
            }
            this.eventLoop().execute(runnable);
            return;
        }
        channelPipeline.fireChannelWritabilityChanged();
    }

    public Http2FrameStream stream() {
        return this.stream;
    }

    void closeOutbound() {
        this.outboundClosed = true;
    }

    void streamClosed() {
        this.unsafe.readEOS();
        this.unsafe.doBeginRead();
    }

    public ChannelMetadata metadata() {
        return METADATA;
    }

    public ChannelConfig config() {
        return this.config;
    }

    public boolean isOpen() {
        return !this.closePromise.isDone();
    }

    public boolean isActive() {
        return this.isOpen();
    }

    public boolean isWritable() {
        return this.unwritable == 0;
    }

    public ChannelId id() {
        return this.channelId;
    }

    public EventLoop eventLoop() {
        return this.parent().eventLoop();
    }

    public Channel parent() {
        return this.parentContext().channel();
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public SocketAddress localAddress() {
        return this.parent().localAddress();
    }

    public SocketAddress remoteAddress() {
        return this.parent().remoteAddress();
    }

    public long bytesBeforeUnwritable() {
        long l2 = (long)this.config().getWriteBufferHighWaterMark() - this.totalPendingSize;
        if (l2 > 0L) {
            if (this.isWritable()) {
                return l2;
            }
            return 0L;
        }
        return 0L;
    }

    public Channel.Unsafe unsafe() {
        return this.unsafe;
    }

    public ChannelPipeline pipeline() {
        return this.pipeline;
    }

    public ByteBufAllocator alloc() {
        return this.config().getAllocator();
    }

    public Channel read() {
        this.pipeline().read();
        return this;
    }

    public Channel flush() {
        this.pipeline().flush();
        return this;
    }

    public ChannelFuture connect(SocketAddress socketAddress) {
        return this.pipeline().connect(socketAddress);
    }

    public ChannelFuture connect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        return this.pipeline().connect(socketAddress, socketAddress2);
    }

    public ChannelFuture close() {
        return this.pipeline().close();
    }

    public ChannelFuture connect(SocketAddress socketAddress, ChannelPromise channelPromise) {
        return this.pipeline().connect(socketAddress, channelPromise);
    }

    public ChannelFuture connect(SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        return this.pipeline().connect(socketAddress, socketAddress2, channelPromise);
    }

    public ChannelFuture disconnect(ChannelPromise channelPromise) {
        return this.pipeline().disconnect(channelPromise);
    }

    public ChannelFuture close(ChannelPromise channelPromise) {
        return this.pipeline().close(channelPromise);
    }

    public ChannelFuture write(Object object) {
        return this.pipeline().write(object);
    }

    public ChannelFuture write(Object object, ChannelPromise channelPromise) {
        return this.pipeline().write(object, channelPromise);
    }

    public ChannelFuture writeAndFlush(Object object) {
        return this.pipeline().writeAndFlush(object);
    }

    public ChannelPromise newPromise() {
        return this.pipeline().newPromise();
    }

    public ChannelFuture newSucceededFuture() {
        return this.pipeline().newSucceededFuture();
    }

    public ChannelFuture newFailedFuture(Throwable throwable) {
        return this.pipeline().newFailedFuture(throwable);
    }

    public ChannelPromise voidPromise() {
        return this.pipeline().voidPromise();
    }

    public int hashCode() {
        return this.id().hashCode();
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public int compareTo(Channel channel) {
        if (this == channel) {
            return 0;
        }
        return this.id().compareTo(channel.id());
    }

    public String toString() {
        return this.parent().toString() + "(H2 - " + this.stream + ')';
    }

    /*
     * Enabled aggressive block sorting
     */
    void fireChildRead(Http2Frame http2Frame) {
        assert (this.eventLoop().inEventLoop());
        if (!this.isActive()) {
            ReferenceCountUtil.release(http2Frame);
            return;
        }
        if (this.readStatus != ReadStatus.IDLE) {
            assert (this.inboundBuffer == null || this.inboundBuffer.isEmpty());
            RecvByteBufAllocator.Handle handle = this.unsafe.recvBufAllocHandle();
            this.unsafe.doRead0(http2Frame, handle);
            if (handle.continueReading()) {
                this.maybeAddChannelToReadCompletePendingQueue();
                return;
            }
            this.unsafe.notifyReadComplete(handle, true);
            return;
        }
        if (this.inboundBuffer == null) {
            this.inboundBuffer = new ArrayDeque<Object>(4);
        }
        this.inboundBuffer.add(http2Frame);
    }

    void fireChildReadComplete() {
        assert (this.eventLoop().inEventLoop());
        assert (this.readStatus != ReadStatus.IDLE || !this.readCompletePending);
        this.unsafe.notifyReadComplete(this.unsafe.recvBufAllocHandle(), false);
    }

    private void maybeAddChannelToReadCompletePendingQueue() {
        if (!this.readCompletePending) {
            this.readCompletePending = true;
            this.addChannelToReadCompletePendingQueue();
        }
    }

    protected void flush0(ChannelHandlerContext channelHandlerContext) {
        channelHandlerContext.flush();
    }

    protected ChannelFuture write0(ChannelHandlerContext channelHandlerContext, Object object) {
        ChannelPromise channelPromise = channelHandlerContext.newPromise();
        channelHandlerContext.write(object, channelPromise);
        return channelPromise;
    }

    protected abstract boolean isParentReadInProgress();

    protected abstract void addChannelToReadCompletePendingQueue();

    protected abstract ChannelHandlerContext parentContext();

    private static final class Http2StreamChannelConfig
    extends DefaultChannelConfig {
        Http2StreamChannelConfig(Channel channel) {
            super(channel);
        }

        public final MessageSizeEstimator getMessageSizeEstimator() {
            return FlowControlledFrameSizeEstimator.INSTANCE;
        }

        public final ChannelConfig setMessageSizeEstimator(MessageSizeEstimator messageSizeEstimator) {
            throw new UnsupportedOperationException();
        }

        public final ChannelConfig setRecvByteBufAllocator(RecvByteBufAllocator recvByteBufAllocator) {
            if (!(recvByteBufAllocator.newHandle() instanceof RecvByteBufAllocator.ExtendedHandle)) {
                throw new IllegalArgumentException("allocator.newHandle() must return an object of type: " + RecvByteBufAllocator.ExtendedHandle.class);
            }
            super.setRecvByteBufAllocator(recvByteBufAllocator);
            return this;
        }
    }

    private final class Http2ChannelUnsafe
    implements Channel.Unsafe {
        private final VoidChannelPromise unsafeVoidPromise;
        private RecvByteBufAllocator.Handle recvHandle;
        private boolean writeDoneAndNoFlush;
        private boolean closeInitiated;
        private boolean readEOS;

        private Http2ChannelUnsafe() {
            this.unsafeVoidPromise = new VoidChannelPromise(AbstractHttp2StreamChannel.this, false);
        }

        public final void connect(SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
            if (!channelPromise.setUncancellable()) {
                return;
            }
            channelPromise.setFailure(new UnsupportedOperationException());
        }

        public final RecvByteBufAllocator.Handle recvBufAllocHandle() {
            if (this.recvHandle == null) {
                this.recvHandle = AbstractHttp2StreamChannel.this.config().getRecvByteBufAllocator().newHandle();
                this.recvHandle.reset(AbstractHttp2StreamChannel.this.config());
            }
            return this.recvHandle;
        }

        public final SocketAddress localAddress() {
            return AbstractHttp2StreamChannel.this.parent().unsafe().localAddress();
        }

        public final SocketAddress remoteAddress() {
            return AbstractHttp2StreamChannel.this.parent().unsafe().remoteAddress();
        }

        public final void register(EventLoop eventLoop, ChannelPromise channelPromise) {
            if (!channelPromise.setUncancellable()) {
                return;
            }
            if (AbstractHttp2StreamChannel.this.registered) {
                channelPromise.setFailure(new UnsupportedOperationException("Re-register is not supported"));
                return;
            }
            AbstractHttp2StreamChannel.this.registered = true;
            channelPromise.setSuccess();
            AbstractHttp2StreamChannel.this.pipeline().fireChannelRegistered();
            if (AbstractHttp2StreamChannel.this.isActive()) {
                AbstractHttp2StreamChannel.this.pipeline().fireChannelActive();
            }
        }

        public final void disconnect(ChannelPromise channelPromise) {
            this.close(channelPromise);
        }

        public final void close(final ChannelPromise channelPromise) {
            Object object;
            if (!channelPromise.setUncancellable()) {
                return;
            }
            if (this.closeInitiated) {
                if (AbstractHttp2StreamChannel.this.closePromise.isDone()) {
                    channelPromise.setSuccess();
                    return;
                }
                if (!(channelPromise instanceof VoidChannelPromise)) {
                    AbstractHttp2StreamChannel.this.closePromise.addListener(new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture channelFuture) {
                            channelPromise.setSuccess();
                        }
                    });
                }
                return;
            }
            this.closeInitiated = true;
            AbstractHttp2StreamChannel.this.readCompletePending = false;
            boolean bl = AbstractHttp2StreamChannel.this.isActive();
            if (AbstractHttp2StreamChannel.this.parent().isActive() && !this.readEOS && Http2CodecUtil.isStreamIdValid(AbstractHttp2StreamChannel.this.stream.id())) {
                object = new DefaultHttp2ResetFrame(Http2Error.CANCEL).stream(AbstractHttp2StreamChannel.this.stream());
                this.write(object, AbstractHttp2StreamChannel.this.unsafe().voidPromise());
                this.flush();
            }
            if (AbstractHttp2StreamChannel.this.inboundBuffer != null) {
                while ((object = AbstractHttp2StreamChannel.this.inboundBuffer.poll()) != null) {
                    ReferenceCountUtil.release(object);
                }
                AbstractHttp2StreamChannel.this.inboundBuffer = null;
            }
            AbstractHttp2StreamChannel.this.outboundClosed = true;
            AbstractHttp2StreamChannel.this.closePromise.setSuccess();
            channelPromise.setSuccess();
            Http2ChannelUnsafe http2ChannelUnsafe = this;
            http2ChannelUnsafe.fireChannelInactiveAndDeregister(http2ChannelUnsafe.voidPromise(), bl);
        }

        public final void closeForcibly() {
            Http2ChannelUnsafe http2ChannelUnsafe = this;
            http2ChannelUnsafe.close(http2ChannelUnsafe.AbstractHttp2StreamChannel.this.unsafe().voidPromise());
        }

        private void fireChannelInactiveAndDeregister(final ChannelPromise channelPromise, final boolean bl) {
            if (!channelPromise.setUncancellable()) {
                return;
            }
            if (!AbstractHttp2StreamChannel.this.registered) {
                channelPromise.setSuccess();
                return;
            }
            this.invokeLater(new Runnable(){

                public void run() {
                    if (bl) {
                        AbstractHttp2StreamChannel.this.pipeline.fireChannelInactive();
                    }
                    if (AbstractHttp2StreamChannel.this.registered) {
                        AbstractHttp2StreamChannel.this.registered = false;
                        AbstractHttp2StreamChannel.this.pipeline.fireChannelUnregistered();
                    }
                    Http2ChannelUnsafe.this.safeSetSuccess(channelPromise);
                }
            });
        }

        private void safeSetSuccess(ChannelPromise channelPromise) {
            if (!(channelPromise instanceof VoidChannelPromise) && !channelPromise.trySuccess()) {
                logger.warn("Failed to mark a promise as success because it is done already: {}", (Object)channelPromise);
            }
        }

        private void invokeLater(Runnable runnable) {
            try {
                AbstractHttp2StreamChannel.this.eventLoop().execute(runnable);
                return;
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                logger.warn("Can't invoke task later as EventLoop rejected it", rejectedExecutionException);
                return;
            }
        }

        public final void beginRead() {
            if (!AbstractHttp2StreamChannel.this.isActive()) {
                return;
            }
            this.updateLocalWindowIfNeeded();
            switch (AbstractHttp2StreamChannel.this.readStatus) {
                case IDLE: {
                    AbstractHttp2StreamChannel.this.readStatus = ReadStatus.IN_PROGRESS;
                    this.doBeginRead();
                    return;
                }
                case IN_PROGRESS: {
                    AbstractHttp2StreamChannel.this.readStatus = ReadStatus.REQUESTED;
                }
            }
        }

        private Object pollQueuedMessage() {
            if (AbstractHttp2StreamChannel.this.inboundBuffer == null) {
                return null;
            }
            return AbstractHttp2StreamChannel.this.inboundBuffer.poll();
        }

        final void doBeginRead() {
            while (AbstractHttp2StreamChannel.this.readStatus != ReadStatus.IDLE) {
                Object object = this.pollQueuedMessage();
                if (object == null) {
                    if (this.readEOS) {
                        AbstractHttp2StreamChannel.this.unsafe.closeForcibly();
                    }
                    this.flush();
                    return;
                }
                RecvByteBufAllocator.Handle handle = this.recvBufAllocHandle();
                handle.reset(AbstractHttp2StreamChannel.this.config());
                boolean bl = false;
                do {
                    this.doRead0((Http2Frame)object, handle);
                } while ((this.readEOS || (bl = handle.continueReading())) && (object = this.pollQueuedMessage()) != null);
                if (bl && AbstractHttp2StreamChannel.this.isParentReadInProgress() && !this.readEOS) {
                    AbstractHttp2StreamChannel.this.maybeAddChannelToReadCompletePendingQueue();
                    continue;
                }
                this.notifyReadComplete(handle, true);
            }
        }

        final void readEOS() {
            this.readEOS = true;
        }

        private void updateLocalWindowIfNeeded() {
            if (AbstractHttp2StreamChannel.this.flowControlledBytes != 0) {
                int n2 = AbstractHttp2StreamChannel.this.flowControlledBytes;
                AbstractHttp2StreamChannel.this.flowControlledBytes = 0;
                ChannelFuture channelFuture = AbstractHttp2StreamChannel.this.write0(AbstractHttp2StreamChannel.this.parentContext(), new DefaultHttp2WindowUpdateFrame(n2).stream(AbstractHttp2StreamChannel.this.stream));
                this.writeDoneAndNoFlush = true;
                if (channelFuture.isDone()) {
                    AbstractHttp2StreamChannel.windowUpdateFrameWriteComplete(channelFuture, AbstractHttp2StreamChannel.this);
                    return;
                }
                channelFuture.addListener(AbstractHttp2StreamChannel.this.windowUpdateFrameWriteListener);
            }
        }

        final void notifyReadComplete(RecvByteBufAllocator.Handle handle, boolean bl) {
            if (!AbstractHttp2StreamChannel.this.readCompletePending && !bl) {
                return;
            }
            AbstractHttp2StreamChannel.this.readCompletePending = false;
            if (AbstractHttp2StreamChannel.this.readStatus == ReadStatus.REQUESTED) {
                AbstractHttp2StreamChannel.this.readStatus = ReadStatus.IN_PROGRESS;
            } else {
                AbstractHttp2StreamChannel.this.readStatus = ReadStatus.IDLE;
            }
            handle.readComplete();
            AbstractHttp2StreamChannel.this.pipeline().fireChannelReadComplete();
            this.flush();
            if (this.readEOS) {
                AbstractHttp2StreamChannel.this.unsafe.closeForcibly();
            }
        }

        final void doRead0(Http2Frame http2Frame, RecvByteBufAllocator.Handle handle) {
            int n2;
            if (http2Frame instanceof Http2DataFrame) {
                n2 = ((Http2DataFrame)http2Frame).initialFlowControlledBytes();
                AbstractHttp2StreamChannel.this.flowControlledBytes = AbstractHttp2StreamChannel.this.flowControlledBytes + n2;
            } else {
                n2 = 9;
            }
            handle.attemptedBytesRead(n2);
            handle.lastBytesRead(n2);
            handle.incMessagesRead(1);
            AbstractHttp2StreamChannel.this.pipeline().fireChannelRead(http2Frame);
        }

        public final void write(Object object, ChannelPromise channelPromise) {
            if (!channelPromise.setUncancellable()) {
                ReferenceCountUtil.release(object);
                return;
            }
            if (!AbstractHttp2StreamChannel.this.isActive() || AbstractHttp2StreamChannel.this.outboundClosed && (object instanceof Http2HeadersFrame || object instanceof Http2DataFrame)) {
                ReferenceCountUtil.release(object);
                channelPromise.setFailure(new ClosedChannelException());
                return;
            }
            try {
                if (!(object instanceof Http2StreamFrame)) {
                    String string = object.toString();
                    ReferenceCountUtil.release(object);
                    channelPromise.setFailure(new IllegalArgumentException("Message must be an " + StringUtil.simpleClassName(Http2StreamFrame.class) + ": " + string));
                    return;
                }
                Http2StreamFrame http2StreamFrame = this.validateStreamFrame((Http2StreamFrame)object).stream(AbstractHttp2StreamChannel.this.stream());
                this.writeHttp2StreamFrame(http2StreamFrame, channelPromise);
            }
            catch (Throwable throwable) {
                channelPromise.tryFailure(throwable);
            }
        }

        private void writeHttp2StreamFrame(Http2StreamFrame http2StreamFrame, final ChannelPromise channelPromise) {
            if (!(AbstractHttp2StreamChannel.this.firstFrameWritten || Http2CodecUtil.isStreamIdValid(AbstractHttp2StreamChannel.this.stream().id()) || http2StreamFrame instanceof Http2HeadersFrame)) {
                ReferenceCountUtil.release(http2StreamFrame);
                channelPromise.setFailure(new IllegalArgumentException("The first frame must be a headers frame. Was: " + http2StreamFrame.name()));
                return;
            }
            final boolean bl = AbstractHttp2StreamChannel.this.firstFrameWritten ? false : (AbstractHttp2StreamChannel.this.firstFrameWritten = true);
            ChannelFuture channelFuture = AbstractHttp2StreamChannel.this.write0(AbstractHttp2StreamChannel.this.parentContext(), http2StreamFrame);
            if (channelFuture.isDone()) {
                if (bl) {
                    this.firstWriteComplete(channelFuture, channelPromise);
                    return;
                }
                this.writeComplete(channelFuture, channelPromise);
                return;
            }
            final long l2 = FlowControlledFrameSizeEstimator.HANDLE_INSTANCE.size(http2StreamFrame);
            AbstractHttp2StreamChannel.this.incrementPendingOutboundBytes(l2, false);
            channelFuture.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture channelFuture) {
                    if (bl) {
                        Http2ChannelUnsafe.this.firstWriteComplete(channelFuture, channelPromise);
                    } else {
                        Http2ChannelUnsafe.this.writeComplete(channelFuture, channelPromise);
                    }
                    AbstractHttp2StreamChannel.this.decrementPendingOutboundBytes(l2, false);
                }
            });
            this.writeDoneAndNoFlush = true;
        }

        private void firstWriteComplete(ChannelFuture object, ChannelPromise channelPromise) {
            if ((object = object.cause()) == null) {
                channelPromise.setSuccess();
                return;
            }
            this.closeForcibly();
            channelPromise.setFailure(this.wrapStreamClosedError((Throwable)object));
        }

        private void writeComplete(ChannelFuture object, ChannelPromise channelPromise) {
            if ((object = object.cause()) == null) {
                channelPromise.setSuccess();
                return;
            }
            if ((object = this.wrapStreamClosedError((Throwable)object)) instanceof IOException) {
                if (AbstractHttp2StreamChannel.this.config.isAutoClose()) {
                    this.closeForcibly();
                } else {
                    AbstractHttp2StreamChannel.this.outboundClosed = true;
                }
            }
            channelPromise.setFailure((Throwable)object);
        }

        private Throwable wrapStreamClosedError(Throwable throwable) {
            if (throwable instanceof Http2Exception && ((Http2Exception)throwable).error() == Http2Error.STREAM_CLOSED) {
                return new ClosedChannelException().initCause(throwable);
            }
            return throwable;
        }

        private Http2StreamFrame validateStreamFrame(Http2StreamFrame http2StreamFrame) {
            if (http2StreamFrame.stream() != null && http2StreamFrame.stream() != AbstractHttp2StreamChannel.this.stream) {
                String string = http2StreamFrame.toString();
                ReferenceCountUtil.release(http2StreamFrame);
                throw new IllegalArgumentException("Stream " + http2StreamFrame.stream() + " must not be set on the frame: " + string);
            }
            return http2StreamFrame;
        }

        public final void flush() {
            if (!this.writeDoneAndNoFlush || AbstractHttp2StreamChannel.this.isParentReadInProgress()) {
                return;
            }
            this.writeDoneAndNoFlush = false;
            AbstractHttp2StreamChannel.this.flush0(AbstractHttp2StreamChannel.this.parentContext());
        }

        public final ChannelPromise voidPromise() {
            return this.unsafeVoidPromise;
        }

        public final ChannelOutboundBuffer outboundBuffer() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ReadStatus {
        IDLE,
        IN_PROGRESS,
        REQUESTED;

    }

    private static final class FlowControlledFrameSizeEstimator
    implements MessageSizeEstimator {
        static final FlowControlledFrameSizeEstimator INSTANCE = new FlowControlledFrameSizeEstimator();
        private static final MessageSizeEstimator.Handle HANDLE_INSTANCE = new MessageSizeEstimator.Handle(){

            public final int size(Object object) {
                if (object instanceof Http2DataFrame) {
                    return (int)Math.min(Integer.MAX_VALUE, (long)((Http2DataFrame)object).initialFlowControlledBytes() + 9L);
                }
                return 9;
            }
        };

        private FlowControlledFrameSizeEstimator() {
        }

        public final MessageSizeEstimator.Handle newHandle() {
            return HANDLE_INSTANCE;
        }
    }
}

