/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec.http;

import com.appoptics.ext.io.netty.util.AsciiString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum HttpStatusClass {
    INFORMATIONAL(100, 200, "Informational"),
    SUCCESS(200, 300, "Success"),
    REDIRECTION(300, 400, "Redirection"),
    CLIENT_ERROR(400, 500, "Client Error"),
    SERVER_ERROR(500, 600, "Server Error"),
    UNKNOWN(0, 0, "Unknown Status"){

        public final boolean contains(int n2) {
            return n2 < 100 || n2 >= 600;
        }
    };

    private final int min;
    private final int max;
    private final AsciiString defaultReasonPhrase;

    public static HttpStatusClass valueOf(int n2) {
        if (INFORMATIONAL.contains(n2)) {
            return INFORMATIONAL;
        }
        if (SUCCESS.contains(n2)) {
            return SUCCESS;
        }
        if (REDIRECTION.contains(n2)) {
            return REDIRECTION;
        }
        if (CLIENT_ERROR.contains(n2)) {
            return CLIENT_ERROR;
        }
        if (SERVER_ERROR.contains(n2)) {
            return SERVER_ERROR;
        }
        return UNKNOWN;
    }

    public static HttpStatusClass valueOf(CharSequence charSequence) {
        if (charSequence != null && charSequence.length() == 3) {
            char c2 = charSequence.charAt(0);
            if (HttpStatusClass.isDigit(c2) && HttpStatusClass.isDigit(charSequence.charAt(1)) && HttpStatusClass.isDigit(charSequence.charAt(2))) {
                return HttpStatusClass.valueOf(HttpStatusClass.digit(c2) * 100);
            }
            return UNKNOWN;
        }
        return UNKNOWN;
    }

    private static int digit(char c2) {
        return c2 - 48;
    }

    private static boolean isDigit(char c2) {
        return c2 >= '0' && c2 <= '9';
    }

    private HttpStatusClass(int n3, int n4, String string2) {
        this.min = n3;
        this.max = n4;
        this.defaultReasonPhrase = AsciiString.cached(string2);
    }

    public boolean contains(int n2) {
        return n2 >= this.min && n2 < this.max;
    }
}

