/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec.http;

import com.appoptics.ext.io.netty.buffer.Unpooled;
import com.appoptics.ext.io.netty.channel.ChannelFuture;
import com.appoptics.ext.io.netty.channel.ChannelFutureListener;
import com.appoptics.ext.io.netty.channel.ChannelHandlerContext;
import com.appoptics.ext.io.netty.handler.codec.http.DefaultFullHttpResponse;
import com.appoptics.ext.io.netty.handler.codec.http.FullHttpRequest;
import com.appoptics.ext.io.netty.handler.codec.http.FullHttpResponse;
import com.appoptics.ext.io.netty.handler.codec.http.HttpHeaderNames;
import com.appoptics.ext.io.netty.handler.codec.http.HttpHeaderValues;
import com.appoptics.ext.io.netty.handler.codec.http.HttpHeaders;
import com.appoptics.ext.io.netty.handler.codec.http.HttpObject;
import com.appoptics.ext.io.netty.handler.codec.http.HttpObjectAggregator;
import com.appoptics.ext.io.netty.handler.codec.http.HttpRequest;
import com.appoptics.ext.io.netty.handler.codec.http.HttpResponseStatus;
import com.appoptics.ext.io.netty.handler.codec.http.HttpVersion;
import com.appoptics.ext.io.netty.util.AsciiString;
import com.appoptics.ext.io.netty.util.ReferenceCountUtil;
import com.appoptics.ext.io.netty.util.ReferenceCounted;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpServerUpgradeHandler
extends HttpObjectAggregator {
    private final SourceCodec sourceCodec;
    private final UpgradeCodecFactory upgradeCodecFactory;
    private boolean handlingUpgrade;

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, HttpObject httpObject, List<Object> list) throws Exception {
        FullHttpRequest fullHttpRequest;
        this.handlingUpgrade |= HttpServerUpgradeHandler.isUpgradeRequest(httpObject);
        if (!this.handlingUpgrade) {
            ReferenceCountUtil.retain(httpObject);
            list.add(httpObject);
            return;
        }
        if (httpObject instanceof FullHttpRequest) {
            fullHttpRequest = (FullHttpRequest)httpObject;
            ReferenceCountUtil.retain(httpObject);
            list.add(httpObject);
        } else {
            super.decode(channelHandlerContext, httpObject, list);
            if (list.isEmpty()) {
                return;
            }
            assert (list.size() == 1);
            this.handlingUpgrade = false;
            fullHttpRequest = (FullHttpRequest)list.get(0);
        }
        if (this.upgrade(channelHandlerContext, fullHttpRequest)) {
            list.clear();
        }
    }

    private static boolean isUpgradeRequest(HttpObject httpObject) {
        return httpObject instanceof HttpRequest && ((HttpRequest)httpObject).headers().get(HttpHeaderNames.UPGRADE) != null;
    }

    private boolean upgrade(ChannelHandlerContext channelHandlerContext, FullHttpRequest fullHttpRequest) {
        Object object;
        CharSequence charSequence;
        List<CharSequence> object22 = HttpServerUpgradeHandler.splitHeader(fullHttpRequest.headers().get(HttpHeaderNames.UPGRADE));
        int n2 = object22.size();
        UpgradeCodec upgradeCodec = null;
        CharSequence charSequence2 = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            charSequence = object22.get(i2);
            object = this.upgradeCodecFactory.newUpgradeCodec(charSequence);
            if (object == null) continue;
            charSequence2 = charSequence;
            upgradeCodec = object;
            break;
        }
        if (upgradeCodec == null) {
            return false;
        }
        List<String> list = fullHttpRequest.headers().getAll(HttpHeaderNames.CONNECTION);
        if (list == null) {
            return false;
        }
        charSequence = new StringBuilder(list.size() * 10);
        for (CharSequence charSequence3 : list) {
            ((StringBuilder)charSequence).append(charSequence3).append(',');
        }
        CharSequence charSequence4 = charSequence;
        ((StringBuilder)charSequence4).setLength(((StringBuilder)charSequence4).length() - 1);
        object = upgradeCodec.requiredUpgradeHeaders();
        List<CharSequence> list2 = HttpServerUpgradeHandler.splitHeader(charSequence);
        if (!AsciiString.containsContentEqualsIgnoreCase(list2, HttpHeaderNames.UPGRADE) || !AsciiString.containsAllContentEqualsIgnoreCase(list2, object)) {
            return false;
        }
        Iterator<CharSequence> iterator = object.iterator();
        while (iterator.hasNext()) {
            CharSequence charSequence5 = iterator.next();
            if (fullHttpRequest.headers().contains(charSequence5)) continue;
            return false;
        }
        FullHttpResponse fullHttpResponse = HttpServerUpgradeHandler.createUpgradeResponse(charSequence2);
        if (!upgradeCodec.prepareUpgradeResponse(channelHandlerContext, fullHttpRequest, fullHttpResponse.headers())) {
            return false;
        }
        UpgradeEvent upgradeEvent = new UpgradeEvent(charSequence2, fullHttpRequest);
        try {
            ChannelFuture channelFuture = channelHandlerContext.writeAndFlush(fullHttpResponse);
            this.sourceCodec.upgradeFrom(channelHandlerContext);
            upgradeCodec.upgradeTo(channelHandlerContext, fullHttpRequest);
            channelHandlerContext.pipeline().remove(this);
            channelHandlerContext.fireUserEventTriggered(upgradeEvent.retain());
            channelFuture.addListener(ChannelFutureListener.CLOSE_ON_FAILURE);
        }
        finally {
            upgradeEvent.release();
        }
        return true;
    }

    private static FullHttpResponse createUpgradeResponse(CharSequence charSequence) {
        DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SWITCHING_PROTOCOLS, Unpooled.EMPTY_BUFFER, false);
        defaultFullHttpResponse.headers().add(HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.UPGRADE);
        defaultFullHttpResponse.headers().add(HttpHeaderNames.UPGRADE, (Object)charSequence);
        return defaultFullHttpResponse;
    }

    private static List<CharSequence> splitHeader(CharSequence charSequence) {
        StringBuilder stringBuilder = new StringBuilder(charSequence.length());
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>(4);
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            char c2 = charSequence.charAt(i2);
            if (Character.isWhitespace(c2)) continue;
            if (c2 == ',') {
                arrayList.add(stringBuilder.toString());
                stringBuilder.setLength(0);
                continue;
            }
            stringBuilder.append(c2);
        }
        if (stringBuilder.length() > 0) {
            arrayList.add(stringBuilder.toString());
        }
        return arrayList;
    }

    public static final class UpgradeEvent
    implements ReferenceCounted {
        private final CharSequence protocol;
        private final FullHttpRequest upgradeRequest;

        UpgradeEvent(CharSequence charSequence, FullHttpRequest fullHttpRequest) {
            this.protocol = charSequence;
            this.upgradeRequest = fullHttpRequest;
        }

        public final FullHttpRequest upgradeRequest() {
            return this.upgradeRequest;
        }

        public final int refCnt() {
            return this.upgradeRequest.refCnt();
        }

        public final UpgradeEvent retain() {
            this.upgradeRequest.retain();
            return this;
        }

        public final UpgradeEvent touch() {
            this.upgradeRequest.touch();
            return this;
        }

        public final UpgradeEvent touch(Object object) {
            this.upgradeRequest.touch(object);
            return this;
        }

        public final boolean release() {
            return this.upgradeRequest.release();
        }

        public final String toString() {
            return "UpgradeEvent [protocol=" + this.protocol + ", upgradeRequest=" + this.upgradeRequest + ']';
        }
    }

    public static interface UpgradeCodecFactory {
        public UpgradeCodec newUpgradeCodec(CharSequence var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface UpgradeCodec {
        public Collection<CharSequence> requiredUpgradeHeaders();

        public boolean prepareUpgradeResponse(ChannelHandlerContext var1, FullHttpRequest var2, HttpHeaders var3);

        public void upgradeTo(ChannelHandlerContext var1, FullHttpRequest var2);
    }

    public static interface SourceCodec {
        public void upgradeFrom(ChannelHandlerContext var1);
    }
}

