/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec.http;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.Unpooled;
import com.appoptics.ext.io.netty.channel.ChannelHandlerContext;
import com.appoptics.ext.io.netty.handler.codec.ByteToMessageDecoder;
import com.appoptics.ext.io.netty.handler.codec.DecoderResult;
import com.appoptics.ext.io.netty.handler.codec.PrematureChannelClosureException;
import com.appoptics.ext.io.netty.handler.codec.TooLongFrameException;
import com.appoptics.ext.io.netty.handler.codec.http.DefaultHttpContent;
import com.appoptics.ext.io.netty.handler.codec.http.DefaultLastHttpContent;
import com.appoptics.ext.io.netty.handler.codec.http.HttpContent;
import com.appoptics.ext.io.netty.handler.codec.http.HttpExpectationFailedEvent;
import com.appoptics.ext.io.netty.handler.codec.http.HttpHeaderNames;
import com.appoptics.ext.io.netty.handler.codec.http.HttpHeaderValues;
import com.appoptics.ext.io.netty.handler.codec.http.HttpHeaders;
import com.appoptics.ext.io.netty.handler.codec.http.HttpMessage;
import com.appoptics.ext.io.netty.handler.codec.http.HttpResponse;
import com.appoptics.ext.io.netty.handler.codec.http.HttpResponseStatus;
import com.appoptics.ext.io.netty.handler.codec.http.HttpUtil;
import com.appoptics.ext.io.netty.handler.codec.http.HttpVersion;
import com.appoptics.ext.io.netty.handler.codec.http.LastHttpContent;
import com.appoptics.ext.io.netty.util.ByteProcessor;
import com.appoptics.ext.io.netty.util.internal.AppendableCharSequence;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpObjectDecoder
extends ByteToMessageDecoder {
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");
    private final int maxChunkSize;
    private final boolean chunkedSupported;
    protected final boolean validateHeaders;
    private final boolean allowDuplicateContentLengths;
    private final HeaderParser headerParser;
    private final LineParser lineParser;
    private HttpMessage message;
    private long chunkSize;
    private long contentLength = Long.MIN_VALUE;
    private volatile boolean resetRequested;
    private CharSequence name;
    private CharSequence value;
    private LastHttpContent trailer;
    private State currentState = State.SKIP_CONTROL_CHARS;

    protected HttpObjectDecoder() {
        this(4096, 8192, 8192, true);
    }

    protected HttpObjectDecoder(int n2, int n3, int n4, boolean bl) {
        this(n2, n3, n4, bl, true);
    }

    protected HttpObjectDecoder(int n2, int n3, int n4, boolean bl, boolean bl2) {
        this(n2, n3, n4, bl, bl2, 128);
    }

    protected HttpObjectDecoder(int n2, int n3, int n4, boolean bl, boolean bl2, int n5) {
        this(n2, n3, n4, bl, bl2, n5, false);
    }

    protected HttpObjectDecoder(int n2, int n3, int n4, boolean bl, boolean bl2, int n5, boolean bl3) {
        ObjectUtil.checkPositive(n2, "maxInitialLineLength");
        ObjectUtil.checkPositive(n3, "maxHeaderSize");
        ObjectUtil.checkPositive(n4, "maxChunkSize");
        AppendableCharSequence appendableCharSequence = new AppendableCharSequence(n5);
        this.lineParser = new LineParser(appendableCharSequence, n2);
        this.headerParser = new HeaderParser(appendableCharSequence, n3);
        this.maxChunkSize = n4;
        this.chunkedSupported = bl;
        this.validateHeaders = bl2;
        this.allowDuplicateContentLengths = bl3;
    }

    @Override
    protected void decode(ChannelHandlerContext object, ByteBuf byteBuf, List<Object> list) throws Exception {
        if (this.resetRequested) {
            this.resetNow();
        }
        switch (this.currentState) {
            case SKIP_CONTROL_CHARS: 
            case READ_INITIAL: {
                try {
                    object = this.lineParser.parse(byteBuf);
                    if (object == null) {
                        return;
                    }
                    String[] stringArray = HttpObjectDecoder.splitInitialLine((AppendableCharSequence)object);
                    if (stringArray.length < 3) {
                        this.currentState = State.SKIP_CONTROL_CHARS;
                        return;
                    }
                    this.message = this.createMessage(stringArray);
                    this.currentState = State.READ_HEADER;
                }
                catch (Exception exception) {
                    list.add(this.invalidMessage(byteBuf, exception));
                    return;
                }
            }
            case READ_HEADER: {
                try {
                    object = this.readHeaders(byteBuf);
                    if (object == null) {
                        return;
                    }
                    this.currentState = object;
                    switch (1.$SwitchMap$io$netty$handler$codec$http$HttpObjectDecoder$State[((Enum)object).ordinal()]) {
                        case 1: {
                            list.add(this.message);
                            list.add(LastHttpContent.EMPTY_LAST_CONTENT);
                            this.resetNow();
                            return;
                        }
                        case 2: {
                            if (!this.chunkedSupported) {
                                throw new IllegalArgumentException("Chunked messages not supported");
                            }
                            list.add(this.message);
                            return;
                        }
                    }
                    long l2 = this.contentLength();
                    if (l2 == 0L || l2 == -1L && this.isDecodingRequest()) {
                        list.add(this.message);
                        list.add(LastHttpContent.EMPTY_LAST_CONTENT);
                        this.resetNow();
                        return;
                    }
                    assert (object == State.READ_FIXED_LENGTH_CONTENT || object == State.READ_VARIABLE_LENGTH_CONTENT);
                    list.add(this.message);
                    if (object == State.READ_FIXED_LENGTH_CONTENT) {
                        this.chunkSize = l2;
                    }
                    return;
                }
                catch (Exception exception) {
                    list.add(this.invalidMessage(byteBuf, exception));
                    return;
                }
            }
            case READ_VARIABLE_LENGTH_CONTENT: {
                int n2 = Math.min(byteBuf.readableBytes(), this.maxChunkSize);
                if (n2 > 0) {
                    ByteBuf byteBuf2 = byteBuf.readRetainedSlice(n2);
                    list.add(new DefaultHttpContent(byteBuf2));
                }
                return;
            }
            case READ_FIXED_LENGTH_CONTENT: {
                int n3 = byteBuf.readableBytes();
                if (n3 == 0) {
                    return;
                }
                int n4 = Math.min(n3, this.maxChunkSize);
                if ((long)n4 > this.chunkSize) {
                    n4 = (int)this.chunkSize;
                }
                ByteBuf byteBuf3 = byteBuf.readRetainedSlice(n4);
                this.chunkSize -= (long)n4;
                if (this.chunkSize == 0L) {
                    list.add(new DefaultLastHttpContent(byteBuf3, this.validateHeaders));
                    this.resetNow();
                    return;
                }
                list.add(new DefaultHttpContent(byteBuf3));
                return;
            }
            case READ_CHUNK_SIZE: {
                try {
                    object = this.lineParser.parse(byteBuf);
                    if (object == null) {
                        return;
                    }
                    int n5 = HttpObjectDecoder.getChunkSize(((AppendableCharSequence)object).toString());
                    this.chunkSize = n5;
                    if (n5 == 0) {
                        this.currentState = State.READ_CHUNK_FOOTER;
                        return;
                    }
                    this.currentState = State.READ_CHUNKED_CONTENT;
                }
                catch (Exception exception) {
                    list.add(this.invalidChunk(byteBuf, exception));
                    return;
                }
            }
            case READ_CHUNKED_CONTENT: {
                assert (this.chunkSize <= Integer.MAX_VALUE);
                int n6 = Math.min((int)this.chunkSize, this.maxChunkSize);
                if ((n6 = Math.min(n6, byteBuf.readableBytes())) == 0) {
                    return;
                }
                DefaultHttpContent defaultHttpContent = new DefaultHttpContent(byteBuf.readRetainedSlice(n6));
                this.chunkSize -= (long)n6;
                list.add(defaultHttpContent);
                if (this.chunkSize != 0L) {
                    return;
                }
                this.currentState = State.READ_CHUNK_DELIMITER;
            }
            case READ_CHUNK_DELIMITER: {
                int n7 = byteBuf.writerIndex();
                int n8 = byteBuf.readerIndex();
                while (n7 > n8) {
                    byte by;
                    if ((by = byteBuf.getByte(n8++)) != 10) continue;
                    this.currentState = State.READ_CHUNK_SIZE;
                    break;
                }
                byteBuf.readerIndex(n8);
                return;
            }
            case READ_CHUNK_FOOTER: {
                try {
                    object = this.readTrailingHeaders(byteBuf);
                    if (object == null) {
                        return;
                    }
                    list.add(object);
                    this.resetNow();
                    return;
                }
                catch (Exception exception) {
                    list.add(this.invalidChunk(byteBuf, exception));
                    return;
                }
            }
            case BAD_MESSAGE: {
                ByteBuf byteBuf4 = byteBuf;
                byteBuf4.skipBytes(byteBuf4.readableBytes());
                return;
            }
            case UPGRADED: {
                int n9 = byteBuf.readableBytes();
                if (n9 <= 0) break;
                list.add(byteBuf.readBytes(n9));
            }
        }
    }

    @Override
    protected void decodeLast(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
        super.decodeLast(channelHandlerContext, byteBuf, list);
        if (this.resetRequested) {
            this.resetNow();
        }
        if (this.message != null) {
            boolean bl = HttpUtil.isTransferEncodingChunked(this.message);
            if (this.currentState == State.READ_VARIABLE_LENGTH_CONTENT && !byteBuf.isReadable() && !bl) {
                list.add(LastHttpContent.EMPTY_LAST_CONTENT);
                this.resetNow();
                return;
            }
            if (this.currentState == State.READ_HEADER) {
                list.add(this.invalidMessage(Unpooled.EMPTY_BUFFER, new PrematureChannelClosureException("Connection closed before received headers")));
                this.resetNow();
                return;
            }
            if (!(this.isDecodingRequest() || bl ? true : (bl = this.contentLength() > 0L))) {
                list.add(LastHttpContent.EMPTY_LAST_CONTENT);
            }
            this.resetNow();
        }
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
        if (object instanceof HttpExpectationFailedEvent) {
            switch (this.currentState) {
                case READ_CHUNK_SIZE: 
                case READ_VARIABLE_LENGTH_CONTENT: 
                case READ_FIXED_LENGTH_CONTENT: {
                    this.reset();
                }
            }
        }
        super.userEventTriggered(channelHandlerContext, object);
    }

    protected boolean isContentAlwaysEmpty(HttpMessage httpMessage) {
        if (httpMessage instanceof HttpResponse) {
            int n2 = (httpMessage = (HttpResponse)httpMessage).status().code();
            if (n2 >= 100 && n2 < 200) {
                return n2 != 101 || httpMessage.headers().contains(HttpHeaderNames.SEC_WEBSOCKET_ACCEPT) || !httpMessage.headers().contains(HttpHeaderNames.UPGRADE, HttpHeaderValues.WEBSOCKET, true);
            }
            switch (n2) {
                case 204: 
                case 304: {
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean isSwitchingToNonHttp1Protocol(HttpResponse object) {
        if (object.status().code() != HttpResponseStatus.SWITCHING_PROTOCOLS.code()) {
            return false;
        }
        return (object = object.headers().get(HttpHeaderNames.UPGRADE)) == null || !((String)object).contains(HttpVersion.HTTP_1_0.text()) && !((String)object).contains(HttpVersion.HTTP_1_1.text());
    }

    public void reset() {
        this.resetRequested = true;
    }

    private void resetNow() {
        HttpMessage httpMessage = this.message;
        this.message = null;
        this.name = null;
        this.value = null;
        this.contentLength = Long.MIN_VALUE;
        this.lineParser.reset();
        this.headerParser.reset();
        this.trailer = null;
        if (!this.isDecodingRequest() && (httpMessage = (HttpResponse)httpMessage) != null && this.isSwitchingToNonHttp1Protocol((HttpResponse)httpMessage)) {
            this.currentState = State.UPGRADED;
            return;
        }
        this.resetRequested = false;
        this.currentState = State.SKIP_CONTROL_CHARS;
    }

    private HttpMessage invalidMessage(ByteBuf object, Exception exception) {
        this.currentState = State.BAD_MESSAGE;
        ByteBuf byteBuf = object;
        byteBuf.skipBytes(byteBuf.readableBytes());
        if (this.message == null) {
            this.message = this.createInvalidMessage();
        }
        this.message.setDecoderResult(DecoderResult.failure(exception));
        object = this.message;
        this.message = null;
        return object;
    }

    private HttpContent invalidChunk(ByteBuf referenceCounted, Exception exception) {
        this.currentState = State.BAD_MESSAGE;
        ByteBuf byteBuf = referenceCounted;
        byteBuf.skipBytes(byteBuf.readableBytes());
        referenceCounted = new DefaultLastHttpContent(Unpooled.EMPTY_BUFFER);
        referenceCounted.setDecoderResult(DecoderResult.failure(exception));
        this.message = null;
        this.trailer = null;
        return referenceCounted;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private State readHeaders(ByteBuf iterator) {
        String string;
        HttpMessage httpMessage = this.message;
        HttpHeaders httpHeaders = httpMessage.headers();
        AppendableCharSequence appendableCharSequence = this.headerParser.parse((ByteBuf)((Object)iterator));
        if (appendableCharSequence == null) {
            return null;
        }
        if (appendableCharSequence.length() > 0) {
            AppendableCharSequence appendableCharSequence2;
            do {
                void var4_5;
                char c2 = var4_5.charAtUnsafe(0);
                if (this.name != null && (c2 == ' ' || c2 == '\t')) {
                    String string2 = var4_5.toString().trim();
                    string = String.valueOf(this.value);
                    this.value = string + ' ' + string2;
                } else {
                    if (this.name != null) {
                        httpHeaders.add(this.name, (Object)this.value);
                    }
                    this.splitHeader((AppendableCharSequence)var4_5);
                }
                appendableCharSequence2 = this.headerParser.parse((ByteBuf)((Object)iterator));
                if (appendableCharSequence2 != null) continue;
                return null;
            } while (appendableCharSequence2.length() > 0);
        }
        if (this.name != null) {
            httpHeaders.add(this.name, (Object)this.value);
        }
        this.name = null;
        this.value = null;
        List<String> list = httpHeaders.getAll(HttpHeaderNames.CONTENT_LENGTH);
        if (!list.isEmpty()) {
            boolean bl = list.size() > 1 || list.get(0).indexOf(44) >= 0;
            if (bl && httpMessage.protocolVersion() == HttpVersion.HTTP_1_1) {
                if (!this.allowDuplicateContentLengths) throw new IllegalArgumentException("Multiple Content-Length values found: " + list);
                string = null;
                for (String string3 : list) {
                    String[] stringArray;
                    String[] stringArray2 = stringArray = COMMA_PATTERN.split(string3, -1);
                    int n2 = stringArray.length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        String string4 = stringArray2[i2];
                        string4 = string4.trim();
                        if (string == null) {
                            string = string4;
                            continue;
                        }
                        if (string4.equals(string)) continue;
                        throw new IllegalArgumentException("Multiple Content-Length values found: " + list);
                    }
                }
                httpHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)string);
                this.contentLength = Long.parseLong(string);
            } else {
                this.contentLength = Long.parseLong(list.get(0));
            }
        }
        if (this.isContentAlwaysEmpty(httpMessage)) {
            HttpUtil.setTransferEncodingChunked(httpMessage, false);
            return State.SKIP_CONTROL_CHARS;
        }
        if (HttpUtil.isTransferEncodingChunked(httpMessage)) {
            if (list.isEmpty() || httpMessage.protocolVersion() != HttpVersion.HTTP_1_1) return State.READ_CHUNK_SIZE;
            this.handleTransferEncodingChunkedWithContentLength(httpMessage);
            return State.READ_CHUNK_SIZE;
        }
        if (this.contentLength() < 0L) return State.READ_VARIABLE_LENGTH_CONTENT;
        return State.READ_FIXED_LENGTH_CONTENT;
    }

    protected void handleTransferEncodingChunkedWithContentLength(HttpMessage httpMessage) {
        httpMessage.headers().remove(HttpHeaderNames.CONTENT_LENGTH);
        this.contentLength = Long.MIN_VALUE;
    }

    private long contentLength() {
        if (this.contentLength == Long.MIN_VALUE) {
            this.contentLength = HttpUtil.getContentLength(this.message, -1L);
        }
        return this.contentLength;
    }

    private LastHttpContent readTrailingHeaders(ByteBuf byteBuf) {
        CharSequence charSequence = this.headerParser.parse(byteBuf);
        if (charSequence == null) {
            return null;
        }
        LastHttpContent lastHttpContent = this.trailer;
        if (charSequence.length() == 0 && lastHttpContent == null) {
            return LastHttpContent.EMPTY_LAST_CONTENT;
        }
        CharSequence charSequence2 = null;
        if (lastHttpContent == null) {
            lastHttpContent = this.trailer = new DefaultLastHttpContent(Unpooled.EMPTY_BUFFER, this.validateHeaders);
        }
        while (charSequence.length() > 0) {
            List<String> list;
            char c2 = charSequence.charAtUnsafe(0);
            if (charSequence2 != null && (c2 == ' ' || c2 == '\t')) {
                list = lastHttpContent.trailingHeaders().getAll(charSequence2);
                if (!list.isEmpty()) {
                    int n2 = list.size() - 1;
                    charSequence = charSequence.toString().trim();
                    String string = (String)list.get(n2);
                    list.set(n2, string + (String)charSequence);
                }
            } else {
                this.splitHeader((AppendableCharSequence)charSequence);
                list = this.name;
                if (!(HttpHeaderNames.CONTENT_LENGTH.contentEqualsIgnoreCase((CharSequence)((Object)list)) || HttpHeaderNames.TRANSFER_ENCODING.contentEqualsIgnoreCase((CharSequence)((Object)list)) || HttpHeaderNames.TRAILER.contentEqualsIgnoreCase((CharSequence)((Object)list)))) {
                    lastHttpContent.trailingHeaders().add((CharSequence)((Object)list), (Object)this.value);
                }
                charSequence2 = this.name;
                this.name = null;
                this.value = null;
            }
            if ((charSequence = this.headerParser.parse(byteBuf)) != null) continue;
            return null;
        }
        this.trailer = null;
        return lastHttpContent;
    }

    protected abstract boolean isDecodingRequest();

    protected abstract HttpMessage createMessage(String[] var1) throws Exception;

    protected abstract HttpMessage createInvalidMessage();

    private static int getChunkSize(String string) {
        string = string.trim();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 != ';' && !Character.isWhitespace(c2) && !Character.isISOControl(c2)) continue;
            string = string.substring(0, i2);
            break;
        }
        return Integer.parseInt(string, 16);
    }

    private static String[] splitInitialLine(AppendableCharSequence appendableCharSequence) {
        int n2 = HttpObjectDecoder.findNonSPLenient(appendableCharSequence, 0);
        int n3 = HttpObjectDecoder.findSPLenient(appendableCharSequence, n2);
        int n4 = HttpObjectDecoder.findNonSPLenient(appendableCharSequence, n3);
        int n5 = HttpObjectDecoder.findSPLenient(appendableCharSequence, n4);
        int n6 = HttpObjectDecoder.findNonSPLenient(appendableCharSequence, n5);
        int n7 = HttpObjectDecoder.findEndOfString(appendableCharSequence);
        return new String[]{appendableCharSequence.subStringUnsafe(n2, n3), appendableCharSequence.subStringUnsafe(n4, n5), n6 < n7 ? appendableCharSequence.subStringUnsafe(n6, n7) : ""};
    }

    private void splitHeader(AppendableCharSequence appendableCharSequence) {
        int n2;
        int n3;
        int n4;
        int n5 = appendableCharSequence.length();
        for (n4 = n2 = HttpObjectDecoder.findNonWhitespace(appendableCharSequence, 0, false); n4 < n5 && (n3 = appendableCharSequence.charAtUnsafe(n4)) != 58 && (this.isDecodingRequest() || !HttpObjectDecoder.isOWS((char)n3)); ++n4) {
        }
        if (n4 == n5) {
            throw new IllegalArgumentException("No colon found");
        }
        for (n3 = n4; n3 < n5; ++n3) {
            if (appendableCharSequence.charAtUnsafe(n3) != ':') continue;
            ++n3;
            break;
        }
        this.name = appendableCharSequence.subStringUnsafe(n2, n4);
        n2 = HttpObjectDecoder.findNonWhitespace(appendableCharSequence, n3, true);
        if (n2 == n5) {
            this.value = "";
            return;
        }
        n5 = HttpObjectDecoder.findEndOfString(appendableCharSequence);
        this.value = appendableCharSequence.subStringUnsafe(n2, n5);
    }

    private static int findNonSPLenient(AppendableCharSequence appendableCharSequence, int n2) {
        while (n2 < appendableCharSequence.length()) {
            char c2 = appendableCharSequence.charAtUnsafe(n2);
            if (!HttpObjectDecoder.isSPLenient(c2)) {
                if (Character.isWhitespace(c2)) {
                    throw new IllegalArgumentException("Invalid separator");
                }
                return n2;
            }
            ++n2;
        }
        return appendableCharSequence.length();
    }

    private static int findSPLenient(AppendableCharSequence appendableCharSequence, int n2) {
        while (n2 < appendableCharSequence.length()) {
            if (HttpObjectDecoder.isSPLenient(appendableCharSequence.charAtUnsafe(n2))) {
                return n2;
            }
            ++n2;
        }
        return appendableCharSequence.length();
    }

    private static boolean isSPLenient(char c2) {
        return c2 == ' ' || c2 == '\t' || c2 == '\u000b' || c2 == '\f' || c2 == '\r';
    }

    private static int findNonWhitespace(AppendableCharSequence appendableCharSequence, int n2, boolean bl) {
        while (n2 < appendableCharSequence.length()) {
            char c2 = appendableCharSequence.charAtUnsafe(n2);
            if (!Character.isWhitespace(c2)) {
                return n2;
            }
            if (bl && !HttpObjectDecoder.isOWS(c2)) {
                throw new IllegalArgumentException("Invalid separator, only a single space or horizontal tab allowed, but received a '" + c2 + "'");
            }
            ++n2;
        }
        return appendableCharSequence.length();
    }

    private static int findEndOfString(AppendableCharSequence appendableCharSequence) {
        for (int i2 = appendableCharSequence.length() - 1; i2 > 0; --i2) {
            if (Character.isWhitespace(appendableCharSequence.charAtUnsafe(i2))) continue;
            return i2 + 1;
        }
        return 0;
    }

    private static boolean isOWS(char c2) {
        return c2 == ' ' || c2 == '\t';
    }

    private final class LineParser
    extends HeaderParser {
        LineParser(AppendableCharSequence appendableCharSequence, int n2) {
            super(appendableCharSequence, n2);
        }

        public final AppendableCharSequence parse(ByteBuf byteBuf) {
            this.reset();
            return super.parse(byteBuf);
        }

        public final boolean process(byte by) throws Exception {
            if (HttpObjectDecoder.this.currentState == State.SKIP_CONTROL_CHARS) {
                char c2 = (char)(by & 0xFF);
                if (Character.isISOControl(c2) || Character.isWhitespace(c2)) {
                    this.increaseCount();
                    return true;
                }
                HttpObjectDecoder.this.currentState = State.READ_INITIAL;
            }
            return super.process(by);
        }

        protected final TooLongFrameException newException(int n2) {
            return new TooLongFrameException("An HTTP line is larger than " + n2 + " bytes.");
        }
    }

    private static class HeaderParser
    implements ByteProcessor {
        private final AppendableCharSequence seq;
        private final int maxLength;
        private int size;

        HeaderParser(AppendableCharSequence appendableCharSequence, int n2) {
            this.seq = appendableCharSequence;
            this.maxLength = n2;
        }

        public AppendableCharSequence parse(ByteBuf byteBuf) {
            int n2 = this.size;
            this.seq.reset();
            int n3 = byteBuf.forEachByte(this);
            if (n3 == -1) {
                this.size = n2;
                return null;
            }
            byteBuf.readerIndex(n3 + 1);
            return this.seq;
        }

        public void reset() {
            this.size = 0;
        }

        public boolean process(byte by) throws Exception {
            char c2 = (char)(by & 0xFF);
            by = (byte)c2;
            if (c2 == '\n') {
                int n2 = this.seq.length();
                by = (byte)n2;
                if (n2 > 0 && this.seq.charAtUnsafe(by - 1) == '\r') {
                    --this.size;
                    this.seq.setLength(by - 1);
                }
                return false;
            }
            this.increaseCount();
            this.seq.append((char)by);
            return true;
        }

        protected final void increaseCount() {
            if (++this.size > this.maxLength) {
                HeaderParser headerParser = this;
                throw headerParser.newException(headerParser.maxLength);
            }
        }

        protected TooLongFrameException newException(int n2) {
            return new TooLongFrameException("HTTP header is larger than " + n2 + " bytes.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        SKIP_CONTROL_CHARS,
        READ_INITIAL,
        READ_HEADER,
        READ_VARIABLE_LENGTH_CONTENT,
        READ_FIXED_LENGTH_CONTENT,
        READ_CHUNK_SIZE,
        READ_CHUNKED_CONTENT,
        READ_CHUNK_DELIMITER,
        READ_CHUNK_FOOTER,
        BAD_MESSAGE,
        UPGRADED;

    }
}

