/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec.http;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.channel.ChannelHandlerContext;
import com.appoptics.ext.io.netty.channel.CombinedChannelDuplexHandler;
import com.appoptics.ext.io.netty.handler.codec.PrematureChannelClosureException;
import com.appoptics.ext.io.netty.handler.codec.http.HttpClientUpgradeHandler;
import com.appoptics.ext.io.netty.handler.codec.http.HttpMessage;
import com.appoptics.ext.io.netty.handler.codec.http.HttpMethod;
import com.appoptics.ext.io.netty.handler.codec.http.HttpRequest;
import com.appoptics.ext.io.netty.handler.codec.http.HttpRequestEncoder;
import com.appoptics.ext.io.netty.handler.codec.http.HttpResponse;
import com.appoptics.ext.io.netty.handler.codec.http.HttpResponseDecoder;
import com.appoptics.ext.io.netty.handler.codec.http.LastHttpContent;
import com.appoptics.ext.io.netty.util.ReferenceCountUtil;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HttpClientCodec
extends CombinedChannelDuplexHandler<HttpResponseDecoder, HttpRequestEncoder>
implements HttpClientUpgradeHandler.SourceCodec {
    private final Queue<HttpMethod> queue = new ArrayDeque<HttpMethod>();
    private final boolean parseHttpAfterConnectRequest;
    private boolean done;
    private final AtomicLong requestResponseCounter = new AtomicLong();
    private final boolean failOnMissingResponse;

    public HttpClientCodec() {
        this(4096, 8192, 8192, false);
    }

    public HttpClientCodec(int n2, int n3, int n4, boolean bl) {
        this(n2, n3, n4, bl, true);
    }

    public HttpClientCodec(int n2, int n3, int n4, boolean bl, boolean bl2) {
        this(n2, n3, n4, bl, bl2, false);
    }

    public HttpClientCodec(int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
        this.init(new Decoder(n2, n3, n4, bl2), new Encoder());
        this.failOnMissingResponse = bl;
        this.parseHttpAfterConnectRequest = bl3;
    }

    @Override
    public final void prepareUpgradeFrom(ChannelHandlerContext channelHandlerContext) {
        ((Encoder)this.outboundHandler()).upgraded = true;
    }

    @Override
    public final void upgradeFrom(ChannelHandlerContext channelOutboundInvoker) {
        channelOutboundInvoker = channelOutboundInvoker.pipeline();
        channelOutboundInvoker.remove(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Decoder
    extends HttpResponseDecoder {
        Decoder(int n2, int n3, int n4, boolean bl) {
            super(n2, n3, n4, bl);
        }

        @Override
        protected final void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
            if (HttpClientCodec.this.done) {
                int n2 = this.actualReadableBytes();
                if (n2 == 0) {
                    return;
                }
                list.add(byteBuf.readBytes(n2));
                return;
            }
            int n3 = list.size();
            super.decode(channelHandlerContext, byteBuf, list);
            if (HttpClientCodec.this.failOnMissingResponse) {
                int n4 = list.size();
                for (int i2 = n3; i2 < n4; ++i2) {
                    this.decrement(list.get(i2));
                }
            }
        }

        private void decrement(Object object) {
            if (object == null) {
                return;
            }
            if (object instanceof LastHttpContent) {
                HttpClientCodec.this.requestResponseCounter.decrementAndGet();
            }
        }

        @Override
        protected final boolean isContentAlwaysEmpty(HttpMessage httpMessage) {
            HttpMethod httpMethod = (HttpMethod)HttpClientCodec.this.queue.poll();
            int n2 = ((HttpResponse)httpMessage).status().code();
            if (n2 >= 100 && n2 < 200) {
                return super.isContentAlwaysEmpty(httpMessage);
            }
            if (httpMethod != null) {
                char c2 = httpMethod.name().charAt(0);
                switch (c2) {
                    case 'H': {
                        if (!HttpMethod.HEAD.equals(httpMethod)) break;
                        return true;
                    }
                    case 'C': {
                        if (n2 != 200 || !HttpMethod.CONNECT.equals(httpMethod)) break;
                        if (!HttpClientCodec.this.parseHttpAfterConnectRequest) {
                            HttpClientCodec.this.done = true;
                            HttpClientCodec.this.queue.clear();
                        }
                        return true;
                    }
                }
            }
            return super.isContentAlwaysEmpty(httpMessage);
        }

        @Override
        public final void channelInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
            long l2;
            super.channelInactive(channelHandlerContext);
            if (HttpClientCodec.this.failOnMissingResponse && (l2 = HttpClientCodec.this.requestResponseCounter.get()) > 0L) {
                channelHandlerContext.fireExceptionCaught(new PrematureChannelClosureException("channel gone inactive with " + l2 + " missing response(s)"));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Encoder
    extends HttpRequestEncoder {
        boolean upgraded;

        private Encoder() {
        }

        @Override
        protected final void encode(ChannelHandlerContext channelHandlerContext, Object object, List<Object> list) throws Exception {
            if (this.upgraded) {
                list.add(ReferenceCountUtil.retain(object));
                return;
            }
            if (object instanceof HttpRequest) {
                HttpClientCodec.this.queue.offer(((HttpRequest)object).method());
            }
            super.encode(channelHandlerContext, object, list);
            if (HttpClientCodec.this.failOnMissingResponse && !HttpClientCodec.this.done && object instanceof LastHttpContent) {
                HttpClientCodec.this.requestResponseCounter.incrementAndGet();
            }
        }
    }
}

