/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec.http;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.Unpooled;
import com.appoptics.ext.io.netty.handler.codec.DefaultHeaders;
import com.appoptics.ext.io.netty.handler.codec.http.DefaultHttpContent;
import com.appoptics.ext.io.netty.handler.codec.http.DefaultHttpHeaders;
import com.appoptics.ext.io.netty.handler.codec.http.HttpHeaderNames;
import com.appoptics.ext.io.netty.handler.codec.http.HttpHeaders;
import com.appoptics.ext.io.netty.handler.codec.http.LastHttpContent;
import com.appoptics.ext.io.netty.util.internal.StringUtil;
import java.util.Map;

public class DefaultLastHttpContent
extends DefaultHttpContent
implements LastHttpContent {
    private final HttpHeaders trailingHeaders;
    private final boolean validateHeaders;

    public DefaultLastHttpContent() {
        this(Unpooled.buffer(0));
    }

    public DefaultLastHttpContent(ByteBuf byteBuf) {
        this(byteBuf, true);
    }

    public DefaultLastHttpContent(ByteBuf byteBuf, boolean bl) {
        super(byteBuf);
        this.trailingHeaders = new TrailingHttpHeaders(bl);
        this.validateHeaders = bl;
    }

    public LastHttpContent retain() {
        super.retain();
        return this;
    }

    public LastHttpContent touch() {
        super.touch();
        return this;
    }

    public LastHttpContent touch(Object object) {
        super.touch(object);
        return this;
    }

    public HttpHeaders trailingHeaders() {
        return this.trailingHeaders;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append(StringUtil.NEWLINE);
        this.appendHeaders(stringBuilder);
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2.setLength(stringBuilder2.length() - StringUtil.NEWLINE.length());
        return stringBuilder.toString();
    }

    private void appendHeaders(StringBuilder stringBuilder) {
        for (Map.Entry<String, String> entry : this.trailingHeaders()) {
            stringBuilder.append(entry.getKey());
            stringBuilder.append(": ");
            stringBuilder.append(entry.getValue());
            stringBuilder.append(StringUtil.NEWLINE);
        }
    }

    private static final class TrailingHttpHeaders
    extends DefaultHttpHeaders {
        private static final DefaultHeaders.NameValidator<CharSequence> TrailerNameValidator = new DefaultHeaders.NameValidator<CharSequence>(){

            @Override
            public final void validateName(CharSequence charSequence) {
                DefaultHttpHeaders.HttpNameValidator.validateName(charSequence);
                if (HttpHeaderNames.CONTENT_LENGTH.contentEqualsIgnoreCase(charSequence) || HttpHeaderNames.TRANSFER_ENCODING.contentEqualsIgnoreCase(charSequence) || HttpHeaderNames.TRAILER.contentEqualsIgnoreCase(charSequence)) {
                    throw new IllegalArgumentException("prohibited trailing header: " + charSequence);
                }
            }
        };

        TrailingHttpHeaders(boolean bl) {
            boolean bl2 = bl;
            super(bl2, bl2 ? TrailerNameValidator : DefaultHeaders.NameValidator.NOT_NULL);
        }
    }
}

