/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec.http;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.handler.codec.http.DefaultHttpHeaders;
import com.appoptics.ext.io.netty.handler.codec.http.DefaultHttpRequest;
import com.appoptics.ext.io.netty.handler.codec.http.FullHttpRequest;
import com.appoptics.ext.io.netty.handler.codec.http.HttpHeaders;
import com.appoptics.ext.io.netty.handler.codec.http.HttpMessageUtil;
import com.appoptics.ext.io.netty.handler.codec.http.HttpMethod;
import com.appoptics.ext.io.netty.handler.codec.http.HttpVersion;
import com.appoptics.ext.io.netty.util.IllegalReferenceCountException;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;

public class DefaultFullHttpRequest
extends DefaultHttpRequest
implements FullHttpRequest {
    private final ByteBuf content;
    private final HttpHeaders trailingHeader;
    private int hash;

    public DefaultFullHttpRequest(HttpVersion httpVersion, HttpMethod httpMethod, String string, ByteBuf byteBuf, boolean bl) {
        super(httpVersion, httpMethod, string, bl);
        this.content = ObjectUtil.checkNotNull(byteBuf, "content");
        this.trailingHeader = new DefaultHttpHeaders(bl);
    }

    public HttpHeaders trailingHeaders() {
        return this.trailingHeader;
    }

    public ByteBuf content() {
        return this.content;
    }

    public int refCnt() {
        return this.content.refCnt();
    }

    public FullHttpRequest retain() {
        this.content.retain();
        return this;
    }

    public FullHttpRequest touch() {
        this.content.touch();
        return this;
    }

    public FullHttpRequest touch(Object object) {
        this.content.touch(object);
        return this;
    }

    public boolean release() {
        return this.content.release();
    }

    public int hashCode() {
        int n2 = this.hash;
        if (n2 == 0) {
            if (this.content().refCnt() != 0) {
                try {
                    n2 = 31 + this.content().hashCode();
                }
                catch (IllegalReferenceCountException illegalReferenceCountException) {}
            }
            n2 = 31;
            n2 = n2 * 31 + this.trailingHeaders().hashCode();
            this.hash = n2 = n2 * 31 + super.hashCode();
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DefaultFullHttpRequest)) {
            return false;
        }
        return super.equals(object = (DefaultFullHttpRequest)object) && this.content().equals(((DefaultFullHttpRequest)object).content()) && this.trailingHeaders().equals(((DefaultFullHttpRequest)object).trailingHeaders());
    }

    public String toString() {
        return HttpMessageUtil.appendFullRequest(new StringBuilder(256), this).toString();
    }
}

