/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec;

import com.appoptics.ext.io.netty.util.concurrent.FastThreadLocal;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import java.util.BitSet;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public final class DateFormatter {
    private static final BitSet DELIMITERS;
    private static final String[] DAY_OF_WEEK_TO_SHORT_NAME;
    private static final String[] CALENDAR_MONTH_TO_SHORT_NAME;
    private static final FastThreadLocal<DateFormatter> INSTANCES;
    private final GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
    private final StringBuilder sb = new StringBuilder(29);
    private boolean timeFound;
    private int hours;
    private int minutes;
    private int seconds;
    private boolean dayOfMonthFound;
    private int dayOfMonth;
    private boolean monthFound;
    private int month;
    private boolean yearFound;
    private int year;

    public static String format(Date date) {
        return DateFormatter.formatter().format0(ObjectUtil.checkNotNull(date, "date"));
    }

    private static DateFormatter formatter() {
        DateFormatter dateFormatter = INSTANCES.get();
        dateFormatter.reset();
        return dateFormatter;
    }

    private DateFormatter() {
        this.reset();
    }

    public final void reset() {
        this.timeFound = false;
        this.hours = -1;
        this.minutes = -1;
        this.seconds = -1;
        this.dayOfMonthFound = false;
        this.dayOfMonth = -1;
        this.monthFound = false;
        this.month = -1;
        this.yearFound = false;
        this.year = -1;
        this.cal.clear();
        this.sb.setLength(0);
    }

    private String format0(Date date) {
        this.append0(date, this.sb);
        return this.sb.toString();
    }

    private StringBuilder append0(Date date, StringBuilder stringBuilder) {
        this.cal.setTime(date);
        stringBuilder.append(DAY_OF_WEEK_TO_SHORT_NAME[this.cal.get(7) - 1]).append(", ");
        DateFormatter.appendZeroLeftPadded(this.cal.get(5), stringBuilder).append(' ');
        stringBuilder.append(CALENDAR_MONTH_TO_SHORT_NAME[this.cal.get(2)]).append(' ');
        stringBuilder.append(this.cal.get(1)).append(' ');
        DateFormatter.appendZeroLeftPadded(this.cal.get(11), stringBuilder).append(':');
        DateFormatter.appendZeroLeftPadded(this.cal.get(12), stringBuilder).append(':');
        return DateFormatter.appendZeroLeftPadded(this.cal.get(13), stringBuilder).append(" GMT");
    }

    private static StringBuilder appendZeroLeftPadded(int n2, StringBuilder stringBuilder) {
        if (n2 < 10) {
            stringBuilder.append('0');
        }
        return stringBuilder.append(n2);
    }

    static {
        int n2;
        DELIMITERS = new BitSet();
        DELIMITERS.set(9);
        for (n2 = 32; n2 <= 47; n2 = (int)((char)(n2 + 1))) {
            DELIMITERS.set(n2);
        }
        for (n2 = 59; n2 <= 64; n2 = (int)((char)(n2 + 1))) {
            DELIMITERS.set(n2);
        }
        for (n2 = 91; n2 <= 96; n2 = (int)((char)(n2 + 1))) {
            DELIMITERS.set(n2);
        }
        for (n2 = 123; n2 <= 126; n2 = (int)((char)(n2 + 1))) {
            DELIMITERS.set(n2);
        }
        DAY_OF_WEEK_TO_SHORT_NAME = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
        CALENDAR_MONTH_TO_SHORT_NAME = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        INSTANCES = new FastThreadLocal<DateFormatter>(){

            @Override
            protected final DateFormatter initialValue() {
                return new DateFormatter();
            }
        };
    }
}

