/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.channel.socket.nio;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.channel.Channel;
import com.appoptics.ext.io.netty.channel.ChannelException;
import com.appoptics.ext.io.netty.channel.ChannelFuture;
import com.appoptics.ext.io.netty.channel.ChannelOption;
import com.appoptics.ext.io.netty.channel.ChannelOutboundBuffer;
import com.appoptics.ext.io.netty.channel.ChannelPromise;
import com.appoptics.ext.io.netty.channel.FileRegion;
import com.appoptics.ext.io.netty.channel.RecvByteBufAllocator;
import com.appoptics.ext.io.netty.channel.nio.AbstractNioByteChannel;
import com.appoptics.ext.io.netty.channel.nio.AbstractNioChannel;
import com.appoptics.ext.io.netty.channel.nio.NioEventLoop;
import com.appoptics.ext.io.netty.channel.socket.DefaultSocketChannelConfig;
import com.appoptics.ext.io.netty.channel.socket.ServerSocketChannel;
import com.appoptics.ext.io.netty.channel.socket.SocketChannel;
import com.appoptics.ext.io.netty.channel.socket.SocketChannelConfig;
import com.appoptics.ext.io.netty.channel.socket.nio.NioChannelOption;
import com.appoptics.ext.io.netty.util.concurrent.GlobalEventExecutor;
import com.appoptics.ext.io.netty.util.internal.PlatformDependent;
import com.appoptics.ext.io.netty.util.internal.SocketUtils;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.spi.SelectorProvider;
import java.util.concurrent.Executor;

public class NioSocketChannel
extends AbstractNioByteChannel
implements SocketChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NioSocketChannel.class);
    private static final SelectorProvider DEFAULT_SELECTOR_PROVIDER = SelectorProvider.provider();
    private final SocketChannelConfig config;

    private static java.nio.channels.SocketChannel newSocket(SelectorProvider selectorProvider) {
        try {
            return selectorProvider.openSocketChannel();
        }
        catch (IOException iOException) {
            throw new ChannelException("Failed to open a socket.", iOException);
        }
    }

    public NioSocketChannel() {
        this(DEFAULT_SELECTOR_PROVIDER);
    }

    public NioSocketChannel(SelectorProvider selectorProvider) {
        this(NioSocketChannel.newSocket(selectorProvider));
    }

    public NioSocketChannel(java.nio.channels.SocketChannel socketChannel) {
        this(null, socketChannel);
    }

    public NioSocketChannel(Channel channel, java.nio.channels.SocketChannel socketChannel) {
        super(channel, socketChannel);
        NioSocketChannel nioSocketChannel = this;
        this.config = nioSocketChannel.new NioSocketChannelConfig(nioSocketChannel, socketChannel.socket());
    }

    public ServerSocketChannel parent() {
        return (ServerSocketChannel)super.parent();
    }

    public SocketChannelConfig config() {
        return this.config;
    }

    protected java.nio.channels.SocketChannel javaChannel() {
        return (java.nio.channels.SocketChannel)super.javaChannel();
    }

    public boolean isActive() {
        java.nio.channels.SocketChannel socketChannel = this.javaChannel();
        return socketChannel.isOpen() && socketChannel.isConnected();
    }

    public boolean isInputShutdown() {
        return this.javaChannel().socket().isInputShutdown() || !this.isActive();
    }

    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    protected final void doShutdownOutput() throws Exception {
        if (PlatformDependent.javaVersion() >= 7) {
            this.javaChannel().shutdownOutput();
            return;
        }
        this.javaChannel().socket().shutdownOutput();
    }

    public ChannelFuture shutdownInput() {
        NioSocketChannel nioSocketChannel = this;
        return nioSocketChannel.shutdownInput(nioSocketChannel.newPromise());
    }

    protected boolean isInputShutdown0() {
        return this.isInputShutdown();
    }

    public ChannelFuture shutdownInput(final ChannelPromise channelPromise) {
        NioEventLoop nioEventLoop = this.eventLoop();
        if (nioEventLoop.inEventLoop()) {
            this.shutdownInput0(channelPromise);
        } else {
            nioEventLoop.execute(new Runnable(){

                public void run() {
                    NioSocketChannel.this.shutdownInput0(channelPromise);
                }
            });
        }
        return channelPromise;
    }

    private void shutdownInput0(ChannelPromise channelPromise) {
        try {
            this.shutdownInput0();
            channelPromise.setSuccess();
            return;
        }
        catch (Throwable throwable) {
            channelPromise.setFailure(throwable);
            return;
        }
    }

    private void shutdownInput0() throws Exception {
        if (PlatformDependent.javaVersion() >= 7) {
            this.javaChannel().shutdownInput();
            return;
        }
        this.javaChannel().socket().shutdownInput();
    }

    protected SocketAddress localAddress0() {
        return this.javaChannel().socket().getLocalSocketAddress();
    }

    protected SocketAddress remoteAddress0() {
        return this.javaChannel().socket().getRemoteSocketAddress();
    }

    private void doBind0(SocketAddress socketAddress) throws Exception {
        if (PlatformDependent.javaVersion() >= 7) {
            SocketUtils.bind(this.javaChannel(), socketAddress);
            return;
        }
        SocketUtils.bind(this.javaChannel().socket(), socketAddress);
    }

    protected boolean doConnect(SocketAddress socketAddress, SocketAddress socketAddress2) throws Exception {
        if (socketAddress2 != null) {
            this.doBind0(socketAddress2);
        }
        boolean bl = false;
        try {
            boolean bl2 = SocketUtils.connect(this.javaChannel(), socketAddress);
            if (!bl2) {
                this.selectionKey().interestOps(8);
            }
            bl = true;
            return bl2;
        }
        catch (Throwable throwable) {
            if (!bl) {
                this.doClose();
            }
            throw throwable;
        }
    }

    protected void doFinishConnect() throws Exception {
        if (!this.javaChannel().finishConnect()) {
            throw new Error();
        }
    }

    protected void doDisconnect() throws Exception {
        this.doClose();
    }

    protected void doClose() throws Exception {
        super.doClose();
        this.javaChannel().close();
    }

    protected int doReadBytes(ByteBuf byteBuf) throws Exception {
        RecvByteBufAllocator.Handle handle = this.unsafe().recvBufAllocHandle();
        handle.attemptedBytesRead(byteBuf.writableBytes());
        return byteBuf.writeBytes(this.javaChannel(), handle.attemptedBytesRead());
    }

    protected int doWriteBytes(ByteBuf byteBuf) throws Exception {
        int n2 = byteBuf.readableBytes();
        return byteBuf.readBytes(this.javaChannel(), n2);
    }

    protected long doWriteFileRegion(FileRegion fileRegion) throws Exception {
        long l2 = fileRegion.transferred();
        return fileRegion.transferTo(this.javaChannel(), l2);
    }

    private void adjustMaxBytesPerGatheringWrite(int n2, int n3, int n4) {
        if (n2 == n3) {
            if (n2 << 1 > n4) {
                ((NioSocketChannelConfig)this.config).setMaxBytesPerGatheringWrite(n2 << 1);
                return;
            }
        } else if (n2 > 4096 && n3 < n2 >>> 1) {
            ((NioSocketChannelConfig)this.config).setMaxBytesPerGatheringWrite(n2 >>> 1);
        }
    }

    protected void doWrite(ChannelOutboundBuffer channelOutboundBuffer) throws Exception {
        java.nio.channels.SocketChannel socketChannel = this.javaChannel();
        int n2 = this.config().getWriteSpinCount();
        do {
            if (channelOutboundBuffer.isEmpty()) {
                this.clearOpWrite();
                return;
            }
            int n3 = ((NioSocketChannelConfig)this.config).getMaxBytesPerGatheringWrite();
            ByteBuffer[] byteBufferArray = channelOutboundBuffer.nioBuffers(1024, n3);
            int n4 = channelOutboundBuffer.nioBufferCount();
            switch (n4) {
                case 0: {
                    n2 -= this.doWrite0(channelOutboundBuffer);
                    break;
                }
                case 1: {
                    ByteBuffer byteBuffer = byteBufferArray[0];
                    int n5 = byteBuffer.remaining();
                    int n6 = socketChannel.write(byteBuffer);
                    if (n6 <= 0) {
                        this.incompleteWrite(true);
                        return;
                    }
                    this.adjustMaxBytesPerGatheringWrite(n5, n6, n3);
                    channelOutboundBuffer.removeBytes(n6);
                    --n2;
                    break;
                }
                default: {
                    long l2 = channelOutboundBuffer.nioBufferSize();
                    long l3 = socketChannel.write(byteBufferArray, 0, n4);
                    if (l3 <= 0L) {
                        this.incompleteWrite(true);
                        return;
                    }
                    this.adjustMaxBytesPerGatheringWrite((int)l2, (int)l3, n3);
                    channelOutboundBuffer.removeBytes(l3);
                    --n2;
                }
            }
        } while (n2 > 0);
        this.incompleteWrite(n2 < 0);
    }

    protected AbstractNioChannel.AbstractNioUnsafe newUnsafe() {
        return new NioSocketChannelUnsafe();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class NioSocketChannelConfig
    extends DefaultSocketChannelConfig {
        private volatile int maxBytesPerGatheringWrite;

        private NioSocketChannelConfig(NioSocketChannel nioSocketChannel2, Socket socket) {
            super(nioSocketChannel2, socket);
            this.maxBytesPerGatheringWrite = Integer.MAX_VALUE;
            this.calculateMaxBytesPerGatheringWrite();
        }

        @Override
        protected final void autoReadCleared() {
            NioSocketChannel.this.clearReadPending();
        }

        @Override
        public final NioSocketChannelConfig setSendBufferSize(int n2) {
            super.setSendBufferSize(n2);
            this.calculateMaxBytesPerGatheringWrite();
            return this;
        }

        @Override
        public final <T> boolean setOption(ChannelOption<T> channelOption, T t2) {
            if (PlatformDependent.javaVersion() >= 7 && channelOption instanceof NioChannelOption) {
                return NioChannelOption.setOption(this.jdkChannel(), (NioChannelOption)channelOption, t2);
            }
            return super.setOption(channelOption, t2);
        }

        @Override
        public final <T> T getOption(ChannelOption<T> channelOption) {
            if (PlatformDependent.javaVersion() >= 7 && channelOption instanceof NioChannelOption) {
                return NioChannelOption.getOption(this.jdkChannel(), (NioChannelOption)channelOption);
            }
            return super.getOption(channelOption);
        }

        final void setMaxBytesPerGatheringWrite(int n2) {
            this.maxBytesPerGatheringWrite = n2;
        }

        final int getMaxBytesPerGatheringWrite() {
            return this.maxBytesPerGatheringWrite;
        }

        private void calculateMaxBytesPerGatheringWrite() {
            int n2 = this.getSendBufferSize() << 1;
            if (n2 > 0) {
                this.setMaxBytesPerGatheringWrite(n2);
            }
        }

        private java.nio.channels.SocketChannel jdkChannel() {
            return ((NioSocketChannel)this.channel).javaChannel();
        }
    }

    private final class NioSocketChannelUnsafe
    extends AbstractNioByteChannel.NioByteUnsafe {
        private NioSocketChannelUnsafe() {
        }

        protected final Executor prepareToClose() {
            try {
                if (NioSocketChannel.this.javaChannel().isOpen() && NioSocketChannel.this.config().getSoLinger() > 0) {
                    NioSocketChannel.this.doDeregister();
                    return GlobalEventExecutor.INSTANCE;
                }
            }
            catch (Throwable throwable) {}
            return null;
        }
    }
}

