/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.channel.nio;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.ByteBufUtil;
import com.appoptics.ext.io.netty.buffer.Unpooled;
import com.appoptics.ext.io.netty.channel.AbstractChannel;
import com.appoptics.ext.io.netty.channel.Channel;
import com.appoptics.ext.io.netty.channel.ChannelException;
import com.appoptics.ext.io.netty.channel.ChannelFuture;
import com.appoptics.ext.io.netty.channel.ChannelFutureListener;
import com.appoptics.ext.io.netty.channel.ChannelPromise;
import com.appoptics.ext.io.netty.channel.ConnectTimeoutException;
import com.appoptics.ext.io.netty.channel.EventLoop;
import com.appoptics.ext.io.netty.channel.nio.NioEventLoop;
import com.appoptics.ext.io.netty.util.ReferenceCountUtil;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public abstract class AbstractNioChannel
extends AbstractChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractNioChannel.class);
    private final SelectableChannel ch;
    protected final int readInterestOp;
    volatile SelectionKey selectionKey;
    boolean readPending;
    private final Runnable clearReadPendingRunnable = new Runnable(){

        public void run() {
            AbstractNioChannel.this.clearReadPending0();
        }
    };
    private ChannelPromise connectPromise;
    private ScheduledFuture<?> connectTimeoutFuture;
    private SocketAddress requestedRemoteAddress;

    protected AbstractNioChannel(Channel channel, SelectableChannel selectableChannel, int n2) {
        super(channel);
        this.ch = selectableChannel;
        this.readInterestOp = n2;
        try {
            selectableChannel.configureBlocking(false);
            return;
        }
        catch (IOException iOException) {
            try {
                selectableChannel.close();
            }
            catch (IOException iOException2) {
                logger.warn("Failed to close a partially initialized socket.", iOException2);
            }
            throw new ChannelException("Failed to enter non-blocking mode.", iOException);
        }
    }

    public boolean isOpen() {
        return this.ch.isOpen();
    }

    public NioUnsafe unsafe() {
        return (NioUnsafe)super.unsafe();
    }

    protected SelectableChannel javaChannel() {
        return this.ch;
    }

    public NioEventLoop eventLoop() {
        return (NioEventLoop)super.eventLoop();
    }

    protected SelectionKey selectionKey() {
        assert (this.selectionKey != null);
        return this.selectionKey;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void clearReadPending() {
        if (!this.isRegistered()) {
            this.readPending = false;
            return;
        }
        NioEventLoop nioEventLoop = this.eventLoop();
        if (nioEventLoop.inEventLoop()) {
            this.clearReadPending0();
            return;
        }
        nioEventLoop.execute(this.clearReadPendingRunnable);
    }

    private void clearReadPending0() {
        this.readPending = false;
        ((AbstractNioUnsafe)this.unsafe()).removeReadOp();
    }

    protected boolean isCompatible(EventLoop eventLoop) {
        return eventLoop instanceof NioEventLoop;
    }

    protected void doRegister() throws Exception {
        boolean bl = false;
        while (true) {
            try {
                this.selectionKey = this.javaChannel().register(this.eventLoop().unwrappedSelector(), 0, this);
                return;
            }
            catch (CancelledKeyException cancelledKeyException) {
                if (!bl) {
                    this.eventLoop().selectNow();
                    bl = true;
                    continue;
                }
                throw cancelledKeyException;
            }
            break;
        }
    }

    protected void doDeregister() throws Exception {
        this.eventLoop().cancel(this.selectionKey());
    }

    protected void doBeginRead() throws Exception {
        SelectionKey selectionKey = this.selectionKey;
        if (!selectionKey.isValid()) {
            return;
        }
        this.readPending = true;
        int n2 = selectionKey.interestOps();
        if ((n2 & this.readInterestOp) == 0) {
            selectionKey.interestOps(n2 | this.readInterestOp);
        }
    }

    protected abstract boolean doConnect(SocketAddress var1, SocketAddress var2) throws Exception;

    protected abstract void doFinishConnect() throws Exception;

    protected final ByteBuf newDirectBuffer(ByteBuf byteBuf) {
        int n2 = byteBuf.readableBytes();
        if (n2 == 0) {
            ReferenceCountUtil.safeRelease(byteBuf);
            return Unpooled.EMPTY_BUFFER;
        }
        Object object = this.alloc();
        if (object.isDirectBufferPooled()) {
            object = object.directBuffer(n2);
            ByteBuf byteBuf2 = byteBuf;
            ((ByteBuf)object).writeBytes(byteBuf2, byteBuf2.readerIndex(), n2);
            ReferenceCountUtil.safeRelease(byteBuf);
            return object;
        }
        object = ByteBufUtil.threadLocalDirectBuffer();
        if (object != null) {
            ByteBuf byteBuf3 = byteBuf;
            ((ByteBuf)object).writeBytes(byteBuf3, byteBuf3.readerIndex(), n2);
            ReferenceCountUtil.safeRelease(byteBuf);
            return object;
        }
        return byteBuf;
    }

    protected void doClose() throws Exception {
        Future<Void> future = this.connectPromise;
        if (future != null) {
            future.tryFailure(new ClosedChannelException());
            this.connectPromise = null;
        }
        if ((future = this.connectTimeoutFuture) != null) {
            future.cancel(false);
            this.connectTimeoutFuture = null;
        }
    }

    protected abstract class AbstractNioUnsafe
    extends AbstractChannel.AbstractUnsafe
    implements NioUnsafe {
        protected AbstractNioUnsafe() {
        }

        protected final void removeReadOp() {
            SelectionKey selectionKey = AbstractNioChannel.this.selectionKey();
            if (!selectionKey.isValid()) {
                return;
            }
            int n2 = selectionKey.interestOps();
            if ((n2 & AbstractNioChannel.this.readInterestOp) != 0) {
                selectionKey.interestOps(n2 & ~AbstractNioChannel.this.readInterestOp);
            }
        }

        public final void connect(final SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
            if (!channelPromise.setUncancellable() || !this.ensureOpen(channelPromise)) {
                return;
            }
            try {
                if (AbstractNioChannel.this.connectPromise != null) {
                    throw new ConnectionPendingException();
                }
                boolean bl = AbstractNioChannel.this.isActive();
                if (!AbstractNioChannel.this.doConnect(socketAddress, socketAddress2)) {
                    AbstractNioChannel.this.connectPromise = channelPromise;
                    AbstractNioChannel.this.requestedRemoteAddress = socketAddress;
                    int n2 = AbstractNioChannel.this.config().getConnectTimeoutMillis();
                    if (n2 > 0) {
                        AbstractNioChannel.this.connectTimeoutFuture = AbstractNioChannel.this.eventLoop().schedule(new Runnable(){

                            public void run() {
                                ChannelPromise channelPromise = AbstractNioChannel.this.connectPromise;
                                ConnectTimeoutException connectTimeoutException = new ConnectTimeoutException("connection timed out: " + socketAddress);
                                if (channelPromise != null && channelPromise.tryFailure(connectTimeoutException)) {
                                    AbstractNioUnsafe.this.close(AbstractNioUnsafe.this.voidPromise());
                                }
                            }
                        }, (long)n2, TimeUnit.MILLISECONDS);
                    }
                    channelPromise.addListener(new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture channelFuture) throws Exception {
                            if (channelFuture.isCancelled()) {
                                if (AbstractNioChannel.this.connectTimeoutFuture != null) {
                                    AbstractNioChannel.this.connectTimeoutFuture.cancel(false);
                                }
                                AbstractNioChannel.this.connectPromise = null;
                                AbstractNioUnsafe.this.close(AbstractNioUnsafe.this.voidPromise());
                            }
                        }
                    });
                    return;
                }
                this.fulfillConnectPromise(channelPromise, bl);
            }
            catch (Throwable throwable) {
                channelPromise.tryFailure(this.annotateConnectException(throwable, socketAddress));
                this.closeIfClosed();
            }
        }

        private void fulfillConnectPromise(ChannelPromise channelPromise, boolean bl) {
            if (channelPromise == null) {
                return;
            }
            boolean bl2 = AbstractNioChannel.this.isActive();
            boolean bl3 = channelPromise.trySuccess();
            if (!bl && bl2) {
                AbstractNioChannel.this.pipeline().fireChannelActive();
            }
            if (!bl3) {
                AbstractNioUnsafe abstractNioUnsafe = this;
                abstractNioUnsafe.close(abstractNioUnsafe.voidPromise());
            }
        }

        private void fulfillConnectPromise(ChannelPromise channelPromise, Throwable throwable) {
            if (channelPromise == null) {
                return;
            }
            channelPromise.tryFailure(throwable);
            this.closeIfClosed();
        }

        public final void finishConnect() {
            assert (AbstractNioChannel.this.eventLoop().inEventLoop());
            try {
                boolean bl = AbstractNioChannel.this.isActive();
                AbstractNioChannel.this.doFinishConnect();
                AbstractNioUnsafe abstractNioUnsafe = this;
                abstractNioUnsafe.fulfillConnectPromise(abstractNioUnsafe.AbstractNioChannel.this.connectPromise, bl);
                return;
            }
            catch (Throwable throwable) {
                AbstractNioUnsafe abstractNioUnsafe = this;
                abstractNioUnsafe.fulfillConnectPromise(abstractNioUnsafe.AbstractNioChannel.this.connectPromise, this.annotateConnectException(throwable, AbstractNioChannel.this.requestedRemoteAddress));
                return;
            }
            finally {
                if (AbstractNioChannel.this.connectTimeoutFuture != null) {
                    AbstractNioChannel.this.connectTimeoutFuture.cancel(false);
                }
                AbstractNioChannel.this.connectPromise = null;
            }
        }

        protected final void flush0() {
            if (!this.isFlushPending()) {
                super.flush0();
            }
        }

        public final void forceFlush() {
            super.flush0();
        }

        private boolean isFlushPending() {
            SelectionKey selectionKey = AbstractNioChannel.this.selectionKey();
            return selectionKey.isValid() && (selectionKey.interestOps() & 4) != 0;
        }
    }

    public static interface NioUnsafe
    extends Channel.Unsafe {
        public void finishConnect();

        public void read();

        public void forceFlush();
    }
}

