/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.channel.nio;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.ByteBufAllocator;
import com.appoptics.ext.io.netty.channel.Channel;
import com.appoptics.ext.io.netty.channel.ChannelConfig;
import com.appoptics.ext.io.netty.channel.ChannelFuture;
import com.appoptics.ext.io.netty.channel.ChannelMetadata;
import com.appoptics.ext.io.netty.channel.ChannelOutboundBuffer;
import com.appoptics.ext.io.netty.channel.ChannelPipeline;
import com.appoptics.ext.io.netty.channel.FileRegion;
import com.appoptics.ext.io.netty.channel.RecvByteBufAllocator;
import com.appoptics.ext.io.netty.channel.nio.AbstractNioChannel;
import com.appoptics.ext.io.netty.channel.socket.ChannelInputShutdownEvent;
import com.appoptics.ext.io.netty.channel.socket.ChannelInputShutdownReadComplete;
import com.appoptics.ext.io.netty.channel.socket.SocketChannelConfig;
import com.appoptics.ext.io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;

public abstract class AbstractNioByteChannel
extends AbstractNioChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(false, 16);
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(ByteBuf.class) + ", " + StringUtil.simpleClassName(FileRegion.class) + ')';
    private final Runnable flushTask = new Runnable(){

        public void run() {
            ((AbstractNioChannel.AbstractNioUnsafe)AbstractNioByteChannel.this.unsafe()).flush0();
        }
    };
    private boolean inputClosedSeenErrorOnRead;

    protected AbstractNioByteChannel(Channel channel, SelectableChannel selectableChannel) {
        super(channel, selectableChannel, 1);
    }

    protected abstract ChannelFuture shutdownInput();

    protected boolean isInputShutdown0() {
        return false;
    }

    protected AbstractNioChannel.AbstractNioUnsafe newUnsafe() {
        return new NioByteUnsafe();
    }

    public ChannelMetadata metadata() {
        return METADATA;
    }

    final boolean shouldBreakReadReady(ChannelConfig channelConfig) {
        return this.isInputShutdown0() && (this.inputClosedSeenErrorOnRead || !AbstractNioByteChannel.isAllowHalfClosure(channelConfig));
    }

    private static boolean isAllowHalfClosure(ChannelConfig channelConfig) {
        return channelConfig instanceof SocketChannelConfig && ((SocketChannelConfig)channelConfig).isAllowHalfClosure();
    }

    protected final int doWrite0(ChannelOutboundBuffer channelOutboundBuffer) throws Exception {
        Object object = channelOutboundBuffer.current();
        if (object == null) {
            return 0;
        }
        ChannelOutboundBuffer channelOutboundBuffer2 = channelOutboundBuffer;
        return this.doWriteInternal(channelOutboundBuffer2, channelOutboundBuffer2.current());
    }

    private int doWriteInternal(ChannelOutboundBuffer channelOutboundBuffer, Object object) throws Exception {
        if (object instanceof ByteBuf) {
            if (!((ByteBuf)(object = (ByteBuf)object)).isReadable()) {
                channelOutboundBuffer.remove();
                return 0;
            }
            int n2 = this.doWriteBytes((ByteBuf)object);
            if (n2 > 0) {
                channelOutboundBuffer.progress(n2);
                if (!((ByteBuf)object).isReadable()) {
                    channelOutboundBuffer.remove();
                }
                return 1;
            }
        } else if (object instanceof FileRegion) {
            if ((object = (FileRegion)object).transferred() >= object.count()) {
                channelOutboundBuffer.remove();
                return 0;
            }
            long l2 = this.doWriteFileRegion((FileRegion)object);
            if (l2 > 0L) {
                channelOutboundBuffer.progress(l2);
                if (object.transferred() >= object.count()) {
                    channelOutboundBuffer.remove();
                }
                return 1;
            }
        } else {
            throw new Error();
        }
        return Integer.MAX_VALUE;
    }

    protected void doWrite(ChannelOutboundBuffer channelOutboundBuffer) throws Exception {
        Object object;
        int n2 = this.config().getWriteSpinCount();
        do {
            if ((object = channelOutboundBuffer.current()) != null) continue;
            this.clearOpWrite();
            return;
        } while ((n2 -= this.doWriteInternal(channelOutboundBuffer, object)) > 0);
        this.incompleteWrite(n2 < 0);
    }

    protected final Object filterOutboundMessage(Object object) {
        if (object instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)object;
            if (byteBuf.isDirect()) {
                return object;
            }
            return this.newDirectBuffer(byteBuf);
        }
        if (object instanceof FileRegion) {
            return object;
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName(object) + EXPECTED_TYPES);
    }

    protected final void incompleteWrite(boolean bl) {
        if (bl) {
            this.setOpWrite();
            return;
        }
        this.clearOpWrite();
        this.eventLoop().execute(this.flushTask);
    }

    protected abstract long doWriteFileRegion(FileRegion var1) throws Exception;

    protected abstract int doReadBytes(ByteBuf var1) throws Exception;

    protected abstract int doWriteBytes(ByteBuf var1) throws Exception;

    protected final void setOpWrite() {
        SelectionKey selectionKey = this.selectionKey();
        if (!selectionKey.isValid()) {
            return;
        }
        int n2 = selectionKey.interestOps();
        if ((n2 & 4) == 0) {
            selectionKey.interestOps(n2 | 4);
        }
    }

    protected final void clearOpWrite() {
        SelectionKey selectionKey = this.selectionKey();
        if (!selectionKey.isValid()) {
            return;
        }
        int n2 = selectionKey.interestOps();
        if ((n2 & 4) != 0) {
            selectionKey.interestOps(n2 & 0xFFFFFFFB);
        }
    }

    protected class NioByteUnsafe
    extends AbstractNioChannel.AbstractNioUnsafe {
        protected NioByteUnsafe() {
            super(AbstractNioByteChannel.this);
        }

        private void closeOnRead(ChannelPipeline channelPipeline) {
            if (!AbstractNioByteChannel.this.isInputShutdown0()) {
                if (AbstractNioByteChannel.isAllowHalfClosure(AbstractNioByteChannel.this.config())) {
                    AbstractNioByteChannel.this.shutdownInput();
                    channelPipeline.fireUserEventTriggered(ChannelInputShutdownEvent.INSTANCE);
                    return;
                }
                NioByteUnsafe nioByteUnsafe = this;
                nioByteUnsafe.close(nioByteUnsafe.voidPromise());
                return;
            }
            AbstractNioByteChannel.this.inputClosedSeenErrorOnRead = true;
            channelPipeline.fireUserEventTriggered(ChannelInputShutdownReadComplete.INSTANCE);
        }

        private void handleReadException(ChannelPipeline channelPipeline, ByteBuf byteBuf, Throwable throwable, boolean bl, RecvByteBufAllocator.Handle handle) {
            if (byteBuf != null) {
                if (byteBuf.isReadable()) {
                    AbstractNioByteChannel.this.readPending = false;
                    channelPipeline.fireChannelRead(byteBuf);
                } else {
                    byteBuf.release();
                }
            }
            handle.readComplete();
            channelPipeline.fireChannelReadComplete();
            channelPipeline.fireExceptionCaught(throwable);
            if (bl || throwable instanceof IOException) {
                this.closeOnRead(channelPipeline);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final void read() {
            ChannelConfig channelConfig = AbstractNioByteChannel.this.config();
            if (AbstractNioByteChannel.this.shouldBreakReadReady(channelConfig)) {
                AbstractNioByteChannel.this.clearReadPending();
                return;
            }
            ChannelPipeline channelPipeline = AbstractNioByteChannel.this.pipeline();
            ByteBufAllocator byteBufAllocator = channelConfig.getAllocator();
            RecvByteBufAllocator.Handle handle = this.recvBufAllocHandle();
            handle.reset(channelConfig);
            ByteBuf byteBuf = null;
            boolean bl = false;
            try {
                do {
                    byteBuf = handle.allocate(byteBufAllocator);
                    handle.lastBytesRead(AbstractNioByteChannel.this.doReadBytes(byteBuf));
                    if (handle.lastBytesRead() <= 0) {
                        byteBuf.release();
                        byteBuf = null;
                        bl = handle.lastBytesRead() < 0;
                        if (!bl) break;
                        AbstractNioByteChannel.this.readPending = false;
                        break;
                    }
                    handle.incMessagesRead(1);
                    AbstractNioByteChannel.this.readPending = false;
                    channelPipeline.fireChannelRead(byteBuf);
                    byteBuf = null;
                } while (handle.continueReading());
                handle.readComplete();
                channelPipeline.fireChannelReadComplete();
                if (bl) {
                    this.closeOnRead(channelPipeline);
                }
                if (AbstractNioByteChannel.this.readPending || channelConfig.isAutoRead()) return;
            }
            catch (Throwable throwable) {
                try {
                    this.handleReadException(channelPipeline, byteBuf, throwable, bl, handle);
                    return;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    if (AbstractNioByteChannel.this.readPending || channelConfig.isAutoRead()) return;
                    this.removeReadOp();
                }
            }
            this.removeReadOp();
            return;
        }
    }
}

